package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.*;
import com.gtis.archive.service.*;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-9-20
 */
public class DocAction extends BaseModelAction<Document> {
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private OriginalService originalService;
    @Autowired
    private AjhRangeService ajhRangeService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private LogManagerService logManagerService;
    /**
     * tree id
     */
    private String treeId;
    /**
     * document view type,wlj(未立卷) ylj(已立卷)
     */
    private String type;
    /**
     * 档案id
     */
    private String archiveId;

    /**
     * 链接字段
     */
    private String linkField;

    /**
     * 保存的doc值
     */
    private String docValue;
    /**
     * 传来的单个卷内Id
     */
    private String docId;

    private String code;

    /**
     * 选中的卷内默认值
     */
    private String selDoc;

    /**
     * 添加卷内默认值时是否覆盖原有卷内
     */
    private Boolean isCover;

    private List<String> operationStrs;

    private String permJson;
    
    /** 字段modelName的值 */
    private String fieldModelName;

    /**
     * 档案中卷内显示的字段
     */
    private Map docShowFields;

    private Map docFields;

    private String archiveIdText = "archiveId";
    private String modelNameText = "modelName";
    private String defaultDocText = "defaultDoc";
    private String errorText = "error";

    private Map docArchive;

    public List<String> getOperationStrs() {
        return operationStrs;
    }

    public void setOperationStrs(List<String> operationStrs) {
        this.operationStrs = operationStrs;
    }

    public Boolean getIsCover() {
        return isCover;
    }

    public void setIsCover(Boolean isCover) {
        this.isCover = isCover;
    }

    public String getSelDoc() {
        return selDoc;
    }

    public void setSelDoc(String selDoc) {
        this.selDoc = selDoc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDocId() {
        return docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    @Override
    public void setModelName(String modelName) {
        super.setModelName(Archive.toDocumentModelName(modelName));
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public String getTreeId() {
        return treeId;
    }

    public String getType() {
        return type;
    }

    public String getDocValue() {
        return docValue;
    }

    public void setDocValue(String docValue) {
        this.docValue = docValue;
    }

    public void setPermJson(String permJson) {
        this.permJson = permJson;
    }

    /**
     * 获得档案中案卷显示的字段
     *
     * @return
     */
    public Map getDocShowFields() {
        if (docShowFields == null) {
            try {
                Model doc = archiveService.getDocumentModel(Document.toArchiveModelName(modelName));
                docShowFields = JSON.parseObject(doc.getTemplate("showFields"), LinkedHashMap.class);
            } catch (Exception ex) {
                docShowFields = JSON.parseObject(getEntityTemplate("Document-showFields"), LinkedHashMap.class);
            }
        }
        if(docShowFields == null){
            docShowFields = new HashMap();
        }
        return docShowFields;
    }

    /**
     * 获取档案中案卷所有字段
     *
     * @return
     */
    public Map getDocFields() {
        if (docFields == null) {
            try {
                Model doc = archiveService.getDocumentModel(Document.toArchiveModelName(modelName));
                docFields = doc.getInheritfieldsMap();
            } catch (ModelNotFoundException ex) {
                logger.error(ex.getMessage());
            }
        }
        return docFields;
    }

    public String getPermJson() {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        Map<String, Boolean> perm = new HashMap<String, Boolean>();
        if (operationStrs == null || operationStrs.isEmpty()) {
            String location = ServletActionContext.getRequest().getSession().getServletContext().getRealPath("/tpls/permission.json");
            try {
                operationStrs = permissionService.getLeavesId(location); // 获取所有的操作项
            } catch (IOException e) {
                logger.error("读取配置文件permission.json错误，请检查，文件位置为:" + location,e);
            }
        }
        if (!EnvHolder.isEnable(Switch.isNewPermission) || userInfo.isAdmin()) {
            for (String s : operationStrs) {
                if (securityService.isPermitted(treeId, s)) {
                    perm.put(s, true);
                }
            }
        }else {
            perm = securityService.getUserPermMap(userInfo,treeId);
        }
        return JSON.toJSONString(perm);
    }

    public List<Map<String, Object>> getTree() {
        return treeService.getTree(null, Constants.MODEL_ROOT);
    }

    @Override
    public String execute() throws Exception {
        String location = ServletActionContext.getRequest().getSession().getServletContext().getRealPath("/tpls/permission.json");
        try {
            operationStrs = permissionService.getLeavesId(location); // 获取所有的操作项
        } catch (IOException e) {
            logger.error("读取配置文件permission.json错误，请检查，文件位置为:" + location,e);
        }

        if (StringUtils.isNotEmpty(modelName)) {
            Resource res = resourceService.findChildResource(null, Document.toArchiveModelName(modelName), Constants.MODEL_ROOT);
            if (res != null) {
                treeId = res.getId();
            } else {
                throw new ModelNotFoundException(modelName);
            }
        }
        modelService.getModel(modelName);
        String id = getId();
        if (id != null) {
            Document doc = archiveService.getDocument(modelName, id);
            if (doc != null) {
                type = doc.getArchiveId() == null ? "wlj" : "ylj";
            }
        }
        return Action.SUCCESS;
    }

    @Override
    protected Page<Document> searchEntity(List<Criterion> criterions, List<Order> orders) {
        if (StringUtils.isNotEmpty(archiveId)) {
            if (EnvHolder.isEnable(Switch.JIANGYIN)) {
                List<Document> documents = entityService.<Document>search(Archive.toDocumentModelName(modelName),
                        Collections.singletonList(Restrictions.eq(archiveIdText, archiveId)), orders, 0, Page.ALL).getItems();
                if (!documents.isEmpty()) {
                    documents.get(0).setArchive(archiveService.getArchive(modelName, archiveId));
                }
                return new Page<Document>(documents);
            } else {
                Page<Document> page = entityService.<Document>search(Archive.toDocumentModelName(modelName),
                        Collections.singletonList(Restrictions.eq(archiveIdText, archiveId)), orders, 0, Page.ALL);
                List<Document> lists = page.getItems();
                for (Object object : lists) {
                    try {
                        String id = PropertyUtils.getProperty(object, "id").toString();
                        String oldId = PropertyUtils.getProperty(object, "oldId").toString();
                        if(!Struts2Utils.isNull(oldId)) {
                            PropertyUtils.setProperty(object, "hasOriginal", originalService.hasOriginalForComp(oldId));
                        }else{
                            PropertyUtils.setProperty(object, "hasOriginal", originalService.hasOriginal(id));
                        }
                    } catch (Exception e) {
                        break;
                    }
                }

                if (isPrint) {
                    String printCount = EnvHolder.getAppEnv().get(Switch.DOCUMENT_PRINT_COUNT);
                    if (printCount != null && StringUtils.isNotBlank(printCount)) {
                        int iCount = Integer.parseInt(printCount);
                        int j = 0;
                        if (page.getItems().size() % iCount != 0) {
                            j = iCount - (page.getItems().size() % iCount);
                        }

                        for (int i = 0; i < j; i++) {
                            Document document = entityService.newInstance(modelName);
                            document.setArchiveId(archiveId);
                            page.getItems().add(document);
                        }
                    }

                    isPrint = false;
                }

                return page;
            }
        }
        if (EnvHolder.isEnable(Switch.JIANGYIN)) {
            Page<Document> page = super.searchEntity(criterions, orders);
            for (Document document : page.getItems()) {
                if (StringUtils.isNotBlank(document.getArchiveId())) {
                    document.setArchive(archiveService.getArchive(modelName, document.getArchiveId()));
                }
                document.setHasOriginal(originalService.hasOriginal(document.getId()));
            }
            return page;
        } else {
            return super.searchEntity(criterions, orders);
        }
    }

    @Override
    protected Page<Document> searchDocentity(List<Criterion> criterions, List<Order> orders, String archiveId) {
        if (StringUtils.isNotEmpty(archiveId)) {
            if (EnvHolder.isEnable(Switch.JIANGYIN)) {
                List<Document> documents = entityService.<Document>search(Archive.toDocumentModelName(modelName),
                        Collections.singletonList(Restrictions.eq(archiveIdText, archiveId)), orders, 0, Page.ALL).getItems();
                if (!documents.isEmpty()) {
                    documents.get(0).setArchive(archiveService.getArchive(modelName, archiveId));
                }
                return new Page<Document>(documents);
            } else {
                return new Page<Document>(entityService.<Document>search(Archive.toDocumentModelName(modelName),
                        Collections.singletonList(Restrictions.eq(archiveIdText, archiveId)), orders, 0, Page.ALL).getItems());
            }
        }
        if (EnvHolder.isEnable(Switch.JIANGYIN)) {
            Page<Document> page = super.searchEntity(criterions, orders);
            for (Document document : page.getItems()) {
                if (StringUtils.isNotBlank(document.getArchiveId())) {
                    document.setArchive(archiveService.getArchive(modelName, document.getArchiveId()));
                }
                document.setHasOriginal(originalService.hasOriginal(document.getId()));
            }
            return page;
        } else {
            return super.searchEntity(criterions, orders);
        }
    }

    @Override
    protected List<Criterion> createCriterions(ArrayList<Criterion> criterions) {
        if (type == null || !"all".equals(type)) {
            criterions.add("ylj".equals(type) ? Restrictions.isNotNull(archiveIdText) : Restrictions.isNull(archiveIdText));
        }
        if (EnvHolder.isEnable(Switch.ZHEN_JINAG) && !SessionUtil.getCurrentUser().isAdmin()) {
            String[] name = modelName.split("_");
            List<AjhRange> ajhRanges = ajhRangeService.getAjhRangeByModelName(name[0]);
            List<String> mlhs = new ArrayList<String>();
            UserInfo userInfo = SessionUtil.getCurrentUser();
            String roleids = userInfo.getRoleIds();
            if (!EnvHolder.isEnable(Switch.isNewPermission) && roleids != null) {
                for (String roleid : roleids.split(",")) {
                    roleid = roleid.substring(1, roleid.length() - 1);
                    for (AjhRange ajhRange : ajhRanges) {
                        if (!permissionService.getPermissions(ajhRange.getId(), roleid).isEmpty()) {
                            mlhs.add(ajhRange.getMlh());
                        }
                    }
                }
            }else {
                String userId = userInfo.getId();
                for (AjhRange ajhRange : ajhRanges){
                    if (permissionService.getUserPermissions(ajhRange.getId(), userId).size() != 0){
                        mlhs.add(ajhRange.getMlh());
                    }
                }
            }
            if (!mlhs.isEmpty()) {
                String sSQL = "(";
                StringBuilder stringBuilder = new StringBuilder();
                for (String mlh : mlhs) {
                    stringBuilder.append("mlh = '").append(mlh).append("' OR ");
                }
                sSQL = sSQL + stringBuilder.toString();
                sSQL = sSQL.substring(0, sSQL.length() - 4);
                sSQL = sSQL + ")";
                criterions.add(Restrictions.sqlRestriction(sSQL));
            }
        }
        return super.createCriterions(criterions);
    }

    @Override
    protected List<Order> createOrders(ArrayList<Order> orders) {
        List<Order> superOrders = super.createOrders(orders);
        if (!superOrders.isEmpty()) {return superOrders;}
        if (StringUtils.isNotEmpty(archiveId)) {
            orders.add(Order.desc("sxh"));
        }
        orders.add(Order.desc("id"));
        return super.createOrders(orders);
    }

    /**
     * 获取卷内所属的档案
     *
     * @return
     */
    public Map getDocArchive() {
        try {
            if (docArchive == null) {
                docArchive = JSON.parseObject(JSON.toJSONString(archiveService.getArchive(modelName, archiveId), SerializerFeature.WriteMapNullValue));
                ////重置归档时间
                if (docArchive.containsKey("gdsj") && docArchive.get("gdsj") != null && docArchive.get("gdsj").toString() != "null") {
                    Date date = new Date((Long) docArchive.get("gdsj"));
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    docArchive.put("gdsj", sdf.format(date));
                }

                docArchive.remove("id");
            }
        } catch (Exception ex) {
            logger.error(ex.toString());
        }
        return docArchive;
    }

    public String getLinkField() {
        if (linkField == null) {
            try {
                linkField = archiveService.getDocumentModel(modelName).getTemplate("linkField");
            } catch (ModelNotFoundException ex) {
                logger.error(ex.getMessage());
            } catch (TemplateNotFoundException ex) {
                linkField = "tm";
            }
        }
        return linkField;
    }

    public void saveDoc() {
        try {
            if (docValue == null || StringUtils.isBlank(docValue)) {
                return;
            }
            List docList = JSONArray.parseArray(docValue);
            if (docList != null && !docList.isEmpty()) {
                for (int i = 0; i < docList.size(); i++) {
                    Map docMap = (Map) docList.get(i);
                    Document document = archiveService.getDocument(modelName, docMap.get("id").toString());
                    document.setSxh(Integer.parseInt(docMap.get("sxh").toString()));
                    document.setYh(docMap.get("yh").toString());
                    archiveService.saveDocument(document);
                }
            }
            renderJson(Action.SUCCESS);
        } catch (Exception ex) {
            renderJson(ex.getMessage());
        }
    }

    public void upDocument() throws Exception {
        List<Criterion> criterions = new ArrayList<Criterion>();
        List<Order> orders;
        Document temp = archiveService.getDocument(modelName, docId);
        Integer docSxh;
        docSxh = temp.getSxh();
        criterions.clear();
        criterions.add(Restrictions.and(Restrictions.eq("sxh", docSxh - 1), Restrictions.eq(archiveIdText, archiveId)));
        orders = new ArrayList<Order>();
        orders.add(Order.desc(sort));
        Page page = archiveService.searchDocument(modelName, criterions, orders, 0, limit);
        if (page.getPageCount() == 0) {
            return;
        }
        List<Document> documents = page.getItems();
        Document movDoc = documents.get(0);
        Integer movSxh = movDoc.getSxh();
        temp.setSxh(movSxh);
        movDoc.setSxh(docSxh);
        entityService.save(movDoc);
        entityService.save(temp);
    }

    public void downDocument() {
        List<Criterion> criterions = new ArrayList<Criterion>();
        List<Order> orders;
        Document temp = archiveService.getDocument(modelName, docId);
        Integer docSxh;
        docSxh = temp.getSxh();
        criterions.clear();
        criterions.add(Restrictions.and(Restrictions.eq("sxh", docSxh + 1), Restrictions.eq(archiveIdText, archiveId)));
        orders = new ArrayList<Order>();
        orders.add(Order.desc(sort));
        Page page = archiveService.searchDocument(modelName, criterions, orders, 0, limit);
        if (page.getPageCount() == 0) {
            return;
        }
        List<Document> documents = page.getItems();
        Document movDoc = documents.get(0);
        Integer movSxh = movDoc.getSxh();
        temp.setSxh(movSxh);
        movDoc.setSxh(docSxh);
        entityService.save(movDoc);
        entityService.save(temp);
    }

    public void saveSort() throws Exception {
        try {
            List<Criterion> criterions = new ArrayList<Criterion>();
            criterions.add(Restrictions.eq(archiveIdText, archiveId));
            List<Order> orders = new ArrayList<Order>();
            orders.add(Order.asc(sort));
            Page page = archiveService.searchDocument(modelName, criterions, orders, 0, limit);
            List<Document> documents = page.getItems();
            int start = 1;
            for (int i = 0; i < documents.size(); i++) {
                Document temp = documents.get(i);
                if (temp.getSxh().equals(i + 1)) {
                    String yhStr = temp.getYh();
                    String begin = yhStr.split("-")[0];
                    String end = yhStr.split("-")[1];
                    //需要移动案卷号长度
                    Integer len1 = Integer.valueOf(end) - Integer.valueOf(begin);
                    Integer newStart;
                    Integer newEnd;
                    if (temp.getSxh() == 1) {
                        newStart = start;
                        newEnd = newStart + len1;
                        start = newEnd;
                    } else {
                        newStart = start + 1;
                        newEnd = newStart + len1;
                        start = newEnd;
                    }
                    String newYh = newStart + "-" + newEnd + "";
                    temp.setYh(newYh);
                    entityService.save(temp);
                }
            }
        } catch (Exception e) {
            logger.error("保存排序出现异常" ,e);
        }
    }


    /**
     * 续添一条卷内
     */
    public void addOneDoc() {
        Document entity = archiveService.newDocument(modelName);
        Archive archive = archiveService.getArchive(fieldModelName==null?modelName:fieldModelName, archiveId);
        Document document = archiveService.getMaxSxhDocuments(modelName, archiveId);
        if (document == null) {
            entity.setSxh(1);
        } else {
            entity.setSxh(document.getSxh() + 1);
        }
        entity.setArchive(archive);
        entity.setAjh(archive.getAjh());
        entity.setMlh(archive.getMlh());
        entity.setQzh(archive.getQzh());
        entity.setDabh(archive.getDh());
        entity.setArchiveId(archive.getId());
        entityService.save(entity);
        Map map = new HashMap();
        map.put("docId", entity.getId());
        map.put("sxh", entity.getSxh());
        map.put("ajh", entity.getAjh() == null ? "" : entity.getAjh());
        map.put("qzh", entity.getQzh() == null ? "" : entity.getQzh());
        map.put("mlh", entity.getMlh() == null ? "" : entity.getMlh());
        map.put("dabh", entity.getDabh() == null ? "" : entity.getDabh());
        map.put(modelNameText, entity.getModelName());
        map.put(archiveIdText, entity.getArchiveId());
        renderJson(map);
        logger.info("新增一条卷内所属案卷的id为[{}],卷内的id为[{}]",archiveId,entity.getId());
        logManagerService.saveDocumentLogManage(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                entity, "add");
    }

    /**
     * 保存所有续添的卷内
     */
    @SuppressWarnings("unchecked")
    public void saveOrUpdateDocs() {
        try {
            if (!StringUtils.isBlank(docValue)) {
                List<Document> docList = new ArrayList<Document>(JSONArray.parseArray(docValue, modelService.getClass(modelName)));
                int ysSum = 0;
                // 是否根据页号生成页数
                boolean generateSumByPagination = EnvHolder.isEnable(Switch.GENERATE_SUM_BY_PAGINATION);
                archiveId = null;

                // 设置数序号和页号、页数
                docList = resetSeqAndPage(docList, generateSumByPagination);

                for (int i = 0; i < docList.size(); i++) {
                    Document doc = docList.get(i);
                    ysSum += (doc.getYs() == null ? 0 : doc.getYs());
                    if (archiveId == null) {
                        archiveId = doc.getArchiveId();
                    }
                    archiveService.saveDocument(doc);

                    if ((!generateSumByPagination && (doc.getYs() == null || doc.getYs() == 0))
                            || (generateSumByPagination && StringUtils.isBlank(doc.getYh()))) {
                        archiveService.removeDocument(doc.getModelName(), new String[]{doc.getId()});
                    }

                    logManagerService.saveDocumentLogManage(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                            doc, "edit");
                }
                archiveService.updateArchiveYsByDoc(ysSum, archiveId);
                renderJson(Action.SUCCESS);
            }
        } catch (ClassNotFoundException e) {
            logger.error(e.getMessage());
            logger.error("不存在类名为" + modelName + "的类",e);
        }
    }

    public void chpList() {
        if (docId == null) {
            return;
        }

        String chpModel = modelName.substring(0,7);
        chpModel = chpModel.replace("cp","jn");

        Document document = archiveService.getDocument(chpModel, docId);
        List<Chapter> chapters = archiveService.getDocumentChapters(document);
        renderJson(new Page<Chapter>(chapters));
    }

    /**
     * 获取修改的卷内的信息
     */
    public void getDocInfo() {
        if (!StringUtils.isEmpty(docId)) {
            Document document = archiveService.getDocument(modelName, docId);
            Map map = new HashMap();
            map.put("docId", document.getId());
            map.put("ajh", document.getAjh() == null ? "" : document.getAjh());
            map.put("qzh", document.getQzh() == null ? "" : document.getQzh());
            map.put("mlh", document.getMlh() == null ? "" : document.getMlh());
            map.put(modelNameText, document.getModelName());
            map.put(archiveIdText, document.getArchiveId());
            renderJson(map);
            logger.info("获取id为[{}]的信息",docId);
        }
    }

    /**
     * 根据卷内获取案卷的信息，并返回给前端
     */
    public void getArchiveInfo() {
        if (!StringUtils.isEmpty(archiveId)) {
            Archive archive = archiveService.getArchive(modelName, archiveId);
            logger.info("获取id为[{}]的案卷信息", archive.getId());
            Map map = new HashMap();
            map.put(archiveIdText, archive.getId());
            map.put("ajh", archive.getAjh() == null ? "" : archive.getAjh());
            map.put("qzh", archive.getQzh() == null ? "" : archive.getQzh());
            map.put("mlh", archive.getMlh() == null ? "" : archive.getMlh());
            map.put("dabh", archive.getDh() == null ? "" : archive.getDh());
            map.put(modelNameText, archive.getModelName() + "_jn");
            renderJson(map);
        }
    }

    /**
     * 根据特征码获取卷内题名
     */
    public void getTmBycode() {
        try {
            List<Item> items = this.dictService.getItems("featureCode");
            for (Item item : items) {
                String value = item.getValue();
                if (value.equals(code)) {
                    code = item.getName();
                    break;
                }
            }
            renderJson(code);
        }catch (Exception e){
            renderJson(code);
        }
    }

    /**
     * 重新计算页号
     *
     * @param begin
     * @param doc
     * @return
     */
    private int resetYh(int begin, Document doc) {
        Integer ys = doc.getYs();
        StringBuilder sb = new StringBuilder();
        int result = begin + ys;
        if (ys == 0) {
            sb.append("0").append("-").append("0");
        } else {
            sb.append(String.valueOf(begin)).append("-").append(String.valueOf(result - 1));
        }
        doc.setYh(sb.toString());
        return result;
    }

    private int resetSxh(int begin, Document document) {
        document.setSxh(begin + 1);
        return begin + 1;
    }

    /**
     * 获取配置的卷内默认值
     */
    public void getDocDefault() {
        List<String> docs = new ArrayList<String>();
        String docList = null;
        try {
            Model doc = archiveService.getDocumentModel(modelName);
            docList = doc.getTemplate(defaultDocText);

            if (docList != null) {
                Pattern pattern = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m = pattern.matcher(docList);
                docList = m.replaceAll("");
                String[] doca = docList.split("],|;|；");
                int j = 0;
                for (int i = 0; i < doca.length; i = i + 2) {
                    docs.add(j, doca[i]);
                    j++;
                }
                renderJson(docs);
            }else{
                renderJson(errorText);
            }
        } catch (TemplateNotFoundException ex) {
            renderJson(errorText);
        }
    }

    /**
     * 获取配置的卷内默认值
     */
    public void setDocDefault() {
        List<Document> docs = new ArrayList<Document>();
        List<String> docA = new ArrayList<String>();

        //此时的modelName形式如Wsda_jn
        String archiveModelName = modelName.substring(0, modelName.lastIndexOf("_"));
        Archive archive = archiveService.getArchive(archiveModelName, archiveId);

        String docList = null;
        try {
            Model doc = archiveService.getDocumentModel(modelName);
            if (selDoc == null) {
                docs = JSON.parseArray(doc.getTemplate(defaultDocText), Document.class);
            } else {
               docList = doc.getTemplate(defaultDocText);

                if (docList != null) {
                    Pattern p = Pattern.compile("\\s*|\t|\r|\n");
                    Matcher m = p.matcher(docList);
                    docList = m.replaceAll("");
                }

                String docD = null;
                String[] doca = docList.split("],|;|；");
                for (int i = 0; i < doca.length; i++) {
                    docA.add(i, doca[i]);
                    if (selDoc.equals(doca[i])) {
                        docD = doca[i + 1];
                    }
                }
                docs = JSON.parseArray(docD, Document.class);
            }
        } catch (TemplateNotFoundException ex) {
            renderJson(errorText);
            return;
        }
        List<Document> list = archiveService.getArchiveDocuments(modelName, archiveId);

        //是否覆盖原有卷内
        if (isCover && list != null) {
            String[] dids = new String[list.size()];
            for (int i = 0; i < list.size(); i++) {
                dids[i] = list.get(i).getId();
            }
            archiveService.removeDocument(modelName, dids);
            list = new ArrayList<Document>();
        }

        try {
            ////begin是默认的页号开始：如1-1的1
            Integer lastSxh = 0;
            Integer ajh = archive.getAjh();
            Integer begin = 1;
            String mlh = archive.getMlh();
            String dwdm = archive.getDwdm();
            if (list != null && !list.isEmpty()) {
                Document document = list.get(list.size() - 1);
                lastSxh = document.getSxh();
                ajh = document.getAjh();
                mlh = document.getMlh();
                if (document.getYh() != null) {
                    String yh = document.getYh();
                    begin = Integer.valueOf(yh.split("-")[1]) + 1;
                }
            } else {
                list = new ArrayList<Document>();
            }
            for (Document doc : docs) {
                Document entity = archiveService.newDocument(modelName);
                doc.setSxh(++lastSxh);
                doc.setAjh(ajh);
                doc.setMlh(mlh);
                doc.setArchiveId(archiveId);
                doc.setModelName(modelName);
                doc.setDwdm(dwdm);
                doc.setArchive(archive);

                PropertyUtils.copyProperties(entity, doc);

                entityService.save(entity);
            }

            super.list();
        } catch (Exception e) {
            renderJson("添加卷内默认值失败！");
        }
    }

    /**
     * 删除卷内
     * @return
     */
    @Override
    public String remove() {
        List<Document> docsToDel = new ArrayList<Document>();
        for (String id : ids) {
            if (StringUtils.isBlank(id)) {
                continue;
            }
            Document doc = archiveService.getDocument(modelName, id);
            docsToDel.add(doc);
        }

        try {
            boolean generateSumByPagination = EnvHolder.isEnable(Switch.GENERATE_SUM_BY_PAGINATION);
            archiveService.removeDocument(modelName, ids);
            for (Document document : docsToDel) {
                logManagerService.saveDocumentLogManage(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                        document, "remove");
            }

            List<Document> docs = archiveService.getArchiveDocuments(modelName, archiveId);
            docs = resetSeqAndPage(docs, generateSumByPagination);
            for (Document d : docs) {
                archiveService.saveDocument(d);
            }
        } catch (Exception e) {
            logger.error("删除失败,{}", e.getMessage());
            logger.error("删除失败");
        }
        return null;
    }

    /**
     * 在新的标签页打开卷内
     * @return
     */
    public String newPage() {
        Struts2Utils.getRequest().setAttribute(archiveIdText, archiveId);
        Struts2Utils.getRequest().setAttribute(modelNameText, modelName);
        Struts2Utils.getRequest().setAttribute("curType", type);
        Struts2Utils.getRequest().setAttribute("docFields", docFields);
        Struts2Utils.getRequest().setAttribute("docShowFields", docShowFields);
        return "newPage";
    }

    /**
     * 对卷内列表重置顺序号和页号
     * 如果有页号并且设置根据页号生成的开关为true则根据页号生成页数
     * @param list 未生成页数或页号的卷内列表
     * @param generateSumByPagination 是否根据页号生成页数
     * @return 生成页号或页数的卷内列表
     */
    private List<Document> resetSeqAndPage(List<Document> list, boolean generateSumByPagination) {
        int begin = 1;
        int sxhBegin = 0;
        // 将页数split后的数组
        String[] pagination;
        try {
            // 卷内列表根据顺序号进行排序
            Collections.sort(list, new Comparator<Document>() {
                @Override
                public int compare(Document doc1, Document doc2) {
                    int o1 = doc1.getSxh() == null ? Integer.MAX_VALUE : doc1.getSxh();
                    int o2 = doc2.getSxh() == null ? Integer.MAX_VALUE : doc2.getSxh();
                    return o1 - o2;
                }
            });

            for (int i = 0; i < list.size(); i++) {
                Document doc = list.get(i);
                Integer ys = doc.getYs();
                if (generateSumByPagination && StringUtils.isNotBlank(doc.getYh())) {
                    pagination = doc.getYh().split("-");
                    pagination = pagination.length > 1 ? pagination : doc.getYh().split("~");
                    ys = pagination.length > 1
                            ? Integer.parseInt(pagination[1]) - Integer.parseInt(pagination[0]) + 1
                            : getPageNumByNext(list, i, doc);
                    doc.setYs(ys);
                } else if (!generateSumByPagination) {
                    if (ys == null || ys == 0) {
                        ys = EnvHolder.isEnable(Switch.AUTO_GENERATE_PAGES) ? 1 : 0;
                    }
                    doc.setYs(ys);
                    begin = resetYh(begin, doc);
                }

                // 若页数或者页号为空则不续编顺序号
                if ((!generateSumByPagination && doc.getYs() != null && doc.getYs() > 0)
                        || (generateSumByPagination && StringUtils.isNotBlank(doc.getYh()))) {
                    sxhBegin = resetSxh(sxhBegin, doc);
                }
            }
        }catch (Exception e){
            logger.error(e.getMessage());
        }
        return list;
    }

    /**
     * 若卷内页号为单数，则通过计算获取卷内的页数
     * @param list 卷内列表
     * @param i 当前元素的索引
     * @param doc 当前元素
     * @return 当前卷内的页数
     */
    private Integer getPageNumByNext(List<Document> list, int i, Document doc) {
        String[] pagination;// 页码
        int next = i + 1;
        while (next < list.size()) {
            Document d = list.get(next);
            if (StringUtils.isNotBlank(d.getYh())) {
                pagination = d.getYh().split("-");
                pagination = pagination.length > 1 ? pagination : d.getYh().split("~");
                int start = Integer.parseInt(doc.getYh());
                int end = Integer.parseInt(pagination[0]);
                if (end > start) {
                    return end - start;
                } else {
                    logger.error("计算页数错误，请调整到正确的顺序");
                }
            }
            next++;
        }
        return 1;
    }

	public String getFieldModelName() {
		return fieldModelName;
	}

	public void setFieldModelName(String fieldModelName) {
		this.fieldModelName = fieldModelName;
	}
}
