package com.gtis.archive.web;

import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.sv.SqlServerServiceImpl;
import com.opensymphony.xwork2.Action;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import java.util.Map;

/**
 * Created by zhayw on 2015/5/6.
 */
public class DailyAction extends BaseModelAction<Archive> {

    @Autowired
    private EntityService entityService;

    @Autowired
    private ArchiveService archiveService ;

    @Autowired
    private SqlServerServiceImpl sqlServerService ;

    private String type;

    private String tplName;

    private String linkField;

    private String ids;

    @Override
    public Map getShowFields(){
        Map showFields = null;
        try{
            showFields = super.getShowFields();
        }catch(TemplateNotFoundException ex){
            logger.error(ex.getMessage());
        }
        return showFields;
    }

    public String getLinkField(){
        if(linkField==null){
            try{
                linkField=archiveService.getArchiveModel(modelName).getTemplate("linkField");
            }catch (Exception ex){
                linkField="tm";
            }
        }
        return linkField;
    }

    @Override
    public String execute(){
        return Action.SUCCESS;
    }

    public String tpl() {
        try {
            if(tplName.contains("list")){
                try{
                    renderModelTemplate(tplName);
                }catch(TemplateNotFoundException e){
                    renderModelTemplate("Daily-list");
                }
            }else{
                renderModelTemplate(tplName);
            }
        } catch (Exception e) {
            logger.error(e.getLocalizedMessage());
        }
        return null;
    }

    /**
     * 删除日常管理数据
     * @return
     */
    @Transactional
    @Override
    public String remove(){
        if(ids==null) {
            return null;
        }

        String[] loanIds = ids.split(",");
        entityService.remove(modelName,loanIds);
        return null;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTplName() {
        return tplName;
    }

    public void setTplName(String tplName) {
        this.tplName = tplName;
    }

    @Override
    public int getLimit() {
        return limit;
    }

    public String getIds() {
        return ids;
    }

    public void setIds(String ids) {
        this.ids = ids;
    }
}
