package com.gtis.archive.web;

import com.gtis.archive.core.support.hibernate.UUIDHexGenerator;

import com.gtis.archive.entity.Document;
import com.gtis.archive.service.LogManagerService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import com.gtis.archive.core.web.BaseEntityAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.service.ArchiveService;
import org.springframework.beans.factory.annotation.Autowired;


/**
 * 档案编研实体类
 * Created by linlong on 2017/4/13 0013.
 */
public class CompilationEntityAction extends BaseEntityAction<Archive> {

    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private LogManagerService logManagerService;

    private Integer pd=0;//判断添加操作

    /** 档案主键id*/
    private String idsArchiveHis;

    public String getIdsArchiveHis() {
        return idsArchiveHis;
    }

    public void setIdsArchiveHis(String idsArchiveHis) {
        this.idsArchiveHis = idsArchiveHis;
    }

    /**
     * 保存之前对实体进行处理
     */
    @Override
    protected void preSave() {
        if (entity != null && StringUtils.isBlank(entity.getId())) {
            pd=1;
            // 生成id
            entity.setId(UUIDHexGenerator.generate());
        }
    }

    /**
     * 返回成功的信息
     * @return
     */
    @Override
    protected String getSuccessMsg() {
        return entity == null ? super.getSuccessMsg() : entity.getId();
    }

    /**
     * 保存实体的方法
     * @return
     * @throws Exception
     */
    @Override
    public String save() throws Exception {
        return renderJs(new Runner() {
            @Override
            public void run() {
                preSave();
                doSave(entity,idsArchiveHis);
                afterSave();
            }
        }, "保存成功", null, getJsCallBack());
    }

    protected void doSave(Archive entity,String idsArchiveHis) {
        String saveType = null;

        entity.setId(UUIDHexGenerator.generate());
        archiveService.saveArchive(entity);
        String jnModelName = modelName + "_jn";
        //选中档案打包到编研
        if(org.apache.commons.lang3.StringUtils.isNotBlank(idsArchiveHis)){
            String[] idsArchiveHisArr = idsArchiveHis.split(",");
            for (int i = 0; i < idsArchiveHisArr.length; i++) {
                String archiveHisId = idsArchiveHisArr[i];
                Archive temp = archiveService.getSimpleArchive(archiveHisId);
                //1.打包到编研
                Document doc = archiveService.newDocument(jnModelName);
                Document document = archiveService.getMaxSxhDocuments(jnModelName, archiveHisId);
                if (document == null) {
                    doc.setSxh(i+1);
                } else {
                    doc.setSxh(document.getSxh() + 1);
                }
                doc.setArchive(entity);
                doc.setMlh(temp.getMlh());
                doc.setArchiveId(entity.getId());
                doc.setAjh(entity.getAjh());
                doc.setDabh(temp.getDh());
                doc.setTm(temp.getTm());
                doc.setQzh(entity.getQzh());
                doc.setModelName(jnModelName);
                doc.setOldId(temp.getId());
                if(Struts2Utils.isNull(temp.getYs())) {
                    doc.setYs(1);
                }else{
                    doc.setYs(temp.getYs());
                }
                doc.setOldId(temp.getId());
                archiveService.saveDocument(doc);
            }
        }

        if (pd == 0) {
            saveType = "edit";
        } else if (pd == 1) {
            saveType = "add";
        }
        logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                entity, saveType);
    }

    /**
     * 保存完成后在前端要调用的回调函数的函数名
     * @return
     */
    @Override
    protected String getJsCallBack() {
        return "onCompilationComplete";
    }

}
