package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.LogManagerService;
import com.gtis.archive.service.OriginalService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import java.util.*;

/**
 * 档案编研
 * Created by linlong on 2017/4/13 0013.
 */
public class CompilationAction extends BaseModelAction<Archive> {

    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private OriginalService originalService;
    @Autowired
    private LogManagerService logManagerService;

    /** 用于超链接的字段 */
    private String linkField;

    /** 用于获取档案编研的id数组 */
    private String[] compilationIds;

    /** 档案中卷内显示的字段 */
    private Map docShowFields;

    /** 卷内的超链接字段 */
    private String docLinkField;

    /** 案卷的字段 */
    private Map docFields;

    /** 获取字典配置的业务 */
    private List<Item> categories;

    public List<Item> getCategories() {
        categories = dictService.getItems("compilation");
        return categories;
    }

    public void setCategories(List<Item> categories) {
        this.categories = categories;
    }

    /**
     * 获得档案中案卷显示的字段
     *
     * @return
     */
    public Map getDocShowFields() {
        if (docShowFields == null) {
            try {
                Model doc = archiveService.getDocumentModel(modelName);
                docShowFields = JSON.parseObject(doc.getTemplate("showFields"), LinkedHashMap.class);
            } catch (ModelNotFoundException ex) {
                logger.error(ex.getMessage());
            } catch (TemplateNotFoundException ex) {
                docShowFields = JSON.parseObject(getEntityTemplate("Document-showFields"), LinkedHashMap.class);
            }
        }
        return docShowFields;
    }

    /**
     * 获取档案中案卷所有字段
     *
     * @return
     */
    public Map getDocFields() {
        if (docFields == null) {
            try {
                Model doc = archiveService.getDocumentModel(modelName);
                docFields = doc.getInheritfieldsMap();
            } catch (ModelNotFoundException ex) {
                logger.error(ex.getMessage());
            }
        }
        return docFields;
    }

    public String getDocLinkField() {
        if (docLinkField == null) {
            try {
                docLinkField = archiveService.getDocumentModel(modelName).getTemplate("linkField");
            } catch (ModelNotFoundException ex) {
                logger.error(ex.getMessage());
            } catch (TemplateNotFoundException ex) {
                docLinkField = "tm";
            }
        }
        return docLinkField;
    }

    public String[] getCompilationIds() {
        return compilationIds;
    }

    public void setCompilationIds(String[] compilationIds) {
        this.compilationIds = compilationIds;
    }

    public void setLinkField(String linkField) {
        this.linkField = linkField;
    }

    public String getLinkField() {
        if (linkField == null) {
            try {
                linkField = archiveService.getArchiveModel(modelName).getTemplate("linkField");
            } catch (Exception ex) {
                linkField = "tm";
            }
        }
        return linkField;
    }

    /**
     * 过滤条件查询id
     *
     * @return
     */
    public String searchIds() {
        List<Criterion> criterions = createCriterions(new ArrayList<Criterion>());
        List<Order> orders = createOrders(new ArrayList<Order>());
        List items = entityService.search(modelName, criterions, orders, start, limit).getItems();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.size(); i++) {
            try {
                sb.append(PropertyUtils.getProperty(items.get(i), "id") + ",");
            } catch (Exception e) {
                logger.error(e.toString());
            }
        }
        ids = sb.toString().split(",");
        return cacheIds();
    }

    /**
     * 删除档案编研记录
     * @return
     */
    @Override
    public String remove() {
        try {
            super.ids = compilationIds;

            List<Archive> archivesToDel = new ArrayList<Archive>();
            for (String id : compilationIds) {
                archivesToDel.add(archiveService.getArchive(modelName, id));
            }

            super.remove();
            Struts2Utils.renderJson("success");
            for (Archive archive : archivesToDel) {
                logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                        archive, "remove");
            }
        } catch (Exception e) {
        	Struts2Utils.renderJson("fail");
            logger.error("保存失败,ids为[{}]" , Arrays.toString(compilationIds));
        }
        return null;
    }

    @Override
    public void setModelName(String modelName) {
        super.setModelName(Document.toArchiveModelName(modelName));
    }

    @Override
    public String execute() {
        return Action.SUCCESS;
    }

    /**
     * 根据条件查找返回结果给前台
     * @param criterions
     * @param orders
     * @return
     */
    @Override
    protected Page<Archive> searchEntity(List<Criterion> criterions, List<Order> orders) {
        Page<Archive> page = archiveService.searchArchive(modelName, criterions, orders, start, limit);
        for (Archive archive : page.getItems()) {
            archive.setHasOriginal(originalService.hasOriginalForComp(archive.getId()));
        }

        return page;
    }

    /**
     * 设置查询条件
     * @param criterions
     * @return
     */
    
    @Override
    protected List<Criterion> createCriterions(ArrayList<Criterion> criterions) {
        return super.createCriterions(criterions);
    }

    /**
     * 获取案卷是否存在卷内
     *
     * @return
     */
    public boolean getIsShowArchiveDoc() {
        try {
            if (modelService.getModel(modelName.concat("_jn")) != null) {
                return true;
            }
        } catch (ModelNotFoundException ex) {
            return false;
        }
        return false;
    }

    /**
     * 编辑或者保存
     * @return edit
     */
    public String editFondsManager(){
        return "edit";
    }

}
