package com.gtis.archive.web;

import com.gtis.archive.core.web.BaseEntityAction;
import com.gtis.archive.entity.Chapter;
import com.gtis.archive.entity.Document;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.LogManagerService;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;


/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-10-13
 */
public class ChapterEntityAction extends BaseEntityAction<Chapter> {
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private LogManagerService logManagerService;

    /**
     * 档案id
     */
    private String archiveId;

    /**
     * 泗洪参照档案的id
     */
    private String preid="";

    /**
     * 案卷modelName
     */
    private String ajModelName;

    public String getPreid() {
        return preid;
    }

    public void setPreid(String preid) {
        this.preid = preid;
    }

    public String getAjModelName() {
        return ajModelName;
    }

    public void setAjModelName(String ajModelName) {
        this.ajModelName = ajModelName;
    }

    @Override
    public void prepare() {
        if (StringUtils.isBlank(id)) {
            entity = archiveService.newChapter(modelName);
            Chapter lastDocument = null;
            lastDocument = archiveService.getMaxSxhChp(modelName, archiveId);
            if (lastDocument != null) {
                try {
                    PropertyUtils.copyProperties(entity, lastDocument);
                    entity.setSxh(entity.getSxh() + 1);
                } catch (Exception ignored) {
                    logger.error(ignored.getMessage());
                }
                entity.setId(null);
            }
            if(!StringUtils.isBlank(archiveId)) {
                entity.setDocumentId(archiveId);
                String jnModel = modelName.replace("cp", "jn");
                Document document = archiveService.getDocument(jnModel, archiveId);
                if (entity.getSxh() == null) {
                    entity.setSxh(1);
                }
                entity.setAjh(document.getAjh());
                entity.setMlh(document.getMlh());
                entity.setQzh(document.getQzh());
                entity.setJnbh(document.getBh());
            }
        } else {
            entity = archiveService.getChapter(modelName, id);
            if (archiveId == null) {
                archiveId = entity.getDocumentId();
            }
        }
        if (entity != null && id != null) {
            try{
                String jnModel = modelName.replace("cp","jn");
                Document document = archiveService.getDocument(jnModel,archiveId);
                if (entity.getSxh() == null) {
                    entity.setSxh(1);
                }
                entity.setAjh(document.getAjh());
                entity.setMlh(document.getMlh());
                entity.setQzh(document.getQzh());
                entity.setJnbh(document.getBh());
            } catch (Exception ex) {
                logger.debug(ex.toString());
            }
        }
    }

    /**
     * 保存实体的方法
     * @return
     * @throws Exception
     */
    @Override
    public String save() throws Exception {
        return renderJs(new Runner() {
            @Override
            public void run() {
                preSave();
                doSave(entity);
                afterSave();
            }
        }, "保存成功", null, getJsCallBack());
    }

    @Override
    protected void doSave(Chapter entity) {
        try {
            archiveService.saveChapter(entity);
        } catch (Exception e) {
            logger.error("保存卷内失败,{}", e.getMessage());
            logger.error("保存卷内失败");
        }

    }

    @Override
    protected String getJsCallBack() {
        return "onDocumentComplete";
    }

    @Override
    protected void afterSave() {
        session.put("currentDId", entity.getId());
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

}
