package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.*;
import com.gtis.archive.service.*;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.*;


/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-9-20
 */
public class ChapterAction extends BaseModelAction<Chapter> {
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private OriginalService originalService;
    @Autowired
    private AjhRangeService ajhRangeService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private LogManagerService logManagerService;
    /**
     * tree id
     */
    private String treeId;
    /**
     * document view type,wlj(未立卷) ylj(已立卷)
     */
    private String type;
    /**
     * 档案id
     */
    private String archiveId;

    /**
     * 链接字段
     */
    private String linkField;

    /**
     * 保存的doc值
     */
    private String docValue;
    /**
     * 传来的单个卷内Id
     */
    private String docId;

    private String code;

    /**
     * 选中的卷内默认值
     */
    private String selDoc;

    /**
     * 添加卷内默认值时是否覆盖原有卷内
     */
    private Boolean isCover;

    private List<String> operationStrs;

    private String permJson;
    
    /** 字段modelName的值 */
    private String fieldModelName;

    /**
     * 档案中卷内显示的字段
     */
    private Map docShowFields;

    private Map docFields;

    private String archiveIdText = "archiveId";
    private String modelNameText = "modelName";

    public List<String> getOperationStrs() {
        return operationStrs;
    }

    public void setOperationStrs(List<String> operationStrs) {
        this.operationStrs = operationStrs;
    }

    public Boolean getIsCover() {
        return isCover;
    }

    public void setIsCover(Boolean isCover) {
        this.isCover = isCover;
    }

    public String getSelDoc() {
        return selDoc;
    }

    public void setSelDoc(String selDoc) {
        this.selDoc = selDoc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDocId() {
        return docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    @Override
    public void setModelName(String modelName) {
        super.setModelName(Archive.toDocumentModelName(modelName));
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public String getTreeId() {
        return treeId;
    }

    public String getType() {
        return type;
    }

    public String getDocValue() {
        return docValue;
    }

    public void setDocValue(String docValue) {
        this.docValue = docValue;
    }

    public void setPermJson(String permJson) {
        this.permJson = permJson;
    }

    /**
     * 获得档案中案卷显示的字段
     *
     * @return
     */
    public Map getDocShowFields() {
        if (docShowFields == null) {
            try {
                Model doc = archiveService.getDocumentModel(Document.toArchiveModelName(modelName));
                docShowFields = JSON.parseObject(doc.getTemplate("showFields"), LinkedHashMap.class);
            } catch (Exception ex) {
                docShowFields = JSON.parseObject(getEntityTemplate("Document-showFields"), LinkedHashMap.class);
            }
        }
        if(docShowFields == null){
            docShowFields = new HashMap();
        }
        return docShowFields;
    }

    /**
     * 获取档案中案卷所有字段
     *
     * @return
     */
    public Map getDocFields() {
        if (docFields == null) {
            try {
                Model doc = archiveService.getDocumentModel(Document.toArchiveModelName(modelName));
                docFields = doc.getInheritfieldsMap();
            } catch (ModelNotFoundException ex) {
                logger.error(ex.getMessage());
            }
        }
        return docFields;
    }

    public String getPermJson() {
        Map<String, Boolean> perm = new HashMap<String, Boolean>();
        if (operationStrs == null || operationStrs.isEmpty()) {
            String location = ServletActionContext.getRequest().getSession().getServletContext().getRealPath("/tpls/permission.json");
            try {
                operationStrs = permissionService.getLeavesId(location); // 获取所有的操作项
            } catch (IOException e) {
                logger.error("读取配置文件permission.json错误，请检查，文件位置为[{}]" , location);
            }
        }
        if (!EnvHolder.isEnable(Switch.isNewPermission)) {
            for (String s : operationStrs) {
                if (securityService.isPermitted(treeId, s)) {
                    perm.put(s, true);
                }
            }
        }else {
            UserInfo userInfo = SessionUtil.getCurrentUser();
            perm = securityService.getUserPermMap(userInfo, treeId);
        }
        return JSON.toJSONString(perm);
    }

    public List<Map<String, Object>> getTree() {
        return treeService.getTree(null, Constants.MODEL_ROOT);
    }

    @Override
    public String execute() throws Exception {
        String location = ServletActionContext.getRequest().getSession().getServletContext().getRealPath("/tpls/permission.json");
        try {
            operationStrs = permissionService.getLeavesId(location); // 获取所有的操作项
        } catch (IOException e) {
            logger.error("读取配置文件permission.json错误，请检查，文件位置为[{}]" , location);
        }

        if (StringUtils.isNotEmpty(modelName)) {
            Resource res = resourceService.findChildResource(null, Document.toArchiveModelName(modelName), Constants.MODEL_ROOT);
            if (res != null) {
                treeId = res.getId();
            } else {
                throw new ModelNotFoundException(modelName);
            }
        }
        modelService.getModel(modelName);
        String id = getId();
        if (id != null) {
            Document doc = archiveService.getDocument(modelName, id);
            if (doc != null) {
                type = doc.getArchiveId() == null ? "wlj" : "ylj";
            }
        }
        return Action.SUCCESS;
    }

    @Override
    public Model getEntityModel() {
        String model = modelName.substring(0,modelName.indexOf("_"));
        return modelService.getModel(model+"_cp");
    }

    @Override
    protected Page<Chapter> searchEntity(List<Criterion> criterions, List<Order> orders) {
        if(modelName.contains("_cp") && modelName.contains("_jn")){
            modelName = modelName.replace("_jn","");
        }
        if (StringUtils.isNotEmpty(archiveId)) {
            if (EnvHolder.isEnable(Switch.JIANGYIN)) {
                List<Chapter> documents = entityService.<Chapter>search(modelName,
                        Collections.singletonList(Restrictions.eq("documentId", archiveId)), orders, 0, Page.ALL).getItems();
                if (!documents.isEmpty()) {
                    String jnModel = modelName.replace("cp","jn");
                    documents.get(0).setDocument(archiveService.getDocument(jnModel, archiveId));
                }
                return new Page<Chapter>(documents);
            } else {
                Page<Chapter> page = entityService.<Chapter>search(modelName,
                        Collections.singletonList(Restrictions.eq("documentId", archiveId)), orders, 0, Page.ALL);
                List<Chapter> lists = page.getItems();
                for (Object object : lists) {
                    try {
                        String id = PropertyUtils.getProperty(object, "id").toString();
                        PropertyUtils.setProperty(object, "hasOriginal", originalService.hasOriginal(id));
                    } catch (Exception e) {
                        break;
                    }
                }

                if (isPrint) {
                    String printCount = EnvHolder.getAppEnv().get(Switch.DOCUMENT_PRINT_COUNT);
                    if (printCount != null && StringUtils.isNotBlank(printCount)) {
                        int iCount = Integer.parseInt(printCount);
                        int j = 0;
                        if (page.getItems().size() % iCount != 0) {
                            j = iCount - (page.getItems().size() % 18);
                        }

                        for (int i = 0; i < j; i++) {
                            Chapter chapter = entityService.newInstance(modelName);
                            chapter.setDocumentId(archiveId);
                            page.getItems().add(chapter);
                        }
                    }

                    isPrint = false;
                }

                return page;
            }
        }
        if (EnvHolder.isEnable(Switch.JIANGYIN)) {
            Page<Chapter> page = super.searchEntity(criterions, orders);
            for (Chapter chapter : page.getItems()) {
                if (StringUtils.isNotBlank(chapter.getDocumentId())) {
                    String jnModel = modelName.replace("cp","jn");
                    chapter.setDocument(archiveService.getDocument(jnModel, chapter.getDocumentId()));
                }
                chapter.setHasOriginal(originalService.hasOriginal(chapter.getId()));
            }
            return page;
        } else {
            return super.searchEntity(criterions, orders);
        }
    }

    @Override
    protected Page<Chapter> searchDocentity(List<Criterion> criterions, List<Order> orders, String archiveId) {
        if (StringUtils.isNotEmpty(archiveId)) {
            if (EnvHolder.isEnable(Switch.JIANGYIN)) {
                List<Chapter> documents = entityService.<Chapter>search(modelName,
                        Collections.singletonList(Restrictions.eq(archiveIdText, archiveId)), orders, 0, Page.ALL).getItems();
                if (!documents.isEmpty()) {
                    String jnModel = modelName.replace("cp","jn");
                    documents.get(0).setDocument(archiveService.getDocument(jnModel, archiveId));
                }
                return new Page<Chapter>(documents);
            } else {
                return new Page<Chapter>(entityService.<Chapter>search(modelName,
                        Collections.singletonList(Restrictions.eq(archiveIdText, archiveId)), orders, 0, Page.ALL).getItems());
            }
        }
        if (EnvHolder.isEnable(Switch.JIANGYIN)) {
            Page<Chapter> page = super.searchEntity(criterions, orders);
            for (Chapter chapter : page.getItems()) {
                if (StringUtils.isNotBlank(chapter.getDocumentId())) {
                    String jnModel = modelName.replace("cp","jn");
                    chapter.setDocument(archiveService.getDocument(jnModel, chapter.getDocumentId()));
                }
                chapter.setHasOriginal(originalService.hasOriginal(chapter.getId()));
            }
            return page;
        } else {
            return super.searchEntity(criterions, orders);
        }

    }

    @Override
    protected List<Criterion> createCriterions(ArrayList<Criterion> criterions) {
        if (type == null || !"all".equals(type)) {
            criterions.add("ylj".equals(type) ? Restrictions.isNotNull(archiveIdText) : Restrictions.isNull(archiveIdText));
        }
        if (EnvHolder.isEnable(Switch.ZHEN_JINAG) && !SessionUtil.getCurrentUser().isAdmin()) {
            String[] name = modelName.split("_");
            List<AjhRange> ajhRanges = ajhRangeService.getAjhRangeByModelName(name[0]);
            List<String> mlhs = new ArrayList<String>();
            UserInfo userInfo = SessionUtil.getCurrentUser();
            String roleids = userInfo.getRoleIds();
            if (!EnvHolder.isEnable(Switch.isNewPermission) && roleids != null) {
                for (String roleid : roleids.split(",")) {
                    roleid = roleid.substring(1, roleid.length() - 1);
                    for (AjhRange ajhRange : ajhRanges) {
                        if (permissionService.getPermissions(ajhRange.getId(), roleid).size() != 0) {
                            mlhs.add(ajhRange.getMlh());
                        }
                    }
                }
            }else {
                String userId = userInfo.getId();
                for (AjhRange ajhRange : ajhRanges){
                    if (permissionService.getUserPermissions(ajhRange.getId(), userId).size() != 0){
                        mlhs.add(ajhRange.getMlh());
                    }
                }
            }
            if (!mlhs.isEmpty()) {
                String sSQL = "(";
                StringBuilder strB = new StringBuilder();
                for (String mlh : mlhs) {
                    strB.append("mlh = '").append(mlh).append("' OR ");
                }
                sSQL = sSQL + strB.toString();
                sSQL = sSQL.substring(0, sSQL.length() - 4);
                sSQL = sSQL + ")";
                criterions.add(Restrictions.sqlRestriction(sSQL));
            }
        }
        return super.createCriterions(criterions);
    }

    @Override
    protected List<Order> createOrders(ArrayList<Order> orders) {
        List<Order> superOrders = super.createOrders(orders);
        if (!superOrders.isEmpty()) {return superOrders;}
        if (StringUtils.isNotEmpty(archiveId)) {
            orders.add(Order.desc("sxh"));
        }
        orders.add(Order.desc("id"));
        return super.createOrders(orders);
    }

    /**
     * 获取卷内所属的档案
     *
     * @return
     */
    private Map docArchive;

    public Map getDocArchive() {
        try {
            if (docArchive == null) {
                docArchive = JSON.parseObject(JSON.toJSONString(archiveService.getSimpleDocument(archiveId), SerializerFeature.WriteMapNullValue));
                ////重置归档时间
                if (docArchive.containsKey("gdsj") && docArchive.get("gdsj") != null && docArchive.get("gdsj").toString() != "null") {
                    Date date = new Date((Long) docArchive.get("gdsj"));
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    docArchive.put("gdsj", sdf.format(date));
                }

                docArchive.remove("id");
            }
        } catch (Exception ex) {
            logger.error(ex.toString());
        }
        return docArchive;
    }

    public String getLinkField() {
        if (linkField == null) {
            try {
                linkField = archiveService.getDocumentModel(modelName).getTemplate("linkField");
            } catch (ModelNotFoundException ex) {
                logger.error(ex.getMessage());
            } catch (TemplateNotFoundException ex) {
                linkField = "tm";
            }
        }
        return linkField;
    }

    public void saveSort() throws Exception {
        try {
            List<Criterion> criterions = new ArrayList<Criterion>();
            criterions.add(Restrictions.eq(archiveIdText, archiveId));
            List<Order> orders = new ArrayList<Order>();
            orders.add(Order.asc(sort));
            Page page = archiveService.searchDocument(modelName, criterions, orders, 0, limit);
            List<Document> documents = page.getItems();
            int start = 1;
            for (int i = 0; i < documents.size(); i++) {
                Document temp = documents.get(i);
                if (temp.getSxh().equals(i + 1)) {
                    String yhStr = temp.getYh();
                    String begin = yhStr.split("-")[0];
                    String end = yhStr.split("-")[1];
                    //需要移动案卷号长度
                    Integer len1 = Integer.valueOf(end) - Integer.valueOf(begin);
                    Integer newStart;
                    Integer newEnd;
                    if (temp.getSxh() == 1) {
                        newStart = start;
                        newEnd = newStart + len1;
                        start = newEnd;
                    } else {
                        newStart = start + 1;
                        newEnd = newStart + len1;
                        start = newEnd;
                    }
                    String newYh = newStart + "-" + newEnd + "";
                    temp.setYh(newYh);
                    entityService.save(temp);
                }
            }
        } catch (Exception e) {
            logger.error("保存排序出现异常" , e);
        }
    }

    /**
     * 获取修改的卷内的信息
     */
    public void getDocInfo() {
        if (!StringUtils.isEmpty(docId)) {
            Document document = archiveService.getDocument(modelName, docId);
            Map map = new HashMap();
            map.put("docId", document.getId());
            map.put("ajh", document.getAjh() == null ? "" : document.getAjh());
            map.put("qzh", document.getQzh() == null ? "" : document.getQzh());
            map.put("mlh", document.getMlh() == null ? "" : document.getMlh());
            map.put(modelNameText, document.getModelName());
            map.put(archiveIdText, document.getArchiveId());
            renderJson(map);
            logger.info("获取id为[{}]的信息",docId);
        }
    }

    /**
     * 根据卷内获取案卷的信息，并返回给前端
     */
    public void getArchiveInfo() {
        if (!StringUtils.isEmpty(archiveId)) {

            Archive archive = archiveService.getArchive(modelName, archiveId);
            logger.info("获取id为[{}]的案卷信息", archive.getId());
            Map map = new HashMap();
            map.put(archiveIdText, archive.getId());
            map.put("ajh", archive.getAjh() == null ? "" : archive.getAjh());
            map.put("qzh", archive.getQzh() == null ? "" : archive.getQzh());
            map.put("mlh", archive.getMlh() == null ? "" : archive.getMlh());
            map.put("dh", archive.getDh() == null ? "" : archive.getDh());
            map.put(modelNameText, archive.getModelName() + "_jn");
            renderJson(map);
        }
    }

    /**
     * 根据特征码获取卷内题名
     */
    public void getTmBycode() {
        try {
            List<Item> items = this.dictService.getItems("featureCode");
            for (Item item : items) {
                String value = item.getValue();
                if (value.equals(code)) {
                    code = item.getName();
                    break;
                }
            }
            renderJson(code);
        }catch (Exception e){
            renderJson(code);
        }
    }

    /**
     * 重新计算页号
     *
     * @param begin
     * @param doc
     * @return
     */
    private int resetYh(int begin, Document doc) {
        Integer ys = doc.getYs();
        StringBuilder sb = new StringBuilder();
        int result = begin + ys;
        if (ys == 0) {
            sb.append("0").append("-").append("0");
        } else {
            sb.append(String.valueOf(begin)).append("-").append(String.valueOf(result - 1));
        }
        doc.setYh(sb.toString());
        return result;
    }

    private int resetSxh(int begin, Document document) {
        document.setSxh(begin + 1);
        return begin + 1;
    }

    /**
     * 删除卷内
     * @return
     */
    @Override
    public String remove() {
        List<Chapter> chpsToDel = new ArrayList<Chapter>();
        modelName = modelName.substring(0,7).toString();
        for (String id : ids) {
            if (StringUtils.isBlank(id)) {
                continue;
            }
            Chapter chp = archiveService.getChapter(modelName, id);
            chpsToDel.add(chp);
        }

        try {
            boolean generateSumByPagination = EnvHolder.isEnable(Switch.GENERATE_SUM_BY_PAGINATION);
            archiveService.removeChapter(modelName, ids);
            for (Chapter chapter : chpsToDel) {
                logManagerService.saveChapterLogManage(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                        chapter, "remove");
            }

            List<Document> docs = archiveService.getArchiveDocuments(modelName, archiveId);
            docs = resetSeqAndPage(docs, generateSumByPagination);
            for (Document d : docs) {
                archiveService.saveDocument(d);
            }
        } catch (Exception e) {
            logger.error("删除失败,{}", e.getMessage());
            logger.error("删除失败");
        }
        return null;
    }

    /**
     * 在新的标签页打开卷内
     * @return
     */
    public String newPage() {
        Struts2Utils.getRequest().setAttribute(archiveIdText, archiveId);
        Struts2Utils.getRequest().setAttribute(modelNameText, modelName);
        Struts2Utils.getRequest().setAttribute("curType", type);
        Struts2Utils.getRequest().setAttribute("docFields", docFields);
        Struts2Utils.getRequest().setAttribute("docShowFields", docShowFields);
        return "newPage";
    }

    /**
     * 对卷内列表重置顺序号和页号
     * 如果有页号并且设置根据页号生成的开关为true则根据页号生成页数
     * @param list 未生成页数或页号的卷内列表
     * @param generateSumByPagination 是否根据页号生成页数
     * @return 生成页号或页数的卷内列表
     */
    private List<Document> resetSeqAndPage(List<Document> list, boolean generateSumByPagination) {
        int begin = 1;
        int sxhBegin = 0;
        // 将页数split后的数组
        String[] pagination;
        // 卷内列表根据顺序号进行排序
        Collections.sort(list, new Comparator<Document>() {
            @Override
            public int compare(Document doc1, Document doc2) {
                int o1 = doc1.getSxh() == null ? Integer.MAX_VALUE : doc1.getSxh();
                int o2 = doc2.getSxh() == null ? Integer.MAX_VALUE : doc2.getSxh();
                return o1 - o2;
            }
        });

        for (int i = 0; i < list.size(); i++) {
            Document doc = list.get(i);
            Integer ys = doc.getYs();
            if (generateSumByPagination && StringUtils.isNotBlank(doc.getYh())) {
                pagination = doc.getYh().split("-");
                pagination = pagination.length > 1 ? pagination : doc.getYh().split("~");
                ys = pagination.length > 1
                        ? Integer.parseInt(pagination[1]) - Integer.parseInt(pagination[0]) + 1
                        : getPageNumByNext(list, i, doc);
                doc.setYs(ys);
            } else if (!generateSumByPagination) {
                if (ys == null || ys == 0) {
                    ys = EnvHolder.isEnable(Switch.AUTO_GENERATE_PAGES) ? 1 : 0;
                }
                doc.setYs(ys);
                begin = resetYh(begin, doc);
            }

            // 若页数或者页号为空则不续编顺序号
            if ((!generateSumByPagination && doc.getYs() != null && doc.getYs() > 0)
                    || (generateSumByPagination && StringUtils.isNotBlank(doc.getYh()))) {
                sxhBegin = resetSxh(sxhBegin, doc);
            }

        }
        return list;
    }

    /**
     * 若卷内页号为单数，则通过计算获取卷内的页数
     * @param list 卷内列表
     * @param i 当前元素的索引
     * @param doc 当前元素
     * @return 当前卷内的页数
     */
    private Integer getPageNumByNext(List<Document> list, int i, Document doc) {
        String[] pagination;// 页码
        int next = i + 1;
        while (next < list.size()) {
            Document d = list.get(next);
            if (StringUtils.isNotBlank(d.getYh())) {
                pagination = d.getYh().split("-");
                pagination = pagination.length > 1 ? pagination : d.getYh().split("~");
                int start = Integer.parseInt(doc.getYh());
                int end = Integer.parseInt(pagination[0]);
                if (end > start) {
                    return end - start;
                } else {
                    logger.error("计算页数错误，请调整到正确的顺序");
                }
            }
            next++;
        }
        return 1;
    }

	public String getFieldModelName() {
		return fieldModelName;
	}

	public void setFieldModelName(String fieldModelName) {
		this.fieldModelName = fieldModelName;
	}
}
