package com.gtis.archive.web;


import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import com.gtis.archive.entity.Loan;
import com.gtis.common.Page;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.entity.LoanCart;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.LoanService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;

public class BorrowAction extends BaseModelAction<Archive> {

    @Autowired
    private LoanService loanService;

    @Autowired
    protected ModelService modelService;

    @Autowired
    protected EntityService entityService;

    @Autowired
    private SysUserService userService;

    @Autowired
    private ArchiveService archiveService;

    private String jsonStringInfo = "success";

    private String archiveType;

    private String idString;

    private String id;

    public String getArchiveType() {
        return this.archiveType;
    }

    public void setArchiveType(String archiveType) {
        this.archiveType = archiveType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIdString(String idString) {
        this.idString = idString;
    }

    public void setIds(String[] ids) {
        this.ids = ids;
    }

    public List<LoanCart> getLoanCar() {
        List<LoanCart> entities = new ArrayList<LoanCart>();
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if (!"".equals(idString) && !idString.isEmpty()) {
            Date date = new Date();
            for (String id : idString.split(",")) {
                LoanCart lc = new LoanCart();
                lc.setArchiveId(id.trim());
                lc.setUserId(userInfo.getId());
                lc.setArchiveType(archiveType);
                lc.setInDate(date);
                lc.setDwdm(getDwdm());
                if (!archiveType.isEmpty()) {
                    if (archiveType.contains("_jn")) {
                        Document document = archiveService.getSimpleDocument(id.trim());
                        if (document.getArchive() != null || document.getArchiveId() != null) {
                            Archive archive = archiveService.getSimpleArchive(document.getArchiveId());
                            if (archive != null) {
                                lc.setAjh(String.valueOf(archive.getAjh()));
                                lc.setMlh(archive.getMlh());
                                lc.setDh(archive.getDh());
                            }
                        }
                        lc.setTm(document.getTm());
                    } else {
                        Archive arvhice = entityService.load(archiveType, id.trim());
                        lc.setMlh(arvhice.getMlh());
                        lc.setAjh(arvhice.getAjh().toString());
                        lc.setTm(arvhice.getTm());
                        lc.setDh(arvhice.getDh());
                    }
                }
                entities.add(lc);
            }
        }
        return entities;
    }

    public String borrows() {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        List<Criterion> criterions = createCriterions(new ArrayList<Criterion>());
        Criterion cr = Restrictions.eq("userId", userInfo.getId());
        criterions.add(cr);
        List<Order> orders = createOrders(new ArrayList<Order>());
        Page<Loan> loans = entityService.search(Loan.class.getSimpleName(),criterions,orders,start,limit);
        Struts2Utils.renderJson(loans);
        return null;
    }

    public String addLoanCar() {
        for (LoanCart loancar : getLoanCar()) {
            loanService.addToCart(loancar);
        }

        Struts2Utils.renderJson(jsonStringInfo);
        return null;
    }

    @Override
    public String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }


    @Override
    public String remove() {
        loanService.removeFromCart(entityService.load(Loan.class, id));
        Struts2Utils.renderJson(jsonStringInfo);
        return null;
    }

    @Override
    public Model getEntityModel() {
        return modelService.getModel("LoanCart");
    }

    /**
     * 获取当前用户借阅车数量
     */
    public void getLoanCartCount() {
        int count = 0;
        String userId = SessionUtil.getCurrentUserId();
        if (!StringUtils.isEmpty(userId)) {
            List<Criterion> criterions = new ArrayList<Criterion>();
            criterions.add(Restrictions.eq("userId", userId));
            criterions.add(Restrictions.eq("sfpz", 4));
            count = entityService.getCount(Loan.class, criterions);
        } else {
            logger.error("用户id为空");
        }
        Struts2Utils.renderJson(String.valueOf(count));
    }

    /**
     *  删除借阅车
     */
    public void removeLoan() {
        try {
            entityService.remove(Loan.class, ids);
            renderJson(jsonStringInfo);
        }catch (Exception e){
            logger.error(e.getMessage());
        }
    }
}
