package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.gtis.archive.Constants;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.*;
import com.gtis.archive.service.*;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import java.io.IOException;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">fan yong sheng</a>
 * @version V1.0, 2016-11-02
 */
public class BindAction extends BaseModelAction<Archive> {
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private DictService dictService;
    @Autowired
    private PermissionService permissionService;

    /**
     * tree id
     */
    private String treeId;

    /**
     * 所有定义的操作项
     */
    private List<Item> operations;

    /**
     * 所有的操作项
     */
    private List<String> operationStr;

    /**
     * 密集柜号
     */
    private String cabinetSno;

    /**
     * 列号
     */
    private String columnId;

    /**
     * 层号
     */
    private String cellid;

    /**
     * 盒号
     */
    private String boxId;

    /**
     * 多个盒号
     */
    private String[] boxIds;

    /**
     * 年度
     */
    private String nd;

    /**
     * 档号
     */
    private String dh;

    /**
     * 目录号
     */
    private String mlh;

    /**
     * 存放位置
     */
    private String cfwz;

    /**
     * 是否显示提示
     */
    private Boolean showInfo;

    /**
     * 保存的值
     */
    private String saveValue;

    /**
     * 入库上架中排序
     */
    private LinkedHashMap<String, String> sjOrderFields;

    public String getTreeId() {
        return treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public List<Item> getOperations() {
        return operations;
    }

    public void setOperations(List<Item> operations) {
        this.operations = operations;
    }

    public List<String> getOperationStr() {
        return operationStr;
    }

    public void setOperationStr(List<String> operationStr) {
        this.operationStr = operationStr;
    }

    public String getNd() {
        return nd;
    }

    public void setNd(String nd) {
        this.nd = nd;
    }

    public String getDh() {
        return dh;
    }

    public void setDh(String dh) {
        this.dh = dh;
    }

    public String getMlh() {
        return mlh;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public String getCabinetSno() {
        return cabinetSno;
    }

    public void setCabinetSno(String cabinetSno) {
        this.cabinetSno = cabinetSno;
    }

    public String getColumnId() {
        return columnId;
    }

    public void setColumnId(String columnId) {
        this.columnId = columnId;
    }

    public String getCellid() {
        return cellid;
    }

    public void setCellid(String cellid) {
        this.cellid = cellid;
    }

    public String getBoxId() {
        return boxId;
    }

    public void setBoxId(String boxId) {
        this.boxId = boxId;
    }

    public String[] getBoxIds() {
        return boxIds;
    }

    public void setBoxIds(String[] boxIds) {
        this.boxIds = boxIds;
    }

    public String getCfwz() {
        return cfwz;
    }

    public void setCfwz(String cfwz) {
        this.cfwz = cfwz;
    }

    public String getSaveValue() {
        return saveValue;
    }

    public void setSaveValue(String saveValue) {
        this.saveValue = saveValue;
    }

    public Boolean getShowInfo() {
        showInfo = false;
        return showInfo;
    }

    public void setShowInfo(Boolean showInfo) {
        this.showInfo = showInfo;
    }

    private List<Map<String, Object>> tree;

    public List<Map<String, Object>> getTree() {
        if (tree == null) {
            List<Map<String, Object>> listTree = treeService.getTree(null, Constants.MODEL_ROOT);
            for (Map item : listTree) {
                logger.debug(item.toString());
                if (item.get("name").equals(Constants.GENERIC)) {
                    listTree.remove(item);
                    break;
                }
            }
            tree = listTree;
        }
        return tree;
    }

    private List<String> ndTree;

    public List<String> getNdTree() {
        if (ndTree == null) {
            ndTree = new ArrayList<String>();
            List list = archiveService.getArchiveNd(modelName);
            if (list != null && !list.isEmpty()) {
                for (int i = 0; i < list.size(); i++) {
                    ndTree.add(list.get(i).toString());
                }
            }
        }

        return ndTree;
    }

    private List<String> qy;

    public List<String> getQy() {
        if (qy == null) {
            qy = new ArrayList<String>();
            List<Item> items = this.dictService.getItems("dwjc");
            if (items != null && !items.isEmpty()) {
                for (int i = 0; i < items.size(); i++) {
                    qy.add(items.get(i).getName());
                }
            }
        }

        return qy;
    }

    private List<String> mlhTree;

    public List<String> getMlhTree() {
        if (mlhTree == null) {
            mlhTree = new ArrayList<String>();
            List list = archiveService.getArchiveMlh(modelName);
            if (list != null && !list.isEmpty()) {
                for (int i = 0; i < list.size(); i++) {
                    mlhTree.add(list.get(i).toString());
                }
            }
        }

        return mlhTree;
    }

    @Override
    public String execute() {
        String location = ServletActionContext.getRequest().getSession().getServletContext().getRealPath("/tpls/permission.json");
        try {
            operationStr = permissionService.getLeavesId(location);
        } catch (IOException e) {
            logger.error("读取permission.json错误,请检查路径 {} permission.json文件是否存在",location);
        }
        if (StringUtils.isNotEmpty(modelName)) {
            Resource res = resourceService.findChildResource(null, modelName, Constants.MODEL_ROOT);
            if (res != null) {
                treeId = res.getId();
            } else {
                throw new ModelNotFoundException(modelName);
            }
        }

        ServletActionContext.getRequest().getSession().setAttribute("username", SessionUtil.getCurrentUser().getUsername());
        return Action.SUCCESS;
    }

    @Override
    public void list() {
        try {
            Page<Map<String, Object>> page = getBindMap();
            renderJson(page);
        } catch (Exception e) {
            renderJson(new Page());
        }
    }

    public Page getBindMap(){
        String fiedsSQL = "count(*),max(ajh),min(ajh),box_id, cfwz, nd, mlh, sjsj";
        String orderSQL = "";
        if(getOrderFields()!=null && getOrderFields().size()>0) {
            for (Map.Entry<String, String> entry : getOrderFields().entrySet()) {
                if (!"box_id".equals(entry.getKey()) && !"cfwz".equals(entry.getKey()) && !"sjsj".equals(entry.getKey())) {
                    fiedsSQL = fiedsSQL + ", " + entry.getKey();
                }
                if("".equals(orderSQL)){
                    orderSQL = entry.getKey() + " " + entry.getValue();
                }else {
                    orderSQL = orderSQL + ", " + entry.getKey() + " " + entry.getValue();
                }
            }
        }

        List list = archiveService.getBox(modelName, nd, dh, mlh, boxId, cabinetSno, columnId, cellid, cfwz, fiedsSQL, orderSQL);
        List<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); i++) {
                Object[] objects = (Object[]) list.get(i);
                if (objects != null && objects.length > 0) {
                    Map<String, Object> map = new HashMap<String, Object>();
                    map.put("xh", list.size()-i);
                    map.put("hh", objects[3]);
                    map.put("ajs", objects[2] + "-" + objects[1]);
                    map.put("nd", objects[5]);
                    map.put("mlh", objects[6]);
                    map.put("sjsj", objects[7]);
                    if (objects.length > 1) {
                        map.put("cfwz", objects[4]);
                    }

                    mapList.add(map);
                }
            }
        }

        List<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        for (int c = 0; c < limit; c++){
            int s=start;
            s = s + c;
            if(s < mapList.size()){
                maps.add(mapList.get(s));
            }
        }
        Page<Map<String, Object>> page = new Page<Map<String, Object>>();
        page.setItems(maps);
        page.setStart(start);
        page.setTotalCount(mapList.size());
        return page;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected LinkedHashMap<String, String> getOrderFields() {
        try {
            return JSON.parseObject(getEntityTemplate("sjOrderFields"), LinkedHashMap.class);
        } catch (TemplateNotFoundException ex) {
            return null;
        }
    }

    /**
     * 删除盒号信息
     */
    public void delete(){
        Page<Map<String, Object>> page = getBindMap();
        List<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();

        maps = page.getItems();
        for(Map map:maps){
            for(String s:boxIds){
                if(s.equals(map.get("xh").toString())){
                    Integer boxId = Integer.parseInt(map.get("hh").toString());
                    String nd = Struts2Utils.requiredString(map.get("nd"));
                    String mlh = Struts2Utils.requiredString(map.get("mlh"));
                    String cfwz = null;
                    if(map.get("cfwz") != null) {
                        cfwz = map.get("cfwz").toString();
                    }
                    String ajhs = Struts2Utils.requiredString(map.get("ajs"));
                    List<Archive> archives = getArchives(boxId,nd,mlh,cfwz,ajhs);
                    updataBoxId(archives);
                }
            }
        }
    }

    public void updataBoxId(List<Archive> archives) {
        for(Archive archive :archives){
            String[] strings= new String[]{archive.getBoxId().toString()};
            archiveService.deleteArchiveBoxId(strings,archive.getModelName(),archive.getNd(),archive.getDh(),archive.getMlh(),archive.getCfwz());
        }
    }

    /**
     * 盒号信息是否更改
     */
    public void isEdit() {
        try {
            String fiedsSQL = "box_id, cfwz, nd, mlh, sjsj";
            String orderSQL = "";
            for (Map.Entry<String, String> entry : getOrderFields().entrySet()) {
                if(!"box_id".equals(entry.getKey()) && !"cfwz".equals(entry.getKey()) && !"sjsj".equals(entry.getKey())){
                    fiedsSQL = fiedsSQL + ", " + entry.getKey();
                    orderSQL = entry.getKey() + " " + entry.getValue() + " ";
                }
            }

            List list = archiveService.getBox(modelName, nd, dh, mlh, boxId, cabinetSno, columnId, cellid, cfwz, fiedsSQL, orderSQL);

            if (saveValue == null || StringUtils.isBlank(saveValue)) {
                return;
            }

            List archiveList = JSONArray.parseArray(saveValue);

            if (list != null && !list.isEmpty() && archiveList != null && !archiveList.isEmpty()) {
                for (int i = 0; i < archiveList.size(); i++) {
                    Map maps = (Map)archiveList.get(i);
                    String boxId = maps.get("boxId").toString();
                    String cfwz = maps.get("cfwz").toString();
                    for(int n = 0; n < list.size(); n++) {
                        Object[] objects = (Object[]) list.get(n);
                        String hh = objects[0].toString();
                        Object wz = "";
                        if (objects.length > 1) {
                            wz = objects[1];
                        }
                        if(boxId.equals(hh) && !cfwz.equals(wz)){
                            renderJson("false");
                            return;
                        }
                    }
                    renderJson("true");
                    return;
                }
                renderJson("true");
            }else {
                renderJson("true");
            }
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    /**
     * 保存盒号信息
     */
    public void saveArchiveBox() {
        try {
            if (saveValue == null || StringUtils.isBlank(saveValue)) {
                return;
            }
            List archiveList = JSONArray.parseArray(saveValue);
            if (archiveList != null && !archiveList.isEmpty()) {
                for (int i = 0; i < archiveList.size(); i++) {
                    Map archiveMap = (Map) archiveList.get(i);
                    String boxId = archiveMap.get("boxId").toString();
                    String cfwz = archiveMap.get("cfwz").toString();
                    archiveService.updateArchiveBoxIDd(modelName, nd, dh, mlh, boxId, cfwz);
                }
            }

            renderJson("保存成功！");
        } catch (Exception e) {
            logger.error(e.getMessage());
            renderJson("保存失败：" + e.toString());
        }
    }

    public List<Archive> getArchives(Integer boxId,String nd,String mlh,String cfwz,String ajhs){
        List<Archive> archives;

        List<Criterion> criterions = new ArrayList<Criterion>();
        if (boxId != null) {
            criterions.add(Restrictions.eq("boxId", boxId));
        }
        if (nd != null) {
            criterions.add(Restrictions.eq("nd", nd));
        }
        if (mlh != null) {
            criterions.add(Restrictions.eq("mlh", mlh));
        }
        if (cfwz != null) {
            criterions.add(Restrictions.eq("cfwz", cfwz));
        }else{
            criterions.add(Restrictions.isNull("cfwz"));
        }

        if(ajhs != null) {
            String[] list = ajhs.split("-");
            criterions.add(Restrictions.between("ajh",Integer.valueOf(list[0]),Integer.valueOf(list[1])));
        }

        List<Order> orders = new ArrayList<Order>();

        orders.add(Order.desc("ajh"));

        Page<Archive> page = archiveService.searchArchive(modelName, criterions, orders, start, limit);

        archives = page.getItems();

        return archives;
    }
}
