package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.*;
import com.gtis.archive.service.*;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContext;
import java.io.*;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-8-23
 */
public class ArchiveopenAction extends BaseModelAction<Archive> {
    private static final Object Lock = 0x001;

    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private DictService dictService;
    @Autowired
    private AjhRangeService ajhRangeService;
    @Autowired
    private OriginalService originalService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private LogManagerService logManagerService;

    /**
     * tree id
     */
    private String treeId;
    /**
     * archive view type,wgd(未归档) ygd(已归档)
     */
    private String type;

    /**
     * 所有的操作项
     */
    private List<String> operationStrs;

    private Map<String, String> topMenu;
    /**
     * 自动组盒用的目录号
     */
    private String mlh;
    /**
     * 自动组盒用的起始案卷号
     */
    private Integer ajh;

    /**
     * 自动组合截止案卷号
     */
    private Integer endAjh;
    /**
     * 自动组盒盒号
     */
    private Integer boxId;
    /**
     * 自动组盒用装盒份数
     */
    private Integer boxSize;

    /**
     * 自动组盒用装盒份数
     */
    private String nd;
    /**
     * 档案中卷内显示的字段
     */
    private Map docShowFields;
    private Map docFields;

    /**
     * 链接字段
     */
    private String linkField;

    private String docLinkField;

    private String wgdState = "false";

    /**
     * excel导入档案
     */
    private File upload;

    private String uploadFileName; //文件名称

    /**
     * 档案流程节点字典
     */
    private List<Item> flowDict;


    /**
     * 机柜所在位置
     */
    private String jgszwz;

    /**
     * 操作机柜命令
     */
    private String cmd;

    /**
     * 分类号检索
     */
    private String flhjs;

    /**
     * 档号
     */
    private String dh;

    /**
     * 档案id
     */
    private String djDaId;

    /**
     * 原文所属ID
     */
    private String ownerId;

    /**
     * 原文所属业务模型名
     */
    private String ownerModelName;

    /**
     * 字符串类型的boxId
     **/
    private String sboxId;

    /**
     * 档案ids
     */
    private String[] archiveIds;
    /**
     * 单位代码
     */
    private String dwdm;

    private String queryArchive;

    /**
     * 原文id
     */
    private String originalId;

    /**
     * 开放状态: public,close
     */
    private String openState;

    String closeStateInfo = "close";
    String openStateInfo = "public";

    public String[] getArchiveIds() {
        return archiveIds;
    }

    public void setArchiveIds(String[] archiveIds) {
        this.archiveIds = archiveIds;
    }

    public String getNd() {
        return nd;
    }

    public void setNd(String nd) {
        this.nd = nd;
    }


    public Map<String, String> getQueryParam() {
        if (EnvHolder.isEnable(Switch.SJWS)) {
            try {
                return JSON.parseObject(getEntityTemplate("queryParam"), LinkedHashMap.class);
            } catch (Exception ex) {
                return new HashMap<String, String>();
            }

        } else {
            return new HashMap<String, String>();
        }

    }

    public Map<String, String> getReceivedParam() {
        if (EnvHolder.isEnable(Switch.SJWS)) {
            try {
                return JSON.parseObject(getEntityTemplate("receivedParam"), LinkedHashMap.class);
            } catch (Exception ex) {
                return new HashMap<String, String>();
            }

        } else {
            return new HashMap<String, String>();
        }
    }

    public String getPermJson() {
        Map<String, Boolean> perm = new HashMap<String, Boolean>();
        if (!EnvHolder.isEnable(Switch.isNewPermission)) {
            for (String s : operationStrs) {
                if (securityService.isPermitted(treeId, s)) {
                    perm.put(s, true);
                }
            }
        }else {
            UserInfo userInfo = SessionUtil.getCurrentUser();
            if (userInfo.isAdmin()){
                for (String s : operationStrs) {
                    perm.put(s, true);
                }
            }else {
                perm = securityService.getUserPermMap(userInfo,treeId);
            }
        }
        return JSON.toJSONString(perm);
    }

    public Map<String, Boolean> getPerms() {
        Map<String, Boolean> perm = new HashMap<String, Boolean>();
        if (!EnvHolder.isEnable(Switch.isNewPermission)) {
            for (String s : operationStrs) {
                if (securityService.isPermitted(treeId, s)) {
                    perm.put(s, true);
                }
            }
        }else {
            UserInfo userInfo = SessionUtil.getCurrentUser();
            if (userInfo.isAdmin()){
                for (Item item : dictService.getItems(Permission.SYS_FUNCTION_DICT)) {
                    perm.put(item.getName(), true);
                }
            }else {
                perm = securityService.getUserPermMap(userInfo,"sys");
            }
        }
        return perm;
    }

    public String getTreeJson() throws JSONException {
        return JSON.toJSONString(rewrite(treeService.getTree(treeId)));
    }

    /**
     * 获取查看流程url地址字典
     */
    public Map<String, Boolean> getFlow() {
        Map<String, Boolean> flow = new HashMap<String, Boolean>();
        for (Model model : modelService.getModels()) {
            flow.put(model.getName(), false);
        }
        for (Item item : flowDict) {
            flow.put(item.getName(), true);
        }
        return flow;
    }

    /**
     * 获取查看流程url地址字典备注
     */
    public void getFlowRemark() {
        String remark = null;
        flowDict = dictService.getItems(Permission.FLOW_DICT);
        for (Item item : flowDict) {
            if (item.getName().equals(modelName)) {
                remark = item.getRemark();
            }
        }
        renderJson(remark);
    }

    private List<Map<String, Object>> tree;

    public List<Map<String, Object>> getTree() {
        if (tree == null) {
            List<Map<String, Object>> listTree = treeService.getTree(null, Constants.MODEL_ROOT);
            for (Map item : listTree) {
                logger.debug(item.toString());
                if (item.get("name").equals(Constants.GENERIC)) {
                    listTree.remove(item);
                    break;
                }
            }
            tree = listTree;
        }
        return tree;
    }

    public Map<String, String> getTopMenu() {
        if (topMenu == null) {
            topMenu = new LinkedHashMap<String, String>();
            for (Item item : dictService.getItems("archiveMenu")) {
                if ("true".equalsIgnoreCase(item.getValue())) {
                    topMenu.put(item.getName(), item.getRemark());
                }
            }
        }

        if (EnvHolder.isEnable(Switch.IMPORTEXCEL)) {
            List<String> menuList = new ArrayList<String>();
            for (Item item : dictService.getItems("importMenu")) {
                menuList.add(item.getName());
            }
            if (!menuList.contains(modelName)) {
                topMenu.remove("importExcel");
            }
        } else {
            topMenu.remove("importExcel");
        }
        return topMenu;
    }

    public String getQueryArchive() {
        return queryArchive;
    }

    public void setQueryArchive(String queryArchive) {
        this.queryArchive = queryArchive;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected LinkedHashMap<String, String> getOrderFields() {
        try {
            if (isPrint) {
                return JSON.parseObject(getEntityTemplate("printOrderFields"), LinkedHashMap.class);
            } else {
                String tmp = "ygd".equals(type) ? "ygdOrderFields" : "wgdOrderFields";
                return JSON.parseObject(getEntityTemplate(tmp), LinkedHashMap.class);
            }
        } catch (TemplateNotFoundException ex) {
            return JSON.parseObject(getEntityTemplate("orderFields"), LinkedHashMap.class);
        }
    }

    public String getOriginalId() {
        return originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    public String getSboxId() {
        return sboxId;
    }

    public void setSboxId(String sboxId) {
        this.sboxId = sboxId;
    }

    public void setDwdm(String dwdm) {
        this.dwdm = dwdm;
    }

    public Integer getBoxId() {
        return boxId;
    }

    public void setBoxId(Integer boxId) {
        this.boxId = boxId;
    }

    public ArchiveService getArchiveService() {
        return archiveService;
    }

    public void setArchiveService(ArchiveService archiveService) {
        this.archiveService = archiveService;
    }

    @Override
    public void setModelName(String modelName) {
        if (modelName.startsWith(Constants.ARCHIVE_PREFIX)) {
            queryArchive = "1";
        } else {
            queryArchive = "0";
        }

        super.setModelName(Document.toArchiveModelName(modelName));
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public String getMlh() {
        return mlh;
    }

    public void setAjh(Integer ajh) {
        this.ajh = ajh;
    }

    public void setEndAjh(Integer endAjh) {
        this.endAjh = endAjh;
    }

    public void setBoxSize(Integer boxSize) {
        this.boxSize = boxSize;
    }

    public Integer getBoxSize() {
        return boxSize;
    }

    public String getTreeId() {
        return treeId;
    }

    public String getType() {
        return type;
    }

    public List<String> getOperationStrs() {
        return operationStrs;
    }

    public String getWgdState() {
        return wgdState;
    }

    public void setWgdState(String wgdState) {
        this.wgdState = wgdState;
    }

    public File getUpload() {
        return upload;
    }

    public void setUpload(File upload) {
        this.upload = upload;
    }

    public String getUploadFileName() {
        return uploadFileName;
    }

    public void setUploadFileName(String uploadFileName) {
        this.uploadFileName = uploadFileName;
    }

    public String getFlhjs() {
        return flhjs;
    }

    public void setFlhjs(String flhjs) {
        this.flhjs = flhjs;
    }

    public String getDh() {
        return dh;
    }

    public void setDh(String dh) {
        this.dh = dh;
    }

    public String getDjDaId() {
        return djDaId;
    }

    public void setDjDaId(String djDaId) {
        this.djDaId = djDaId;
    }

    public String getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerModelName() {
        return ownerModelName;
    }

    public void setOwnerModelName(String ownerModelName) {
        this.ownerModelName = ownerModelName;
    }

    public String getJgszwz() {
        return jgszwz;
    }

    public void setJgszwz(String jgszwz) {
        this.jgszwz = jgszwz;
    }

    public String getCmd() {
        return cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public String getTddjPath() {
        return EnvHolder.getAppEnv().get(Switch.TDDJPATH);
    }

    public static Object getLock() {
        return Lock;
    }

    public String getOpenState() {
        return openState;
    }

    public void setOpenState(String openState) {
        this.openState = openState;
    }

    @Override
    public String execute() {
        flowDict = dictService.getItems(Permission.FLOW_DICT);
        String location = ServletActionContext.getRequest().getSession().getServletContext().getRealPath("/tpls/permission.json");
        try {
            operationStrs = permissionService.getLeavesId(location); // 获取所有的操作项
        } catch (IOException e) {
            logger.error("读取配置文件permission.json错误，请检查，文件位置为{}" + location,e);
        }
        if (StringUtils.isNotEmpty(modelName)) {
            Resource res = resourceService.findChildResource(null, modelName, Constants.MODEL_ROOT);
            if (res != null) {
                treeId = res.getId();
            } else {
                throw new ModelNotFoundException(modelName);
            }
        }
        modelService.getModel(modelName);
        String id = getId();
        if (id != null) {
            Archive archive = archiveService.getArchive(modelName, id);
            if (archive != null) {
                openState = archive.getOpen() == 0 ? closeStateInfo : openStateInfo;
            }
        }
        ServletActionContext.getRequest().getSession().setAttribute("username", SessionUtil.getCurrentUser().getUsername());
        return Action.SUCCESS;
    }

    @Override
    protected Page<Archive> searchEntity(List<Criterion> criterions, List<Order> orders) {
        Page<Archive> page = archiveService.searchArchive(modelName, criterions, orders, start, limit);
        for (Archive archive : page.getItems()) {
            archive.setHasOriginal(originalService.hasOriginal(archive.getId()));
        }
        return page;
    }

    @Override
    protected List<Criterion> createCriterions(ArrayList<Criterion> criterions) {
        String resourceIdInfo = "resourceId";
        if (ajh != null) {
            criterions.add(Restrictions.eq("mlh", mlh));
            criterions.add(Restrictions.gt("ajh", ajh - 1));
            if (endAjh != null) {
                criterions.add(Restrictions.lt("ajh", endAjh + 1));
            }
            if (nd != null) {
                criterions.add(Restrictions.eq("nd", nd));
            }
            sort = "ajh";
        } else {
            if (openState.equalsIgnoreCase(openStateInfo)){
                criterions.add(Restrictions.or(Restrictions.isNull("open"),Restrictions.eq("open",1)));
            }
            if (openState.equalsIgnoreCase(closeStateInfo)){
                criterions.add(Restrictions.eq("open",0));
            }

            if (mlh != null && StringUtils.isNotBlank(mlh)) {
                criterions.add(Restrictions.eq("mlh", mlh));
            }
            if (dwdm == null) {
                dwdm = getDwdm();
            }
            if (StringUtils.isNotBlank(treeId)) {
                if ("checkbox".equals(EnvHolder.getAppEnv().get(Switch.CLASSIFYVIEWMODE))) {
                    String[] treeIds = treeId.split(",");
                    if (treeIds.length == 1) {
                        if (resourceService.getResource(treeId).getName().equals(modelName)) {
                            criterions.add(Restrictions.or(Restrictions.eq(resourceIdInfo, treeId), Restrictions.isNull(resourceIdInfo)));
                        } else {
                            criterions.add(Restrictions.eq(resourceIdInfo, treeId));
                        }
                    } else {
                        if (treeIds.length > 2) {
                            Criterion temp = Restrictions.or(Restrictions.eq(resourceIdInfo, treeIds[0]), Restrictions.eq(resourceIdInfo, treeIds[1]));
                            for (int i = 2; i < treeIds.length; i++) {
                                temp = Restrictions.or(temp, Restrictions.eq(resourceIdInfo, treeIds[i]));
                            }
                            criterions.add(temp);
                        } else {
                            criterions.add(Restrictions.or(Restrictions.eq(resourceIdInfo, treeIds[0]), Restrictions.eq(resourceIdInfo, treeIds[1])));
                        }
                    }
                } else {
                    if (resourceService.getResource(treeId).getName().equals(modelName)) {
                        criterions.add(Restrictions.or(Restrictions.eq(resourceIdInfo, treeId), Restrictions.isNull(resourceIdInfo)));
                    } else {
                        criterions.add(Restrictions.eq(resourceIdInfo, treeId));
                    }
                }
            } else {
                criterions.add(Restrictions.isNull(resourceIdInfo));
            }

            if (EnvHolder.isEnable(Switch.ZHEN_JINAG) && !SessionUtil.getCurrentUser().isAdmin()) {
                List<AjhRange> ajhRanges = ajhRangeService.getAjhRangeByModelName(modelName);
                List<String> mlhs = new ArrayList<String>();
                String roleids = SessionUtil.getCurrentUser().getRoleIds();
                if (roleids != null) {
                    for (String roleid : roleids.split(",")) {
                        roleid = roleid.substring(1, roleid.length() - 1);
                        for (AjhRange ajhRange : ajhRanges) {
                            if (permissionService.getPermissions(ajhRange.getId(), roleid).size() != 0) {
                                mlhs.add(ajhRange.getMlh());
                            }
                        }
                    }

                    if (!mlhs.isEmpty()) {
                        String sSQL = "(";
                        for (String mlh : mlhs) {
                            StringBuilder strB = new StringBuilder();
                            strB.append(sSQL).append("mlh = '").append(mlh).append("' OR");
                            sSQL = strB.toString();
                        }
                        sSQL = sSQL.substring(0, sSQL.length() - 4);
                        sSQL = sSQL + ")";
                        criterions.add(Restrictions.sqlRestriction(sSQL));
                    }
                }
            }
        }

        return super.createCriterions(criterions);
    }

    /**
     * 分类号类型检索
     *
     * @return
     */
    public String searchFlh() {
        String flhtj = archiveService.flhjs(flhjs, modelName);
        renderJson(flhtj);
        return null;
    }

    @SuppressWarnings("unchecked")
    private List<Map<String, Object>> rewrite(List<Map<String, Object>> tree) {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if (tree != null) {
            for (Map<String, Object> map : tree) {
                rewrite((List<Map<String, Object>>) map.get("children"));
                String id = (String) map.get("id");
                Map<String, Boolean> perm = new HashMap<String, Boolean>();
                if (!EnvHolder.isEnable(Switch.isNewPermission)) {
                    for (String s : operationStrs) {
                        if (securityService.isPermitted(id, s)) {
                            perm.put(s, true);
                        }
                    }
                }else if (EnvHolder.isEnable(Switch.isNewPermission) && userInfo.isAdmin()){
                    for (String s : operationStrs) {
                        perm.put(s, true);
                    }
                }else {
                    perm = securityService.getUserPermMap(userInfo,id);
                }
                map.put("perm", perm);
            }
        }
        return tree;
    }

    /**
     * 获得档案中案卷显示的字段
     *
     * @return
     */
    public Map getDocShowFields() {
        if (docShowFields == null) {
            try {
                Model doc = archiveService.getDocumentModel(modelName);
                docShowFields = JSON.parseObject(doc.getTemplate("showFields"), LinkedHashMap.class);
            } catch (Exception ex) {
                docShowFields = JSON.parseObject(getEntityTemplate("Document-showFields"), LinkedHashMap.class);
            }
        }
        if(docShowFields == null){
            docShowFields = new HashMap();
        }
        return docShowFields;
    }

    /**
     * 获取档案中案卷所有字段
     *
     * @return
     */
    public Map getDocFields() {
        if (docFields == null) {
            try {
                Model doc = archiveService.getDocumentModel(modelName);
                docFields = doc.getInheritfieldsMap();
            } catch (ModelNotFoundException ex) {
                logger.error(ex.getMessage());
            }
        }
        return docFields;
    }

    public String getLinkField() {
        if (linkField == null) {
            try {
                linkField = archiveService.getArchiveModel(modelName).getTemplate("linkField");
            } catch (Exception ex) {
                linkField = "tm";
            }
        }
        return linkField;
    }

    /**
     * 获取是否存在卷内案卷模型
     *
     * @return
     */
    public boolean getIsShowArchiveInfo() {
        try {
            if (modelService.getModel(modelName.concat("_ai")) != null) {
                return true;
            }
        } catch (ModelNotFoundException ex) {
            return false;
        }
        return false;
    }

    /**
     * 获取案卷是否存在卷内
     *
     * @return
     */
    public boolean getIsShowArchiveDoc() {
        try {
            if (modelService.getModel(modelName.concat("_jn")) != null) {
                return true;
            }
        } catch (ModelNotFoundException ex) {
            return false;
        }
        return false;
    }

    private List docEntities;

    /**
     * 获取档案相关卷内值
     *
     * @return
     */
    public List getDocEntities() {
        if (docEntities != null) {return docEntities;}
        docEntities = new ArrayList();
        if (ids.length > 0) {
            for (String id : ids) {
                docEntities.addAll(archiveService.getArchiveDocuments(modelName, id));
            }
        }

        return docEntities;
    }

    public void setIdString(String idString) {
        if (StringUtils.isNotBlank(idString)) {
            ids = idString.split(",");
        }
    }

    /**
     * 获取单位代码
     *
     * @return
     */
    @Override
    public String getDwdm() {
        dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            ////单位代码用部门代码进行替换
            if (EnvHolder.isEnable(Switch.ORAGAN_NO)) {
                String oraganNo = null;
                List<PfOrganVo> pfOrganVoList = userService.getOrganListByUser(SessionUtil.getCurrentUserId());
                if (pfOrganVoList != null && !pfOrganVoList.isEmpty()) {
                    PfOrganVo pfOrganVo = pfOrganVoList.get(0);
                    oraganNo = pfOrganVo.getOraganNo();
                }

                dwdm = oraganNo;
            } else {
                UserInfo userInfo = new UserInfo();
                SecurityContext context = (SecurityContext)session.get("SPRING_SECURITY_CONTEXT");
                if (context != null) {
                    Authentication authentication = context.getAuthentication();
                    userInfo =(UserInfo) authentication.getPrincipal();
                }
                dwdm = userInfo.getRegionCode();
            }
        }

        return dwdm;
    }

    public void getUserCode(){
        String userCode = getUser().getRegionCode();
        renderJson(userCode);
    }

    public void docList() {
        if (djDaId == null) {
            return;
        }
        Archive archive = archiveService.getArchive(modelName, djDaId);
        List<Document> documentList = archiveService.getArchiveDocuments(archive);
        renderJson(new Page<Document>(documentList));
    }

    public void publicArchive(){
        try {
            for (String id : ids) {
                if (StringUtils.isBlank(id)) {
                    continue;
                }
                Archive archive = archiveService.getArchive(modelName, id);
                archive.setOpen(1);
                logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                        archive, openStateInfo);
                renderJson("操作成功");
            }
        }catch (Exception e){
            logger.error(e.getMessage());
            renderJson("操作失败，请查看日志");
        }
    }

    public void closeArchive(){
        try {
            for (String id : ids) {
                if (StringUtils.isBlank(id)) {
                    continue;
                }
                Archive archive = archiveService.getArchive(modelName, id);
                archive.setOpen(0);
                logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                        archive, closeStateInfo);
                renderJson("操作成功");
            }
        }catch (Exception e){
            logger.error(e.getMessage());
            renderJson("操作失败，请查看日志");
        }
    }

}

