package com.gtis.archive.web;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.ArchiveJdHistory;
import com.gtis.archive.service.ArchiveJdHistoryService;
import com.gtis.archive.service.LogManagerService;
import com.gtis.common.Page;
import com.gtis.web.SessionUtil;

/**
 * 描述：鉴定审批历史操作
 * @author 卜祥东
 * 2017年10月19日 上午10:06:45
 */
public class ArchiveappraisalJdHistoryAction extends BaseModelAction<ArchiveJdHistory> {

    @Autowired
    private LogManagerService logManagerService;
    @Autowired
    private ArchiveJdHistoryService archiveJdHistoryService;
    
    /**
     * 列表要显示的字段
     */
    private Map showFields;

    private String type;
    
    /**
     * 审批意见
     */
    private String spyj;
    
    /**
     * 链接字段
     */
    private String linkField;
    
    public String getLinkField() {
        if (linkField == null) {
            try {
                linkField = archiveService.getArchiveModel(modelName).getTemplate("linkField");
            } catch (Exception ex) {
                linkField = "tm";
            }
        }
        return linkField;
    }

    @Override
    public Map getShowFields() {
        if (showFields == null) {
            showFields = JSON.parseObject(getEntityTemplate("showFields"), LinkedHashMap.class);
        }
        return showFields == null ? Collections.emptyMap() : showFields;
    }

    @Override
    protected Page<ArchiveJdHistory> searchEntity(final List<Criterion> criterions, final List<Order> orders) {
    	criterions.add(Restrictions.eq("sqrId",  SessionUtil.getCurrentUserId()));
        return entityService.search(ArchiveJdHistory.class, criterions, orders, start, limit);
    }

    
    
	public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }
    
    public String[] getIds() {
        return ids;
    }

    public void setIds(String[] ids) {
        this.ids = ids;
    }

	public String getSpyj() {
		return spyj;
	}

	public void setSpyj(String spyj) {
		this.spyj = spyj;
	}
    
}
