package com.gtis.archive.web;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.ArchiveJdHistory;
import com.gtis.archive.service.ArchiveJdHistoryService;
import com.gtis.archive.service.LogManagerService;
import com.gtis.common.Page;
import com.gtis.web.SessionUtil;

/**
 * 描述：鉴定审批操作
 * @author 卜祥东
 * 2017年10月12日 上午10:06:45
 */
public class ArchiveappraisalJdAction extends BaseModelAction<ArchiveJdHistory> {

    @Autowired
    private LogManagerService logManagerService;
    @Autowired
    private ArchiveJdHistoryService archiveJdHistoryService;
    
    /**
     * 列表要显示的字段
     */
    private Map showFields;

    private String type;
    
    /**
     * 审批意见
     */
    private String spyj;
    
    /**
     * 链接字段
     */
    private String linkField;
    
    public String getLinkField() {
        if (linkField == null) {
            try {
                linkField = archiveService.getArchiveModel(modelName).getTemplate("linkField");
            } catch (Exception ex) {
                linkField = "tm";
            }
        }
        return linkField;
    }

    @Override
    public Map getShowFields() {
        if (showFields == null) {
            showFields = JSON.parseObject(getEntityTemplate("showFields"), LinkedHashMap.class);
        }
        return showFields == null ? Collections.emptyMap() : showFields;
    }

    @Override
    protected Page<ArchiveJdHistory> searchEntity(final List<Criterion> criterions, final List<Order> orders) {
    	criterions.add(Restrictions.like("spztName",  "%待审批"));
        return entityService.search(ArchiveJdHistory.class, criterions, orders, start, limit);
    }

    
    /**
     * 描述：档案鉴定审批通过
     * @author 卜祥东
     * 2017年9月28日 上午9:02:24
     */
    public void examed() {
        for (String id : ids) {
            if (StringUtils.isBlank(id)) {
                continue;
            }
            try {
				ArchiveJdHistory tempArchiveJdHistory = archiveJdHistoryService.getSimpleArchiveJdHistory(id);
				Archive archiveTemp = entityService.load(Archive.class, tempArchiveJdHistory.getArchiveId());
				int key = tempArchiveJdHistory.getSpztName().indexOf("待审批");
				tempArchiveJdHistory.setSpztName(tempArchiveJdHistory.getSpztName().substring(0, key)+"审批通过");
				tempArchiveJdHistory.setSprId(SessionUtil.getCurrentUserId());
				tempArchiveJdHistory.setSprName(SessionUtil.getCurrentUser().getUsername());
				tempArchiveJdHistory.setSprq(new Date());
				archiveJdHistoryService.saveArchiveJdHistory(tempArchiveJdHistory);
				if(tempArchiveJdHistory.getSpztName().indexOf("销毁") > -1){
					archiveTemp.setState(8);//销毁
				    logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
				    		archiveTemp, "destroy");
				}else{
					archiveTemp.setBgqx(tempArchiveJdHistory.getSpztName().substring(0, key));//提升档案
				}
				archiveService.saveArchive(archiveTemp);
			} catch (Exception e) {
				logger.error(e.getMessage());
			}
        }
    }

    /**
     * 描述：档案鉴定审批不通过
     * @author 卜祥东
     * 2017年9月28日 上午9:02:24
     */
    public void unexamed() {
        for (String id : ids) {
            if (StringUtils.isBlank(id)) {
                continue;
            }
			ArchiveJdHistory tempArchiveJdHistory = archiveJdHistoryService.getSimpleArchiveJdHistory(id);
			int key = tempArchiveJdHistory.getSpztName().indexOf("待审批");
			tempArchiveJdHistory.setSpztName(tempArchiveJdHistory.getSpztName().substring(0,key)+"审批不通过");
			tempArchiveJdHistory.setSprId(SessionUtil.getCurrentUserId());
			tempArchiveJdHistory.setSprName(SessionUtil.getCurrentUser().getUsername());
			tempArchiveJdHistory.setSprq(new Date());
			tempArchiveJdHistory.setSpyj(spyj);
			archiveJdHistoryService.saveArchiveJdHistory(tempArchiveJdHistory);
        }
    }
    
	public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }
    
    public String[] getIds() {
        return ids;
    }

    public void setIds(String[] ids) {
        this.ids = ids;
    }

	public String getSpyj() {
		return spyj;
	}

	public void setSpyj(String spyj) {
		this.spyj = spyj;
	}
    
}
