package com.gtis.archive.web;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.ArchiveJdHistory;
import com.gtis.archive.entity.RecordAjhRange;
import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.ArchiveJdHistoryService;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.LogManagerService;
import com.gtis.archive.service.RecordAjhRangeService;
import com.gtis.archive.service.ResourceService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.web.SessionUtil;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:wanggang@gtis.com.cn">WangGang</a>
 * @version V1.0, 2010-11-9
 */
public class ArchiveappraisalAction extends BaseModelAction<Archive> {

    @Autowired
    private ResourceService resourceService;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private RecordAjhRangeService recordAjhRangeService;
    @Autowired
    private LogManagerService logManagerService;
    @Autowired
    private ArchiveJdHistoryService archiveJdHistoryService;

    private String idString;

    public String getIdString() {
        return idString;
    }

    public void setIdString(String idString) {
        this.idString = idString;
    }

    /**
     * id
     */
    private String id;

    /**
     * ids
     */
    private String[] ids;

    /**
     * 保管期限
     */
    private String bgqx;

    /**
     * 密级
     */
    private String mj;

    /**
     * 列表要显示的字段
     */
    private Map showFields;

    /**
     * 链接字段
     */
    private String linkField;

    private String type;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }

    /**
     * 审批状态
     */
    private int sfpz;

    private Integer state;

    @Override
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String[] getIds() {
        return ids;
    }

    public void setIds(String[] ids) {
        this.ids = ids;
    }

    public String getBgqx() {
        return bgqx;
    }

    public void setBgqx(String bgqx) {
        this.bgqx = bgqx;
    }

    public String getMj() {
        return mj;
    }

    public void setMj(String mj) {
        this.mj = mj;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public int getSfpz() {
        return sfpz;
    }

    public void seoSfpz(int sfpz) {
        this.sfpz = sfpz;
    }

    public String getLinkField() {
        if (linkField == null) {
            try {
                linkField = archiveService.getArchiveModel(modelName).getTemplate("linkField");
            } catch (Exception ex) {
                linkField = "tm";
            }
        }
        return linkField;
    }

    @Override
    public Map getShowFields() {
        if (showFields == null) {
            showFields = JSON.parseObject(getEntityTemplate("showFields"), LinkedHashMap.class);
        }
        return showFields == null ? Collections.emptyMap() : showFields;
    }

    @Override
    protected Page<Archive> searchEntity(final List<Criterion> criterions, final List<Order> orders) {
        String ststeInfo = "state";
        String modelNameInfo = "modelName";
        if("checkup".equals(type)) {
            criterions.add(Restrictions.eq(ststeInfo, 1));
            criterions.add(Restrictions.eq(modelNameInfo, modelName));
            criterions.add(Restrictions.ne("bgqx", "永久"));
        }else if("open".equals(type)){
            criterions.add(Restrictions.eq(ststeInfo, 1));
            criterions.add(Restrictions.ne("mj", "公开"));
            criterions.add(Restrictions.eq(modelNameInfo, modelName));
        }else if("recycle".equals(type)){
            criterions.add(Restrictions.eq(ststeInfo, 8));
            criterions.add(Restrictions.eq(modelNameInfo, modelName));
        }
        if (query != null) {
            criterions.add(Restrictions.or(Restrictions.like("tm", "%" + query + "%"), Restrictions.like("dh", "%" + query + "%")));
        }

        Page<Archive> page;
        if("checkup".equals(type)) {
            page = getArchiveByBgqx(criterions,orders);
        }else{
            page = entityService.search(Archive.class, criterions, orders, start, limit);
        }

        return page;
    }

    /**
     * 获取超期的案卷
     * @return
     */
    public Page<Archive> getArchiveByBgqx(List<Criterion> criterions,List<Order> orders){
        try{
            Page<Archive> page = entityService.search(modelName, criterions, orders, start, -1);

            List<Archive> archiveList = page.getItems();
            Page<Archive> archivePage1 = null;
            List<Archive> archiveList1 = new ArrayList<Archive>();
            for(Archive archive:archiveList){
                boolean isBgqx = isBgqx(archive);
                if (isBgqx){
                    archiveList1.add(archive);
                }
            }

            if(limit == -1){
                return new Page<Archive>(archiveList1);
            }

            int count = start + 20;
            if(count > archiveList1.size()){
                count = archiveList1.size();
            }

            List<Archive> archiveListPa = new ArrayList<Archive>();
            for(int i=start;i < count;i++){
                archiveListPa.add(archiveList1.get(i));
            }

            archivePage1 = new Page<Archive>(archiveListPa);
            archivePage1.setTotalCount(archiveList1.size());
            archivePage1.setStart(start);
            return archivePage1;
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
        return null;
    }

    /**
     * 判断案卷是否超期
     * @return
     */
    public boolean isBgqx(Archive archive){
        try{
            DateFormat sdf = new SimpleDateFormat("yyyy");
            String nd = archive.getNd();
            Date djrq = sdf.parse(nd);

            if(djrq == null){
                return false;
            }

            Calendar djrqCal = Calendar.getInstance();
            djrqCal.setTime(djrq);
            bgqx = archive.getBgqx();
            if("5年".equals(bgqx)){
                djrqCal.add(Calendar.YEAR,5);//日期加5年
            }else if("10年".equals(bgqx)){
                djrqCal.add(Calendar.YEAR,10);
            }else if("15年".equals(bgqx)){
                djrqCal.add(Calendar.YEAR,15);
            }else if("30年".equals(bgqx)){
                djrqCal.add(Calendar.YEAR,30);
            }else if("短期".equals(bgqx)){
                djrqCal.add(Calendar.YEAR,10);
            }else if("长期".equals(bgqx)){
                djrqCal.add(Calendar.YEAR,30);
            }
            java.util.Date today=new java.util.Date();
            Date date = djrqCal.getTime();
            return date.before(today);
        } catch (Exception e) {
            logger.error(e.getMessage());
            return false;
        }
    }

    /**
     * 获取档案类型
     * @return
     */
    public Map getSearchModelFields() {
        List<Resource> ress = resourceService.getChildrenResource(resourceService.getResource(null, Constants.MODEL_ROOT).getId());
        Map map = new LinkedHashMap();
        for (Resource resource : ress) {
            List<Resource> childress = resourceService.getChildrenResource(resource.getId());
            for (Resource childres : childress) {
                map.put(childres.getName(), childres);
            }
        }
        return map;
    }

    /**
     * 获取modelName的资源ID
     */
    public void getTreeId() {
        String treeId = "";
        Archive archive = null;
        if (id != null && StringUtils.isNotEmpty(id)) {
            archive = archiveService.getArchive(modelName, id);
            modelName = archive.getModelName();
            if (modelName != null && StringUtils.isNotEmpty(modelName)) {
                Resource res = resourceService.findChildResource(null, modelName, Constants.MODEL_ROOT);
                if (res != null) {
                    treeId = res.getId();
                }
            }
        }
        Map map = new HashMap();
        map.put("modelName", modelName);
        map.put("resourceId", treeId);
        renderJson(map);
    }

    /**
     * 获取保管期限
     * @return
     */
    public String getBgqxItem() {
        try {
            List<Item> bgqxItems = dictService.getItems(Constants.BGQX);

            List<Item> items = new ArrayList<Item>();
            for(Item item:bgqxItems){
                items.add(item);
            }
            String json = JSON.toJSONString(items);
            Struts2Utils.renderJson(json);
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
        return null;
    }

    /**
     * 档案提升申请
     */
    public void upArchiving(){
        try {
        	for (int i = 0; i < ids.length; i++) {
				String id = ids[i];
				Archive archiveTemp = archiveService.getSimpleArchive(id);
	            //存入档案鉴定历史表
	            ArchiveJdHistory archiveJdHistory = new ArchiveJdHistory();
	            archiveJdHistory.setArchiveId(archiveTemp.getId());
	            archiveJdHistory.setTm(archiveTemp.getTm());
	            archiveJdHistory.setBgqxOld(archiveTemp.getBgqx());
	            archiveJdHistory.setBgqxUpdated(bgqx);
                archiveJdHistory.setDh(archiveTemp.getDh());
	            archiveJdHistory.setCz("档案提升申请");
	            archiveJdHistory.setSpztName(bgqx+"待审批");
	            archiveJdHistory.setSqrId(SessionUtil.getCurrentUserId());
	            archiveJdHistory.setSqrName(SessionUtil.getCurrentUser().getUsername());
	            archiveJdHistory.setSqrq(new Date());
	            archiveJdHistoryService.saveArchiveJdHistory(archiveJdHistory);
			}
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
    }
    
    /**
     * 描述：档案鉴定销毁审批申请
     * @author 卜祥东
     * 2017年9月28日 上午9:02:24
     */
    public void isDestroying() {
    	for (int i = 0; i < ids.length; i++) {
			String id = ids[i];
    		Archive archiveTemp = entityService.load(Archive.class, id);
    		//存入档案鉴定历史表
            ArchiveJdHistory archiveJdHistory = new ArchiveJdHistory();
            archiveJdHistory.setTm(archiveTemp.getTm());
            archiveJdHistory.setArchiveId(archiveTemp.getId());
            archiveJdHistory.setBgqxOld(archiveTemp.getBgqx());
            archiveJdHistory.setCz("档案销毁申请");
            archiveJdHistory.setSpztName("销毁待审批");
            archiveJdHistory.setSqrId(SessionUtil.getCurrentUserId());
            archiveJdHistory.setSqrName(SessionUtil.getCurrentUser().getUsername());
            archiveJdHistory.setSqrq(new Date());
            archiveJdHistoryService.saveArchiveJdHistory(archiveJdHistory);
    	}
    }

    /**
     * 修改保管期限
     */
    public void isDestroy(){
        try {
            Archive archive = archiveService.getSimpleArchive(ids[0]);
            boolean isBgqx = isBgqx(archive);
            if (!isBgqx){
                renderJson("超期");
            }else if("永久".equals(archive.getBgqx())){
                renderJson("永久");
            }else {
                renderJson("允许");
            }
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    /**
     * 获取密级字典
     * @return
     */
    public String getMjItem() {
        try {
            List<Item> mjItems = dictService.getItems("mj");
            String json = JSON.toJSONString(mjItems);
            Struts2Utils.renderJson(json);
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
        return null;
    }

    /**
     * 修改密级
     */
    public void openArchive() {
        try {
            if (ids == null) {
                return;
            }

            for (String id : ids) {
                if (StringUtils.isBlank(id)) {
                    continue;
                }
                Archive archive = archiveService.getSimpleArchive(id);
                archive.setMj(mj);
                archiveService.saveArchive(archive);
            }
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    /**
     * 档案销毁
     *
     * @return
     */
    public String destroyArchive() {
        try{
            if(ids == null){
                List<Archive> archiveList = getEntityPage().getItems();
                String[] idString = new String[archiveList.size()];

                for(int i = 0; i < archiveList.size(); i++){
                    idString[i] = archiveList.get(i).getId();
                }

                ids = idString;
            }

            for (String id : ids) {
                if (StringUtils.isBlank(id)) {
                    continue;
                }
                Archive archive = archiveService.getArchive(modelName, id);
                archive.setState(8);
                archiveService.saveArchive(archive);
                logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                        archive, "destroy");
            }
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
        return null;
    }

    /**
     * 档案删除
     *
     * @return
     */
    public void removeArchiveIds() {
        try{
            List<Archive> archiveList = getEntityPage().getItems();
            String[] idString = new String[archiveList.size()];

            for(int i = 0; i < archiveList.size(); i++){
                idString[i] = archiveList.get(i).getId();
            }

            ids = idString;
            renderJson(ids);
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    @Override
    public String remove() throws Exception {
        if (EnvHolder.isEnable(Switch.RECORD_AJH_RANGE)) {
            for (String id : ids) {
                Archive archive = archiveService.getArchive(modelName, id);
                if (archive.getAjh() != null && archive.getMlh() != null && archive.getModelName() != null) {
                    RecordAjhRange recordAjhRange = new RecordAjhRange();
                    recordAjhRange.setAjh(archive.getAjh());
                    recordAjhRange.setMlh(archive.getMlh());
                    recordAjhRange.setDwdm(archive.getDwdm());
                    recordAjhRange.setModelName(archive.getModelName());
                    recordAjhRange.setBgqx(archive.getBgqx());
                    recordAjhRangeService.saveRecordAjh(recordAjhRange);
                }
            }
        }
        List<Archive> archivesToDel = new ArrayList<Archive>();
        for (String id : ids) {
            archivesToDel.add(archiveService.getArchive(modelName, id));
        }
        try {
            super.remove();
            for (Archive archive : archivesToDel) {
                logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                        archive, "remove");
            }
        } catch (Exception e) {
            logger.error("删除失败,{}", e.getMessage());
            logger.error("删除失败");
        }
        return null;
    }

    /**
     * 回收站中退回档案
     *
     * @return
     * @throws Exception
     */
    public String returnArchive() {
        try{
            if(ids == null){
                List<Archive> archiveList = getEntityPage().getItems();
                String[] idString = new String[archiveList.size()];

                for(int i = 0; i < archiveList.size(); i++){
                    idString[i] = archiveList.get(i).getId();
                }

                ids = idString;
            }

            for (String id : ids) {
                if (StringUtils.isBlank(id)) {
                    continue;
                }

                Archive archive = archiveService.getSimpleArchive(id);
                archive.setState(1);
                archiveService.saveArchive(archive);
            }
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
        return null;
    }
    
    /**
     * 描述：获取档案鉴定状态
     * @author 卜祥东
     * 2017年9月29日 上午9:02:24
     */
    public String getArchiveExamState() {
		try {
			ArchiveJdHistory temp = archiveJdHistoryService.getSimpleArchiveJdHistoryByArchiveId(id);
			String json = JSON.toJSONString(temp == null ? null : temp.getSpztName());
			Struts2Utils.renderJson(json);
		} catch (Exception e) {
            logger.error(e.getMessage());
		}
		return null;
    }
    
}
