package com.gtis.archive.web;

import com.google.common.base.Strings;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.web.BaseEntityAction;
import com.gtis.archive.entity.ArchiveMetaData;
import com.gtis.archive.service.ArchiveMetadataService;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 档案元数据实体操作
 *
 * @author linlong
 *
 * @since 2019.04.02
 */
public class ArchiveMetadataEntityAction extends BaseEntityAction<ArchiveMetaData> {

    @Autowired
    private ArchiveMetadataService archiveMetadataService;

    private String archiveId;

    private Number version;

    public String getArchiveId() {
        return archiveId;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    @Override
    protected void preSave() {
        if (entity != null && StringUtils.isBlank(entity.getId())) {
            entity.setId(UUIDGenerator.generate());
        }
    }

    @Override
    public Model getEntityModel() {
        return modelService.getModel("ArchiveMetaData");
    }

    @Override
    public void prepare() {
        if (!Strings.isNullOrEmpty(archiveId)) {
            entity = archiveMetadataService.getArchiveMetadataByArchiveId(archiveId);
        }
    }

    @Override
    public String save() throws Exception {
        return renderJs(new Runner() {
            @Override
            public void run() {
                preSave();
                doSave(entity);
                afterSave();
            }
        }, getSuccessMsg(), null, getJsCallBack());
    }

    public Number getVersion() {
        return version;
    }

    public void setVersion(Number version) {
        this.version = version;
    }

}
