package com.gtis.archive.web;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.ArchiveMetaData;
import com.gtis.archive.service.ArchiveMetadataService;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.util.Struts2Utils;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * 档案元数据action
 *
 * @author linlong
 *
 * @since 2019.04.02
 */
public class ArchiveMetaDataAction extends BaseModelAction<ArchiveMetaData> {

    private String applicationChoose = "application/octet-stream";

    private String attachment = "attachment";
    private String filenameString = "; filename=\"";
    private String contentDispositionInfo = "Content-Disposition";
    private String isoInfo = "iso8859-1";

    private String[] metadataIds;

    private String archiveId;

    @Autowired
    private ArchiveMetadataService archiveMetadataService;
    @Autowired
    private ArchiveService archiveService;


    public String[] getMetadataIds() {
        return metadataIds;
    }

    public void setMetadataIds(String[] metadataIds) {
        this.metadataIds = metadataIds;
    }

    public String getArchiveId() {
        return archiveId;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public void batch() {
        String parentPath = ServletActionContext.getServletContext().getRealPath("/xml");
        String zipParentPath = ServletActionContext.getServletContext().getRealPath("/xml/zip");
        File zipParent = new File(zipParentPath);
        if (!zipParent.exists()) {
            zipParent.mkdirs();
        }
        String zipFileName = System.currentTimeMillis() + ".zip";
        String zipPath = zipParentPath + File.separator + zipFileName;
        List<File> files = null;
        org.apache.tools.zip.ZipOutputStream zipOutputStream = null;
        FileInputStream fis = null;
        byte[] buffer = new byte[1024];
        try {
            files = archiveMetadataService.batch(Arrays.asList(metadataIds), parentPath);
            zipOutputStream = new org.apache.tools.zip.ZipOutputStream(new FileOutputStream(zipPath));
            zipOutputStream.setEncoding("gbk");
            for (File f : files) {
                zipOutputStream.putNextEntry(new org.apache.tools.zip.ZipEntry(f.getName()));
                fis = new FileInputStream(f);
                int len;
                while ((len = fis.read(buffer)) > 0) {
                    zipOutputStream.write(buffer, 0, len);
                }
                zipOutputStream.closeEntry();
                fis.close();
            }
            HttpServletResponse response = ServletActionContext.getResponse();
            response.setContentType(applicationChoose);
            response.setHeader(contentDispositionInfo, attachment + filenameString + new String(zipFileName.getBytes("gbk"), isoInfo) + "\"");
            sendFile(new File(zipPath));
            File file = new File(zipPath);
            if (file.exists() && !file.delete()) {
                logger.error("getBatch方法删除临时文件失败！[{}]" , file.getPath());
            }
        } catch (IOException e) {
            logger.error(e.getMessage());
        } finally {
            try {
                Closeables.close(fis, true);
            } catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
    }

    public void getInfoFromArchive() {
        Archive archive = null;
        if (!Strings.isNullOrEmpty(archiveId) && !Strings.isNullOrEmpty(modelName)) {
            archive = archiveService.getArchive(modelName, archiveId);
        } else if (!Strings.isNullOrEmpty(archiveId)) {
            archive = archiveService.getSimpleArchive(archiveId);
        }

        if (archive != null) {
            ArchiveMetaData archiveMetaData = archiveMetadataService.getArchiveMetaDataInfoFromArchive(archive, null);
            archiveMetadataService.saveOrUpdate(archiveMetaData);
        }

        Struts2Utils.renderJson("生成成功");
    }

    public void getTotalVersions() throws ClassNotFoundException {
        List<Number> list = archiveMetadataService.getVersions(modelName, archiveId);
        Map<String, Object> map = Maps.newHashMapWithExpectedSize(4);
        map.put("size", list.size());
        map.put("versions", list);
        renderJson(map);
    }

}
