package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.ArchiveInfo;
import com.gtis.archive.service.ArchiveService;
import org.springframework.beans.factory.annotation.Autowired;
import java.util.Map;

/**
 * .
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelonXu</a>
 * @version V1.0, 12-5-19 下午4:11
 */
public class ArchiveInfoAction extends BaseModelAction<ArchiveInfo>{
    @Autowired
    private ArchiveService archiveService;

    private String archiveId;

    private Map docArchive;
    public Map getDocArchive(){
        try{
            if(docArchive==null) {
                docArchive = JSON.parseObject(JSON.toJSONString(archiveService.getArchive(toBaseModelName(modelName), archiveId), SerializerFeature.WriteMapNullValue));
                docArchive.remove("id");
            }
        }catch(Exception ex){
            logger.error(ex.toString());
        }
        return docArchive;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }
    
    private String toBaseModelName(String modelName){
        if(modelName.endsWith("_ai")){
            return modelName.substring(0,modelName.lastIndexOf("_ai"));
        }
        return modelName;
    }
}
