package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Strings;
import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.support.hibernate.UUIDHexGenerator;
import com.gtis.archive.core.web.BaseEntityAction;
import com.gtis.archive.entity.*;
import com.gtis.archive.service.*;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.util.ValueStack;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContext;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-10-13
 */
public class ArchiveEntityAction extends BaseEntityAction<Archive> {
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private AjhRangeService ajhRangeService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private RecordAjhRangeService recordAjhRangeService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private LogManagerService logManagerService;
    @Autowired
    private ArchiveMetadataService archiveMetadataService;

    private int version;


    private String treeId;
    private AjhRange ajhRange;
    private Integer _ajh;
    private boolean gd;

    private String template;

    private List<String> mlhs;//江阴目录号列表


    private String currentMlh;

    private Integer currentAjh;

    private String mlh;//用户江阴目录号下拉框改变时同时改变案卷号

    private String bgqx;//保管期限

    private String nd;//年度

    private String cwlx;//财务类型

    private String lb;//类别

    private String jnmllx;//句容卷内目录类型

    private Integer pd=0;//判断添加操作

    private String  preid="";//泗洪参照档案的id
    private String currentAId ;
    private Map docShowFields;
    private Map docFields;
    private Integer state;
    private String currentAIdString = "currentAId";
    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public String getCurrentAId() {
        return currentAId;
    }

    public void setCurrentAId(String currentAId) {
        this.currentAId = currentAId;
    }

    public String getLb() {
        return lb;
    }

    public void setLb(String lb) {
        this.lb = lb;
    }

    public String getCwlx() {
        return cwlx;
    }

    public void setCwlx(String cwlx) {
        this.cwlx = cwlx;
    }

    public String getNd() {
        return nd;
    }

    public void setNd(String nd) {
        this.nd = nd;
    }

    public void setAjhRange(AjhRange ajhRange) {
        this.ajhRange = ajhRange;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public void setGd(boolean gd) {
        this.gd = gd;
    }

    public AjhRange getAjhRange() {
        return ajhRange;
    }

    public String getTreeId() {
        return treeId;
    }

    public String getBgqx() {
        return bgqx;
    }

    public void setBgqx(String bgqx) {
        this.bgqx = bgqx;
    }

    /**
     * 是否处于档案补录状态
     */
    private boolean isMakeUp;

    public boolean isMakeUp() {
        return isMakeUp;
    }

    public void setMakeUp(boolean makeUp) {
        isMakeUp = makeUp;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getCurrentMlh() {
        return entity.getMlh();
    }

    public Integer getCurrentAjh() {
        return entity.getAjh();
    }

    public Integer getPd() {
        return pd;
    }

    public void setPd(Integer pd) {
        this.pd = pd;
    }

    public String getPreid() {
        return preid;
    }

    public void setPreid(String preid) {
        this.preid = preid;
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public void prepare() {
        String cid = "";
        boolean isCreate = StringUtils.isBlank(id);
        if (isCreate) {
            if (preid != null && !"".equals(preid)) {
                entity = archiveService.getArchive(modelName,preid);
            } else {
                entity = archiveService.newArchive(modelName);
            }
            if (!StringUtils.isBlank(this.currentAId)) {
                cid = this.currentAId;
            } else {
                 cid = (String) session.get(currentAIdString);
            }
            Archive lastArchive = null;
            if (cid != null&& "".equals(preid)) {
                lastArchive = archiveService.getArchive(modelName, cid);
            }
            if (lastArchive != null && lastArchive.getModelName().equals(modelName)) {
                try {
                    PropertyUtils.copyProperties(entity, lastArchive);
                    if (!StringUtils.isBlank(this.currentAId)){
                        entity.setMlh(null);
                    }
                } catch (Exception ignored) {
                    logger.error(ignored.getMessage());
                }
                entity.setDh(null);
            } else if (EnvHolder.isEnable(Switch.JIANGYIN)) {
                entity.setDwdm(getDwdm());
                entity.setQzh(getQzh());
            }
            if (StringUtils.isBlank(entity.getNd()) && EnvHolder.isEnable(Switch.JIN_TAN)) {
                entity.setNd(String.valueOf(Calendar.getInstance().get(Calendar.YEAR)));
            }
            entity.setId(UUIDHexGenerator.generate());
            if (StringUtils.isNotBlank(treeId)) {
                String flh = resourceService.getResource(treeId).getFlh();
                if (StringUtils.isNotBlank(flh)) {
                    entity.setFlh(flh);
                }
            }
        } else {
            entity = archiveService.getArchive(modelName, id);
            if (entity == null) {
                entity = archiveService.newArchive(modelName);
            }

            if(entity.getLrr() == null && EnvHolder.isEnable(Switch.HASLRR_LRRID)) {
                UserInfo user = SessionUtil.getCurrentUser();
                entity.setLrrId(user.getId());
                entity.setLrr(user.getUsername());
                entity.setLrsj(new Date());
            }
        }

        if(entity.getDwdm() == null){
            entity.setDwdm(getDwdm());
        }
        if (isCreate && EnvHolder.isEnable(Switch.INCREASE_AJH)) {
            if (EnvHolder.isEnable(Switch.JIN_TAN)) {  //金坛文书档案使用年度和保管期限
                if ("Wsda".equals(modelName)) {
                    ajhRange = ajhRangeService.getAvailableAjhRangByNd(modelName, entity.getNd());
                } else if ("Jhcw".equals(modelName)) {  //金坛财务档案，目录号不区分单位代码，根据字典中的配置财务分类（凭证，现金，明细）读取，若字典中没有指定则自动获取
                    try {
                        if (PropertyUtils.getProperty(entity, "cwlx") != null) {
                            cwlx = PropertyUtils.getProperty(entity, "cwlx").toString();
                            ajhRange = ajhRangeService.getAvailableAjhRange(modelName, true, entity.getNd(), cwlx);
                        } else {
                            ajhRange = ajhRangeService.getAvailableAjhRangByNd(modelName, entity.getNd());
                        }
                    } catch (Exception ex) {
                        logger.error(ex.toString());
                    }

                } else if ("Swda".equals(modelName)) {
                    lb = null;
                    try {
                        lb = PropertyUtils.getProperty(entity, "lb").toString();
                    } catch (Exception ex) {
                        logger.error(ex.getMessage());
                    }
                    ajhRange = ajhRangeService.getAvailableAjhRangeByLb(modelName, lb);
                } else if("Tddj".equals(modelName)) {
                    try{
                        ajhRange = ajhRangeService.getAvailableAjhRangByNd(modelName,entity.getNd());
                    }catch (Exception ex){
                        ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                    }
                } else {
                    try{
                        ajhRange = ajhRangeService.getAvailableAjhRangByNd(modelName,entity.getNd());
                    }catch (Exception ex){
                        ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                    }                }
            } else if (EnvHolder.isEnable(Switch.DONGTAI) && entity.getMlh()!=null) {
                ajhRange = ajhRangeService.getAvailableAjhRange(modelName,entity.getMlh());
            } else  {
                ajhRange = getAvailableAjhRange();
            }
            entity.setMlh(ajhRange.getMlh());
            if (EnvHolder.isEnable(Switch.RECORD_AJH_RANGE)) { //江阴，根据该目录号先查找改目录号是否存在之前已删除的案卷号
                RecordAjhRange recordAjhRange = recordAjhRangeService.getAvailable(ajhRange.getMlh(), modelName, getDwdm());
                if (recordAjhRange != null) {
                    entity.setAjh(recordAjhRange.getAjh());
                } else {
                    entity.setAjh(ajhRange.getNextValue());
                }
            } else {
                entity.setAjh(ajhRange.getNextValue());
            }
            if (EnvHolder.isEnable(Switch.JIANGYIN) || (EnvHolder.isEnable(Switch.JIN_TAN) && "Wsda".equals(modelName))) {
                entity.setBgqx(ajhRange.getBgqx());
            }
        }
    }

    @Override
    protected void preSave() {
        if (ajhRange != null && StringUtils.isNotBlank(ajhRange.getId()) && entity.getAjh() != null && entity.getAjh() == ajhRange.getNextValue() && !(EnvHolder.isEnable(Switch.JIN_TAN) && pd==0)) {//如果相等，说明用户未修改ajh，取出当前可用案卷号赋值
            ajhRange = ajhRangeService.getAjhRange(ajhRange.getId());
            _ajh = ajhRange.getNextValue();
            entity.setAjh(_ajh);
        } else {
            if (!EnvHolder.isEnable(Switch.NOT_CHECK_AJH) && !(EnvHolder.isEnable(Switch.JIN_TAN) && pd == 0)) {
                List<Criterion> criterions = new ArrayList<Criterion>();
                criterions.add(Restrictions.eq("qzh", entity.getQzh()));
                criterions.add(Restrictions.eq("mlh", entity.getMlh()));
                criterions.add(Restrictions.eq("ajh", entity.getAjh()));
                Page<Archive> page = archiveService.searchArchive(modelName, criterions, null, 0, 1);

                if (!page.isEmpty() && !page.getItem(0).getId().equals(entity.getId())) {
                    if (!EnvHolder.isEnable(Switch.BENG_BU) && !isMakeUp) {
                        logger.error("此案卷号已被使用");
                        throw new AjhRangeService.AjhException("此案卷号已被使用");
                    }
                    if (EnvHolder.isEnable(Switch.JIN_TAN) && isMakeUp) {
                        logger.debug("档案补录，插入案卷号");
                        makeUpArchive();
                    }
                }
            }
        }

        if (StringUtils.isNotBlank(treeId)) {
            entity.setResourceId(treeId);
        }

        if(StringUtils.isNotBlank(modelName) && !StringUtils.isNotBlank(treeId)) {
            Resource res = resourceService.getResourceByName(modelName);
            if (res != null) {
                treeId = res.getId();
            }
            entity.setResourceId(treeId);
        }

        if (entity.getAjh() != null && entity.getMlh() != null && !EnvHolder.isEnable(Switch.NOT_CHECK_AJH)&&!(EnvHolder.isEnable(Switch.JIN_TAN)&&pd==0)) {
            AjhRange preAjhRange = null;
            if (ajhRange != null) { //说明添加操作，要获取可用案卷号
                preAjhRange = ajhRangeService.getAvailableAjhRange(modelName, entity.getMlh());
            } else if(entity.getId().length() == 32) {    //编辑操作，不对案卷号做可用判断
                preAjhRange = ajhRangeService.getAjhRangesForGeneric(modelName, entity.getMlh());
            }
            /**
             **如果当前案卷号大于当前最大可用案卷号或者是小于当前最小可用案卷号，则给出提示！
             */
            if (preAjhRange != null) {
                if (entity.getAjh() > preAjhRange.getMaxValue()) {
                    logger.error("案卷号不能大于当前最大案卷号");
                }
                if (entity.getAjh() < preAjhRange.getMinValue()) {
                    logger.error("案卷号不能小于当前最小案卷号");
                }
            }
        }

        if (gd) {
            if (!EnvHolder.isEnable(Switch.NOT_CHECK_AJH) && entity.getMlh() != null) {
                ajhRange = ajhRangeService.getAvailableAjhRange(modelName, entity.getMlh());
                if (entity.getAjh() > ajhRange.getNextValue()) {
                    logger.error("不能大于当前最大案卷号");
                }
            }
            entity.setGdsj(new Date());
            entity.setState(Archive.STATE_YGD);
        }

        if(EnvHolder.isEnable(Switch.GUIDANG)){
            entity.setGdsj(new Date());
            entity.setState(Archive.STATE_YGD);
        }

        if (EnvHolder.isEnable(Switch.CHANGZHOU) && EnvHolder.isEnable(Switch.ALLOW_NULL_DH)) {
            entity.setDh(null);
        }
    }

    /**
     * 档案补录
     */
    private void makeUpArchive() {
        try {
            List<Criterion> criterions = new ArrayList<Criterion>();
            criterions.add(Restrictions.eq("mlh", entity.getMlh()));
            criterions.add(Restrictions.ge("ajh", entity.getAjh()));
            List<Order> orders = new ArrayList<Order>();
            orders.add(Order.asc("ajh"));
            List<AjhRange> ajhRanges = ajhRangeService.getAjhRangeByModelName(modelName);
            for (AjhRange range : ajhRanges) {
                if (range.getMlh().equalsIgnoreCase(entity.getMlh())) {
                    ajhRange = range;
                    break;
                }
            }
            Page<Archive> pages = archiveService.searchArchive(modelName, criterions, orders, 0, ajhRange.getMaxValue());
            for (int i = pages.getTotalCount(); i > 0; i--) {
                Archive archive = pages.getItem(i - 1);
                archive.setAjh(archive.getAjh().intValue() + 1);
                archive.setDh(null);
                if (archive.getAjh() > ajhRange.getMaxValue()) {
                    logger.error("档案移动后将会超出目录最大容量，请先扩充目录号[{}]容量",archive.getMlh());
                }
                archiveService.saveArchive(archive);
            }
        } catch (Exception ex) {
            logger.error("档案补录异常【{}】,确认目录号【{}】已配置", ex.getLocalizedMessage(), entity.getMlh());
            logger.error("档案补录异常,确认目录号【{}】已配置",entity.getMlh());
        }
    }

    public String bl() throws Exception {
        return renderModelTemplate("bl");
    }

    /**
     * render template
     *
     * @return
     * @throws Exception
     */
    public String render() throws Exception {
        return renderModelTemplate(template);
    }

    @Override
    protected void doSave(Archive entity) {
        String saveType = null;
        if (EnvHolder.isEnable(Switch.CREATEDHBYMODELNAME)) {
            String userId = SessionUtil.getCurrentUserId();
            if(StringUtils.isBlank(entity.getDh()) || StringUtils.isEmpty(entity.getDh())) {
                entity = archiveService.createDhByArchive(entity, userId);
            }
        }
        archiveService.saveArchive(entity);
        if (this.pd == 0) {
            saveType = "edit";
        } else if (this.pd == 1) {
            saveType = "add";
        }
        logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                entity, saveType);
    }

    @Override
    protected void afterSave() {
        if (!EnvHolder.isEnable(Switch.NOT_CHECK_AJH) && !(EnvHolder.isEnable(Switch.JIN_TAN) && pd == 0)) {       //notCheckAjh.enable=false 设置为此情况，所有业务都可以在添加之后更新业务
            updateAjhRange();
        } else if (EnvHolder.isEnable(Switch.NOT_CHECK_AJH) && !(EnvHolder.isEnable(Switch.JIN_TAN) && pd == 0)) {  //notCheckAjh.enable=true 设置为此情况,当字典当中配置这个业务时就给这个业务更新案卷号
            List<Item> dictList = dictService.getItems("increaseAjh");
            for (Item item : dictList) {
                if (item.getName().equalsIgnoreCase(modelName)) {
                    updateAjhRange();
                    break;
                }
            }
        }
        updateDoc(entity.getId());
        session.put(currentAIdString, entity.getId());
    }

    public void updateDoc(String id) {
        Archive archive = archiveService.getSimpleArchive(id);
        List<Document> docs = archiveService.getArchiveDocuments(archive);

        for (int i = 0, size = docs.size(); i < size; i++) {
            Document document = docs.get(i);
            document.setAjh(archive.getAjh());
            document.setMlh(archive.getMlh());
            archiveService.saveDocument(document);
        }
    }

    public void updateAjhRange() {
        if (_ajh != null) {
            ajhRange.setCurrentValue(_ajh);
            ajhRangeService.saveAjhRange(ajhRange);
        }
        if (EnvHolder.isEnable(Switch.RECORD_AJH_RANGE) && !"Wsda".equalsIgnoreCase(modelName)) { //当使用recordAjhRange时要将那条记录删除
            String id = recordAjhRangeService.removeHasUsed(entity.getMlh(), entity.getModelName(), entity.getDwdm(), entity.getAjh());
            if (StringUtils.isNotBlank(id)) {
                recordAjhRangeService.remove(id);
            }
        }
    }

    /**
     * 获取可用的案卷号
     *
     * @return
     */
    private AjhRange getAvailableAjhRange() {
        if (entity.getMlh() != null) {
            return ajhRangeService.getAvailableAjhRange(modelName, entity.getMlh());
        } else if(EnvHolder.isEnable(Switch.INDIVIDUAL_MLH)){
            UserInfo userInfo = new UserInfo();
            SecurityContext context = (SecurityContext)session.get("SPRING_SECURITY_CONTEXT");
            if (context != null) {
                Authentication authentication = context.getAuthentication();

                userInfo =(UserInfo) authentication.getPrincipal();
            }
            if(userInfo !=null) {
                String dwdm = userInfo.getRegionCode();
                return ajhRangeService.getAvailableAjhRangeByDwdm(modelName, dwdm);
            }else {
                return ajhRangeService.getAvailableAjhRange(modelName);
            }
        }else {
            return ajhRangeService.getAvailableAjhRange(modelName);
        }
    }

    @Override
    protected String getSuccessMsg() {
        return entity == null ? super.getSuccessMsg() : entity.getId();
    }

    @Override
    protected String getJsCallBack() {
        return "onArchiveComplete";
    }

    /**
     * 获取全宗号
     *
     * @return
     */
    private String getQzh() {
        String qzh = "";
        String dwdm = getDwdm();
        try {
            List<Item> items = dictService.getItems(Constants.QZH_DWDM);
            if (!items.isEmpty()) {
                for (Item item : items) {
                    if (dwdm.equals(item.getName())) {
                        qzh = item.getValue();
                        break;
                    }
                }
            }
        } catch (Exception ex) {
            logger.info("未配置[{}]单位代码全宗号字典项", Constants.QZH_DWDM);
        }
        return qzh;
    }

    /**
     * 获取当前用户的单位代码
     *
     * @return dwdm
     */
    private String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            ////单位代码用部门代码进行替换
            if (EnvHolder.isEnable(Switch.ORAGAN_NO)) {
                String oraganNo = null;
                List<PfOrganVo> pfOrganVoList = userService.getOrganListByUser(SessionUtil.getCurrentUserId());
                if (pfOrganVoList != null && !pfOrganVoList.isEmpty()) {
                    PfOrganVo pfOrganVo = pfOrganVoList.get(0);
                    oraganNo = pfOrganVo.getOraganNo();
                }
                if(oraganNo != null) {
                    dwdm = oraganNo;
                }else{
                    dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
                }
            } else {
                UserInfo userInfo = new UserInfo();
                SecurityContext context = (SecurityContext)session.get("SPRING_SECURITY_CONTEXT");
                if (context != null) {
                    Authentication authentication = context.getAuthentication();

                    userInfo =(UserInfo) authentication.getPrincipal();
                }
                dwdm = userInfo.getRegionCode();
            }
        }

        return dwdm;
    }

    /**
     * 金坛，文书档案中根据保管期限重新设置目录号案卷号
     *
     * @return
     */
    public String reSetAjhRange() {
        try {
            if (StringUtils.isBlank(nd)) {
                nd = String.valueOf(Calendar.getInstance().get(Calendar.YEAR));
            }
            ajhRange = ajhRangeService.getAjhRangeByNdBgqx(modelName, bgqx, nd);
            entity.setAjh(ajhRange.getNextValue());
            renderJson(ajhRange.getNextValue() + "," + ajhRange.getId() + "," + ajhRange.getCurrentValue() + "," + ajhRange.getMlh());
        } catch (Exception ex) {
            renderJson(ex.getMessage());
        }
        return null;
    }

    /**
     * 句容卷内目录类型变化后，重新获取目录号案卷号
     * @return
     */
    public String changeJnmllx(){
        try{
            if(StringUtils.isBlank(jnmllx)){
                //do nothing
            }else{
                ajhRange = ajhRangeService.getAvaliableAjhRangeByJnmllx(modelName, jnmllx);
                entity.setAjh(ajhRange.getNextValue());
                renderJson(ajhRange.getNextValue() + "," + ajhRange.getId() + "," + ajhRange.getCurrentValue() + "," + ajhRange.getMlh());
            }
        }catch (Exception ex){
            renderJson(ex.getMessage());
        }
        return null;
    }

    public String reSetAjh() {
        try {
            ajhRange = ajhRangeService.getAvailableAjhRange(modelName, mlh);
            entity.setMlh(mlh);
            entity.setAjh(ajhRange.getNextValue());
            renderJson(ajhRange.getNextValue() + "," + ajhRange.getId() + "," + ajhRange.getCurrentValue() + "," + ajhRange.getBgqx());
        } catch (Exception ex) {
            renderJson("该目录案卷号已用完");
        }

        return null;
    }

    public String reSetMlh() {
        try {
            ajhRange = ajhRangeService.getAjhRangesByBgqx(modelName, bgqx);
            RecordAjhRange recordAjhRange = recordAjhRangeService.getRecordAjhRange(ajhRange.getMlh(), modelName, getDwdm(), bgqx);
            entity.setMlh(ajhRange.getMlh());
            int tempAjh = ajhRange.getNextValue();
            if (recordAjhRange != null) {
                entity.setAjh(recordAjhRange.getAjh());
                tempAjh = recordAjhRange.getAjh();
            } else {
                entity.setAjh(ajhRange.getNextValue());
            }
            renderJson(tempAjh + "," + ajhRange.getId() + "," + ajhRange.getCurrentValue() + "," + ajhRange.getMlh());
        } catch (Exception ex) {
            renderJson(ex.getMessage());
        }
        return null;
    }

    /**
     * 金坛年度变化时查找对应的目录号
     *
     * @return
     */
    public String changeNd() {
        if (StringUtils.isBlank(nd)) {
            nd = String.valueOf(Calendar.getInstance().get(Calendar.YEAR));
        }
        if (EnvHolder.isEnable(Switch.JIN_TAN)) {
            if ("Wsda".equals(modelName)) {
                ajhRange = ajhRangeService.getAjhRangeByNdBgqx(modelName, entity.getBgqx(), nd);
                entity.setAjh(ajhRange.getNextValue());
            } else if ("Jhcw".equals(modelName)) {
                if ("凭证".equals(cwlx)) {//获取凭证的案卷号
                    ajhRange = ajhRangeService.getAvailableAjhRange(modelName, true, nd, cwlx);
                } else {//现金和明细是共用一个目录号的
                    ajhRange = ajhRangeService.getAvailableAjhRange(modelName, false, nd, cwlx);
                }
            } else if ("Swda".equals(modelName)) {  //实物档案不区分年度

            } else {
                ajhRange = ajhRangeService.getAvailableAjhRangByNd(modelName, nd);
            }
        } else {
            ajhRange = ajhRangeService.getAvailableAjhRangByNd(modelName, nd);
        }
        renderJson(ajhRange.getNextValue() + "," + ajhRange.getId() + "," + ajhRange.getCurrentValue() + "," + ajhRange.getMlh());
        return null;
    }

    /**
     * 修改财务类型后，修改目录号和案卷号
     *
     * @return
     */
    public String changeCwlx() {
        if (!StringUtils.isBlank(cwlx)) {
            if("凭证".equals(cwlx)){//获取凭证的案卷号
                ajhRange = ajhRangeService.getAvailableAjhRange(modelName, true, entity.getNd(), cwlx);
            }else{//现金和明细是共用一个目录号的
                ajhRange = ajhRangeService.getAvailableAjhRange(modelName, true, null, cwlx);
            }
            renderJson(ajhRange.getNextValue() + "," + ajhRange.getId() + "," + ajhRange.getCurrentValue() + "," + ajhRange.getMlh());
        }
        return null;
    }


    public String changeLb() {
        if (!StringUtils.isBlank(lb)) {
            ajhRange = ajhRangeService.getAvailableAjhRangeByLb(modelName, lb);
            renderJson(ajhRange.getNextValue() + "," + ajhRange.getId() + "," + ajhRange.getCurrentValue() + "," + ajhRange.getMlh());
        }
        return null;
    }

    /**
     * 获取目录号下的可用案卷号
     * @return
     */
    public String getAvailableAjh(){
        AjhRange ajhRange1 = null;
        Map info = new HashMap();
        try {
            if (mlh != null) {
                ajhRange1 = ajhRangeService.getAvailableAjhRange(modelName, mlh);
            } else {
                ajhRange1 = ajhRangeService.getAvailableAjhRange(modelName);
            }
            info.put("success",ajhRange1);
            renderJson(info);
        }catch (Exception ex){
            logger.error(ex.getMessage());
            info.put("error",ex.getMessage());
            renderJson(info);
        }
        return null;
    }

    public String getMlh() {
        return mlh;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public List<String> getMlhs() {
        if (template == null) {
            return ajhRangeService.getMlhByModelName(modelName);
        } else {
            return ajhRangeService.getMlh(modelName, entity.getDwdm());
        }
    }

    public String getJnmllx() {
        return jnmllx;
    }

    public void setJnmllx(String jnmllx) {
        this.jnmllx = jnmllx;
    }

    @Action("detail")
    public String showArchiveDetail(){
        entity = this.archiveService.getArchive(modelName,id);
        HttpServletRequest request = ServletActionContext.getRequest();
       request .setAttribute("entity", entity);
        request.setAttribute("modelName",modelName);
        return "detail";
    }

    @Action("show")
    public String toShow(){
        HttpServletRequest request = ServletActionContext.getRequest();
        request.setAttribute("modelName", modelName);
        request.setAttribute("id", id);
        request.setAttribute("state",state);
        return "show";
    }

    private List<Item> operations;



    public String getPermJson() {
        List<String> operationStr = new ArrayList<String>();
        String location = ServletActionContext.getRequest().getSession().getServletContext().getRealPath("/tpls/permission.json");
        Map<String, Boolean> perm = new HashMap<String, Boolean>();
        if (StringUtils.isNotEmpty(modelName)) {
            Resource res = resourceService.findChildResource(null, modelName, Constants.MODEL_ROOT);
            if (res != null) {
                treeId = res.getId();
            } else {
                throw new ModelNotFoundException(modelName);
            }
        }
        if (!EnvHolder.isEnable(Switch.isNewPermission) || SessionUtil.getCurrentUser().isAdmin()) {
            try {
                operationStr = permissionService.getLeavesId(location);
            } catch (IOException e) {
                logger.error("读取配置文件permission.json错误，请检查，文件位置为" + location,e);
            }
            for (String s : operationStr) {
                if (securityService.isPermitted(treeId, s)) {
                    perm.put(s, true);
                }
            }
        }else {
            perm = securityService.getUserPermMap(SessionUtil.getCurrentUser(),treeId);
        }
        return JSON.toJSONString(perm);
    }

    public Map getDocShowFields() {
        if(docShowFields==null)
        {
            try{
                Model doc = archiveService.getDocumentModel(modelName+"_jn");
                docShowFields = JSON.parseObject(doc.getTemplate("showFields"), LinkedHashMap.class);
            }catch(ModelNotFoundException ex){
                logger.error(ex.getMessage());
            }catch(TemplateNotFoundException ex){
                docShowFields = JSON.parseObject(getEntityTemplate("Document-showFields"),LinkedHashMap.class);
            }
        }
        return docShowFields;
    }

    public Map getDocFields(){
        if(docFields==null){
            try {
                Model doc = archiveService.getDocumentModel(modelName);
                docFields = doc.getInheritfieldsMap();
            }catch(ModelNotFoundException ex){
                logger.error(ex.getMessage());
            }
        }
        return docFields;
    }

    public void getArchiveForBoxId(){
        try {
            logger.info("开始获取：");
            logger.info("id" + session);
            String id = (String) session.get(currentAIdString);
            logger.info("currentAId:" + id);
            if (!org.apache.commons.lang.StringUtils.isBlank(id)) {
                Archive archive1 = archiveService.getArchive(modelName, id);
                logger.info("获取结束：" + archive1.getDh().toString());
                renderJson(archive1);
            }
        }catch (Exception e){
            logger.error(e.getMessage());
        }
    }

    /**
     * 获取先前版本的档案
     *
     * @return 先前版本的档案记录
     * @throws Exception
     */
    public String getPreVersion() throws Exception {
        if (!Strings.isNullOrEmpty(modelName) && !Strings.isNullOrEmpty(id)) {
            try {
                this.entity = archiveMetadataService.getPreVersionArchive(modelName, id, version);
            } catch (Exception e) {
                logger.error(e.getMessage());
            }
        }

        /*
         * 更新valuestack中的entity
         * // todo：测试检验，自我感觉这种操作比较危险
         */
        ValueStack stack = ServletActionContext.getValueStack(ServletActionContext.getRequest());
        stack.getRoot().pop();
        stack.getRoot().push(getModel());
        return renderModelTemplate("edit");
    }
}
