package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.EntityNotFoundException;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.support.hibernate.UUIDHexGenerator;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.*;
import com.gtis.archive.service.*;
import com.gtis.archive.service.sv.SqlServerService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import freemarker.template.TemplateException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContext;
import javax.xml.XMLConstants;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.*;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.io.*;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-8-23
 */
public class ArchiveAction extends BaseModelAction<Archive> {
    private static final Object Lock = 0x001;

    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private DictService dictService;
    @Autowired
    private AjhRangeService ajhRangeService;
    @Autowired
    private OriginalService originalService;
    @Autowired
    private LoanService loanService;
    @Autowired
    private GatewayService gatewayService;
    @Autowired
    private RecordAjhRangeService recordAjhRangeService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private SqlServerService sqlServerService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private LogManagerService logManagerService;


    /**
     * tree id
     */
    private String treeId;
    /**
     * archive view type,wgd(未归档) ygd(已归档)
     */
    private String type;
    /**
     * 所有定义的操作项
     */
    private List<Item> operations;

    /**
     * 所有的操作项
     */
    private List<String> operationStrs;

    private Map<String, String> topMenu;
    /**
     * 自动组盒用的目录号
     */
    private String mlh;
    /**
     * 自动组盒用的起始案卷号
     */
    private Integer ajh;

    /**
     * 自动组合截止案卷号
     */
    private Integer endAjh;
    /**
     * 自动组盒盒号
     */
    private Integer boxId;
    /**
     * 自动组盒用装盒份数
     */
    private Integer boxSize;

    /**
     * 自动组盒用装盒份数
     */
    private String nd;
    /**
     * 档案中卷内显示的字段
     */
    private Map docShowFields;
    private Map docFields;

    /**
     * 链接字段
     */
    private String linkField;

    private String docLinkField;

    private String wgdState = "false";

    /**
     * excel导入档案
     */
    private File upload;

    private String uploadFileName; //文件名称

    /**
     * 档案流程节点字典
     */
    private List<Item> flowDict;

    private Map<String, String> queryParam = new HashMap<String, String>();

    private Map<String, String> receivedParam = new HashMap<String, String>();

    /**
     * 机柜所在位置
     */
    private String jgszwz;

    /**
     * 操作机柜命令
     */
    private String cmd;

    /**
     * 分类号检索
     */
    private String flhjs;

    /**
     * 档号
     */
    private String dh;
    /**
     * 题名
     */
    private String tm;

    /**
     * 档案id
     */
    private String djDaId;

    /**
     * 原文所属ID
     */
    private String ownerId;

    /**
     * 原文所属业务模型名
     */
    private String ownerModelName;

    /**
     * 字符串类型的boxId
     **/
    private String sboxId;

    /**
     * 档案ids
     */
    private String[] archiveIds;

    private String cabinetSno;
    private Integer cellId;
    private Integer sideId;
    private Integer columnId;

    /**
     * 单位代码
     */
    private String dwdm;

    private String queryArchive;

    /**
     * 原文id
     */
    private String originalId;

    /**
     * 开放状态: public,close
     */
    private String openState;

    private String isImage = "isImage";
    private String isDoc = "isDoc";
    private String parentId = "parentId";
    private String scopeText = "scope";
    private String updateTime= "updateTime";
    private String itemText = "items";
    private String childCount ="childCount";
    private String folderGif = "folder.gif";
    private String pageCountText ="pageCount";
    private String total = "total";

    public String[] getArchiveIds() {
        return archiveIds;
    }

    public void setArchiveIds(String[] archiveIds) {
        this.archiveIds = archiveIds;
    }

    public String getNd() {
        return nd;
    }

    public void setNd(String nd) {
        this.nd = nd;
    }

    public Map<String, String> getQueryParam() {
        if (EnvHolder.isEnable(Switch.SJWS)) {
            try {
                return JSON.parseObject(getEntityTemplate("queryParam"), LinkedHashMap.class);
            } catch (Exception ex) {
                return new HashMap<String, String>();
            }

        } else {
            return new HashMap<String, String>();
        }

    }

    public Map<String, String> getReceivedParam() {
        if (EnvHolder.isEnable(Switch.SJWS)) {
            try {
                return JSON.parseObject(getEntityTemplate("receivedParam"), LinkedHashMap.class);
            } catch (Exception ex) {
                return new HashMap<String, String>();
            }

        } else {
            return new HashMap<String, String>();
        }
    }

    public String getPermJson() {
        Map<String, Boolean> perm = new HashMap<String, Boolean>();
        if(!EnvHolder.isEnable(Switch.isNewPermission)) {
            for (String s : operationStrs) {
                if (securityService.isPermitted(treeId, s)) {
                    perm.put(s, true);
                }
            }
        }else {
            UserInfo userInfo = SessionUtil.getCurrentUser();
            if (userInfo.isAdmin()){
                for (String s : operationStrs) {
                    perm.put(s, true);
                }
            }else {
                perm = securityService.getUserPermMap(userInfo,treeId);
            }
        }
        return JSON.toJSONString(perm);
    }

    public Map<String, Boolean> getPerms() {
        Map<String, Boolean> perm = new HashMap<String, Boolean>();
        if(!EnvHolder.isEnable(Switch.isNewPermission)) {
            for (String s : operationStrs) {
                if (securityService.isPermitted(treeId, s)) {
                    perm.put(s, true);
                }
            }
        }else {
            UserInfo userInfo = SessionUtil.getCurrentUser();
            if (userInfo.isAdmin()){
                for (Item item : dictService.getItems(Permission.SYS_FUNCTION_DICT)) {
                    perm.put(item.getName(), true);
                }
            }else {
                perm = securityService.getUserPermMap(userInfo,"sys");
            }
        }
        return perm;
    }

    public String getTreeJson() throws JSONException {
        return JSON.toJSONString(rewrite(treeService.getTree(treeId)));
    }

    /**
     * 获取查看流程url地址字典
     */
    public Map<String, Boolean> getFlow() {
        Map<String, Boolean> flow = new HashMap<String, Boolean>();
        for (Model model : modelService.getModels()) {
            flow.put(model.getName(), false);
        }
        for (Item item : flowDict) {
            flow.put(item.getName(), true);
        }
        return flow;
    }

    /**
     * 获取查看流程url地址字典备注
     */
    public void getFlowRemark() {
        String remark = null;
        flowDict = dictService.getItems(Permission.FLOW_DICT);
        for (Item item : flowDict) {
            if (item.getName().equals(modelName)) {
                remark = item.getRemark();
            }
        }
        renderJson(remark);
    }

    private List<Map<String, Object>> tree;

    public List<Map<String, Object>> getTree() {
        if (tree == null) {
            List<Map<String, Object>> listTree = treeService.getTree(null, Constants.MODEL_ROOT);
            for (Map item : listTree) {
                logger.debug(item.toString());
                if (item.get("name").equals(Constants.GENERIC)) {
                    listTree.remove(item);
                    break;
                }
            }
            tree = listTree;
        }
        return tree;
    }

    public Map<String, String> getTopMenu() {
        if (topMenu == null) {
            topMenu = new LinkedHashMap<String, String>();
            for (Item item : dictService.getItems("archiveMenu")) {
                if ("true".equalsIgnoreCase(item.getValue())) {
                    topMenu.put(item.getName(), item.getRemark());
                }
            }
        }

        if (EnvHolder.isEnable(Switch.IMPORTEXCEL)) {
            List<String> menuList = new ArrayList<String>();
            for (Item item : dictService.getItems("importMenu")) {
                menuList.add(item.getName());
            }
            if (!menuList.contains(modelName)) {
                topMenu.remove("importExcel");
            }
        } else {
            topMenu.remove("importExcel");
        }
        return topMenu;
    }

    public String getQueryArchive() {
        return queryArchive;
    }

    public void setQueryArchive(String queryArchive) {
        this.queryArchive = queryArchive;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected LinkedHashMap<String, String> getOrderFields() {
        try {
            if (isPrint) {
                return JSON.parseObject(getEntityTemplate("printOrderFields"), LinkedHashMap.class);
            } else {
                String tmp = "ygd".equals(type) ? "ygdOrderFields" : "wgdOrderFields";
                return JSON.parseObject(getEntityTemplate(tmp), LinkedHashMap.class);
            }
        } catch (TemplateNotFoundException ex) {
            return JSON.parseObject(getEntityTemplate("orderFields"), LinkedHashMap.class);
        }
    }

    public String getOriginalId() {
        return originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    public String getSboxId() {
        return sboxId;
    }

    public void setSboxId(String sboxId) {
        this.sboxId = sboxId;
    }

    public void setDwdm(String dwdm) {
        this.dwdm = dwdm;
    }

    public Integer getBoxId() {
        return boxId;
    }

    public void setBoxId(Integer boxId) {
        this.boxId = boxId;
    }

    public ArchiveService getArchiveService() {
        return archiveService;
    }

    public void setArchiveService(ArchiveService archiveService) {
        this.archiveService = archiveService;
    }

    public void setCabinetSno(String cabinetSno) {
        this.cabinetSno = cabinetSno;
    }

    public void setCellId(Integer cellId) {
        this.cellId = cellId;
    }

    public void setSideId(Integer sideId) {
        this.sideId = sideId;
    }

    public void setColumnId(Integer columnId) {
        this.columnId = columnId;
    }

    public void setTm(String tm) {
        this.tm = tm;
    }

    @Override
    public void setModelName(String modelName) {
        if (modelName.startsWith(Constants.ARCHIVE_PREFIX)) {
            queryArchive = "1";
        } else {
            queryArchive = "0";
        }

        super.setModelName(Document.toArchiveModelName(modelName));
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public String getMlh() {
        return mlh;
    }

    public void setAjh(Integer ajh) {
        this.ajh = ajh;
    }

    public void setEndAjh(Integer endAjh) {
        this.endAjh = endAjh;
    }

    public void setBoxSize(Integer boxSize) {
        this.boxSize = boxSize;
    }

    public Integer getBoxSize() {
        return boxSize;
    }

    public String getTreeId() {
        return treeId;
    }

    public String getType() {
        return type;
    }

    public List<Item> getOperations() {
        return operations;
    }

    public List<String> getOperationStrs() {
        return operationStrs;
    }

    public String getWgdState() {
        return wgdState;
    }

    public void setWgdState(String wgdState) {
        this.wgdState = wgdState;
    }

    public File getUpload() {
        return upload;
    }

    public void setUpload(File upload) {
        this.upload = upload;
    }

    public String getUploadFileName() {
        return uploadFileName;
    }

    public void setUploadFileName(String uploadFileName) {
        this.uploadFileName = uploadFileName;
    }

    public String getFlhjs() {
        return flhjs;
    }

    public void setFlhjs(String flhjs) {
        this.flhjs = flhjs;
    }

    public String getDh() {
        return dh;
    }

    public void setDh(String dh) {
        this.dh = dh;
    }

    public String getDjDaId() {
        return djDaId;
    }

    public void setDjDaId(String djDaId) {
        this.djDaId = djDaId;
    }

    public String getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerModelName() {
        return ownerModelName;
    }

    public void setOwnerModelName(String ownerModelName) {
        this.ownerModelName = ownerModelName;
    }

    public String getJgszwz() {
        return jgszwz;
    }

    public void setJgszwz(String jgszwz) {
        this.jgszwz = jgszwz;
    }

    public String getCmd() {
        return cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public String getTddjPath() {
        return EnvHolder.getAppEnv().get(Switch.TDDJPATH);
    }

    public static Object getLock() {
        return Lock;
    }

    public String getOpenState() {
        return openState;
    }

    public void setOpenState(String openState) {
        this.openState = openState;
    }

    @Override
    public String execute() {
        flowDict = dictService.getItems(Permission.FLOW_DICT);
        String location = ServletActionContext.getRequest().getSession().getServletContext().getRealPath("/tpls/permission.json");
        try {
            operationStrs = permissionService.getLeavesId(location); // 获取所有的操作项
        } catch (IOException e) {
            logger.error("读取配置文件permission.json错误，请检查，文件位置为{}" + location,e);
        }

        if (StringUtils.isNotEmpty(modelName)) {
            Resource res = resourceService.findChildResource(null, modelName, Constants.MODEL_ROOT);
            if (res != null) {
                treeId = res.getId();
            } else {
                throw new ModelNotFoundException(modelName);
            }
        }
        modelService.getModel(modelName);
        String id = getId();
        if (id != null) {
            Archive archive = archiveService.getArchive(modelName, id);
            if (archive != null) {
                type = archive.getState() == Archive.STATE_YGD ? "ygd" : "wgd";
            }
        }

        ServletActionContext.getRequest().getSession().setAttribute("username", SessionUtil.getCurrentUser().getUsername());
        return Action.SUCCESS;
    }

    /**
     * 归档
     *
     * @return
     */
    public String gd() {
        for (String id : ids) {
            if (StringUtils.isBlank(id)) {
                continue;
            }
            Archive archive = archiveService.getArchive(modelName, id);

            if (EnvHolder.isEnable("gdsetnd.enable")) {
                int year = Calendar.getInstance().get(1);
                archive.setNd(String.valueOf(year));
            }

            AjhRange ajhRange = null;
            if (archive.getDh() == null && !EnvHolder.isEnable(Switch.NOT_NEED_AJH) && !EnvHolder.isEnable(Switch.LIAN_YUNGANG)) {  //连云港档案系统归档时，目录号、分类号及案卷号不变
                try {
                    if (PropertyUtils.isReadable(archive, "jnmllx")) {
                        ajhRange = ajhRangeService.getAvailableAjhRange(modelName, archive);
                    } else {
                        if (!EnvHolder.isEnable(Switch.JIN_TAN)) {
                            ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                        } else {
                            if ("Tddj".equalsIgnoreCase(modelName) && getDwdm().length() == 6 && archive.getNd() != null) {
                                try {
                                    ajhRange = ajhRangeService.getAvailableAjhRangByNd(modelName, archive.getNd());
                                } catch (Exception ex) {
                                    ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                                }
                            } else {
                                ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                            }
                        }
                    }
                } catch (EntityNotFoundException e) {
                    Struts2Utils.renderText(e.getMessage());
                } catch (NoSuchMethodException e) {
                    logger.error(e.getMessage());
                } catch (IllegalAccessException e) {
                    logger.error(e.getMessage());
                } catch (InvocationTargetException e) {
                    logger.error(e.getMessage());
                }

                if (!EnvHolder.isEnable(Switch.NOT_CHECK_AJH)) {       //notCheckAjh.enable=false 设置为此情况，所有业务都可以在添加之后更新业务
                    archive.setMlh(ajhRange.getMlh());
                    archive.setAjh(ajhRange.getNextValue());
                } else if (EnvHolder.isEnable(Switch.NOT_CHECK_AJH)) {  //notCheckAjh.enable=true 设置为此情况,当字典当中配置这个业务时就给这个业务更新案卷号
                    List<Item> dictList = dictService.getItems("increaseAjh");
                    boolean flag = false;
                    for (Item item : dictList) {
                        if (item.getName().equalsIgnoreCase(modelName)) {
                            archive.setMlh(ajhRange.getMlh());
                            archive.setAjh(ajhRange.getCurrentValue());
                            flag = true;
                            break;
                        }
                        if (!flag) {
                            archive.setMlh(ajhRange.getMlh());
                            archive.setAjh(ajhRange.getNextValue());
                        }
                    }
                }
            }

            //归档人及归档人id的写入
            if (EnvHolder.isEnable(Switch.HASGDR_GDRID)) {
                archive = this.setGdrAndGdrId(archive);
            }
            //归档时是否自动添加案卷号
            if (EnvHolder.isEnable(Switch.AUTO_CREATE_AJH) && archive.getAjh() == null && archive.getMlh() != null) {
                try {
                    ajhRange = ajhRangeService.getAvailableAjhRange(modelName, archive.getMlh());
                } catch (EntityNotFoundException e) {
                    ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                }
                // 只要是案卷号回收的那么使用的时候优先使用回收的案卷号【王建明 2017/10/10 0010 上午 10:57】
                if (EnvHolder.isEnable(Switch.RECORD_AJH_RANGE)) {
                    RecordAjhRange recordAjhRange = recordAjhRangeService.getAvailable(ajhRange.getMlh(), modelName, getDwdm());
                    if (recordAjhRange != null) {
                        archive.setAjh(recordAjhRange.getAjh());
                        archive.setMlh(recordAjhRange.getMlh());
                        updateAjhRange(archive);
                    } else {
                        archive.setMlh(ajhRange.getMlh());
                        archive.setAjh(ajhRange.getNextValue());
                    }
                } else {
                    archive.setMlh(ajhRange.getMlh());
                    archive.setAjh(ajhRange.getNextValue());
                }
            }
            if (EnvHolder.isEnable(Switch.AUTO_CREATE_CABINETSNO)) {
                archive = changeArchive(archive);
            }
            archive.setState(Archive.STATE_YGD);
            archive.setGdsj(new Date());

            archiveService.saveArchive(archive);
            try {
                List<Document> documents = archiveService.getArchiveDocuments(modelName + "_jn", archive.getId());
                for (Document document : documents) {
                    document.setMlh(archive.getMlh());
                    document.setAjh(archive.getAjh());
                    document.setDabh(archive.getDh());
                    archiveService.saveDocument(document);
                }
            } catch (Exception ex) {
                //不设置卷内的情况下
            }

            if (ajhRange != null) {
                ajhRange.setCurrentValue(archive.getAjh());
                ajhRangeService.saveAjhRange(ajhRange);
            }

            logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                    archive, "gd");
        }
        return null;
    }

    /**
     * 更新案卷号回收表
     *
     * @param archive
     */
    public void updateAjhRange(Archive archive) {
        if (EnvHolder.isEnable(Switch.RECORD_AJH_RANGE)) { //当使用recordAjhRange时要将那条记录删除
            String id = recordAjhRangeService.removeHasUsed(archive.getMlh(), archive.getModelName(), archive.getDwdm(), archive.getAjh());
            if (StringUtils.isNotBlank(id)) {
                recordAjhRangeService.remove(id);
            }
        }
    }

    /**
     * 撤销归档
     *
     * @return
     */
    public String cxgd() {
        for (String id : ids) {
            if (StringUtils.isBlank(id)) {
                continue;
            }
            Archive archive = archiveService.getArchive(modelName, id);
            archive.setState(Archive.STATE_WGD);
            archive.setGdsj(null);
            if (EnvHolder.isEnable(Switch.ALLOW_NULL_DH)) {
                if (EnvHolder.isEnable(Switch.RECORD_AJH_RANGE)) {
                    RecordAjhRange recordAjhRange = new RecordAjhRange();
                    recordAjhRange.setAjh(archive.getAjh());
                    recordAjhRange.setMlh(archive.getMlh());
                    recordAjhRange.setDwdm(archive.getDwdm());
                    recordAjhRange.setModelName(archive.getModelName());
                    recordAjhRange.setBgqx(archive.getBgqx());
                    recordAjhRangeService.saveRecordAjh(recordAjhRange);
                }
                archive.setMlh(null);
                archive.setAjh(null);
                archive.setDh(null);
            }
            archiveService.saveArchive(archive);
            logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                    archive, "cxgd");
        }
        return null;
    }

    /**
     * 档案销毁
     *
     * @return
     */
    public String destroyArchive() {
        for (String id : ids) {
            if (StringUtils.isBlank(id)) {
                continue;
            }
            Archive archive = archiveService.getArchive(modelName, id);
            archive.setState(8);
            archiveService.saveArchive(archive);
            logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                    archive, "destroy");
        }
        return null;
    }

    /**
     * 快速归档
     *
     * @return
     * @throws Exception
     */
    public String fastGd() throws Exception {
        try {
            synchronized (Lock) {
                String id = getId();
                if (StringUtils.isNotBlank(id)) {
                    Archive archive = archiveService.getArchive(modelName, id);
                    archive.setState(Archive.STATE_YGD);
                    archive.setGdsj(new Date());
                    AjhRange ajhRange = null;
                    String userName = SessionUtil.getCurrentUser().getUsername();
                    if (archive.getDh() == null) {
                        if (!EnvHolder.isEnable(Switch.JIN_TAN)) {
                            ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                        } else if(EnvHolder.isEnable(Switch.LIYANG)){
                            if("国图归档".equals(userName)){
                                ajhRange = this.ajhRangeService.getAvailableAjhRangeByMlh(this.modelName, "98");
                            }else{
                                ajhRange = this.ajhRangeService.getAvailableAjhRangeByDwdm(this.modelName, archive.getDwdm());
                            }
                        }else {
                            if ("Tddj".equalsIgnoreCase(modelName) && getDwdm().length() == 6 && archive.getNd() != null) {
                                try {
                                    ajhRange = ajhRangeService.getAvailableAjhRangByNd(modelName, archive.getNd());
                                } catch (Exception ex) {
                                    ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                                }
                            } else {
                                ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                            }
                        }
                        archive.setMlh(ajhRange.getMlh());
                        archive.setAjh(ajhRange.getNextValue());
                    }
                    if (EnvHolder.isEnable(Switch.HASGDR_GDRID)) {
                        archive = this.setGdrAndGdrId(archive);
                    }
                    archiveService.saveArchive(archive);
                    if (ajhRange != null) {
                        ajhRange.setCurrentValue(archive.getAjh());
                        ajhRangeService.saveAjhRange(ajhRange);
                    }
                    logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                            archive, "fastGd");
                }
            }
        }catch (Exception e){
            logger.error(e.getMessage());
        }
        return renderModelTemplate("fastGd");
    }

    public String move() {
        if (StringUtils.isBlank(treeId)) {
            treeId = null;
        }
        for (String id : ids) {
            if (StringUtils.isBlank(id)) {
                continue;
            }
            Archive archive = archiveService.getArchive(modelName, id);
            archive.setResourceId(treeId);
            archiveService.saveArchive(archive);
            logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                    archive, "move");
        }
        return null;
    }

    public String order() {
        AjhRange ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
        for (Archive archive : getEntities()) {
            if (!ajhRange.hasExhausted()) {
                ajhRangeService.saveAjhRange(ajhRange);
                ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
            }
            archive.setAjh(ajhRange.getNextValue());
            archive.setDh(null);
            archiveService.saveArchive(archive);
        }
        return null;
    }

    @Override
    protected Page<Archive> searchEntity(List<Criterion> criterions, List<Order> orders) {
        Page<Archive> page = archiveService.searchArchive(modelName, criterions, orders, start, limit);
        for (Archive archive : page.getItems()) {
            archive.setHasOriginal(originalService.hasOriginal(archive.getId()));
        }
        return page;
    }

    @Override
    protected List<Criterion> createCriterions(ArrayList<Criterion> criterions) {
        String resourceIdInfo = "resourceId";
        if (ajh != null) {
            criterions.add(Restrictions.eq("mlh", mlh));
            criterions.add(Restrictions.gt("ajh", ajh - 1));
            if (endAjh != null) {
                criterions.add(Restrictions.lt("ajh", endAjh + 1));
            }
            if (nd != null) {
                criterions.add(Restrictions.eq("nd", nd));
            }
            sort = "ajh";
        } else {
            if (type == null || !"all".equals(type)) {
                criterions.add(Restrictions.eq("state", "ygd".equals(type) ? Archive.STATE_YGD : Archive.STATE_WGD));
            }
            if (mlh != null && StringUtils.isNotBlank(mlh)) {
                criterions.add(Restrictions.eq("mlh", mlh));
            }
            if (openState == null){
                criterions.add(Restrictions.or(Restrictions.eq("open",1),Restrictions.isNull("open")));
            }

            if (dwdm == null) {
                dwdm = getDwdm();
            }

            if (StringUtils.isNotBlank(treeId)) {
                if ("checkbox".equals(EnvHolder.getAppEnv().get(Switch.CLASSIFYVIEWMODE))) {
                    String[] treeIds = treeId.split(",");
                    if (treeIds.length == 1) {
                        if (resourceService.getResource(treeId).getName().equals(modelName)) {
                            criterions.add(Restrictions.or(Restrictions.eq(resourceIdInfo, treeId), Restrictions.isNull(resourceIdInfo)));
                        } else {
                            criterions.add(Restrictions.eq(resourceIdInfo, treeId));
                        }
                    } else {
                        if (treeIds.length > 2) {
                            Criterion temp = Restrictions.or(Restrictions.eq(resourceIdInfo, treeIds[0]), Restrictions.eq(resourceIdInfo, treeIds[1]));
                            for (int i = 2; i < treeIds.length; i++) {
                                temp = Restrictions.or(temp, Restrictions.eq(resourceIdInfo, treeIds[i]));
                            }
                            criterions.add(temp);
                        } else {
                            criterions.add(Restrictions.or(Restrictions.eq(resourceIdInfo, treeIds[0]), Restrictions.eq(resourceIdInfo, treeIds[1])));
                        }
                    }
                } else {
                    if (resourceService.getResource(treeId).getName().equals(modelName)) {
                        criterions.add(Restrictions.or(Restrictions.eq(resourceIdInfo, treeId), Restrictions.isNull(resourceIdInfo)));
                    } else {
                        criterions.add(Restrictions.eq(resourceIdInfo, treeId));
                    }
                }
            } else {
                criterions.add(Restrictions.isNull(resourceIdInfo));
            }

            if (EnvHolder.isEnable(Switch.ZHEN_JINAG) && !SessionUtil.getCurrentUser().isAdmin()) {
                List<AjhRange> ajhRanges = ajhRangeService.getAjhRangeByModelName(modelName);
                List<String> mlhs = new ArrayList<String>();
                UserInfo userInfo = SessionUtil.getCurrentUser();
                String roleids = userInfo.getRoleIds();
                if (!EnvHolder.isEnable(Switch.isNewPermission) && roleids != null) {
                    for (String roleid : roleids.split(",")) {
                        roleid = roleid.substring(1, roleid.length() - 1);
                        for (AjhRange ajhRange : ajhRanges) {
                            if (permissionService.getPermissions(ajhRange.getId(), roleid).size() != 0) {
                                mlhs.add(ajhRange.getMlh());
                            }
                        }
                    }
                }else {
                    String userId = userInfo.getId();
                    for (AjhRange ajhRange : ajhRanges){
                        if (permissionService.getUserPermissions(ajhRange.getId(), userId).size() != 0){
                            mlhs.add(ajhRange.getMlh());
                        }
                    }
                }
                if (!mlhs.isEmpty()) {
                    String sSQL = "(";
                    for (String mlh : mlhs) {
                        StringBuilder strB = new StringBuilder();
                        strB.append(sSQL).append("mlh = '").append(mlh).append("' OR");
                        sSQL = strB.toString();
                    }
                    sSQL = sSQL.substring(0, sSQL.length() - 4);
                    sSQL = sSQL + ")";
                    criterions.add(Restrictions.sqlRestriction(sSQL));
                }
            }
        }
        return super.createCriterions(criterions);
    }

    /**
     * 分类号类型检索
     *
     * @return
     */
    public String searchFlh() {
        String flhtj = archiveService.flhjs(flhjs, modelName);
        renderJson(flhtj);
        return null;
    }

    @SuppressWarnings("unchecked")
    private List<Map<String, Object>> rewrite(List<Map<String, Object>> tree) {
        if (tree != null) {
            for (Map<String, Object> map : tree) {
                rewrite((List<Map<String, Object>>) map.get("children"));
                String id = (String) map.get("id");
                Map<String, Boolean> perm = new HashMap<String, Boolean>();
                if (!EnvHolder.isEnable(Switch.isNewPermission) || SessionUtil.getCurrentUser().isAdmin()) {
                    for (String s : operationStrs) {
                        if (securityService.isPermitted(id, s)) {
                            perm.put(s, true);
                        }
                    }
                } else {
                    perm = securityService.getUserPermMap(SessionUtil.getCurrentUser(),id);
                }
                map.put("perm", perm);
            }
        }
        return tree;
    }

    /**
     * 获得档案中案卷显示的字段
     *
     * @return
     */
    public Map getDocShowFields() {
        if (docShowFields == null) {
            try {
                Model doc = archiveService.getDocumentModel(modelName);
                docShowFields = JSON.parseObject(doc.getTemplate("showFields"), LinkedHashMap.class);
            } catch (Exception ex) {
                docShowFields = JSON.parseObject(getEntityTemplate("Document-showFields"), LinkedHashMap.class);
            }
        }
        if(docShowFields == null){
            docShowFields = new HashMap();
        }
        return docShowFields;
    }

    /**
     * 获取档案中案卷所有字段
     *
     * @return
     */
    public Map getDocFields() {
        if (docFields == null) {
            try {
                Model doc = archiveService.getDocumentModel(modelName);
                docFields = doc.getInheritfieldsMap();
            } catch (ModelNotFoundException ex) {
                logger.error(ex.getMessage());
            }
        }
        return docFields;
    }

    public String getLinkField() {
        if (linkField == null) {
            try {
                linkField = archiveService.getArchiveModel(modelName).getTemplate("linkField");
            } catch (Exception ex) {
                linkField = "tm";
            }
        }
        return linkField;
    }

    public String getDocLinkField() {
        if (docLinkField == null) {
            try {
                docLinkField = archiveService.getDocumentModel(modelName).getTemplate("linkField");
            } catch (ModelNotFoundException ex) {
                logger.error(ex.getMessage());
            } catch (TemplateNotFoundException ex) {
                docLinkField = "tm";
            }
        }
        return docLinkField;
    }

    /**
     * 快速补件
     *
     * @return
     * @throws Exception
     */
    public String fastAddOG() throws Exception {
        //
        return renderModelTemplate("fastAddOG");
    }

    /**
     * 获取是否存在卷内案卷模型
     *
     * @return
     */
    public boolean getIsShowArchiveInfo() {
        try {
            if (modelService.getModel(modelName.concat("_ai")) != null) {
                return true;
            }
        } catch (ModelNotFoundException ex) {
            return false;
        }
        return false;
    }

    /**
     * 获取案卷是否存在卷内
     *
     * @return
     */
    public boolean getIsShowArchiveDoc() {
        try {
            if (modelService.getModel(modelName.concat("_jn")) != null) {
                return true;
            }
        } catch (ModelNotFoundException ex) {
            return false;
        }
        return false;
    }

    /**
     * 打印档案相关案卷信息
     *
     * @return
     * @throws IOException
     * @throws TemplateException
     */
    public String printArcDocs() throws IOException, TemplateException {
        try {
            return renderTemplate(getEntityModel().getTemplate("printArcDoc"));
        } catch (TemplateNotFoundException ex) {
            logger.error(ex.getMessage());
        }
        return null;
    }

    /**
     * 检索数据后进行统一归档
     *
     * @return
     */
    public String gdAfterSearch() {
        List<Archive> list = getEntityPage().getItems();
        for (Archive archive : list) {
            AjhRange ajhRange = null;
            if (archive.getDh() == null) {
                try {
                    ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                } catch (Exception e) {
                    Struts2Utils.renderText(e.getMessage());
                    break;
                }
                archive.setMlh(ajhRange.getMlh());
                archive.setAjh(ajhRange.getNextValue());
            }
            archive.setState(Archive.STATE_YGD);
            archive.setGdsj(new Date());
            archiveService.saveArchive(archive);
            if (ajhRange != null) {
                ajhRange.setCurrentValue(archive.getAjh());
                ajhRangeService.saveAjhRange(ajhRange);
            }
            logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                    archive, "gdAfterSearch");
        }
        return null;
    }

    @Override
    public String remove() throws Exception {
        if (EnvHolder.isEnable(Switch.RECORD_AJH_RANGE)) {
            for (String id : ids) {
                Archive archive = archiveService.getArchive(modelName, id);
                if (archive.getAjh() != null && archive.getMlh() != null && archive.getModelName() != null) {
                    RecordAjhRange recordAjhRange = new RecordAjhRange();
                    recordAjhRange.setAjh(archive.getAjh());
                    recordAjhRange.setMlh(archive.getMlh());
                    recordAjhRange.setDwdm(archive.getDwdm());
                    recordAjhRange.setModelName(archive.getModelName());
                    recordAjhRange.setBgqx(archive.getBgqx());
                    recordAjhRangeService.saveRecordAjh(recordAjhRange);
                }
            }
        }

        List<Archive> archivesToDel = new ArrayList<Archive>();
        for (String id : ids) {
            archivesToDel.add(archiveService.getArchive(modelName, id));
        }

        try {
            super.remove();
            for (Archive archive : archivesToDel) {
                logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                        archive, "remove");
            }
        } catch (Exception e) {
            logger.error("删除失败,{}", e.getMessage());
        }
        return null;
    }

    private List docEntities;

    /**
     * 获取档案相关卷内值
     *
     * @return
     */
    public List getDocEntities() {
        if (docEntities != null) {return docEntities;}
        docEntities = new ArrayList();
        if (ids.length > 0) {
            for (String id : ids) {
                docEntities.addAll(archiveService.getArchiveDocuments(modelName, id));
            }
        }

        return docEntities;
    }

    public void setIdString(String idString) {
        if (StringUtils.isNotBlank(idString)) {
            ids = idString.split(",");
        }
    }

    /**
     * 过滤条件查询ｉｄ
     *
     * @return
     */
    public String searchIds() {
        List<Criterion> criterions = createCriterions(new ArrayList<Criterion>());
        List<Order> orders = createOrders(new ArrayList<Order>());
        List items = entityService.search(modelName, criterions, orders, start, limit).getItems();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.size(); i++) {
            try {
                sb.append(PropertyUtils.getProperty(items.get(i), "id") + ",");
            } catch (Exception e) {
                logger.error(e.toString());
            }
        }
        ids = sb.toString().split(",");
        return cacheIds();
    }

    /**
     * excel导入档案
     */
    public void importExcel() {
        String realpath = ServletActionContext.getServletContext().getRealPath("/WEB-INF");
        String msg = "";
        if (upload != null) {
            File savefile = new File(new File(realpath), uploadFileName);
            try {
                FileUtils.copyFile(upload, savefile);
                InputStream is = new FileInputStream(realpath + File.separator + uploadFileName);

                Workbook book = WorkbookFactory.create(is);
                List list = new ArrayList();
                // 循环工作表Sheet
                for (int numSheet = 0; numSheet < book.getNumberOfSheets(); numSheet++) {
                    Sheet sheet = book.getSheetAt(numSheet);
                    if (sheet == null) {
                        continue;
                    }

                    Map filedMap = new HashMap();

                    /**
                     * 存储所有属性信息，应用于和excel的表头进行比较
                     */
                    //获取第一行的头信息
                    Row row = sheet.getRow(0);
                    for (int titleNum = 0; titleNum < row.getLastCellNum(); titleNum++) {
                        for (Field field : modelService.getModel(modelName).getInheritfieldsMap().values()) {
                            if (row.getCell(titleNum) != null && (row.getCell(titleNum).toString().replaceAll(" ", "")).equals(field.getTitle())) {
                                filedMap.put(titleNum, field.getName());
                            }
                        }
                    }

                    /**
                     * 获取数据
                     */
                    for (int rowNum = 1; rowNum <= sheet.getLastRowNum(); rowNum++) {
                        Object o = entityService.newInstance(modelName);
                        Row rows = sheet.getRow(rowNum);
                        if (rows == null) {
                            continue;
                        }

                        /**
                         * 循环取出所有的单元格的值并且判断类型赋值
                         */
                        for (int cellNum = 0; cellNum <= rows.getLastCellNum(); cellNum++) {
                            if (filedMap.get(cellNum) != null && rows.getCell(cellNum) != null) {
                                if (PropertyUtils.getPropertyType(o, filedMap.get(cellNum).toString()) == String.class) {
                                    if (rows.getCell(cellNum) == null || "".equals(rows.getCell(cellNum).toString())) {
                                        PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), null);
                                    } else {
                                        PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), rows.getCell(cellNum).toString());
                                    }
                                } else if (PropertyUtils.getPropertyType(o, filedMap.get(cellNum).toString()) == Boolean.class) {
                                    PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), rows.getCell(cellNum).getBooleanCellValue());
                                } else if (PropertyUtils.getPropertyType(o, filedMap.get(cellNum).toString()) == Integer.class) {
                                    if (rows.getCell(cellNum) == null || "".equals(rows.getCell(cellNum).toString())) {
                                        PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), 0);
                                    } else {
                                        PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), Integer.valueOf(Math.round(Float.valueOf(rows.getCell(cellNum).toString()))));
                                    }
                                } else if (PropertyUtils.getPropertyType(o, filedMap.get(cellNum).toString()) == Float.class) {
                                    if (rows.getCell(cellNum) == null || "".equals(rows.getCell(cellNum).toString())) {
                                        PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), 0);
                                    } else {
                                        PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), Float.valueOf(rows.getCell(cellNum).toString()));
                                    }
                                } else if (rows.getCell(cellNum) == null || PropertyUtils.getPropertyType(o, filedMap.get(cellNum).toString()) == Double.class) {
                                    if ("".equals(rows.getCell(cellNum).toString())) {
                                        PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), 0);
                                    } else {
                                        PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), Double.valueOf(rows.getCell(cellNum).toString()));
                                    }
                                } else if (PropertyUtils.getPropertyType(o, filedMap.get(cellNum).toString()) == Date.class) {
                                    PropertyUtils.setProperty(o, filedMap.get(cellNum).toString(), rows.getCell(cellNum).getDateCellValue());
                                }
                            }
                        }
                        PropertyUtils.setProperty(o, "id", UUIDHexGenerator.generate());

                        //对象档号值都为空的不存储
                        if (PropertyUtils.getProperty(o, "dh") != null && PropertyUtils.getProperty(o, "dh") != "") {
                            list.add(o);
                        }
                    }
                }

                for (Object ob : list) {
                    entityService.save(ob);
                }
                msg = "导入成功";
            } catch (Exception e) {
                logger.error("导入失败" + e.getMessage(),e);
                msg = "导入失败";
            } finally {
                if (savefile.exists() && !savefile.delete()) {
                        logger.error("导入Excel临时文件删除失败!");
                }
            }
        }

        renderJson(msg);
    }

    /**
     * 档案开启机柜
     */
    public void openBox() {
        Map result = null;
        try {
            result = sqlServerService.insertOpenCmd(jgszwz, cmd, SessionUtil.getCurrentUser().getUsername());
        } catch (Exception ex) {
            logger.error("open box with error:" + ex.toString(),ex);
        }

        renderJson(result);
    }

    /**
     * 获取单位代码
     *
     * @return
     */
    @Override
    public String getDwdm() {
        dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            ////单位代码用部门代码进行替换
            if (EnvHolder.isEnable(Switch.ORAGAN_NO)) {
                String oraganNo = null;
                List<PfOrganVo> pfOrganVoList = userService.getOrganListByUser(SessionUtil.getCurrentUserId());
                if (pfOrganVoList != null && !pfOrganVoList.isEmpty()) {
                    PfOrganVo pfOrganVo = pfOrganVoList.get(0);
                    oraganNo = pfOrganVo.getOraganNo();
                }

                dwdm = oraganNo;
            } else {
                UserInfo userInfo = new UserInfo();
                SecurityContext context = (SecurityContext)session.get("SPRING_SECURITY_CONTEXT");
                if (context != null) {
                    Authentication authentication = context.getAuthentication();
                    userInfo =(UserInfo) authentication.getPrincipal();
                }
                dwdm = userInfo.getRegionCode();
            }
        }

        return dwdm;
    }

    /**
     * 根据档号获取档案信息
     */
    private String modelNameInfo = "modelName";
    public void boxDetail() {
        Archive archive = archiveService.getArchiveByDh(dh);
        Map archiveMap = new HashMap();
        archiveMap.put(modelNameInfo, archive.getModelName());
        archiveMap.put("mlh", archive.getMlh());
        archiveMap.put("nd", archive.getNd());
        String room = archive.getRoomId();
        String carbinet = archive.getCabinetSno();
        Integer side = archive.getSideId();
        Integer cell = archive.getCellId();
        Integer box = archive.getBoxId();

        String ajhs = archiveService.getAjhs(room, carbinet, side, cell, box);
        if(Struts2Utils.isNull(ajhs)) {
            archiveMap.put("ajhs", archive.getAjh());
        }else{
            archiveMap.put("ajhs", ajhs);
        }
        renderJson(archiveMap);
    }

    /**
     * 获取档案的不动产登记proid
     */
    public void materialProid() {
        Archive archive = archiveService.getArchive(modelName, djDaId);
        try {
            String proid = archive.getProId();
            if (proid != null) {
                renderJson(proid);
            } else {
                renderJson("null");
            }
        } catch (Exception e) {
            renderJson("null");
        }
    }

    /**
     * 查询
     */
    public void search() {
        ArrayList<Criterion> criterions = new ArrayList<Criterion>();
        if (ajh != null) {
            criterions.add(Restrictions.eq("ajh", ajh));
        }
        if (!"".equals(mlh)) {
            criterions.add(Restrictions.eq("mlh", mlh));
        }
        if (!"".equals(tm)) {
            criterions.add(Restrictions.like("tm", tm));
        }
        Page<Archive> page = archiveService.searchArchive(modelName, criterions, null, start, limit);
        renderJson(page);
    }

    /**
     * 原文展示
     */
    public String viewOg() {
        if (StringUtils.isBlank(ownerId) || ownerId == null) {
            return null;
        }

        String sXmlDoc = "";
        StringBuilder strB = new StringBuilder();
        String nameText = "\" name=\"";
        String startText = "<Original id=\"";
        String endText = "\"></Original>";
        if (modelName.contains("_jn")) {
            Document document = archiveService.getDocument(modelName, ownerId);
            if (document == null) {
                return null;
            }

            sXmlDoc = "<Document id=\"" + document.getId() + nameText + document.getTm() + "\" yh=\"" + document.getYh() + "\">";
            List<Original> originals = originalService.getOriginals(document.getId());
            if (originals == null) {
                Archive archive = archiveService.getSimpleArchive(document.getArchiveId());
                if (archive != null) {
                    originals = originalService.getOriginals(archive.getId());
                    if (originals != null && originals.size() == 1) {
                        Original original = originals.get(0);
                        sXmlDoc = sXmlDoc + startText + original.getId() + nameText + original.getName() + endText;
                    }
                }
            } else {
                strB.append(sXmlDoc);
                for (Original original : originals) {
                    strB.append(startText).append(original.getId()).append(nameText).append(original.getName()).append(endText);
                }
                sXmlDoc = strB.toString();
            }

            sXmlDoc = sXmlDoc + "</Document>";
        } else {
            Archive archive = archiveService.getArchive(modelName, ownerId);
            if (archive == null) {
                return null;
            }

            sXmlDoc = "<Archive  id=\"" + archive.getId() + "\">";
            List<Original> originals = originalService.getOriginals(archive.getId());
            if (originals != null) {
                strB.append(sXmlDoc);
                for (Original original : originals) {
                    strB.append(startText).append(original.getId()).append(nameText).append(original.getName()).append(endText);
                }
                sXmlDoc = strB.toString();
            }

            List<Document> documentList = archiveService.getArchiveDocuments(archive);
            if (documentList != null) {
                for (Document document : documentList) {
                    strB.append(sXmlDoc).append("<Document id=\"").append(document.getTm()).append(nameText).append(document.getTm()).append("\" yh=\"").append(document.getYh()).append("\">");
                    sXmlDoc = strB.toString();

                    originals = originalService.getOriginals(document.getId());
                    if (originals != null) {
                        for (Original original : originals) {
                            strB.append(sXmlDoc).append(startText).append(original.getId()).append(nameText).append(original.getName()).append(endText);
                            sXmlDoc = strB.toString();
                        }
                    }
                    strB.append(sXmlDoc).append("</Document>");
                    sXmlDoc = strB.toString();
                }
            }

            sXmlDoc = sXmlDoc + "</Archive>";
        }
        renderJson(sXmlDoc);
        return "viewOg";
    }

    /**
     * 获取第一个ModelName名称
     */
    public void getFirstModelName() {
        List<Map<String, Object>> listTree = treeService.getTree(null, Constants.MODEL_ROOT);
        bgm:for (Map item : listTree) {
            List<Map<String, Object>> childItem = (List<Map<String, Object>>) item.get("children");
            for (Map child : childItem) {
                modelName = child.get("name").toString();
                if(!modelName.isEmpty()){
                    break bgm;
                }
            }
        }
        renderJson(modelName);
    }

    /**
     * 跳转到新页面
     *
     * @return
     */
    public String groupArchive() {
        return "groupPackage";
    }

    /**
     * 档案组合自动填充
     */
    private String cabinetSnoInfo = "cabinetSno";
    private String cellIdinfo = "cellId";
    private String boxIdInfo = "boxId";
    private String successInfo = "success";
    public void packageArchive() {
        List<String> mlhs = new ArrayList();
        List ajhs = new ArrayList();
        Map map = new HashMap();
        try{
            for (int i = 0; i < this.archiveIds.length; i++) {
                Archive archive = this.archiveService.getArchive(this.modelName, this.archiveIds[i]);
                if (archive != null) {
                    mlhs.add(archive.getMlh());
                    ajhs.add(archive.getAjh());
                } else {
                    return;
                }
            }
            boolean flag = true;
            String firstMlh = mlhs.get(0);
            for (String mlh : mlhs) {
                if (!mlh.equals(firstMlh)) {
                    flag = false;
                }
            }

            Collections.sort(ajhs);

            Archive archiveP = this.archiveService.getArchiveByPosition(modelName);
            if (archiveP != null) {
                logger.info(archiveP.getId());
                map.put(cabinetSnoInfo, archiveP.getCabinetSno());
                map.put("columnId", archiveP.getColumnId());
                map.put(cellIdinfo, archiveP.getCellId());
                map.put(boxIdInfo, archiveP.getBoxId());
            } else {
                map.put(cabinetSnoInfo, Integer.valueOf(1));
                map.put("columnId", Integer.valueOf(1));
                map.put(cellIdinfo, Integer.valueOf(1));
                map.put(boxIdInfo, Integer.valueOf(1));
            }

            map.put("mlh", firstMlh);
            map.put("firstAjh", ajhs.get(0));
            map.put("lastAjh", ajhs.get(ajhs.size() - 1));
            map.put("size", Integer.valueOf(ajhs.size()));
            if (flag) {
                map.put(successInfo, "true");
            } else {
                map.put(successInfo, "false");
            }
            logger.info(map.toString());
        }catch (Exception e){
            logger.error(e.toString());
        }
        renderJson(map);
    }

    /**
     * 档案组合自动填充(武进)
     */
    public void packageBoxId() {
        Map map = new HashMap();

        Integer bixId = archiveService.getMaxBoxNum(modelName,nd,mlh);
        Resource resource = resourceService.getResourceByName(modelName);
        map.put(boxIdInfo, bixId);
        map.put("flh", resource.getFlh());
        map.put(successInfo, "true");

        renderJson(map);
    }

    /**
     * 根据扫描的id获取案卷信息
     */
    public void getScanArchive() {
        if (StringUtils.isBlank(idsKey)) {
            logger.error("扫描的id不能为空");
        } else {
            String field = EnvHolder.getAppEnv().get(Switch.QRCODE_FIELD_NAME);
            ArrayList<Criterion> criterions = new ArrayList<Criterion>();
            if (field == null) {
                criterions.add(Restrictions.eq("id", idsKey));
            } else {
                String[] fields = StringUtils.split(field, ";");
                String[] fieldValues = StringUtils.split(idsKey, ";");
                if (fieldValues.length == 1) {
                    criterions.add(Restrictions.eq(fields[0], idsKey));
                } else {
                    int iCnt = fields.length > fieldValues.length ? fieldValues.length : fields.length;
                    for (int i = 0; i < iCnt; i++) {
                        criterions.add(Restrictions.eq(fields[i], fieldValues[i]));
                    }
                }
            }

            Page<Archive> archivePage = archiveService.searchArchive(modelName, criterions, createOrders(new ArrayList<Order>()), start, -1);
            List<Archive> archiveList = archivePage.getItems();

            List<Map> mapList = new ArrayList<Map>();
            for (Archive archive : archiveList) {
                Map map = new HashMap();
                map.put("id", archive.getId());
                map.put("ajh", archive.getAjh() == null ? "" : archive.getAjh());
                map.put("mlh", archive.getMlh() == null ? "" : archive.getMlh());
                map.put("tm", archive.getTm() == null ? "" : archive.getTm());
                map.put("dh", archive.getDh() == null ? "" : archive.getDh());
                map.put("state", archive.getBoxId() == null ? "未组盒" : "已组盒");
                mapList.add(map);
            }
            renderJson(mapList);
        }
    }

    /**
     * 根据案卷号设置盒号，格号，柜号递增
     *
     * @param archive 需要递增的案卷
     * @return
     */
    private Archive changeArchive(Archive archive) {
        //获取最大柜号
        Integer count = archiveService.getArchivePosition();
        int cell;
        int box;
        if (count == null) {
            count = 1;
        }
        //最大柜号的最大格号
        cell = archiveService.getMaxCellId(count.toString());
        //最大柜号的最大格中的最大盒号
        box = archiveService.getMaxBox(cell, count.toString());
        //最大柜号的最大格中的最大盒号中是否存满
        cabinetSno = archive.getCabinetSno();
        cellId = archive.getCellId();
        boxId = archive.getBoxId();
        boolean lab = archiveService.isBoxFull(box, cell, count.toString());
        //如果新归档的柜号小于最大的柜号，则从最大柜号中续编下去               //新归档档案格号小于最大柜号中最大格号                  //新归档档案盒号小于最大柜号中最大格号的最大盒号
        if ((cabinetSno == null || Integer.valueOf(cabinetSno) <= count) && (cellId == null || cellId <= cell || cellId > 30) && (boxId == null || boxId <= box || boxId > 15)) {
            //最大盒号未满，则直接放入
            if (!lab) {
                archive.setCabinetSno(count + "");
                archive.setCellId(cell);
                archive.setBoxId(box);
            } else {
                //最大盒号放满，判断该格是否放满
                if (box == 12) {//最大格放满
                    //最大格放满，判断最大柜是否放满
                    if (cell == 30) {//最大柜放满
                        archive.setCellId(1);
                        archive.setCabinetSno(count + 1 + "");
                    }
                    if (cell < 30) {//最大柜未放满
                        archive.setCabinetSno(count + "");
                        archive.setCellId(cell + 1);
                    }
                    archive.setBoxId(1);
                }
                if (box < 12) {//最大格未放满
                    archive.setCellId(cell);
                    archive.setCabinetSno(count + "");
                    archive.setBoxId(box + 1);
                }
            }

        }
        return archive;
    }

    /**
     * 归档是向案卷内写入归档人及归档人id
     */
    private Archive setGdrAndGdrId(Archive archive) {
        archive.setGdr(SessionUtil.getCurrentUser().getUsername());
        archive.setGdrId(SessionUtil.getCurrentUserId());
        if (archive.getGdsj() == null) {
            archive.setGdsj(new Date());
        }
        return archive;
    }

    /**
     * 自动组盒根据案卷号范围查询案卷id
     */
    public void getPakageArchiveId() {
        ArrayList<Criterion> criterions = new ArrayList<Criterion>();
        List<Criterion> criterions1 = this.createCriterions(criterions);
        Page<Archive> page = this.searchEntity(criterions1, null);
        List<Archive> archives = page.getItems();
        List<String> ids = new ArrayList<String>();
        for (Archive archive : archives) {
            ids.add(archive.getId());
        }
        renderJson(ids);
    }

    /**
     * 归档时自动生成档号13位
     *
     * @param archive
     * @return
     */
    public Archive createDhByArchive(Archive archive) {
        String dwjc = null;
        String nd = archive.getNd();
        String modelName = archive.getModelName();
        if (nd == null) {
            DateFormat df = new SimpleDateFormat("yyyy");
            nd = df.format(new Date());
        }
        try {
            String oraganNo = null;
            List<PfOrganVo> pfOrganVoList = userService.getOrganListByUser(SessionUtil.getCurrentUserId());
            if (pfOrganVoList != null && !pfOrganVoList.isEmpty()) {
                PfOrganVo pfOrganVo = pfOrganVoList.get(0);
                oraganNo = pfOrganVo.getOraganNo();
            }
            dwdm = oraganNo;
            if (dwdm != null) {
                List<Item> items = this.dictService.getItems("dwjc");
                for (Item item : items) {
                    String value = item.getValue();
                    if (value.equals(dwdm)) {
                        dwjc = item.getName();
                        break;
                    }
                }
                StringBuilder buffer = new StringBuilder();
                buffer.append(nd).append(dwjc);
                buffer.append(modelName.toUpperCase());
                String newDh = buffer.toString();
                ajh = archive.getAjh();
                int length = ajh.toString().length();
                for (int i = newDh.length(); i < 13 - length; i++) {
                    buffer.append("0");
                }
                buffer.append(ajh);
                newDh = buffer.toString();
                archive.setDh(newDh);
            } else {
                logger.error("找不到oraganNo");
            }
        } catch (Exception e) {
            logger.error("dwjc的字典项不存在", e);
        }
        return archive;
    }

    /**
     * 保存扫描获取的档案
     */
    public void scanPackageArchive() {
        String[] ids = idsKey.split(",");
        for (int i = 0; i < ids.length; i++) {
            Archive archive = archiveService.getArchive(modelName, ids[i]);
            //boxId为整型，需去除字符串中的非数字并保存
            archive.setBoxId(Integer.parseInt(sboxId.trim().replaceAll("[^0-9]", "")));
            archiveService.saveArchive(archive);
        }
    }

    /**
     * 跳转到新页面
     *
     * @return
     */
    public String scan() {
        return "scanPackage";
    }

    /**
     * 自动获取生成盒号
     * 盒号格式按照芜湖县的要求
     * 格式：H-年-流水号
     */
    public void autoGenerateBoxId() {
        String generatedBoxId = archiveService.autoGenerateBoxId();
        Map<String, String> map = new HashMap<String, String>();
        map.put(boxIdInfo, generatedBoxId);
        renderJson(map);
    }

    /**
     * 根据业务名获取它的所有的目录号
     */
    public void queryMlhByModelName() {
        List<String> mlhList = ajhRangeService.getMlhByModelName(modelName);
        Map map = new HashMap();
        map.put("list", mlhList);
        renderJson(map);
    }

    /**
     * 获取列表信息
     */
    public void doList() {
        if (ids == null) {
            return;
        }

        String id = getId();
        if (ownerModelName == null || StringUtils.isBlank(ownerModelName)) {
            return;
        }

        if (ownerModelName.contains("_jn") || "document".equals(ownerModelName)) {
            Map<String, Object> docMap = getDocumentList(id);
            renderJson(docMap);
        } else if("Loan".equals(ownerModelName)){
            Map<String, Object> archiveMap = getLoanList(id);
            renderJson(archiveMap);
        } else {
            Map<String, Object> archiveMap = getArchiveList(id);
            renderJson(archiveMap);
        }
    }

    /**
     * 获取卷内访问列表
     *
     * @param id
     * @return
     */
    private Map<String, Object> getDocumentList(String id) {
        if (id == null || StringUtils.isBlank(id)) {
            return null;
        }

        Document document = archiveService.getSimpleDocument(id);
        if (document == null) {
            return null;
        }

        Map<String, Object> docMap = new HashMap<String, Object>();
        List<Original> originals = originalService.getOriginals(document.getId());
        Map<String, Object> docNode = new HashMap<String, Object>();
        /**
         * 添加原文的list
         */
        try {
            if (originals != null && !originals.isEmpty()) {
                List<Map<String, Object>> ogList = new ArrayList<Map<String, Object>>();
                for (int i = 0; i < originals.size(); i++) {
                    Map<String, Object> ogMap = new HashMap<String, Object>();
                    Original original = originals.get(i);
                    String sFileName = original.getName();
                    String sFileType = sFileName.substring(sFileName.indexOf('.') + 1);
                    if ("JPG".equalsIgnoreCase(sFileType) || "BMP".equalsIgnoreCase(sFileType) || "PNG".equalsIgnoreCase(sFileType)) {
                        ogMap.put(isImage, true);
                    } else {
                        ogMap.put(isDoc, true);
                    }

                    ogMap.put("icon", sFileType + ".gif");
                    ogMap.put("id", original.getId());
                    ogMap.put("name", sFileName.trim());
                    ogMap.put(parentId, document.getId());
                    ogMap.put(scopeText, 0);
                    ogMap.put("size", original.getFileSize());
                    ogMap.put("type", 1);
                    ogMap.put(updateTime, original.getUpdateTime());

                    ogList.add(ogMap);
                }
                docMap.put(itemText, ogList);docNode.put(childCount, originals.size());
                docNode.put("icon", folderGif);
                docNode.put("id", document.getId());
                docNode.put("name", document.getTm().trim());
                docNode.put(modelNameInfo, document.getModelName());
                docNode.put(parentId, archiveService.getSimpleArchive(document.getArchiveId()).getId());
                docNode.put(scopeText, 0);
                docNode.put("type", 0);
                docNode.put(pageCountText, (document.getYs() == null || StringUtils.isBlank(document.getYs().toString())) ? 1 : document.getYs());

                docMap.put("node", docNode);
                docMap.put(total, originals.size());
            } else {
                docMap.put(itemText, null);docNode.put(childCount, originals.size());
                docNode.put("icon", folderGif);
                docNode.put("id", document.getId());
                docNode.put("name", document.getTm().trim());
                docNode.put(modelNameInfo, document.getModelName());
                docNode.put(parentId, archiveService.getSimpleArchive(document.getArchiveId()).getId());
                docNode.put(scopeText, 0);
                docNode.put("type", 0);
                docNode.put(pageCountText, (document.getYs() == null || StringUtils.isBlank(document.getYs().toString())) ? 1 : document.getYs());

                docMap.put("node", docNode);
                docMap.put(total, originals.size());
            }
        }catch (Exception e){
            logger.error(e.getMessage());
        }

        return docMap;
    }

    /**
     * 获取借阅原文列表
     *
     * @param id
     * @return
     */
    private Map<String, Object> getLoanList(String id) {
        if (id == null || StringUtils.isBlank(id)) {
            return null;
        }

        Loan loan = loanService.findLoanById(id);
        if (loan == null) {
            return null;
        }

        Map<String, Object> docMap = new HashMap<String, Object>();
        /**
         * 添加原文的list
         */
        List<Original> originals = originalService.getOriginals(loan.getId());
        Map<String, Object> docNode = new HashMap<String, Object>();
        try {
            if (originals != null && !originals.isEmpty()) {
                List<Map<String, Object>> ogList = new ArrayList<Map<String, Object>>();
                for (int i = 0; i < originals.size(); i++) {
                    Map<String, Object> ogMap = new HashMap<String, Object>();
                    Original original = originals.get(i);
                    String sFileName = original.getName();
                    String sFileType = sFileName.substring(sFileName.indexOf('.') + 1);
                    if ("JPG".equalsIgnoreCase(sFileType) || "BMP".equalsIgnoreCase(sFileType) || "PNG".equalsIgnoreCase(sFileType)) {
                        ogMap.put(isImage, true);
                    } else {
                        ogMap.put(isDoc, true);
                    }
                    ogMap.put("icon", sFileType + ".gif");
                    ogMap.put("id", original.getId());
                    ogMap.put("name", sFileName.trim());
                    ogMap.put(parentId, loan.getId());
                    ogMap.put(scopeText, 0);
                    ogMap.put("size", original.getFileSize());
                    ogMap.put("type", 1);
                    ogMap.put(updateTime, original.getUpdateTime());
                    ogList.add(ogMap);
                }
                docNode.put(childCount, originals.size());
                docNode.put("icon", folderGif);
                docNode.put("id", loan.getId());
                docNode.put("name", loan.getTm().trim());
                docNode.put(modelNameInfo, loan.getType());
                docNode.put(parentId, archiveService.getSimpleArchive(loan.getArchiveId()).getId());
                docNode.put(scopeText, 0);
                docNode.put("type", 0);
                docMap.put("node", docNode);
                docMap.put(total, originals.size());
                docMap.put(itemText, ogList);
            } else {
                docMap.put(itemText, null);
                docNode.put(childCount, originals.size());
                docNode.put("icon", folderGif);
                docNode.put("id", loan.getId());
                docNode.put("name", loan.getTm().trim());
                docNode.put(modelNameInfo, loan.getType());
                docNode.put(parentId, archiveService.getSimpleArchive(loan.getArchiveId()).getId());
                docNode.put(scopeText, 0);
                docNode.put("type", 0);
                docMap.put("node", docNode);
                docMap.put(total, originals.size());
            }
        }catch (Exception e){
            logger.error(e.getMessage());
        }

        return docMap;
    }

    /**
     * 获取案卷的List
     *
     * @param id
     * @return
     */
    private Map<String, Object> getArchiveList(String id) {
        if (id == null || StringUtils.isBlank(id)) {
            return null;
        }

        Archive archive = archiveService.getSimpleArchive(id);
        if (archive == null) {
            return null;
        }

        Map<String, Object> archiveMap = new HashMap<String, Object>();
        List<Map<String, Object>> itemList = new ArrayList<Map<String, Object>>();
        Map<String, Object> nodeMap = new HashMap<String, Object>();
        /**
         * 添加卷内的信息到list中
         */
        List<Document> documentList = archiveService.getArchiveDocuments(archive.getModelName(), archive.getId());
        try {
            if (documentList != null && !documentList.isEmpty()) {
                for (int i = 0; i < documentList.size(); i++) {
                    Map<String, Object> docMap = new HashMap<String, Object>();
                    Document document = documentList.get(i);
                    List<Original> originals = originalService.getOriginals(document.getId());
                    docMap.put(childCount, originals.size());
                    docMap.put("icon", folderGif);
                    docMap.put("id", document.getId());
                    docMap.put("name", document.getTm().trim());
                    docMap.put(modelNameInfo, document.getModelName());
                    docMap.put(parentId, archiveService.getSimpleArchive(document.getArchiveId()).getId());
                    docMap.put(scopeText, 0);
                    docMap.put("type", 0);
                    docMap.put(pageCountText, (document.getYs() == null || StringUtils.isBlank(document.getYs().toString())) ? 1 : document.getYs());

                    itemList.add(docMap);
                }
            }

            /**
             * 添加原文的信息到List中
             */
            List<Original> originals = originalService.getOriginals(archive.getId());
            if (originals != null && !originals.isEmpty()) {
                for (int i = 0; i < originals.size(); i++) {
                    Map<String, Object> ogMap = new HashMap<String, Object>();
                    Original original = originals.get(i);
                    String sFileName = original.getName();
                    String sFileType = sFileName.substring(sFileName.indexOf('.') + 1);
                    if ("JPG".equalsIgnoreCase(sFileType) || "BMP".equalsIgnoreCase(sFileType) || "PNG".equalsIgnoreCase(sFileType)) {
                        ogMap.put(isImage, true);
                    } else {
                        ogMap.put(isDoc, true);
                    }

                    ogMap.put("icon", sFileType + ".gif");
                    ogMap.put("id", original.getId());
                    ogMap.put("name", sFileName.trim());
                    ogMap.put(parentId, archive.getId());
                    ogMap.put(scopeText, 0);
                    ogMap.put("size", original.getFileSize());
                    ogMap.put("type", 1);
                    ogMap.put(updateTime, original.getUpdateTime());
                    itemList.add(ogMap);
                }
                archiveMap.put(itemText, itemList);

                nodeMap.put(childCount, documentList.size() + originals.size());
                nodeMap.put("icon", folderGif);
                nodeMap.put("id", archive.getId());
                nodeMap.put("name", StringUtils.isBlank(archive.getTm()) ? "所有原文" : archive.getTm().trim());
                nodeMap.put(modelNameInfo, archive.getModelName());
                nodeMap.put(parentId, -1);
                nodeMap.put(scopeText, 0);
                nodeMap.put("type", 0);
                nodeMap.put(pageCountText, (archive.getYs() == null || StringUtils.isBlank(archive.getYs().toString())) ? 1 : archive.getYs());
                archiveMap.put("node", nodeMap);

                ////添加total信息
                archiveMap.put(total, documentList.size() + originals.size());
            }else {
                archiveMap.put(itemText, itemList);
                nodeMap.put(childCount, documentList.size() + originals.size());
                nodeMap.put("icon", folderGif);
                nodeMap.put("id", archive.getId());
                nodeMap.put("name", StringUtils.isBlank(archive.getTm()) ? "所有原文" : archive.getTm().trim());
                nodeMap.put(modelNameInfo, archive.getModelName());
                nodeMap.put(parentId, -1);
                nodeMap.put(scopeText, 0);
                nodeMap.put("type", 0);
                nodeMap.put(pageCountText, (archive.getYs() == null || StringUtils.isBlank(archive.getYs().toString())) ? 1 : archive.getYs());
                archiveMap.put("node", nodeMap);

                ////添加total信息
                archiveMap.put(total, documentList.size() + originals.size());
            }
        }catch (Exception e){
            logger.error(e.getMessage());
        }

        return archiveMap;
    }

    /**
     * 查看档案流程
     */
    public void showFlow() {
        String flowValue = null;
        try {
            flowValue = dictService.getItemValue(Permission.FLOW_DICT, modelName);
            Archive archive = archiveService.getArchive(modelName, djDaId);
            String proid = archive.getId();
            if (proid != null && StringUtils.isNotBlank(proid)) {
                flowValue = flowValue + proid;
            }
        } catch (Exception e) {
            logger.error("查看档案流程失败", e);
            renderJson("查看档案流程失败");
        }
        renderJson(flowValue);
    }

    public void getUserCode(){
        String userCode = getUser().getRegionCode();
        renderJson(userCode);
    }

    /**
     * 组盒保存更新案卷的盒号
     */
    public void pakageAndSaveBox() {
        if (!archiveService.isExistBoxId(boxId, mlh, cabinetSno, sideId, cellId, modelName, nd)) {
            renderJson("操作失败！盒号" + boxId + "已被占用！");
        } else {
            ArrayList<Criterion> criterions = new ArrayList<Criterion>();
            Page<Archive> page = archiveService.searchArchive(modelName, criterions, null, 0, -1);
            List<Archive> archives = page.getItems();
            StringBuilder sb = new StringBuilder();
            for (Archive archive : archives) {
                if (archive.getBoxId() != null) {
                    renderJson("操作失败！案卷号为" + archive.getAjh() + "的案卷已经装盒！");
                    return;
                }
                sb.append("\'").append(archive.getId()).append("\'").append(",");
            }
            if (cabinetSno != null) {
                String cfwz = cabinetSno + "号密集架，第" + sideId + "列-第" + cellId + "层";
                String sbs = sb.toString();
                String idStr = sbs.substring(0, sbs.length() - 1);
                Date date = new Date();
                String hql = "update t_archive t set t.box_id = ?, t.cell_id = ?, t.side_id = ?, t.cabinet_sno = ?, t.cfwz = ?, t.sjsj = ? where t.id in (" + idStr + ")";
                archiveService.upDateArchiveByHql(hql, boxId, cellId, sideId, cabinetSno, cfwz, date);

                for (Archive archiveLog : archives) {
                    logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                            archiveLog, "package");
                    logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                            archiveLog, "bind");
                }

                renderJson("组盒成功！");
            } else {
                String sbs = sb.toString();
                String idStr = sbs.substring(0, sbs.length() - 1);
                Date date = new Date();
                String hql = "update t_archive t set t.box_id = ?, t.sjsj = ? where t.id in (" + idStr + ")";
                archiveService.upDateArchiveByHql(hql, boxId, date);

                for (Archive archiveLog : archives) {
                    logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                            archiveLog, "package");
                }

                renderJson("组盒成功！");
            }
        }
    }

    /**
     * 撤销组盒
     */
    public void removePakage() {
        if (!archiveService.isExistBoxId(boxId, mlh, cabinetSno, sideId, cellId, modelName, nd)) {
            renderJson("撤销失败！");
        } else {
            ArrayList<Criterion> criterions = new ArrayList<Criterion>();
            Page<Archive> page = archiveService.searchArchive(modelName, criterions, null, 0, -1);
            List<Archive> archives = page.getItems();
            StringBuilder sb = new StringBuilder();
            for (Archive archive : archives) {
                if (!(archive.getBoxId().equals(boxId)) && archive.getBoxId().equals(boxId)) {
                    renderJson("撤销失败！");
                    return;
                }

                sb.append("\'").append(archive.getId()).append("\'").append(",");
            }
            String sbs = sb.toString();
            String idStr = sbs.substring(0, sbs.length() - 1);
            String hql = "update t_archive t set t.box_id = null, t.cell_id = null, t.side_id = null, t.cabinet_sno = null, t.cfwz = null, t.sjsj = null where t.id in (" + idStr + ")";
            archiveService.upDateArchiveByHql(hql);

            for (Archive archiveLog : archives) {
                logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                        archiveLog, "cx-package");
            }

            renderJson("撤销成功！");
        }
    }

    /**
     * 设置存放位置
     */
    public void setCfwz() {
        String[] ids = archiveIds[0].split(",");
        List<Archive> archives = new ArrayList<Archive>();
        try {
            for (String id : ids) {
                Archive archive = archiveService.getSimpleArchive(id);
                archives.add(archive);

                if (archive.getCfwz() != null) {
                    renderJson("存在已上架的案卷，请先下架！");
                    return;
                }
            }
            //柜顺序号
            String cabinetsno = this.cabinetSno;
            //行顺序号
            cellId = this.cellId;
            //列顺序号
            boxId = this.boxId;
            //案卷数
            sideId = this.sideId;

            List<RecordAjhRange> recordAjhRanges = recordAjhRangeService.getAvailableMlh();
            sideId = sideId - 1;
            Integer n = 0;
            for (Archive archive : archives) {
                n = n + 1;
                //柜顺序号
                String cabinet = this.cabinetSno;
                //行顺序号
                Integer cell = this.getAvailableCellId(cabinet);
                //列顺序号
                Integer box = this.getAvailableBoxId(cabinet, cellId);
                //案卷数
                Integer side = this.getAvailableSideId(cabinet, cellId, boxId) - 1;
                if (!cell.equals(cellId) || !box.equals(boxId) || !side.equals(sideId)) {
                    if (n == 1) {
                        cell = cellId;
                        box = boxId;
                        side = sideId + 1;
                    } else {
                        cell = this.getAvailableCellId(cabinet);
                        box = this.getAvailableBoxId(cabinet, cell);
                        side = this.getAvailableSideId(cabinetsno, cell, box);
                    }
                } else {
                    cell = this.getAvailableCellId(cabinet);
                    box = this.getAvailableBoxId(cabinet, cell);
                    side = this.getAvailableSideId(cabinetsno, cell, box);
                }

                String cfwz = new StringBuilder(cabinetsno).append(".").append(cell).append(".").append(box).append(".").append(side).toString();
                archive.setCabinetSno(cabinetsno);
                archive.setBoxId(box);
                archive.setCellId(cell);
                archive.setCfwz(cfwz);
                archive.setSideId(side);
                archiveService.saveArchive(archive);

                //使用回收的要删除
                for (RecordAjhRange recordAjhRange : recordAjhRanges) {
                    //只要使用的是回收的就要删除
                    if (cfwz.equals(recordAjhRange.getMlh())) {
                        recordAjhRangeService.remove(recordAjhRange.getId());
                    }
                }

            }

        } catch (Exception e) {
            renderJson("设置失败！");
            return;
        }
        renderJson("设置成功！");
    }

    /**
     * 获取可用的位置
     */
    public void getAvailableWz() {
        try {
            Integer cabinetsno;
            RecordAjhRange recordAjhRange = null;

            if (this.cabinetSno != null) {
                cabinetsno = Integer.valueOf(this.cabinetSno);
            } else {
                List<RecordAjhRange> recordAjhRanges = recordAjhRangeService.getAvailableMlh();

                if (recordAjhRanges != null && !recordAjhRanges.isEmpty()) {
                    recordAjhRange = recordAjhRanges.get(0);
                }
                //先使用回收的存放位置信息
                if (recordAjhRange != null) {
                    String cfwz = recordAjhRange.getMlh();
                    String[] cfwzs = cfwz.split("\\.");

                    if (cfwzs.length >= 1) {
                        cabinetsno = Integer.valueOf(cfwzs[0]);
                        cellId = cfwzs.length >= 2 ? Integer.valueOf(cfwzs[1]) : 1;
                        boxId = cfwzs.length >= 3 ? Integer.valueOf(cfwzs[2]) : 1;
                        sideId = cfwzs.length >= 4 ? Integer.valueOf(cfwzs[3]) : 1;

                        Map<String, Object> map = new HashMap<String, Object>();
                        map.put(cabinetSnoInfo, cabinetsno);
                        map.put("sideId", sideId);
                        map.put(cellIdinfo, cellId);
                        map.put(boxIdInfo, boxId);

                        map.put("cfwz", cfwz);
                        Map<String, Object> mapMap = new HashMap();
                        mapMap.put(successInfo, true);
                        mapMap.put("data", map);
                        renderJson(mapMap);
                        return;
                    }

                    cabinetsno = Integer.valueOf(getCabinetSno());
                } else {
                    cabinetsno = Integer.valueOf(getCabinetSno());
                }
            }

            if (cabinetsno == 0) {
                cabinetsno = 1;
                boxId = 1;
                cellId = 1;
                sideId = 1;
            } else {
                cellId = this.cellId == null ? this.getAvailableCellId(cabinetsno.toString()) : this.cellId;
                boxId = this.boxId == null ? this.getAvailableBoxId(cabinetsno.toString(), cellId) : this.boxId;
                sideId = this.sideId == null ? this.getAvailableSideId(cabinetsno.toString(), cellId, boxId) : this.sideId;
            }

            Map<String, Object> map = new HashMap<String, Object>();
            map.put(cabinetSnoInfo, cabinetsno);
            map.put("sideId", sideId);
            map.put(cellIdinfo, cellId);
            map.put(boxIdInfo, boxId);
            String cfwz1 = new StringBuilder().append(cabinetsno).append(".").append(cellId).append(".").append(boxId).append(".").append(sideId).toString();
            map.put("cfwz", cfwz1);
            Map<String, Object> mapMap = new HashMap();
            mapMap.put(successInfo, true);
            mapMap.put("data", map);
            renderJson(mapMap);
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    /**
     * 档案下架
     */
    public void cancelCfwz() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.cabinetSno).append(".").append(this.cellId).append(".").append(this.boxId).append(".").append(this.sideId);
        String cfwz = sb.toString();

        if (archiveService.isExistArchiveByCfwz(cfwz)) {
            List<Archive> archives = archiveService.getArchivesByCfwz(cfwz);
            if (archives.isEmpty()) {
                return;
            }
            String hql = "update t_archive t set t.cabinet_sno = null,t.cell_id = null,t.box_id = null,t.side_id = null,t.cfwz=null,t.sjsj = null where t.cfwz = \'" + cfwz + "\'";
            archiveService.upDateArchiveByHql(hql);
            //将删除的存放位置进行回收。
            RecordAjhRange recordAjhRange = new RecordAjhRange();
            recordAjhRange.setMlh(cfwz);
            recordAjhRange.setModelName("recordeCfwz");
            recordAjhRange.setAjh(1);
            recordAjhRange.setDwdm(getDwdm());
            recordAjhRangeService.saveRecordAjh(recordAjhRange);

            for (Archive archiveLog : archives) {
                logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                        archiveLog, "cx-bind");
            }

            renderJson("下架成功");
        } else {
            renderJson("位置" + cfwz + "无档案存放！");
        }
    }

    /**
     * 获取所有可用的柜号
     */
    public void getAvailableCabinetSno() {
        try {
            List<String> cabinetSnos = new ArrayList<String>();
            List<Item> cfwzs = dictService.getItems("cfwz");
            for (Item item : cfwzs) {
                cabinetSnos.add(item.getName());
            }
            List<List> list2 = new ArrayList<List>();
            for (Object cabinetSno : cabinetSnos) {
                if (this.getAvailableCellId((String) cabinetSno) != null) {
                    List list = new ArrayList();
                    list.add(cabinetSno);
                    list2.add(list);
                }
            }

            String json = JSON.toJSONString(list2);
            Struts2Utils.renderJson(json);
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    /**
     * 获取某柜下的最大行号
     */
    public Integer getAvailableCellId(String cabinetSno) {
        Integer maxCellId = null;
        cellId = null;
        try {
            if (!StringUtils.isEmpty(cabinetSno)) {
                List<Item> items = dictService.getItems("cfwz");
                Item item = null;
                String value = null;
                for (Item item1 : items) {
                    if (item1.getName().equals(cabinetSno)) {
                        item = item1;
                        break;
                    }
                }
                if (item != null) {
                    value = item.getValue();
                }
                String[] values = null;
                if (value != null && !StringUtils.isEmpty(value)) {
                    values = value.split("\\.");
                    //字典项中11.11.20对应最大行数，最大列数，最大案卷数
                    if (values.length >= 1) {
                        maxCellId = Integer.valueOf(value.split("\\.")[0]);
                    }
                }
                if (maxCellId == null) {
                    maxCellId = 1;
                }
                for (int i = 1; i <= maxCellId; i++) {
                    Integer box = archiveService.getMaxBox(i, cabinetSno);
                    //如果改行下最大列没用完则是当前可用的
                    if(values != null && (box < Integer.valueOf(values[1]) || (box.equals(Integer.valueOf(values[1])) && archiveService.getMaxSideId(cabinetSno, box, i) < Integer.valueOf(values[2])))) {
                            cellId = i;
                            break;
                    }
                }
            }
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
        return cellId;
    }

    /**
     * 获取某柜某行下的列
     */
    public Integer getAvailableBoxId(String cabinetSno, Integer cellId) {
        Integer maxboxId = null;
        boxId = null;
        try {
            if (!StringUtils.isEmpty(cabinetSno) && cellId != null) {
                List<Item> items = dictService.getItems("cfwz");
                Item item = null;
                String value = null;

                for (Item item1 : items) {
                    if (item1.getName().equals(cabinetSno)) {
                        item = item1;
                        break;
                    }
                }
                if (item != null) {
                    value = item.getValue();
                }
                String[] values = null;
                if (!StringUtils.isEmpty(value) && value != null) {
                    //字典项中11.11.20对应最大行数，最大列数，
                    values = value.split("\\.");
                    if (values.length >= 2) {
                        maxboxId = Integer.valueOf(values[1]);
                    }
                }
                if (maxboxId == null) {
                    maxboxId = 1;
                }

                if(values != null) {
                    for (int i = 1; i <= maxboxId; i++) {
                        Integer side = archiveService.getMaxSideId(cabinetSno, i, cellId);
                        if (side < Integer.valueOf(values[2])) {
                            boxId = i;
                            break;
                        }
                    }
                }

            }
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
        return boxId;
    }

    /**
     * 获取某柜某行某列写的所有案卷数
     */
    public Integer getAvailableSideId(String cabinetSno, Integer cellId, Integer boxId) {
        try {
            Integer maxSideId = null;
            if (!StringUtils.isEmpty(cabinetSno) && cellId != null && boxId != null) {
                maxSideId = archiveService.getMaxSideId(cabinetSno, boxId, cellId);
            }
            List<Item> items = dictService.getItems("cfwz");
            Item item = null;
            String value = null;

            for (Item item1 : items) {
                if (item1.getName().equals(cabinetSno)) {
                    item = item1;
                    break;
                }
            }
            if (item != null) {
                value = item.getValue();
                String[] values = value.split("\\.");
                return maxSideId < Integer.valueOf(values[2]) ? maxSideId + 1 : maxSideId;
            }
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
        return null;
    }

    public String getCabinetSno() {
        try {
            List<String> cabinetSnos = new ArrayList<String>();
            List<Item> cfwzs = dictService.getItems("cfwz");

            for (Item item : cfwzs) {
                if (this.getAvailableCellId(item.getName()) != null) {
                    cabinetSnos.add(item.getName());
                }
            }
            return Collections.min(cabinetSnos);
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
        return null;
    }

    public void docList() {
        if (djDaId != null && !djDaId.isEmpty()) {
            Archive archive = archiveService.getArchive(modelName, djDaId);
            List<Document> documentList = archiveService.getArchiveDocuments(archive);
            renderJson(new Page<Document>(documentList));
        }else {
//            logger.error("请检查传入参数");
            renderJson("请检查传入参数");
        }
    }

    /**
     * 电子档案柜开灯
     */
    public void archiveOpen(){
        String dzdagUrl = EnvHolder.getAppEnv().get("electronicCabinet.url");
        if (StringUtils.isBlank(dzdagUrl)) {
            logger.error("electronicCabinet.url没有配置");
        }

        dzdagUrl = dzdagUrl + "/MJJ?Op=Open&DzCode=" + jgszwz;


        //解析一个来自所请求的URL的XML文档
        try {
            URL url = new URL(dzdagUrl);
            try {
                URLConnection urlConnection = url.openConnection();
                urlConnection.setConnectTimeout(30000);
                urlConnection.setReadTimeout(30000);
                HttpURLConnection httpConnection = (HttpURLConnection) urlConnection;
                int responseCode = httpConnection.getResponseCode();
                if (responseCode == HttpURLConnection.HTTP_OK) {
                    InputStream in = httpConnection.getInputStream();
                    try {
                        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder db = factory.newDocumentBuilder();
                        org.w3c.dom.Document doc = db.parse(in);
                        if (doc != null) {
                            String docS = getXmlString(doc);
                            docS = docS.replace("\n", "");
                            docS = docS.replace("\r", "");
                            renderJson(docS);
                        }
                    } catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                } else {
                    logger.error("HTTP connection response !=HTTP_OK");
                }
            } catch (IOException e) {
                logger.error(e.getMessage());
            }
        } catch (MalformedURLException e) {
            logger.error(e.getMessage());
        }
    }

    /**
     * xml转字符串
     * @param doc xml内容
     */
    public String getXmlString(org.w3c.dom.Document doc) {
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            tf.setFeature(XMLConstants.FEATURE_SECURE_PROCESSING, true);
            Transformer t = tf.newTransformer();
            t.setOutputProperty(OutputKeys.ENCODING, "UTF-8");//解决中文问题，试过用GBK不行
            t.setOutputProperty(OutputKeys.METHOD, "html");
            t.setOutputProperty(OutputKeys.VERSION, "4.0");
            t.setOutputProperty(OutputKeys.INDENT, "no");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            t.transform(new DOMSource(doc), new StreamResult(bos));
            return bos.toString();
        } catch (TransformerException e) {
            logger.error(e.getMessage());
        }
        return "";
    }

    /**
     * 生成流水号
     */
    public void generateLsh() {
        if (ArrayUtils.isNotEmpty(archiveIds) && org.apache.commons.lang.StringUtils.isNotBlank(modelName)) {
            Archive archive = archiveService.getArchive(modelName, archiveIds[0]);
            if (archive == null) {
                logger.error("没有找到案卷");
            } else {
                if (org.apache.commons.lang.StringUtils.isBlank(archive.getLsh())) {
                    try {
                        logger.info("开始生成流水号");
                        String s = archiveService.generateAndUpdateLsh(archive.getModelName(), archive);
                        logger.info("生成的流水号为:{}", s);
                    }catch (Exception e){
                        logger.error("生成的流水号错误！");
                    }
                }
            }
        }
    }

    public void resetCfwz(){
        String mothed = "AddRFIDBorrowDA";
        String cfwz = "";
        try {
            if (archiveIds != null) {
                for (String id : archiveIds) {
                    Archive archive = archiveService.getSimpleArchive(id);
                    dh = archive.getDh();
                    cfwz = gatewayService.translate(dh, mothed);
                    judgeCfwz(cfwz,id);
                }
            } else {
                entities = getEntityPage().getItems();
                for (Archive archive : entities) {
                    dh = archive.getDh();
                    String id = archive.getId();
                    cfwz = gatewayService.translate(dh, mothed);
                    judgeCfwz(cfwz,id);
                }
            }
        }catch (Exception e){
            logger.error(e.getMessage());
        }
    }
    /**
     *  连云港 判断存放位置是否更新成功
     */
    public void judgeCfwz(String cfwz,String id){
        if (cfwz == null || cfwz.equals("")){
            renderJson("获取存放位置为空");
        }else if (cfwz.equals("操作失败")){
            renderJson("获取存放位置失败");
        } else {
            String hql = "update t_archive t set t.cfwz = " + cfwz + " where t.id = " + id;
            archiveService.upDateArchiveByHql(hql);
            renderJson("获取成功");
        }
    }

    /**
     * 获取随机验证码
     */
    public void createCode() {
        String code = this.archiveService.getCode(getId());
        Struts2Utils.renderJson(code);
    }

    /*
     * 马鞍山收发文历史数据 去重插入oracle
     */
    public void getSqlServerData() {
        Page<Map<String, Object>> page;
        String esql = "select * from dbo.Archive";
        try {
            page = sqlServerService.getTransmitDate(esql);
            for (int i = 0; i < page.getItems().size(); i++) {
                Map<String, Object> map = page.getItem(i);
                String id = map.get("ID").toString();
                Archive archive1 = archiveService.getArchive("Zhda",id);
                if (archive1 == null) {
                    if (!Struts2Utils.isNull(map.get("QCRQ"))) {
                        String time = map.get("QCRQ").toString();
                        String current = "2018-06-14 00:00:00.000";
                        if (time.compareTo(current) >= 0) {
                            String s = gatewayService.getTransmitXmlData(map);
                            String ss = gatewayService.in(s);
                            logger.info(ss);
                            logger.info(map.get("ID") + "+" + map.get("TM"));
                        }
                    }else if (Struts2Utils.isNull(map.get("QCRQ"))){
                        String s = gatewayService.getTransmitXmlData(map);
                        String ss = gatewayService.in(s);
                        logger.info(ss);
                        logger.info(map.get("ID") + "+" + map.get("TM"));
                    }
                }
            }
        } catch (Exception e) {
            logger.error("导入数据错误:[{}]",e.getMessage());
        }
        renderJson("更新完成");
        logger.info("finsh:{}", new Date());
    }

    /**
     * 自动组盒根据案卷号范围查询案卷id
     */
    public void searchData() {
        ArrayList<Criterion> criterions = new ArrayList<Criterion>();

        if (!org.apache.commons.lang3.StringUtils.isEmpty(tm)) {
            criterions.add(Restrictions.eq("tm", tm));
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty(dh)) {
            criterions.add(Restrictions.eq("dh", dh));
        }
        if (!Struts2Utils.isNull(ajh)) {
            criterions.add(Restrictions.eq("ajh", ajh));
        }
        Page<Archive> page = this.searchEntity(criterions, null);

        renderJson(page);
    }
}
