package com.gtis.archive.web;

import com.gtis.archive.Constants;
import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.service.AjhRangeService;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.OriginalService;
import com.gtis.archive.util.Struts2Utils;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-7-22
 */
public class A3dAction {
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private OriginalService originalService;
    @Autowired
    private AjhRangeService ajhRangeService;

    private int start = 0;
    private int limit = Constants.DEFAULT_PAGE_SIZE;
    private String mlh;
    private String id;

    public void setStart(int start) {
        this.start = start;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String execute() {
        String modelName = ajhRangeService.getModelNameByMlh(mlh);
        if (modelName != null) {
            Struts2Utils.renderJson(archiveService.searchArchive(modelName, Collections.singletonList(Restrictions.eq("mlh", mlh)), null, start, limit));
        }
        return null;
    }

    public String archive() {
        Archive archive = archiveService.getArchive("Archive", id);
        Model model = archiveService.getArchiveModel(archive.getModelName());
        Map<String, String> metadata = new HashMap<String, String>();
        for (Field f : model.getInheritfieldsMap().values()) {
            metadata.put(f.getName(), f.getTitle());
        }
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("metadata", metadata);
        map.put("archive", archive);
        Struts2Utils.renderJson(map);
        return null;
    }

    public String doc() {
        Document doc = archiveService.getDocument("Document", id);
        Model model = archiveService.getDocumentModel(doc.getModelName());
        Map<String, String> metadata = new HashMap<String, String>();
        for (Field f : model.getInheritfieldsMap().values()) {
            metadata.put(f.getName(), f.getTitle());
        }
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("metadata", metadata);
        map.put("doc", doc);
        Struts2Utils.renderJson(map);
        return null;
    }

    public String docs() {
        List<Document> docs = archiveService.getArchiveDocuments(archiveService.getArchive("Archive", id));
        Struts2Utils.renderJson(docs);
        return null;
    }

    public String ogs() {
        Struts2Utils.renderJson(originalService.getOriginals(id));
        return null;
    }
}
