package com.gtis.archive.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;

import static sun.font.FontManager.logger;

public class NumberFormateUtil {

	public static String doubleToDoubleDotN(BigDecimal doubleValue, int n,
			boolean forceToN) {
		if (doubleValue == null) {
			return "";
		}
		return doubleToDoubleDotN(doubleValue.doubleValue(), n, forceToN, false);
	}

	/**
	 * @param doubleValue
	 *            要格式化的值
	 * @param n
	 *            保留几位小数
	 * @param forceToN
	 *            是否强制添0
	 * @param returnZero
	 *            值为零时，false返回"",true返回"0"
	 * @return
	 * @作者 王建明
	 * @创建日期 2012-9-27
	 * @创建时间 下午04:08:32
	 * @描述 ——
	 */
	public static String doubleToDoubleDotN(double doubleValue, int n,
			boolean forceToN, boolean returnZero) {
		String ret = String.valueOf(doubleValue);
		boolean isZero = doubleValue == 0.0D;
		try {
			BigDecimal b = new BigDecimal(Double.toString(doubleValue));
			BigDecimal one = new BigDecimal("1");
			double aa = b.divide(one, n, 4).doubleValue();
			StringBuilder sb = new StringBuilder();
			sb.append("###");
			if (n > 0) {
				sb.append(".");
				for (int i = 1; i <= n; ++i) {
					sb.append("#");
				}
			}

			DecimalFormat df = new DecimalFormat(sb.toString());
			String tempValue = df.format(aa);

			ret = tempValue;
			if ((forceToN) && (n > 0)) {
				if (ret.indexOf('.') < 0) {
					ret = ret + ".0";
				}
				while (ret.substring(ret.indexOf('.') + 1, ret.length()).length() < n) {
					StringBuilder strB = new StringBuilder();
					strB.append(ret).append("0");
					ret = strB.toString();
				}
			}
		} catch (Exception e) {
			ret = String.valueOf(doubleValue);
		}
		if (!(forceToN)) {
			while (ret.endsWith("0")) {
				ret = ret.substring(0, ret.length() - 1);
			}
			if (ret.endsWith(".")) {
				ret = ret.substring(0, ret.length() - 1);
			}
		}
		if ((isZero) && (!(returnZero))) {
			return "";
		}
		if ((isZero)) {
			return "0";
		}
		return ret;
	}

	public static String doubleToDoubleDot4(double doubleValue) {
		return doubleToDoubleDotN(doubleValue, 4, false, false);
	}

	public static String doubleToDoubleDot2(double doubleValue) {
		return doubleToDoubleDotN(doubleValue, 2, false, false);
	}

	public static void main(String[] aa) {

		
		String d = doubleToDoubleDotN(-56.0D, 4, false, false);
		logger.info(d);
	}

	/**
	 * @param doubleIn
	 * @return
	 * @作者 王建明
	 * @创建日期 2013-06-19
	 * @创建时间 15:31:06
	 * @描述 —— 过滤空的double类型数据
	 */
	public static Double filterNullDouble(Double doubleIn) {
		if (doubleIn == null) {
			return 0.0;
		}
		return doubleIn;
	}

	public static Integer filterNullInt(Integer intValue) {
		if (intValue == null) {
			return 0;
		}
		return intValue;
	}

	public static BigDecimal stringToBigDecimal(String inputValue) {
		if (inputValue == null) {
			return null;
		}
		inputValue = inputValue.trim();
		if (inputValue.length() == 0) {
			return null;
		}
		BigDecimal temp = null;
		try {
			temp = new BigDecimal(inputValue);
		} catch (Exception ex) {
			return null;
		}
		return temp;
	}

	public static String formatNumber(String value, Integer n) {
		if ((value == null) || ("".equals(value.trim()))) {
			return "";
		}
		return doubleToDoubleDotN(Double.parseDouble(value), n, true, true);
	}

	public static String formatNumber(double value, int n) {
		return doubleToDoubleDotN(value, n, true, true);
	}

	public static String formatNumber(String value) {
		return doubleToDoubleDotN(Double.parseDouble(value), 4, false, true);
	}

	public static String formatNumber(double value) {
		return doubleToDoubleDotN(value, 4, true, true);
	}

	public static String toNumber(double value, int n) {
		return doubleToDoubleDotN(value, n, true, false);
	}

	public static String toNumber(Double value, int n) {
		if (value == null) {
			return "";
		}
		return toNumber(value.doubleValue(), n);
	}

	public static String toNumber(Float value, int n) {
		if (value == null) {
			return "";
		}
		return toNumber(value.doubleValue(), n);
	}

	public static String toNumber(BigDecimal value, int n) {
		if (value == null) {
			return "";
		}
		return toNumber(value.doubleValue(), n);
	}

	public static String toNumber(Long value, int n) {
		if (value == null) {
			return "";
		}
		return toNumber(value.doubleValue(), n);
	}

	public static String toNumberTwoFigures(Integer value) {
		if (value == null) {
			return "";
		}
		if (value < 10 && value >= 0) {
			return "0" + value;
		}
		return String.valueOf(value);
	}
	
	/**
     * 数字金额大写转换，思想先写个完整的然后将如零拾替换成零
     * 要用到正则表达式
     */
    public static String intToChinese(BigDecimal num){
    	double n = num.doubleValue();
		String[] fraction = {"角", "分"};
		String[] digit = {"零", "壹", "贰", "叁", "肆", "伍", "陆", "柒", "捌", "玖"};
		String[][] unit = {{"万元", "万", "亿"},
				{"", "拾", "佰", "仟"}};
 		String zeroText = "(零.)+";
        String head = n < 0? "负": "";
        n = Math.abs(n);
        String s = "";
		StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < fraction.length; i++) {
        	stringBuilder.append(s).append(digit[(int)(Math.floor(n * 10 * Math.pow(10, i)) % 10)]).append(fraction[i]);
        }
        s = stringBuilder.toString().replace(zeroText, "");
        if(s.length()<1){
            s = "整";    
        }
        int integerPart = (int)Math.floor(n);
 
        for (int i = 0; i < unit[0].length && integerPart > 0; i++) {
            String p ="";
            for (int j = 0; j < unit[1].length && n > 0; j++) {
            	StringBuilder strB = new StringBuilder();
            	strB.append(digit[integerPart%10]).append(unit[1][j]).append(p);
                p = strB.toString();
                integerPart = integerPart/10;
            }
            StringBuilder strB = new StringBuilder();
			strB.append(p.replaceAll("(零.)*零$", "").replaceAll("^$", "零")).append(unit[0][i]).append(s);
            s = strB.toString();
        }
        return head + s.replaceAll("(零.)*零元", "元").replaceFirst(zeroText, "").replaceAll(zeroText, "零").replaceAll("^整$", "零元整");
    }
    
    /**
     * 两个Double数相除，并保留scale位小数
     * @param v1
     * @param v2
     * @param scale
     * @return Double
     */
    public static Double div(Double v1,Double v2,int scale){
        if(scale<0){
            throw new IllegalArgumentException(
            "The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(v1.toString());
        BigDecimal b2 = new BigDecimal(v2.toString());
        return b1.divide(b2,scale,BigDecimal.ROUND_HALF_UP).doubleValue();
    }
    
    /**
     * 两个Double数相除，返回百分比
     * @param v1
     * @param v2
     * @param scale
     * @return String
     */
    public static String getPercent(Double v1,Double v2,int scale){
    	if(scale<0){
            throw new IllegalArgumentException(
            "The scale must be a positive integer or zero");
        }
        if(v2 == 0){
            return "0.0%";
        }
        BigDecimal b1 = new BigDecimal(v1.toString());
        BigDecimal b2 = new BigDecimal(v2.toString());
        double per =  ((b1.divide(b2,scale,BigDecimal.ROUND_HALF_UP)).multiply(new BigDecimal(100)).doubleValue());
        return per + "%";
    }
    
}
