package com.gtis.archive.util;

import java.io.BufferedReader;
import java.io.Reader;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import oracle.sql.CLOB;
import oracle.sql.TIMESTAMP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @作者 王建明
 * @创建日期 2012-6-1
 * @创建时间 上午11:04:59
 * @版本号 V 1.0
 */
public class MyOracleClobJsonBeanProcessor implements JsonValueProcessor {
	private static final Logger logger = LoggerFactory.getLogger(MyOracleClobJsonBeanProcessor.class);
	@Override
	public Object processArrayValue(Object arg0, JsonConfig arg1) {
		return null;
	}

	@Override
	public Object processObjectValue(String key, Object value, JsonConfig arg2) {
		if (value == null) {
			return "";
		}
		String reString = "";
		if (value instanceof CLOB) {
			try {
				Reader is = ((CLOB) value).getCharacterStream();// 得到流
				BufferedReader br = new BufferedReader(is);
				String s = br.readLine();
				StringBuilder sb = new StringBuilder();
				while (s != null) {// 执行循环将字符串全部取出付值给StringBuffer由StringBuffer转成STRING
					sb.append(s);
					s = br.readLine();
					if (s != null) {
						sb.append("\n");
					}
				}
				reString = sb.toString();
			} catch (Exception e) {
				logger.error(e.getMessage());
			}
		}
		return reString;
	}

	/**
	 * 描述：将Clob对象转换为String对象,Blob处理方式与此相同
	 * 
	 * @author 卜祥东 2016年5月30日 上午9:12:07
	 * @param clob
	 * @return
	 * @throws Exception
	 */
	public static String oracleClob2Str(CLOB clob) throws SQLException {
		return (clob != null ? clob.getSubString(11L, (int) clob.length())
				: null);
	}

	/**
	 * 描述：将Oracle的Timestamp对象转换为String对象
	 * 
	 * @author 鞠文杰 2016年5月30日 上午10:12:07
	 * @param clob
	 * @return
	 * @throws Exception
	 */
	public static String oracleTimestamp2Str(Object obj, String formatStr)
			throws SQLException {
		if (obj != null) {
			TIMESTAMP t = (TIMESTAMP) obj;
			if (formatStr == null || "".equals(formatStr)) {
				formatStr = "yyyy-MM-dd hh:mm:ss";
			}
			Timestamp tt;
			tt = t.timestampValue();
			Date date = new Date(tt.getTime());
			SimpleDateFormat sd = new SimpleDateFormat(formatStr);
			return sd.format(date);
		} else {
			return "";
		}

	}
}
