package com.gtis.archive.util;

import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import oracle.sql.TIMESTAMP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @作者 王建明
 * @创建日期 2012-6-1
 * @创建时间 上午11:04:59
 * @版本号 V 1.0
 */
public class MyDateJsonBeanProcessor implements JsonValueProcessor {
	private static final String FORMAT = "yyyy-MM-dd";
	private static final Logger logger = LoggerFactory.getLogger(MyDateJsonBeanProcessor.class);

	public JSONObject processBean(Object bean, JsonConfig jsonConfig) {
		JSONObject jsonObject = null;
		// System.out.println("processor class name:" +
		SimpleDateFormat sdf = new SimpleDateFormat(FORMAT);
		if (bean instanceof java.util.Date) {
			bean = new Date(((java.util.Date) bean).getTime());
		}
		if (bean instanceof java.sql.Date) {
			bean = new Date(((java.sql.Date) bean).getTime());
		}
		if (bean instanceof java.sql.Timestamp) {
			bean = new Date(((java.sql.Timestamp) bean).getTime());
		}
		if (bean instanceof TIMESTAMP) {
			try {
				bean = new Date(((TIMESTAMP) bean).timestampValue().getTime());
			} catch (SQLException e) {
				logger.error(e.getMessage());
			}
		}
		if (bean instanceof Date) {
			jsonObject = new JSONObject();
			jsonObject.element("time", sdf.format(bean));
		} else {
			jsonObject = new JSONObject(true);
		}
		return jsonObject;
	}

	@Override
	public Object processArrayValue(Object arg0, JsonConfig arg1) {

		return null;
	}

	@Override
	public Object processObjectValue(String key, Object value, JsonConfig arg2) {
		if (value == null) {
			return "";
		}
		if (value instanceof java.util.Date) {
			value = new Date(((java.util.Date) value).getTime());
		}
		if (value instanceof java.sql.Date) {
			value = new Date(((java.sql.Date) value).getTime());
		}
		if (value instanceof java.sql.Timestamp) {
			value = new Date(((java.sql.Timestamp) value).getTime());
		}
		if (value instanceof TIMESTAMP) {
			try {
				value = new Date(((TIMESTAMP) value).timestampValue().getTime());
			} catch (Exception e) {
				logger.error(e.getMessage());
			}
		}
		return new SimpleDateFormat(FORMAT).format((Date) value);
	}
}
