package com.gtis.archive.service.sv;

import com.gtis.archive.core.dict.DictService;
import com.gtis.common.Page;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import java.sql.*;
import java.util.*;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

/**
 * Created by zhayw on 2015/6/5.
 */
public class SqlServerServiceImpl implements SqlServerService {
    private static final Logger logger = LoggerFactory.getLogger(SqlServerServiceImpl.class);
    private String driverName;
    private String dbUrl;
    private String dbUsername;
    private String password;

    private String pfdriver;
    private String pfUrl;
    private String pfUsername;
    private String pfPassword;

    private String transmitDriver;
    private String transmitUrl;
    private String transmitUsername;
    private String transmitPassword;

    private String oracleDriver;
    private String oracleUrl;
    private String oracleUsername;
    private String oraclePassword;

    private Connection conn = null;
    private PreparedStatement preparedStatement = null;

    @Autowired
    private DictService dictService;

    @Override
    public Map insertOpenCmd(String content, String cmd, String operator) {
        Map map = new HashMap();
//        String sql = "insert into wdCmd (operator,cmd,qh,lh,wlh,jh,ch,lwz,czsj,isDo) values (?,?,?,?,?,?,?,?,?,?)";
        String sql = "insert into wdCmd (operator,cmd,lch,kfh,qh,wqh,lh,wlh,jh,ch,lwz,czsj,isDo) values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
        String[] values = content.split("-");

        try {
            conn = getConnection();
            preparedStatement = conn.prepareStatement(sql);
            preparedStatement.setString(1, "超级用户");
            preparedStatement.setString(2, cmd);
            preparedStatement.setInt(3, 1);
            preparedStatement.setInt(4, 1);
            preparedStatement.setInt(5, Integer.parseInt(values[0]));
            preparedStatement.setInt(6, Integer.parseInt(values[0]));
            preparedStatement.setInt(7, Integer.parseInt(values[1]));
            preparedStatement.setInt(8, Integer.parseInt(values[1]));
            preparedStatement.setInt(9, Integer.parseInt(values[2]));
            preparedStatement.setInt(10, Integer.parseInt(values[3]));
            preparedStatement.setString(11, values[4]);
            preparedStatement.setTimestamp(12, new Timestamp(System.currentTimeMillis()));
            preparedStatement.setInt(13,0);

            int row = preparedStatement.executeUpdate();

            if (row>0){
                map.put("success", true);
            }else{
                map.put("success", false);
                map.put("msg", "操作失败！");
            }

            preparedStatement.close();
            conn.close();
        } catch (Exception e) {
            logger.error("jdbc error:" + e.toString());
            map.put("success", false);
            map.put("msg", "操作异常:" + e.toString());
        }finally {
            try {
                preparedStatement.close();
                conn.close();
            }catch (Exception ex) {
                logger.error(ex.getMessage());
            }
        }
        return map;
    }

    /**
     * 获取温湿度数据
     */
    @Override
    public Page<Map<String,Object>> getDate(Page<Map<String,Object>> page, String sql){
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Connection conn = null;
        // SQL语句
        String esql = "SELECT * FROM dbo.Conf_Module INNER JOIN dbo.RT_APoint ON dbo.Conf_Module.SortID = dbo.RT_APoint.ModuleID WHERE ModuleType=1 ORDER BY TM DESC";
        if(StringUtils.isNotBlank(sql)) {
            esql = "SELECT * FROM dbo.Conf_Module INNER JOIN dbo.RT_APoint ON dbo.Conf_Module.SortID = dbo.RT_APoint.ModuleID WHERE ModuleType=1 " + sql + " ORDER BY TM DESC";
        }
        try {
            // 创建Connection连接
            conn = getConnection();

            list = queryData(conn,esql);

            conn.close(); // 关闭Connection
        } catch (ClassNotFoundException e) {
            logger.error(e.getMessage());
        } catch (SQLException e) {
            logger.error(e.getMessage());
        }finally {
            try{
                if(null != conn) {
                    conn.close(); // 关闭Connection
                }
            }catch (Exception ex){
                logger.error(ex.getMessage());
            }
        }
        page.setItems(list);
        page.setTotalCount(list.size());
        return page;
    }

    /**
     * 获取案卷信息
     */
    @Override
    public Page<Map<String,Object>> getPfDate(String modelName){
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Page<Map<String,Object>> page = new Page<Map<String, Object>>();
        Connection conn = null;
        // SQL语句
        String esql = "SELECT * FROM T_" + modelName;
        try {
            // 创建Connection连接
            conn = getPfConnection();

            list = queryData(conn,esql);

            conn.close(); // 关闭Connection
        } catch (ClassNotFoundException e) {
            logger.error(e.getMessage());
        } catch (SQLException e) {
            logger.error(e.getMessage());
        }finally {
            try{
                if(null != conn) {
                    conn.close(); // 关闭Connection
                }
            }catch (Exception ex){
                logger.error(ex.getMessage());
            }
        }
        page.setItems(list);
        page.setTotalCount(list.size());
        return page;
    }

    /**
     * 马鞍山获取收发文数据sql server
     */
    public Page<Map<String,Object>> getTransmitDate(String esql){
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Page<Map<String,Object>> page = new Page<Map<String, Object>>();
        conn = null;
        try {
            // 创建Connection连接
            conn = getTransmitConnection();
            list = queryData(conn,esql);
        } catch (ClassNotFoundException e) {
            logger.error(e.getMessage());
        } catch (SQLException e) {
            logger.error(e.getMessage());
        }finally {
            try{
                if(null != conn) {
                    conn.close(); // 关闭Connection
                }
            }catch (Exception ex){
                logger.error(ex.getMessage());
            }
        }
        page.setItems(list);
        page.setTotalCount(list.size());
        return page;
    }

    /**
     * 获取马鞍山案卷信息oracle
     */
    public Page<Map<String,Object>> getArchiveDate(){
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Page<Map<String,Object>> page = new Page<Map<String, Object>>();
        Connection conn = null;
        // SQL语句
        String esql = "select a.id,a.tm,a.nd,b.registertime,b.wh,b.archiveorgname from t_archive a,t_archive_zhda b where a.id = b.id";
        try {
            // 创建Connection连接
            conn = getOracleConnection();
            list = queryData(conn,esql);
            conn.close(); // 关闭Connection
        } catch (ClassNotFoundException e) {
            logger.error(e.getMessage());
        } catch (SQLException e) {
            logger.error(e.getMessage());
        }finally {
            try{
                if(null != conn) {
                    conn.close(); // 关闭Connection
                }
            }catch (Exception ex){
                logger.error(ex.getMessage());
            }
        }
        page.setItems(list);
        page.setTotalCount(list.size());
        return page;
    }

    /**
     * 获取卷内信息
     */
    public Page<Map<String,Object>> getJnDate(String modelName){
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Page<Map<String,Object>> page = new Page<Map<String, Object>>();
        Connection conn = null;

        // SQL语句
        String esql = "SELECT * FROM T_" + modelName + "_jn";

        try {
            // 创建Connection连接
            conn = getPfConnection();

            list = queryData(conn,esql);

            conn.close(); // 关闭Connection
        } catch (ClassNotFoundException e) {
            logger.error(e.getMessage());
        } catch (SQLException e) {
            logger.error(e.getMessage());
        }catch (Exception e){
            logger.error(e.getMessage());
        }finally {
            try{
                if(null != conn) {
                    conn.close(); // 关闭Connection
                }
            }catch (Exception ex){
                logger.error(ex.getMessage());
            }
        }
        page.setItems(list);
        page.setTotalCount(list.size());
        return page;
    }

//    public List<Map<String, Object>> queryData(Connection con, String sql) {
//        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
//        ResultSet rs = null;
//        try (Statement stmt = con.createStatement()) {
//            rs = stmt.executeQuery(sql);
//            ResultSetMetaData md = rs.getMetaData();//得到结果集(rs)的结构信息，比如字段数、字段名等
//
//            int columnCount = md.getColumnCount(); // 返回此 ResultSet 对象中的列数
//            Map<String, Object> rowData = new HashMap<String, Object>();
//            while (rs.next()) {
//                rowData = new HashMap<String, Object>(columnCount);
//                for (int i = 1; i <= columnCount; i++) {
//                    rowData.put(md.getColumnName(i), rs.getObject(i));
//                }
//                list.add(rowData);
//            }
//            return list;
//        }catch (SQLException e) {
//            logger.error("获取数据集错误：" + e.getMessage());
//        }finally {
//            try{
//                if(null != rs) {
//                    rs.close(); // 关闭Connection
//                }
//            }catch (Exception ex){
//                logger.error(ex.getMessage());
//            }
//        }
//        return list;
//    }

    public List<Map<String, Object>> queryData(Connection con, String sql) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            ResultSetMetaData md = rs.getMetaData();//得到结果集(rs)的结构信息，比如字段数、字段名等
            int columnCount = md.getColumnCount(); // 返回此 ResultSet 对象中的列数
            Map<String, Object> rowData = new HashMap<String, Object>();
            while (rs.next()) {
                rowData = new HashMap<String, Object>(columnCount);
                for (int i = 1; i <= columnCount; i++) {
                    rowData.put(md.getColumnName(i), rs.getObject(i));
                }
                list.add(rowData);
            }
            return list;

        }catch (SQLException e) {
            logger.error("获取数据集错误：" + e.getMessage());
        }finally {
            try{
                if(null != rs) {
                    rs.close(); // 关闭Connection
                }
            }catch (Exception ex){
                logger.error(ex.getMessage());
            }finally {
                try{
                    if(null != rs) {
                        rs.close(); // 关闭Connection
                    }
                }catch (Exception ex){
                    logger.error(ex.getMessage());
                }
            }
        }
        return list;
    }

    private Connection getPfConnection() throws ClassNotFoundException, SQLException {
        Class.forName(this.pfdriver);
        return DriverManager.getConnection(this.pfUrl,pfUsername,this.pfPassword);
    }

    private Connection getConnection() throws ClassNotFoundException, SQLException {
        Class.forName(this.driverName);
        return DriverManager.getConnection(this.dbUrl,dbUsername,this.password);
    }

    private Connection getTransmitConnection() throws ClassNotFoundException, SQLException {
        Class.forName(this.transmitDriver);
        return DriverManager.getConnection(this.transmitUrl,transmitUsername,this.transmitPassword);
    }

    private Connection getOracleConnection() throws ClassNotFoundException, SQLException {
        Class.forName(this.oracleDriver);
        return DriverManager.getConnection(this.oracleUrl,oracleUsername,this.oraclePassword);
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public void setDbUsername(String dbUsername) {
        this.dbUsername = dbUsername;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPfdriver() {
        return pfdriver;
    }

    public void setPfdriver(String pfdriver) {
        this.pfdriver = pfdriver;
    }

    public String getPfUrl() {
        return pfUrl;
    }

    public void setPfUrl(String pfUrl) {
        this.pfUrl = pfUrl;
    }

    public String getPfUsername() {
        return pfUsername;
    }

    public void setPfUsername(String pfUsername) {
        this.pfUsername = pfUsername;
    }

    public String getPfPassword() {
        return pfPassword;
    }

    public void setPfPassword(String pfPassword) {
        this.pfPassword = pfPassword;
    }

    public String getTransmitDriver() {
        return transmitDriver;
    }

    public void setTransmitDriver(String transmitDriver) {
        this.transmitDriver = transmitDriver;
    }

    public String getTransmitUrl() {
        return transmitUrl;
    }

    public void setTransmitUrl(String transmitUrl) {
        this.transmitUrl = transmitUrl;
    }

    public String getTransmitUsername() {
        return transmitUsername;
    }

    public void setTransmitUsername(String transmitUsername) {
        this.transmitUsername = transmitUsername;
    }

    public String getTransmitPassword() {
        return transmitPassword;
    }

    public void setTransmitPassword(String transmitPassword) {
        this.transmitPassword = transmitPassword;
    }

    public String getOracleDriver() {
        return oracleDriver;
    }

    public void setOracleDriver(String oracleDriver) {
        this.oracleDriver = oracleDriver;
    }

    public String getOracleUrl() {
        return oracleUrl;
    }

    public void setOracleUrl(String oracleUrl) {
        this.oracleUrl = oracleUrl;
    }

    public String getOracleUsername() {
        return oracleUsername;
    }

    public void setOracleUsername(String oracleUsername) {
        this.oracleUsername = oracleUsername;
    }

    public String getOraclePassword() {
        return oraclePassword;
    }

    public void setOraclePassword(String oraclePassword) {
        this.oraclePassword = oraclePassword;
    }
}
