package com.gtis.archive.service.impl;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.service.VRService;
import com.gtis.support.hibernate.HibernateDao;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.core.io.Resource;

import java.beans.PropertyDescriptor;

import java.util.*;

/**
 * .
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2015/6/29 13:45
 */
public class VRServiceImpl extends HibernateDao implements VRService {

    private static final Logger logger = LoggerFactory.getLogger(VRServiceImpl.class);

    private Resource location;

    /**
     * get vr config
     *
     * @return
     */
    @Override
    public Map getConfig() {
        try {
            return JSON.parseObject(IOUtils.toByteArray(location.getURI()), Map.class);
        } catch (Exception e) {
            logger.error("read vr config.cfg error [{}]", e.getLocalizedMessage());
            throw new VRException(e.getLocalizedMessage());
        }
    }

    /**
     * get vr rooms
     *
     * @return
     */
    @Override
    public List getRooms() {
        return (List) getConfig().get(Tag.rooms.name());
    }

    /**
     * get rooms only
     *
     * @return
     */
    @Override
    public List getRoomsOnly() {
        List<Map> rooms = getRooms();
        for (Map room : rooms) {
            if (room.containsKey(Tag.cabinets.name())) {
                room.remove(room.get(Tag.cabinets.name()));
            }
        }
        return rooms;
    }

    /**
     * 根据id查找房间
     * @param roomId
     * @return room
     */
    @Override
    public Map getRoomById(String roomId){
        List<Map> rooms = getRooms();
        for (Map room : rooms) {
            if (room.get(Tag.id.name()).equals(roomId)) {
                return room;
            }
        }
        throw new RuntimeException(" room " + roomId + " not found");
    }

    /**
     * 将list按照groupKey分组成Map<String,List>
     *
     * @param list
     * @param groupKey
     * @return 分组结果
     */
    private Map listConvertMap(List list, String groupKey) {
        assert list != null;
        assert groupKey != null;
        Map<String, List<Map>> map = new HashMap<String, List<Map>>();
        if (!list.isEmpty()) {
            for (Object obj : list) {
                Map item = new HashMap();
                if (obj instanceof Archive) {
                    copyBean(item,obj);
                } else if (obj instanceof Map) {
                    item = (Map) obj;
                }
                if (item.isEmpty() || !item.containsKey(groupKey)) {
                    continue;
                }
                String key = MapUtils.getString(item, groupKey);
                if (map.containsKey(key)) {
                    List list1 = map.get(key);
                    list1.add(item);
                    map.put(key, list1);
                } else {
                    List list2 = new ArrayList();
                    list2.add(item);
                    map.put(key, list2);
                }
            }
            return map;
        }
        return null;
    }

    /**
     * 转换对象类型
     * @param dest
     * @param src
     */
    private void copyBean(Map dest,Object src){
        assert src!=null;
        BeanWrapper beanWrapper = new BeanWrapperImpl(src);
        PropertyDescriptor[] descriptor = beanWrapper.getPropertyDescriptors();
        for (int i = 0; i < descriptor.length; i++) {
            dest.put(descriptor[i].getName(), beanWrapper.getPropertyValue(descriptor[i].getName()));
        }
    }

    /**
     * 获取柜子信息
     * @param roomId
     * @return
     */
    private String titleInfo = "title";


    /***
     * 从数据库查数据
     * @param roomId
     * @return
     */
    @Override
    public Map getRoomByIdFromDb(String roomId) {
        Map room=new HashMap();
        List<Map> rooms = getRoomsOnly();
        for (Map r : rooms) {
            if (roomId.equals(MapUtils.getString(r, "id"))) {
                room.put("id", roomId);
                room.put(titleInfo, MapUtils.getString(r, titleInfo));
                room.put("desc", MapUtils.getString(r, "desc"));
            }
        }
        return room;

    }
    private String roomIdInfo = "roomId";
    @Override
    public List getCabinetByRoomId(String roomId){
        String hql = "select cabinetSno from Archive where roomId=:roomId group by cabinetSno order by cabinetSno";
        List<Object> list = new ArrayList<Object>();
        Map map = new HashMap();
        map.put(roomIdInfo,roomId);
        try {
            list = find(hql, map);
        } catch (Exception e) {
            logger.error("查询房间信息异常！");
        }
        return list;
    }

    private String cabIdInfo = "cabId";
    private String sideIdInfo = "sideId";
    @Override
    public List cabinetsDetail(String roomId,String cabId,String sideId){
        String hql = "select max(nd),min(nd),max(ajh),min(ajh),cellId FROM Archive WHERE roomId=:roomId AND cabinetSno=:cabId and sideId=:sideId group by cellId order by cellId";
        List<Object[]> list = new ArrayList<Object[]>();
        Map map = new HashMap();
        map.put(roomIdInfo,roomId);
        map.put(cabIdInfo,cabId);
        map.put(sideIdInfo,Integer.parseInt(sideId));
        try {
            list = find(hql, map);
        } catch (Exception e) {
            logger.error("查询柜子信息异常！");
        }
        List<Map> cellList = new ArrayList<Map>();
        for(Object[] object:list){
            Map<String,String> cellMap = new HashMap<String, String>();
            cellMap.put("maxnd",object[0].toString());
            cellMap.put("minnd",object[1].toString());
            cellMap.put("maxajh",object[2].toString());
            cellMap.put("minajh",object[3].toString());
            cellMap.put("cellid",object[4].toString());
            cellList.add(cellMap);
        }
        return cellList;
    }
    private String boxIdInfo = "boxId";
    @Override
    public List cellsDetail(String roomId,String cabId,String sideId,String cellId){
        String hql = "select max(qzh),max(mlh),max(flh),max(ajh),min(ajh),max(nd),boxId FROM Archive WHERE roomId=:roomId AND cabinetSno=:cabId and sideId=:sideId and cellId=:cellId group by boxId order by boxId";
        List<Object[]> list = new ArrayList<Object[]>();
        Map map = new HashMap();
        map.put(roomIdInfo,roomId);
        map.put(cabIdInfo,cabId);
        map.put(sideIdInfo,Integer.parseInt(sideId));
        map.put("cellId",Integer.parseInt(cellId));
        try {
            list = find(hql, map);
        } catch (Exception e) {
            logger.error("查询格子信息异常！");
        }

        List<Map> boxList = new ArrayList<Map>();
        for(Object[] object:list){
            Map<String,String> boxMap = new HashMap<String, String>();
            boxMap.put("qzh",object[0].toString());
            boxMap.put("mlh",object[1].toString());
            boxMap.put("flh",object[2].toString());
            boxMap.put("maxajh",object[3].toString());
            boxMap.put("minajh",object[4].toString());
            boxMap.put("nd",object[5].toString());
            boxMap.put(boxIdInfo,object[6].toString());
            boxList.add(boxMap);
        }
        return boxList;
    }
    private String modelNameInfo = "modelName";
    @Override
    public List boxajhs(String roomId,String cabId,String sideId,String cellId,String boxId){
        String hql = "FROM Archive WHERE roomId=:roomId AND cabinetSno=:cabId and sideId=:sideId and cellId=:cellId and boxId=:boxId";
        List<Object> list = new ArrayList<Object>();
        Map map = new HashMap();
        map.put(roomIdInfo,roomId);
        map.put(cabIdInfo,cabId);
        map.put(sideIdInfo,Integer.parseInt(sideId));
        map.put("cellId",Integer.parseInt(cellId));
        map.put(boxIdInfo,Integer.parseInt(boxId));
        try {
            list = find(hql, map);
        } catch (Exception e) {
            logger.error("查询格子信息异常！");
        }
        List<Map> boxlist = new ArrayList<Map>();
        for (Object object:list){
            Archive archive = (Archive)object;
            Map boxMap = new HashMap();
            boxMap.put("mlh",archive.getMlh());
            boxMap.put("ajh",archive.getAjh());
            boxMap.put("nd",archive.getNd());
            boxMap.put(modelNameInfo,archive.getModelName());
            boxlist.add(boxMap);
        }
        return boxlist;

    }



    public void setLocation(Resource location) {
        this.location = location;
    }
}
