package com.gtis.archive.service.impl;

import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.entity.Permission;
import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.PermissionService;
import com.gtis.archive.service.ResourceService;
import com.gtis.archive.service.SecurityService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">Administrator</a>
 * @version V1.0, 2010-12-8
 */
public class SecurityServiceImpl implements SecurityService {
    protected final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private ResourceService resourceService;
    @Autowired
    private PermissionService permissionService;

    @Override
    public boolean isPermitted(String permissionString) {
        String[] arr = StringUtils.split(permissionString, ":");
        if (arr.length < 2) {
            return false;
        }
        String[] names = StringUtils.split(arr[0], ".");
        String[] operations = StringUtils.split(arr[0], ",");
        if (names.length == 0 || operations.length == 0) {
            return false;
        }
        Resource res = resourceService.getResource(null, names);
        for (String op : operations) {
            if (!permissionService.hasPermission(res.getId(), op)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isPermitted(String resourceId, String operation) {
        while (resourceId != null) {
            if (permissionService.hasPermission(resourceId, operation)) {
                return true;
            } else {
                Resource res = resourceService.getResource(resourceId);
                if (res == null) {
                    return false;
                }
                resourceId = res.getParentId();
            }
        }
        return false;
    }

    /**
     * 判断当前登录用户对资源是否拥有权限
     * @param resourceId
     * @return
     */
    @Override
    public boolean isResPermitted(String resourceId) {
        boolean b = false;
        try {
            if (permissionService.hasResPermission(resourceId)) {
                b = true;
            }
        }catch (Exception e){
            logger.error(e.getMessage());
        }
        return b;
    }

    @Override
    public Set<String> getReadableRoleIds(String resourceId) {
        Set<String> set = new HashSet<String>();
        while (resourceId != null) {
            set.addAll(permissionService.getReadableRoleIds(resourceId));
            resourceId = resourceService.getResource(resourceId).getParentId();
        }
        return set;
    }

    /**
     *  获取用户权限集合
     */
    public HashMap<String, Boolean> getUserPermMap(UserInfo user, String resId){
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        List<Permission> userPermissions = permissionService.getUserPermissions(resId, user.getId());
        for (Permission permission : userPermissions) {
            map.put(permission.getOperation(), true);
        }
        return map;
    }

    /**
     * 判断当前登录用户对资源是否拥有权限
     * @param resourceId
     * @return
     */
    public boolean isResPermittedNew(String resourceId,String operation) {
        boolean b = false;
        UserInfo userInfo = SessionUtil.getCurrentUser();
        try {
            if (userInfo.isAdmin() || permissionService.hasUserResPermission(userInfo.getId(),resourceId,operation)) {
                b = true;
            }
        }catch (Exception e){
            logger.error(e.getMessage());
        }
        return b;
    }

    public HashMap<String, Boolean> getUserPermMapTest(String user, String resId){
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        List<Permission> userPermissions = permissionService.getUserPermissions(resId, user);
        for (Permission permission : userPermissions) {
            map.put(permission.getOperation(), true);
        }
        return map;
    }
}
