package com.gtis.archive.service.impl;

import com.gtis.archive.core.EntityService;
import com.gtis.archive.entity.Archive;

import com.gtis.archive.entity.LogManager;
import com.gtis.archive.service.LogManagerService;
import com.gtis.common.Page;
import com.gtis.support.hibernate.HibernateTemplate;

import org.hibernate.criterion.Order;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;


/**
 * Created by FYS on 2017/2/7
 */
@Service
public class LogManagerServiceImpl extends HibernateTemplate<LogManager,String> implements LogManagerService {

    private static final Logger logger = LoggerFactory.getLogger(LogManagerServiceImpl.class);

    @Autowired
    protected EntityService entityService;

    /**
     * 发生操作时记录
     * @param logManager
     */
    @Override
    @Transactional
        public void saveLogManager(LogManager logManager) {
        if(logManager != null) {
            getSession().save(logManager);
        } else {
            logger.error("记录不能为空");
        }
    }



    /**
     * 保存案卷的操作日志
     * @param userId 用户ID
     * @param userName 用户姓名
     * @param archive 案卷信息
     * @param action 操作（add、edit、remove、gd、cxgd）
     */
    @Override
    @Transactional
    public void saveArchiveLogManager(String userId, String userName, Archive archive, String action){
        LogManager logManager = new LogManager();

        logManager.setUserId(userId);
        logManager.setUserName(userName);
        logManager.setOwnerId(archive.getId());
        logManager.setModelName(archive.getModelName());
        logManager.setDwdm(archive.getDwdm());
        logManager.setTm(archive.getTm());
        logManager.setQzh(archive.getQzh());
        logManager.setMlh(archive.getMlh());
        logManager.setAjh(archive.getAjh());
        logManager.setAction(action);
        logManager.setOprationTime(new Date());

        saveLogManager(logManager);
    }

    /**
     * 保存卷内的操作日志
     * @param userId 用户ID
     * @param userName 用户姓名
     * @param document 案卷信息
     * @param action 操作（add、edit、remove、gd、cxgd）
     */
    @Override
    @Transactional
    public  void saveDocumentLogManage(String userId, String userName, com.gtis.archive.entity.Document document, String action){
        LogManager logManager = new LogManager();

        logManager.setUserId(userId);
        logManager.setUserName(userName);
        logManager.setOwnerId(document.getId());
        logManager.setModelName(document.getModelName());
        logManager.setDwdm(document.getDwdm());
        logManager.setTm(document.getTm());
        logManager.setQzh(document.getQzh());
        logManager.setMlh(document.getMlh());
        logManager.setAjh(document.getAjh());
        logManager.setAction(action);
        logManager.setOprationTime(new Date());

        saveLogManager(logManager);
    }

    /**
     * 保存卷内的操作日志
     * @param userId 用户ID
     * @param userName 用户姓名
     * @param document 案卷信息
     * @param action 操作（add、edit、remove、gd、cxgd）
     */
    @Override
    @Transactional
    public void saveChapterLogManage(String userId, String userName, com.gtis.archive.entity.Chapter document, String action){
        LogManager logManager = new LogManager();

        logManager.setUserId(userId);
        logManager.setUserName(userName);
        logManager.setOwnerId(document.getId());
        logManager.setModelName(document.getModelName());
        logManager.setDwdm(document.getDwdm());
        logManager.setTm(document.getTm());
        logManager.setQzh(document.getQzh());
        logManager.setMlh(document.getMlh());
        logManager.setAjh(document.getAjh());
        logManager.setAction(action);
        logManager.setOprationTime(new Date());

        saveLogManager(logManager);
    }
    /**
     * 发生操作时记录
     */



    @Override
    public Page<LogManager> getDllRanges(int start, int limit, Order[] orders) {
        return search(start, limit, orders);
    }
}
