package com.gtis.archive.service.impl;

import com.gtis.archive.core.EntityService;
import com.gtis.archive.entity.Loan;
import com.gtis.archive.entity.LoanCart;

import com.gtis.archive.service.LoanService;
import com.gtis.common.Page;

import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * .
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 12-9-3 上午11:01
 */
@Service
public class LoanServiceImpl implements LoanService<LoanCart> {

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private EntityService entityService;

    /**
     * 添加到借阅车
     *
     * @param entity
     */
    @Override
    public void addToCart(LoanCart entity) {
        entityService.save(entity);
    }

    /**
     * 移出借阅车
     *
     * @param entity
     */
    @Override
    public void removeFromCart(LoanCart entity) {
        entityService.remove(LoanCart.class, new String[]{entity.getId()});
    }

    /**
     * 移出借阅
     *
     * @param id
     */
    @Override
    public void removeLoan(String id) {
        entityService.remove(Loan.class, new String[]{id});
    }

    /**
     * 删除借阅车中记录
     *
     * @param ids
     */
    @Override
    public void removeFromeCart(String[] ids) {
        entityService.remove(LoanCart.class, ids);
    }

    /**
     * 借阅
     *
     * @param loanCarts
     * @param loan
     */
    @Override
    public void doLoan(List<LoanCart> loanCarts, Loan loan) {
        List<Loan> loans = new ArrayList<Loan>();
        for (LoanCart loanCart : loanCarts) {
            try {
                Loan loan1 = loan.clone();
                loan1.setArchiveId(loanCart.getArchiveId());
                loan1.setState(0);
                loans.add(loan1);
                removeFromCart(loanCart);
            } catch (CloneNotSupportedException e) {
                logger.error("借阅数据拷贝异常", e.getLocalizedMessage(),e);
            }
        }
        if (loans.size() != loanCarts.size()){ return;}
        for (Loan loan1 : loans) {
            entityService.save(loan1);
        }
    }


    /**
     * 获取借阅车内所有内容
     *
     * @param start
     * @param limit
     * @param criterions
     * @return
     */
    @Override
    public Page<LoanCart> getPages(int start, int limit, List<? extends Criterion> criterions) {
        return entityService.search(LoanCart.class.getSimpleName(), criterions, null, start, limit);
    }

    /**
     * 获取所有记录条数
     *
     * @return
     */
    @Override
    public int count(List<? extends Criterion> criterions) {
        return entityService.getCount(LoanCart.class, criterions);
    }

    @Override
    public Loan findLoanById(String id) {
        return entityService.load(Loan.class, id);
    }

    @Override
    public Loan loanState(String archiveId) {
        return entityService.loadState(Loan.class, archiveId);
    }

    @Override
    public LoanCart getLoanCart(String id) {
        Criterion criterion = Restrictions.eq("id", id);
        List<Criterion> criterions = new ArrayList<Criterion>();
        criterions.add(criterion);
        Page<LoanCart> loanCartPage = entityService.search(LoanCart.class, criterions, null, 0, 20);
        List<LoanCart> loanCartList = loanCartPage.getItems();
        if (loanCartList != null && !loanCartList.isEmpty()) {
            return loanCartList.get(0);
        }

        return null;
    }

    @Override
    public List<Loan> getLoan(List<Criterion> criterions){
        Page<Loan> loanPage = entityService.search(Loan.class.getSimpleName(), criterions, null, 0, 20);
        return loanPage.getItems();
    }

    @Override
    public Page<Loan> pageLoan(int start, int limit, List<Criterion> criterions){
        return entityService.search(Loan.class.getSimpleName(), criterions, null, start, limit);
    }

    @Override
    public Integer getLoanCount(List<Criterion> criterions,String dwdm) {
        if(criterions == null) {
            criterions = new ArrayList<Criterion>();
        }
        criterions.add(Restrictions.eq("sfpz",0));
        criterions.add(Restrictions.eq("dwdm",dwdm));
        return entityService.getCount(Loan.class,criterions);
    }

    @Override
    public String viewState(String ownerId) {
        String viewS = "已归还";
        try {
            Loan loan = findLoanById(ownerId);
            Calendar calendar = new GregorianCalendar();
            calendar.setTime(loan.getJyrq());
            calendar.add(Calendar.DATE, loan.getJyqx());//把日期往后增加一天.整数往后推,负数往前移动
            Date date = calendar.getTime();//这个时间就是日期往后推一天的结果
            Date now = new Date();

            if (loan.getState() == 1) {
                viewS = "已归还";
            } else if (now.after(date)) {
                viewS = "超期";
            } else {
                viewS = "正在查阅";
            }
        }catch (Exception e){
            logger.error("查阅数据状态异常", e.getLocalizedMessage(),e);
        }

        return viewS;
    }
}
