package com.gtis.archive.service.impl;

import com.gtis.archive.Switch;
import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.entity.*;
import com.gtis.archive.service.*;
import com.gtis.archive.util.ReportCache;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.web.SessionUtil;
import com.gtis.archive.service.sv.SqlServerService;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.struts2.ServletActionContext;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.FileCopyUtils;
import javax.servlet.http.HttpServletRequest;
import java.awt.image.BufferedImage;
import java.io.*;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-9-30
 */
@Service
public class GatewayServiceImpl implements GatewayService {
    private final Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    private SysUserService userService;
    @Autowired
    private AjhRangeService ajhRangeService;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private OriginalService originalService;
    @Autowired
    private EntityService entityService;
    @Autowired
    private FileToPicService fileToPicService;
    @Autowired
    private RecordAjhRangeService recordAjhRangeService;
    @Autowired
    public ReportCache reportCache;
    @Autowired
    protected DictService dictService;
    @Autowired
    private SqlServerService sqlServerService;

    private String userId;
    private String bdcdyh;

    private String archiveText = "Archive";
    private String fieldNameText = "<field name=\"";
    private String fieldEnd = "</field>\n";
    private String endText = "\"/>\n";
    private String fieldIdStart = "<file id=\"";
    private String documentText = "Document";
    private String selectNodesText = "/list/archive";
    private String succeedInfo = "succeed";
    private String resultInfo = "result";
    private String originalText = "original";

    public AjhRangeService getAjhRangeService() {
        return ajhRangeService;
    }

    public void setAjhRangeService(AjhRangeService ajhRangeService) {
        this.ajhRangeService = ajhRangeService;
    }

    /**
     * 要转换的文件名后缀
     */
    private static List<String> extensions;
    /**
     * 可转换的文件名后缀
     */
    private static List<String> convertableExtensions;

    static {
        extensions = new ArrayList<String>();
        String s = EnvHolder.getAppEnv().get("convertToJpg");
        String[] ss = s.split(",");
        for (String extension : ss) {
            extensions.add(extension);
        }

        convertableExtensions = new ArrayList<String>(Arrays.asList("doc", "docx", "xls", "xlsx", "pdf", "ceb"));
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    private HttpClient httpClient;

    public GatewayServiceImpl() {
        HttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.getParams().setDefaultMaxConnectionsPerHost(20);
        connectionManager.getParams().setConnectionTimeout(30000);
        connectionManager.getParams().setSoTimeout(30000);
        httpClient = new HttpClient(connectionManager);
    }

    @Override
    public String in(String content) {
        logger.debug("gateway in:[\n{}\n]", content);
        org.dom4j.Document xmlDoc;
        try {
            SAXReader reader = new SAXReader();
            xmlDoc = reader.read(new StringReader(content)).getDocument();
            for (Object node : xmlDoc.selectNodes(selectNodesText)) {
                Element element = (Element) node;
                String modelName = element.attributeValue("type");
                Archive archive = saveArchive(element, modelName);
                if (archive != null) {
                    for (Object node1 : element.selectNodes("doc")) {
                        Element el = (Element) node1;
                        Document doc = saveDoc2(el, archive, modelName);
                        ////保存卷内的原文信息
                        for (Object node2 : el.selectNodes("file")) {
                            Element el2 = (Element) node2;
                            saveOriginal(el2, doc.getId(), modelName + "_jn");
                        }
                        //临时原文地址
                        for (Object node2 : element.selectNodes(originalText)) {
                            Element el2 = (Element) node2;
                            saveOriginalPath(el2, archive.getId(), modelName);
                        }
                    }
                    for (Object node1 : element.selectNodes("file")) {
                        Element el = (Element) node1;
                        saveOriginal(el, archive.getId(), modelName);
                    }
                    //档案卷内附属信息
                    for (Object node1 : element.selectNodes("archiveinfo")) {
                        Element el = (Element) node1;
                        saveArchiveInfo(el, archive.getId(), modelName);
                    }
                    //档案备考表信息
                    for (Object nodel1 : element.selectNodes("note")) {
                        Element el = (Element) nodel1;
                        saveNote(el, archive.getId());
                    }
                    //档案元数据
                    for (Object node1 : element.selectNodes("metadata")) {
                        Element el = (Element) node1;
                        saveMetadata(el, archive, modelName);
                    }
                    //临时原文地址
                    for (Object node1 : element.selectNodes(originalText)) {
                        Element el = (Element) node1;
                        saveOriginalPath(el, archive.getId(), modelName);
                    }
                }
            }
            for (Object node : xmlDoc.selectNodes("/list/doc")) {
                Element element = (Element) node;
                String modelName = element.attributeValue("type");
                Document doc = saveDoc(element, null, modelName);
                for (Object node1 : element.selectNodes("file")) {
                    Element el = (Element) node1;
                    saveOriginal(el, doc.getId(), modelName);
                }
            }
            xmlDoc.getRootElement().addAttribute(resultInfo, succeedInfo);
        } catch (Exception e) {
            xmlDoc = DocumentHelper.createDocument();
            Element result = xmlDoc.addElement("list");
            result.addAttribute(resultInfo, "fail");
            result.addAttribute("msg", e.getMessage());
        }
        String ret = xmlDoc.asXML();
        logger.debug("gateway ret:[\n{}\n]", ret);
        return ret;
    }

    @Override
    public String out(String key) {
        Archive archive = archiveService.getSimpleArchive(key);
        StringBuilder sb = new StringBuilder();
        if (archive != null) {
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            sb.append("<archive>\n");
            List<String> archiveFields = getFieldNames(archiveText);
            for (String archiveField : archiveFields) {
                try {
                    sb.append(fieldNameText + archiveField + "\">" + PropertyUtils.getProperty(archive, archiveField) + fieldEnd);
                } catch (Exception e) {
                    logger.error(e.toString());
                }
            }
            List<Original> originalList = originalService.getOriginals(archive.getId());
            for (Original original : originalList) {
                sb.append(fieldIdStart + original.getId() + endText);
            }
            List<Document> documentList = archiveService.getArchiveDocuments(archive);
            List<String> documentFields = new ArrayList<String>();
            if (!documentList.isEmpty()) {
                documentFields = getFieldNames(documentText);
            }
            for (Document document : documentList) {
                sb.append("<document>\n");
                for (String documentField : documentFields) {
                    try {
                        sb.append(fieldNameText + documentField + "\">" + PropertyUtils.getProperty(document, documentField) + fieldEnd);
                    } catch (Exception e) {
                        logger.error(e.toString());
                    }
                }
                List<Original> originals = originalService.getOriginals(document.getId());
                for (Original original : originals) {
                    sb.append(fieldIdStart + original.getId() + endText);
                }
                sb.append("</document>\n");
            }
            sb.append("</archive>");
            return sb.toString();
        }
        return null;
    }

    /**
     * 更新档案
     *
     * @param content the content of archive(before update,format the content)
     * @return
     */
    @Override
    public String update(String content) {
        logger.debug("gateway before update: [\n{}\n]", content);
        org.dom4j.Document xmlDoc;
        try {
            SAXReader reader = new SAXReader();
            xmlDoc = reader.read(new StringReader(content)).getDocument();
            for (Object node : xmlDoc.selectNodes(selectNodesText)) {
                Element element = (Element) node;
                String modelName = element.attributeValue("type");
                String id = getIdKey(element);
                Archive archive = archiveService.getArchive(modelName, id);
                if (archive == null) {
                    element.addAttribute(resultInfo, "fail");
                    element.addAttribute("msg", "未找到id=" + id + "的档案信息");
                    continue;
                }

                archiveService.saveArchive((Archive) parseXmlField2Entity(archive, element));
                //卷内
                for (Object docNode : element.selectNodes("doc")) {
                    Element doc = (Element) docNode;
                    if (StringUtils.isNotBlank(getIdKey(doc))) {
                        //更新卷内
                        String docId = getIdKey(doc);
                        Document document = archiveService.getDocument(modelName, docId);
                        parseXmlField2Entity(document, doc);
                        document = archiveService.saveDocument(document);
                        //卷内原文
                        for (Object docOg : doc.selectNodes("file")) {
                            saveOriginal((Element) docOg, document.getId(), modelName + "_jn");
                        }
                    } else {
                        //新增卷内
                        Document document =saveDoc2(doc, archive, modelName);
                        ////保存卷内的原文信息
                        for (Object node2 : doc.selectNodes("file")) {
                            Element el2 = (Element) node2;
                            saveOriginal(el2, document.getId(), modelName + "_jn");
                        }
                    }
                }
                //原文
                for (Object ogNode : element.selectNodes("file")) {
                    Element og = (Element) ogNode;
                    saveOriginal(og, archive.getId(), modelName);
                }
                element.addAttribute(resultInfo, succeedInfo);
            }

            xmlDoc.getRootElement().addAttribute(resultInfo, succeedInfo);
        } catch (Exception ex) {
            logger.error("更新档案异常【{}】", ex.getLocalizedMessage());
            xmlDoc = DocumentHelper.createDocument();
            Element result = xmlDoc.addElement("list");
            result.addAttribute(resultInfo, "fail");
            result.addAttribute("msg", ex.getMessage());
        }
        String res = xmlDoc.asXML();
        logger.debug("gateway after update: [\n{}\n]", res);
        return res;
    }

    @Override
    public String preIn(String content) {
        logger.debug("gateway in:[\n{}\n]", content);
        org.dom4j.Document xmlDoc;
        try {
            SAXReader reader = new SAXReader();
            xmlDoc = reader.read(new StringReader(content)).getDocument();
            for (Object node : xmlDoc.selectNodes(selectNodesText)) {
                Element element = (Element) node;
                String modelName = element.attributeValue("type");
                Archive archive = saveDGDArchive(element, modelName);
                if (archive != null) {
                    for (Object node1 : element.selectNodes("doc")) {
                        Element el = (Element) node1;
                        Document document = saveDoc2(el, archive, modelName);
                        ////保存卷内的原文信息
                        for (Object node2 : el.selectNodes("file")) {
                            Element el2 = (Element) node2;
                            saveOriginal(el2, document.getId(), modelName + "_jn");
                        }
                    }
                    for (Object node1 : element.selectNodes("file")) {
                        Element el = (Element) node1;
                        saveOriginal(el, archive.getId(), modelName);
                    }
                    //档案卷内附属信息
                    for (Object node1 : element.selectNodes("archiveinfo")) {
                        Element el = (Element) node1;
                        saveArchiveInfo(el, archive.getId(), modelName);
                    }
                }
            }
            for (Object node : xmlDoc.selectNodes("/list/doc")) {
                Element element = (Element) node;
                String modelName = element.attributeValue("type");
                Document doc = saveDoc(element, null, modelName);
                for (Object node1 : element.selectNodes("file")) {
                    Element el = (Element) node1;
                    saveOriginal(el, doc.getId(), modelName);
                }
            }
            xmlDoc.getRootElement().addAttribute(resultInfo, succeedInfo);
        } catch (Exception e) {
            xmlDoc = DocumentHelper.createDocument();
            Element result = xmlDoc.addElement("list");
            result.addAttribute(resultInfo, "fail");
            result.addAttribute("msg", e.getMessage());
        }
        String ret = xmlDoc.asXML();
        logger.debug("gateway ret:[\n{}\n]", ret);
        return ret;
    }
    private String ajhError = "ajh not available" ;
    @Override
    public String preDispose(String modelName, String id, String mlh) {
        Archive archive = archiveService.getArchive(modelName, id);
        if (StringUtils.isBlank(modelName) || StringUtils.isBlank(id) || archive == null) {
            return "";
        }
        if ((archive.getState() == 3 && (archive.getMlh() != null && archive.getAjh() != null)) || EnvHolder.isEnable(Switch.NOT_CHECK_AJH)) {  //撤销后重新进行处理，其案卷号和目录号都是保留的
            archive.setState(2);
            archiveService.saveArchive(archive);
        } else {
            archive.setState(2);
            RecordAjhRange recordAjhRange = recordAjhRangeService.getAvailable(mlh, modelName, archive.getDwdm());
            if (recordAjhRange != null) {
                archive.setAjh(recordAjhRange.getAjh());
                archive.setMlh(recordAjhRange.getMlh());
                archiveService.saveArchive(archive);
                recordAjhRangeService.remove(recordAjhRange.getId());
            } else {
                AjhRange ajhRange;
                if (StringUtils.isBlank(mlh)) {
                    ajhRange = getAvailAjhRange(archive, modelName);
                    if (ajhRange != null) {
                        int ajh = ajhRange.getNextValue();
                        archive.setMlh(ajhRange.getMlh());
                        archive.setAjh(ajh);
                        ajhRange.setCurrentValue(ajh);
                        archiveService.saveArchive(archive);
                        ajhRangeService.saveAjhRange(ajhRange);
                    } else {
                        logger.error(ajhError);
                    }
                } else {
                    ajhRange = ajhRangeService.getAvailableAjhRange(modelName, mlh);
                    if (ajhRange != null) {
                        int ajh = ajhRange.getNextValue();
                        archive.setMlh(ajhRange.getMlh());
                        archive.setAjh(ajh);
                        ajhRange.setCurrentValue(ajh);
                        archiveService.saveArchive(archive);
                        ajhRangeService.saveAjhRange(ajhRange);
                    } else {
                        logger.error(ajhError);
                    }
                }
            }
        }
        return null;
    }

    @Override
    public String cancelDispose(String modelName, String id) {
        Archive archive = archiveService.getArchive(modelName, id);
        if (StringUtils.isBlank(modelName) || StringUtils.isBlank(id) || archive == null) {
            return "";
        }
        RecordAjhRange recordAjhRange = new RecordAjhRange();
        recordAjhRange.setAjh(archive.getAjh());
        recordAjhRange.setMlh(archive.getMlh());
        recordAjhRange.setDwdm(archive.getDwdm());
        recordAjhRange.setModelName(archive.getModelName());
        archive.setState(3);
        archive.setAjh(null);
        archive.setMlh(null);
        archiveService.saveArchive(archive);
        recordAjhRangeService.saveRecordAjh(recordAjhRange);
        return null;
    }

    @Override
    public String dispose(String modelName, String id) {
        if (StringUtils.isBlank(modelName) || StringUtils.isBlank(id)) {
            return null;
        }
        Archive archive = archiveService.getArchive(modelName, id);
        if (archive == null) {
            return null;
        }
        if (archive.getState() == 2) {
            archive.setState(0);
            archiveService.saveArchive(archive);
        } else {
            return "改条档案记录不处于预处理状态";
        }
        return "success";
    }

    @Override
    public String out(String key, String modelName) {
        Archive archive = archiveService.getArchive(modelName, key);
        StringBuilder sb = new StringBuilder();
        if (archive != null) {
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            sb.append("<archive>\n");
            List<String> ownerFields = getFieldsName(archive);
            List<String> archiveFields = getFieldNames(archiveText);
            for (String archiveField : archiveFields) {
                try {
                    sb.append(fieldNameText + archiveField + "\">" + PropertyUtils.getProperty(archive, archiveField) + fieldEnd);
                } catch (Exception e) {
                    logger.error(e.toString());
                }
            }
            for (String ownerField : ownerFields) {
                try {
                    sb.append(fieldNameText + ownerField + "\">" + PropertyUtils.getProperty(archive, ownerField) + fieldEnd);
                } catch (Exception e) {
                    logger.error(e.toString());
                }
            }
            List<Original> originalList = originalService.getOriginals(archive.getId());
            for (Original original : originalList) {
                sb.append(fieldIdStart + original.getId() + endText);
            }
            List<Document> documentList = archiveService.getArchiveDocuments(archive);
            List<String> documentFields = new ArrayList<String>();
            List<String> ownerDocumentFields = new ArrayList<String>();
            if (!documentList.isEmpty()) {
                documentFields = getFieldNames(documentText);
                ownerDocumentFields = getFieldsName(documentList.get(0));
            }

            for (Document document : documentList) {
                sb.append("<document>\n");
                for (String documentField : documentFields) {
                    try {
                        sb.append(fieldNameText + documentField + "\">" + PropertyUtils.getProperty(document, documentField) + fieldEnd);
                    } catch (Exception e) {
                        logger.error(e.toString());
                    }
                }
                for (String ownerDocumentField : ownerDocumentFields) {
                    try {
                        sb.append(fieldNameText + ownerDocumentField + "\">" + PropertyUtils.getProperty(document, ownerDocumentField) + fieldEnd);
                    } catch (Exception e) {
                        logger.error(e.toString());
                    }
                }
                List<Original> originals = originalService.getOriginals(document.getId());
                for (Original original : originals) {
                    sb.append(fieldIdStart + original.getId() + endText);
                }
                sb.append("</document>\n");
            }
            sb.append("</archive>");
            return sb.toString();
        }
        return null;
    }

    /**
     * 删除档案信息
     * @param key  id
     * @param modelName 模型名称
     * @return
     */
    @Override
    public Boolean remove(String key, String modelName) {
        Archive archive = archiveService.getArchive(modelName, key);
        if (archive != null) {
            ////删除案卷信息
            archiveService.removeArchive(modelName, new String[]{archive.getId()});
        }

        return true;
    }
    private String fieldText2 = "field";
    private Archive saveDGDArchive(Element el, String modelName) {
        try {
            Archive archive = readArchive(el, modelName);
            archive.setDh(null);
            archive.setState(3);//****
            boolean returnId = StringUtils.isBlank(archive.getId());
            archiveService.saveArchive(archive);
            el.addAttribute(resultInfo, succeedInfo);
            if (returnId) {
                Element idField = el.addElement(fieldText2);
                idField.addAttribute("name", "id");
                idField.setText(archive.getId());
            }
            return archive;
        } catch (Exception e) {
            el.addAttribute(resultInfo, "fail");
            el.addAttribute("msg", e.getMessage());
        }

        return null;
    }


    /**
     * 获取包含id的field值
     *
     * @param element
     * @return
     */
    private String getIdKey(Element element) {
        for (Object node : element.selectNodes(fieldText2)) {
            Element el = (Element) node;
            if ("id".equals(el.attributeValue("name"))) {
                return el.getTextTrim();
            }
        }
        return null;
    }

    /**
     * 自动添加目录号值数据库
     * 佳木斯地区对于档案归档时目录号要求和老地号一致
     * 老地号： 老地号 就是 x-x-x-x  这样  然后第一位作为全宗号  中间两位 为目录号 最后一位委案卷号  整个继承为档号
     */
    private void autoInsertMlh(Archive archive) {
        if (archive.getMlh() != null) {
            List<AjhRange> ajhRanges = ajhRangeService.getAjhRangeByModelName(archive.getModelName());
            boolean isExist = false;
            for (AjhRange ajhRange : ajhRanges) {
                if (archive.getMlh() == null || ajhRange.getMlh().equals(archive.getMlh())) {
                    isExist = true;
                    break;
                }
            }

            if (!isExist) {
                AjhRange ajhRange = new AjhRange();
                ajhRange.setMaxValue(200);
                ajhRange.setMinValue(0);
                ajhRange.setCurrentValue(0);
                ajhRange.setMlh(archive.getMlh());
                ajhRange.setModelName(archive.getModelName());
                ajhRangeService.saveAjhRange(ajhRange);
            }
        }
    }

    public Archive saveArchive(Element el, String modelName) {
        try {
            Archive archive = readArchive(el, modelName);
            boolean returnId = StringUtils.isBlank(archive.getId());

            /**
             * 佳木斯档案归档之前判断档案的目录号是否存在，不存在由系统自动的插入数据
             */
            if (EnvHolder.isEnable("jiamusi.enable")) {
                autoInsertMlh(archive);
            }

            if (!EnvHolder.isEnable(Switch.NOT_CHECK_AJH)) {
                if ((archive.getAjh() == null && !EnvHolder.isEnable(Switch.ALLOW_NULL_DH)) || archive.getMlh() != null) {
                    changeAndSave(archive, modelName);
                } else {
                    archiveService.saveArchive(archive);
                }
            } else {  // NOT_CHECK_AJH为true的时候，允许字典【increaseAjh】指定的业务模型可以增加ajh
                boolean flag = false;
                List<Item> dictList = dictService.getItems("increaseAjh");
                for (Item item : dictList) {
                    if (item.getName().equalsIgnoreCase(modelName)) {
                        flag = true;
                        break;
                    }
                }

                if (flag) {
                    if ((archive.getAjh() == null && !EnvHolder.isEnable(Switch.ALLOW_NULL_DH)) || archive.getMlh() != null) {
                        changeAndSave(archive, modelName);
                    } else {
                        archiveService.saveArchive(archive);
                    }
                } else {
                    archiveService.saveArchive(archive);
                }
            }

            if (EnvHolder.isEnable("autoCreateMlh.enable") && archive.getMlh() == null) {
                AjhRange ajhRange = getAvailAjhRange(archive, modelName);
                archive.setMlh(ajhRange.getMlh());
                archiveService.saveArchive(archive);
            }

            if (EnvHolder.isEnable("isAllowNewDh")) {
                archive = createNewDh(archive);
                archiveService.saveArchive(archive);
            }

            if (EnvHolder.isEnable(Switch.CREATEDHBYMODELNAME)) {
                archive = this.createDhByArchive(archive, this.userId);
                archiveService.saveArchive(archive);
            }

            if(archive.getFlh() == null){
                String flh = resourceService.getResourceByName(modelName).getFlh();
                if(StringUtils.isNotBlank(flh)){
                    archive.setFlh(flh);
                    archiveService.saveArchive(archive);
                }
            }

            if(EnvHolder.isEnable("jinjiang.enable")){
                logger.info("开始档号重组：");
                String ajh = archive.getAjh().toString();
                String jh = "000000".substring(0, 6-ajh.length())+ajh;
                logger.info("jh[{}]" , jh);
                String fldm = "无";
                List<Item> items = dictService.getItems("fldm");
                for(Item item:items){
                    if(item.getName().equals(archive.getModelName())){
                        fldm = item.getValue();
                    }
                }

                String bgqx = archive.getBgqx();
                List<Item> bgqxitems = dictService.getItems("bgqx");
                for(Item bgqxitem:bgqxitems){
                    if(bgqxitem.getName().equals(archive.getBgqx())){
                        bgqx = bgqxitem.getValue();
                    }
                }
                String dh = archive.getQzh() + "-" + archive.getFlh() + archive.getNd() + "-" + fldm + "-" + bgqx + "-" + jh;

                if(archive.getModelName().equals("Wsda")){
                    jh = "0000".substring(0, 4-ajh.length())+ajh;
                    dh = archive.getQzh() + "-WS" + archive.getNd() + "-" + bgqx + "-" + jh;
                }
                logger.info("档号[{}]" , dh);
                archive.setDh(dh);
                PropertyUtils.setProperty(archive, "jh", jh);
                archiveService.saveArchive(archive);
            }

            el.addAttribute(resultInfo, succeedInfo);
            if (returnId) {
                Element idField = el.addElement(fieldText2);
                idField.addAttribute("name", "id");
                idField.setText(archive.getId());
            }
            if (archive.getMlh() != null) {
                Element mlhField = el.addElement(fieldText2);
                mlhField.addAttribute("name", "mlh");
                mlhField.setText(archive.getMlh());
            }
            Element ajhField = el.addElement(fieldText2);
            ajhField.addAttribute("name", "ajh");
            ajhField.setText(String.valueOf(archive.getAjh()));

            return archive;
        } catch (Exception e) {
            el.addAttribute(resultInfo, "fail");
            el.addAttribute("msg", e.getMessage());
            logger.error(e.getMessage());
        }
        return null;
    }

    /**
     * 保存档案和更新案卷号
     *
     * @param archive
     * @param modelName
     */
    private void changeAndSave(Archive archive, String modelName) {
        if (EnvHolder.isEnable(Switch.JURONG)) {
            String jnmllxValue = "";
            try {
                jnmllxValue = (String) PropertyUtils.getProperty(archive, "jnmllx");
            } catch (Exception ex) {
                logger.error(ajhError);
            }
            if (StringUtils.isBlank(jnmllxValue)) {
                AjhRange ajhRange = ajhRangeService.getAvaliableAjhRangeByJnmllx(modelName, jnmllxValue);
                if (ajhRange != null) {
                    int ajh = ajhRange.getNextValue();
                    archive.setMlh(ajhRange.getMlh());
                    archive.setAjh(ajh);
                    ajhRange.setCurrentValue(ajh);
                    archiveService.saveArchive(archive);
                    ajhRangeService.saveAjhRange(ajhRange);
                } else {
                    ajhRange = getAvailAjhRange(archive, modelName);
                    if (ajhRange != null) {
                        int ajh = ajhRange.getNextValue();
                        archive.setMlh(ajhRange.getMlh());
                        archive.setAjh(ajh);
                        ajhRange.setCurrentValue(ajh);
                        archiveService.saveArchive(archive);
                        ajhRangeService.saveAjhRange(ajhRange);
                    } else {
                        logger.error(ajhError);
                    }
                }
            } else {
                AjhRange ajhRange = getAvailAjhRange(archive, modelName);
                if (ajhRange != null) {
                    int ajh = ajhRange.getNextValue();
                    archive.setMlh(ajhRange.getMlh());
                    archive.setAjh(ajh);
                    ajhRange.setCurrentValue(ajh);
                    archiveService.saveArchive(archive);
                    ajhRangeService.saveAjhRange(ajhRange);
                } else {
                    logger.error(ajhError);
                }
            }
        } else {
            AjhRange ajhRange = getAvailAjhRange(archive, modelName);
            if (ajhRange != null) {
                archive.setMlh(ajhRange.getMlh());
                ////是否启用回收站里面的案卷号
                if (EnvHolder.isEnable(Switch.RECORD_AJH_RANGE)) {
                    RecordAjhRange recordAjhRange = recordAjhRangeService.getAvailable(ajhRange.getMlh(), archive.getModelName(), archive.getDwdm());
                    if (recordAjhRange != null) {
                        archive.setAjh(recordAjhRange.getAjh());
                        archiveService.saveArchive(archive);

                        ////删除回收站里面的案卷号
                        String id = recordAjhRangeService.removeHasUsed(archive.getMlh(), archive.getModelName(), archive.getDwdm(), archive.getAjh());
                        if (StringUtils.isNotBlank(id)) {
                            recordAjhRangeService.remove(id);
                        }
                    } else {
                        int ajh = ajhRange.getNextValue();
                        archive.setAjh(ajh);
                        ajhRange.setCurrentValue(ajh);
                        archiveService.saveArchive(archive);
                        ajhRangeService.saveAjhRange(ajhRange);
                    }
                } else {
                    int ajh = ajhRange.getNextValue();
                    archive.setAjh(ajh);
                    ajhRange.setCurrentValue(ajh);
                    archiveService.saveArchive(archive);
                    ajhRangeService.saveAjhRange(ajhRange);
                }
            } else {
                logger.error(ajhError);
            }
        }
    }

    private AjhRange getAvailAjhRange(Archive archive, String modelName) {
        Archive archiveTemp = this.archiveService.newArchive(modelName);
        if (("Bzm".equals(modelName) || "Bcf".equals(modelName) || "Bdcdyzxdj".equals(modelName)) && EnvHolder.isEnable("wujin.enable")) {
            archiveTemp.setDwdm("320412");
        } else {
            archiveTemp.setDwdm(archive.getDwdm());
        }

        String defaultDwdm = archiveService.newArchive(modelName).getDwdm();
        AjhRange ajhRange = null;
        if (StringUtils.isNotBlank(archiveTemp.getDwdm()) && StringUtils.isNotBlank(archive.getMlh())) {
            if (archiveTemp.getDwdm() == defaultDwdm) {     //如果单位代码使用的是默认值，则根据目录号获取案卷号
                ajhRange = ajhRangeService.getAvailableAjhRange(modelName, archive.getMlh());
            } else {
                ajhRange = ajhRangeService.getAvailableAjhRange(modelName, archiveTemp.getDwdm(), archive.getMlh());
            }
        } else if (StringUtils.isNotBlank(archive.getMlh())) {
            ajhRange = ajhRangeService.getAvailableAjhRange(modelName, archive.getMlh());
        } else if (StringUtils.isNotBlank(archiveTemp.getDwdm())) {
            if (archiveTemp.getDwdm() == defaultDwdm) { //如果单位代码使用的是默认值，则根据modelName获取案卷号
                ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
            } else {
                ajhRange = ajhRangeService.getAvailableAjhRangeByDwdm(modelName, archiveTemp.getDwdm());
            }
        } else {
            ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
        }
        return ajhRange;
    }

    /**
     * 解析xml中的field至对应实体类对象中
     *
     * @param entity
     * @param el
     * @return
     */
    private String zdzInfo = "字段值[{}]有误";
    private Object parseXmlField2Entity(Object entity, Element el) {
        if (entity == null) {
            return null;
        }
        for (Object node : el.selectNodes(fieldText2)) {
            Element field = (Element) node;
            String name = field.attributeValue("name");
            if (StringUtils.isBlank(name)) {
                continue;
            }
            try {
                BeanUtils.setProperty(entity, name, field.getTextTrim());
            } catch (Exception e) {
                logger.debug(e.getLocalizedMessage() + zdzInfo, name,e);
            }
        }
        return entity;
    }

    @Override
    public Archive readArchive(Element el, String modelName) {
        Archive archive = archiveService.newArchive(modelName);
        if (archive != null) {
            for (Object node : el.selectNodes(fieldText2)) {
                Element field = (Element) node;
                String name = field.attributeValue("name");
                if (!StringUtils.isBlank(name) && !StringUtils.isBlank(field.getTextTrim())) {
                    try {
                        if ("createUser".equals(name)) {
                            this.userId = field.getTextTrim();
                            continue;
                        }
                        if ("bdcdyh".equalsIgnoreCase(name)) {
                            this.bdcdyh = field.getTextTrim();
                        }
                        BeanUtils.setProperty(archive, name, field.getTextTrim());
                    } catch (Exception e) {
                        logger.debug(e.getLocalizedMessage() + zdzInfo, name,e);
                    }
                }
            }
        }

        return archive;
    }

    private Document saveDoc2(Element el, Archive archive, String modelName) {
        try {
            Document doc = readDoc(el, modelName);
            boolean returnId = StringUtils.isBlank(doc.getId());
            if (archive != null) {
                if (archive.getAjh() != null) {
                    doc.setDwdm(archive.getDwdm());
                }
                doc.setArchiveId(archive.getId());
                doc.setMlh(archive.getMlh());
                if (archive.getAjh() != null) {
                    doc.setAjh(archive.getAjh());
                }
            }
            archiveService.saveDocument(doc);
            el.addAttribute(resultInfo, succeedInfo);
            if (returnId) {
                Element idField = el.addElement(fieldText2);
                idField.addAttribute("name", "id");
                idField.setText(doc.getId());
            }
            return doc;
        } catch (Exception e) {
            el.addAttribute(resultInfo, "fail");
            el.addAttribute("msg", e.getMessage());
        }
        return null;
    }

    private Document saveDoc(Element el, String archiveId, String modelName) {
        try {
            Document doc = readDoc(el, modelName);
            boolean returnId = StringUtils.isBlank(doc.getId());
            if (archiveId != null) {
                doc.setArchiveId(archiveId);
            }
            archiveService.saveDocument(doc);
            el.addAttribute(resultInfo, succeedInfo);
            if (returnId) {
                Element idField = el.addElement(fieldText2);
                idField.addAttribute("name", "id");
                idField.setText(doc.getId());
            }
            return doc;
        } catch (Exception e) {
            el.addAttribute(resultInfo, "fail");
            el.addAttribute("msg", e.getMessage());
        }
        return null;
    }

    private Document readDoc(Element el, String modelName){
        Document entity = archiveService.newDocument(modelName);
        if (entity != null) {
            for (Object node : el.selectNodes(fieldText2)) {
                Element field = (Element) node;
                String name = field.attributeValue("name");
                if (StringUtils.isBlank(name)) {
                    continue;
                }
                try {
                    BeanUtils.setProperty(entity, name, field.getTextTrim());
                } catch (Exception e) {
                    logger.debug(e.getLocalizedMessage() + zdzInfo, name,e);
                }
            }
        }
        return entity;
    }

    private Metadata saveMetadata(Element el, Archive archive, String modelName) {
        try {
            Metadata metadata = readMetadata(el,archive.getId(), modelName);
            boolean returnId = StringUtils.isBlank(metadata.getId());
            if (archive.getId() != null) {
                metadata.setArchiveId(archive.getId());
                metadata.setRecordCode(archive.getDh());
            }
            entityService.save(metadata);
            el.addAttribute(resultInfo, succeedInfo);
            if (returnId) {
                Element idField = el.addElement(fieldText2);
                idField.addAttribute("name", "id");
                idField.setText(metadata.getId());
            }
            return metadata;
        } catch (Exception e) {
            el.addAttribute(resultInfo, "fail");
            el.addAttribute("msg", e.getMessage());
        }
        return null;
    }

    private Metadata readMetadata(Element el, String archiveId, String modelName){
        Metadata entity = (Metadata) entityService.newInstance(Metadata.class);

        if (entity != null) {
            for (Object node : el.selectNodes(fieldText2)) {
                Element field = (Element) node;
                String name = field.attributeValue("name");
                if (StringUtils.isBlank(name)) {
                    continue;
                }
                try {
                    BeanUtils.setProperty(entity, name, field.getTextTrim());
                } catch (Exception e) {
                    logger.debug(e.getLocalizedMessage() + zdzInfo, name,e);
                }
            }
        }
        return entity;
    }

    private Original saveOriginal(Element el, String ownerId, String modelName) {
        String url = el.attributeValue("url");
        String id = el.attributeValue("id");
        String status = el.attributeValue("status");
        GetMethod get = null;
        try {
            String relationId = getRelIdKey(el);
            if ((id == null || StringUtils.isBlank(id)) && (relationId != null || StringUtils.isNotBlank(relationId))) {
                ////获取原文的关联Id，如果已经存在则不需要再添加原文信息，直接用即可
                Original original = originalService.getOriginalByRelationId(relationId);
                if (original != null) {
                    original.setOwnerId(ownerId);
                    original.setOwnerModelName(modelName);
                    originalService.saveOriginalRel(original, relationId);
                    el.addAttribute(resultInfo, "success");
                    Element idField = el.addElement(fieldText2);
                    idField.addAttribute("name", "id");
                    idField.setText(original.getId());
                    return original;
                }
            }

            get = new GetMethod(url);
            if (get == null) {
                return null;
            }
            get.getParams().setHttpElementCharset("iso-8859-1");
            httpClient.executeMethod(get);
            String fileName = "";
            try {
                fileName = new String(get.getResponseHeader("Content-Disposition").getValue().getBytes("iso-8859-1"));
                fileName = fileName.substring(fileName.indexOf('\"') + 1, fileName.lastIndexOf('\"'));
            }catch (Exception e){
                String[] strings = url.split("[/=]");
                fileName = strings[strings.length-1];
                fileName = fileName + ".jpg";
            }
            if (StringUtils.isBlank(fileName)) {
                el.addAttribute(resultInfo, "fail");
                el.addAttribute("msg", "未获取到原文文件");
                logger.error("Save original error : 未获取到原文文件[{}]" ,url);
                return null;
            }
            logger.info("fileName = {}", fileName);
            String extension = fileName.substring(fileName.lastIndexOf('.') + 1);
            logger.info("extension = {}", extension);
            if (convertableExtensions.contains(extension) && extensions.contains(extension)) {
                List<Original> list = originalService.getOriginals(ownerId);
                int lastPageNum = list == null ? 0 : list.size();
                logger.info("save original lastPageNum =  {}", lastPageNum);
                convertFileToJpg(get, el, url, lastPageNum, fileName, extension, ownerId, modelName, id, status);
            } else {
                if (EnvHolder.isEnable(Switch.TAI_XING) && StringUtils.isNotBlank(modelName) && modelName.startsWith("Ydys")) {
                    Archive archive = archiveService.getArchive(modelName, ownerId);
                    String standardPrefix = archive.getQzh() + "-" + archive.getMlh() + "-0000-" + addPrefixZero(4, archive.getAjh());
                    saveUnconvertableFile(get, el, standardPrefix + "." + extension, ownerId, modelName, id, status);
                } else {
                    saveUnconvertableFile(get, el, fileName, ownerId, modelName, id, status);
                }
            }
        } catch (Exception e) {
            el.addAttribute(resultInfo, "fail");
            el.addAttribute("msg", e.getMessage());
            logger.error("Save original error", e);
        } finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
        return null;
    }

    private ArchiveInfo saveArchiveInfo(Element e, String ownerId, String modelName) {
        ArchiveInfo archiveInfo = null;
        String aiModelName = modelName.concat("_ai");
        try {
            archiveInfo = entityService.newInstance(aiModelName);
        } catch (Exception e1) {
            logger.error("实例化[{}]模型出错,检查该卷内模型是否配置！".concat(e1.getLocalizedMessage()), aiModelName);
        }
        if (archiveInfo == null) {
            return null;
        }
        archiveInfo.setArchiveId(ownerId);
        archiveInfo.setArchiveModel(modelName);
        for (Object node : e.selectNodes(fieldText2)) {
            Element field = (Element) node;
            String name = field.attributeValue("name");
            if (StringUtils.isBlank(name)) {
                continue;
            }
            try {
                BeanUtils.setProperty(archiveInfo, name, field.getTextTrim());
            } catch (Exception e1) {
                logger.debug(e1.getLocalizedMessage() + zdzInfo, name,e1);
            }
        }
        entityService.save(archiveInfo);
        return archiveInfo;
    }

    private List<String> getFieldsName(Object o) {
        Field[] fields = o.getClass().getDeclaredFields();
        ArrayList fieldsName = new ArrayList();
        for (Field field : fields) {
            if (field.getModifiers() == 2) {
                fieldsName.add(field.getName());
            }
        }
        return fieldsName;
    }

    /**
     * 根据modelName获取对象属性列表
     *
     * @param modelName
     * @return
     */
    private List<String> getFieldNames(String modelName) {
        Field[] fields;
        ArrayList fieldsName = new ArrayList();
        if (modelName == archiveText) {
            fields = Archive.class.getDeclaredFields();

        } else if (modelName == documentText) {
            fields = Document.class.getDeclaredFields();
        } else {
            return new ArrayList<String>();
        }
        for (Field field : fields) {
            if (field.getModifiers() == 2) {
                fieldsName.add(field.getName());
            }
        }
        return fieldsName;
    }

    /**
     * 归档时自动生成档号13位
     * @param archive 档案信息
     * @param userId 用户ID
     * @return
     */
    private Archive createDhByArchive(Archive archive, String userId) {
        String dwjc = null;
        String nd = archive.getNd();
        String modelName = archive.getModelName();
        if (nd == null) {
            DateFormat df = new SimpleDateFormat("yyyy");
            nd = df.format(new Date());
        }
        try {
            String oraganNo = null;
            if (userId == null || userId == "") {
                logger.error("用户Id为空");
            }
            List<PfOrganVo> pfOrganVoList = userService.getOrganListByUser(userId);
            if (pfOrganVoList != null && !pfOrganVoList.isEmpty()) {
                PfOrganVo pfOrganVo = pfOrganVoList.get(0);
                oraganNo = pfOrganVo.getOraganNo();
            }
            String dwdm = oraganNo;
            if (dwdm != null) {
                List<Item> items = this.dictService.getItems("dwjc");
                for (Item item : items) {
                    String value = item.getValue();
                    if (value.equals(dwdm)) {
                        dwjc = item.getName();
                        break;
                    }
                }
                StringBuilder buffer = new StringBuilder();
                buffer.append(nd).append(dwjc);
                buffer.append(modelName.toUpperCase());
                String newDh = buffer.toString();
                Integer ajh = archive.getAjh();
                int length = ajh.toString().length();
                for (int i = newDh.length(); i < 13 - length; i++) {
                    buffer.append("0");
                }
                buffer.append(ajh);
                newDh = buffer.toString();
                archive.setDh(newDh);
            } else {
                logger.error("找不到对应的部门简称");
            }
        } catch (Exception e) {
            logger.error("dwjc的字典项不存在", e);
        }
        return archive;
    }

    private String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
        }
        return dwdm;
    }

    /**
     * 获取包含id的field值
     *
     * @param element
     * @return
     */
    private String getRelIdKey(Element element) {
        for (Object node : element.selectNodes(fieldText2)) {
            Element el = (Element) node;
            if ("relationid".equalsIgnoreCase(el.attributeValue("name"))) {
                return el.getTextTrim();
            }
        }
        return null;
    }

    private void saveNote(Element el, String id) {
        Note note = readNote(el);
        note.setArchiveId(id);
        entityService.save(note);
    }

    private Note readNote(Element element) {
        Note entity = new Note();
        for (Object node1 : element.selectNodes(fieldText2)) {
            Element field = (Element) node1;
            String name = field.attributeValue("name");
            if (StringUtils.isBlank(name)) {
                continue;
            }
            try {
                BeanUtils.setProperty(entity, name, field.getTextTrim());
            } catch (Exception e) {
                logger.debug(e.getLocalizedMessage() + "备考表字段值[{}]有误", name,e);
            }
        }
        return entity;
    }

    public Archive createNewDh(Archive archive) {
        StringBuilder sb = new StringBuilder();
        String qzh = archive.getQzh();
        String nd = archive.getNd();
        if (StringUtils.isBlank(qzh)) {
            this.logger.error("全宗号为空");
            return archive;
        }
        if (StringUtils.isBlank(this.bdcdyh)) {
            this.logger.error("不动产单元号为空");
            return archive;
        }
        if (StringUtils.isBlank(nd)) {
            this.logger.error("年度为空");
            return archive;
        }
        String bdcdyhStr = this.bdcdyh.substring(3, 6);
        sb.append(qzh).append("-").append(nd).append("-").append(bdcdyhStr).append("-");
        String value = ((Item) this.dictService.getItems("lsh").get(0)).getValue();
        String newValue = String.valueOf(Integer.parseInt(value) + 1);
        int length = newValue.length();
        for (int i = 0; i < 7 - length; i++) {
            sb.append("0");
        }
        sb.append(newValue);
        archive.setDh(sb.toString());
        return archive;
    }

    /**
     * 将文件转换为图片
     *
     * @param get         get请求
     * @param el          xml节点
     * @param url         文件路径
     * @param lastPageNum 上一个附件的最后一个页号
     * @param fileName    文件名
     * @param extension   扩展名
     * @param ownerId     所有者的业务名
     * @param modelName   业务名
     * @param id          原文id
     * @param status      状态
     */
    private int convertFileToJpg(GetMethod get, Element el, String url, int lastPageNum, String fileName, String extension, String ownerId, String modelName, String id, String status) {
        String text1 = "docPath = {}";
        String text2 = "pageNum = {}";
        logger.info("进入转换图片方法");
        logger.info("convertFileToJpg lastPageNum = {}", lastPageNum);
        String standardPrefix = null;
        if(modelName.equals("Grjf_jn")){
            Document document = archiveService.getDocument(modelName, ownerId);
            Archive archive = archiveService.getDocumentArchive(document);
            standardPrefix = archive.getDh() + "-" + addPrefixZero(4, document.getSxh());
        }else {
            Archive archive = archiveService.getArchive(modelName, ownerId);
            standardPrefix = archive.getQzh() + "-" + archive.getMlh()
                    + "-0000-" + addPrefixZero(4, archive.getAjh());
        }
        logger.info("文件名前缀为, {}", standardPrefix);
        File baseFolder = null;
        int pageNum = 0;
        try {
            // 获取临时文件夹
            String temp = "D:\\";
            String basePath = temp + extension + "tojpg";
            baseFolder = new File(basePath);
            if (baseFolder.exists() && !baseFolder.delete()) {
                    logger.error("convertFileToJpg方法删除临时文件失败！{}" , baseFolder.getPath());
            }
            baseFolder.mkdirs();
            if (extension.equals("doc") || extension.equals("docx")) {
                // 针对泰兴的建设用地预审类档案需要将word和excel转换为pdf，并重新按照规则“全宗号-目录号-0000-案卷号（共四位，不足自动在前面补0）-页码”命名文件【王建明 2017/10/11 0011 上午 9:56】
                if (EnvHolder.isEnable(Switch.TAI_XING) && StringUtils.isNotBlank(modelName) && modelName.startsWith("Ydys")) {
                    logger.info("=============开始doc转pdf");
                    String docPath = basePath + File.separator + standardPrefix + "." + extension;
                    String pdfPath = basePath + File.separator + standardPrefix + ".pdf";
                    logger.info(text1, docPath);
                    FileCopyUtils.copy(get.getResponseBodyAsStream(), new BufferedOutputStream(new FileOutputStream(docPath)));

                    fileToPicService.wordToPdf(docPath, pdfPath);

                    File tofile = new File(basePath);
                    if (tofile.exists() && !tofile.delete()) {
                            logger.error("convertFileToJpg方法删除临时文件失败！[{}]" , tofile.getPath());
                    }
                    logger.info(text2, pageNum);
                    saveConvertedOriginalWithExtraExtension(el, basePath, status, ownerId, modelName, "pdf");
                } else {
                    logger.info("=============开始doc转图片");
                    String docPath = basePath + File.separator + fileName;
                    logger.info(text1, docPath);
                    FileCopyUtils.copy(get.getResponseBodyAsStream(), new BufferedOutputStream(new FileOutputStream(docPath)));

                    pageNum = fileToPicService.wordToJpg(docPath, basePath, standardPrefix, ownerId, modelName);
                    logger.info(text2, pageNum);
                    saveConvertedOriginal(el, basePath, status, ownerId, modelName);
                }

            } else if (extension.equals("xls") || extension.equals("xlsx")) {
                // 针对泰兴的建设用地预审类档案需要将word和excel转换为pdf，并重新按照规则“全宗号-目录号-0000-案卷号（共四位，不足自动在前面补0）-页码”命名文件【王建明 2017/10/11 0011 上午 9:56】
                if (EnvHolder.isEnable(Switch.TAI_XING) && StringUtils.isNotBlank(modelName) && modelName.startsWith("Ydys")) {
                    logger.info("=============开始excel转pdf");
                    String docPath = basePath + File.separator + standardPrefix + "." + extension;
                    String pdfPath = basePath + File.separator + standardPrefix + ".pdf";
                    logger.info(text1, docPath);
                    FileCopyUtils.copy(get.getResponseBodyAsStream(), new BufferedOutputStream(new FileOutputStream(docPath)));

                    fileToPicService.excelToPdf(docPath, pdfPath);

                    File docFile = new File(docPath);
                    if (docFile.exists() && !docFile.delete()) {
                            logger.error("convertFileToJpg方法删除临时文件失败！[{}]" , docFile.getPath());
                    }
                    logger.info(text2, pageNum);
                    saveConvertedOriginalWithExtraExtension(el, basePath, status, ownerId, modelName, "pdf");
                } else {
                    logger.info("=================开始excel转图片");
                    String xlsPath = basePath + File.separator + fileName;
                    logger.info("excelPath = {}", xlsPath);
                    FileCopyUtils.copy(get.getResponseBodyAsStream(), new BufferedOutputStream(new FileOutputStream(xlsPath)));
                    pageNum = fileToPicService.excelToJpg(xlsPath, basePath, standardPrefix, ownerId, modelName);
                    saveConvertedOriginal(el, basePath, status, ownerId, modelName);
                }
            } else if (extension.equals("pdf")) {
                // 针对泰兴的建设用地预审类档案需要将word和excel转换为pdf，并重新按照规则“全宗号-目录号-0000-案卷号（共四位，不足自动在前面补0）-页码”命名文件【王建明 2017/10/11 0011 上午 9:56】
                if (EnvHolder.isEnable(Switch.TAI_XING) && StringUtils.isNotBlank(modelName) && modelName.startsWith("Ydys")) {
                    logger.info("=============开始下载pdf");
                    String docPath = basePath + File.separator + standardPrefix + "." + extension;
                    logger.info(text1, docPath);
                    FileCopyUtils.copy(get.getResponseBodyAsStream(), new BufferedOutputStream(new FileOutputStream(docPath)));
                    logger.info(text2, pageNum);
                    saveConvertedOriginalWithExtraExtension(el, basePath, status, ownerId, modelName, "pdf");
                } else {
                    logger.info("=================开始pdf转图片");
                    String pdfPath = basePath + File.separator + fileName;
                    FileCopyUtils.copy(get.getResponseBodyAsStream(), new BufferedOutputStream(new FileOutputStream(pdfPath)));
                    pageNum = fileToPicService.pdfToJpg(pdfPath, basePath, standardPrefix, ownerId, modelName);
                    saveConvertedOriginal(el, basePath, status, ownerId, modelName);
                }
            } else if (extension.equals("ceb")) {
                logger.info("==================开始ceb转图片");
                fileToPicService.cebToJpg(fileName, url, ownerId, modelName);
            }
            logger.info(text2, pageNum);
        } catch (IOException e) {
            logger.error(e.getMessage());
        } finally {
            try {
                FileUtils.cleanDirectory(baseFolder);
            } catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
        return pageNum;
    }

    /**
     * 保存已经转换为图片的原文
     *
     * @param el        xml节点
     * @param basePath  基本路径
     * @param status    状态
     * @param ownerId   所有者id
     * @param modelName 模型名
     */
    private void saveConvertedOriginal(Element el, String basePath, String status, String ownerId, String modelName) {
        File f = new File(basePath);
        Archive archive;
        Document document = new Document();
        if(modelName.endsWith("_jn")){
            document = archiveService.getDocument(modelName, ownerId);
            archive = archiveService.getDocumentArchive(document);
        }else {
            archive = archiveService.getArchive(modelName, ownerId);
        }
        int i = 1;
        List<File> jpgs = new ArrayList<File>();
        for (File file : f.listFiles()) {
            if (file.getName().endsWith("jpg")) {
                jpgs.add(file);
            }
        }

        for (File jpg : jpgs) {
            logger.info("jpg fileName = {}", jpg.getName());
            if (i == 1 && EnvHolder.isEnable(Switch.GENERATE_ARCHIVE_INFO_TABLE)) {
                String[][] archiveInfo = {{archive.getQzh(), ("WS" + archive.getNd()), archive.getAjh().toString()},
                        {"", archive.getBgqx(), jpgs == null ? 0 + "" : jpgs.size() + ""}};
                String digitalSign = basePath + File.separator + "digitalSign.png";
                logger.info("digitalSign = {}", digitalSign);
                fileToPicService.generateTableGraphics(archiveInfo, digitalSign, 16, 168, 27);
                BufferedImage img = fileToPicService.digitalSign(jpg, new File(digitalSign), 1.0f);
                fileToPicService.generateSignFile(img, jpg.getPath());
                i++;
            }
            Original original = new Original();
            original.setName(jpg.getName());
            original.setOwnerId(ownerId);
            if (StringUtils.isBlank(status)) {
                original.setStatus(status);
            }
            originalService.saveOriginalFile(original, jpg, modelName, StringUtils.isNotBlank(original.getId()));
            originalService.saveOriginal(original);
            Element idField = el.addElement(fieldText2);
            idField.addAttribute("name", "id");
            idField.setText(original.getId());
        }
        int ys = archive.getYs() == null ? 0 : archive.getYs();
        logger.info("档案原来的页数{}", ys);
        int n = jpgs == null ? 0 : jpgs.size();
        logger.info("新增的页数{}", n);
        if(modelName.endsWith("_jn")){
            document.setYs(ys + n);
            document.setYh("1-" + document.getYs().toString());
            archive.setYs(ys + n);
        }else {
            archive.setYs(ys + n);
        }
        logger.info("新增后的页数{}", ys + n);
        archiveService.saveArchive(archive);
    }

    /**
     * @作者 王建明
     * @创建日期 2017/10/11 0011
     * @创建时间 上午 10:43
     * @描述 —— 保存所有类型的原文文件并非只存jpg格式的图片
     */
    private void saveConvertedOriginalWithExtraExtension(Element el, String basePath, String status, String ownerId, String modelName,String extension) {
        File f = new File(basePath);
        Archive archive = archiveService.getArchive(modelName, ownerId);
        List<File> files = new ArrayList<File>();
        for (File file : f.listFiles()) {
            if (file.getName().endsWith(extension)) {
                files.add(file);
            }
        }

        for (File file : files) {
            Original original = new Original();
            original.setName(file.getName());
            original.setOwnerId(archive.getId());
            if (StringUtils.isBlank(status)) {
                original.setStatus(status);
            }
            originalService.saveOriginalFile(original, file, modelName, StringUtils.isNotBlank(original.getId()));
            if(!file.delete()){
                logger.error("saveConvertedOriginalWithExtraExtension方法删除临时文件失败！[{}]" , file.getPath());
            }
            originalService.saveOriginal(original);
            Element idField = el.addElement(fieldText2);
            idField.addAttribute("name", "id");
            idField.setText(original.getId());
        }
    }

    /**
     * 保存不能转化为图片的文件
     *
     * @param get            get请求
     * @param el             xml节点
     * @param fileName       文件名
     * @param ownerId        原文拥有者id
     * @param ownerModelName 原文拥有者模型名
     * @param id             原文id
     * @param status         状态
     * @throws IOException
     */
    private void saveUnconvertableFile(GetMethod get, Element el, String fileName, String ownerId, String ownerModelName, String id, String status) throws IOException {
        Original original = new Original();
        original.setName(fileName);
        original.setOwnerId(ownerId);
        if (StringUtils.isNotBlank(id)) {
            original.setId(id);
        }

        if (StringUtils.isNotBlank(status)) {
            original.setStatus(status);
        }

        File tmpFile = File.createTempFile("archive_gw", null);
        FileCopyUtils.copy(get.getResponseBodyAsStream(), new BufferedOutputStream(new FileOutputStream(tmpFile)));
        originalService.saveOriginalFile(original, tmpFile, ownerModelName, StringUtils.isNotBlank(id));
        if(!tmpFile.delete()){
            logger.error("删除文件[{}]出错！",tmpFile.getPath());
        }
        originalService.saveOriginal(original);
        Element idField = el.addElement(fieldText2);
        idField.addAttribute("name", "id");
        idField.setText(original.getId());
    }

    /**
     * 补齐0
     *
     * @param count 位数
     * @param s     字符串
     * @return 补齐后的字符串
     */
    private String addPrefixZero(int count, String s) {
        boolean b = NumberUtils.isNumber(s);
        if (b) {
            return String.format("%0" + count + "d", Integer.parseInt(s));
        }
        return s;
    }

    /**
     * 数字补齐0
     *
     * @param count 位数
     * @param i     数字
     * @return 补齐后的字符串
     */
    private String addPrefixZero(int count, Integer i) {
        if (i == null || count <= 0) {
            return null;
        }
        return String.format("%0" + count + "d", i);
    }

    /**
     * 根据档号获取档案edit模板上的信息（连云港电子标签）
     * @param mlh 目录号
     * @param ajh 案卷号
     * @return
     */
    public java.util.Map getArchiveForEdit(String modelName,String mlh,String ajh,String nd){
        String frontList = "FrontList";
        String isSuccessful = "IsSuccessful";
        String reData = "ReData";
        String errMsg = "ErrMsg";
        logger.info("目录号:{}；案卷号:{}",mlh,ajh);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");//设置日期格式
        String newsNo = df.format(new Date());// new Date()为获取当前系统时间，也可使用当前时间戳

        java.util.Map rootItem = new HashMap();

        java.util.Map archiverootItem = new HashMap();
        List archiveChildren = new ArrayList();

        try {
            List<Criterion> criterions = new ArrayList<Criterion>();
            criterions.add(Restrictions.eq("mlh", mlh));
            criterions.add(Restrictions.eq("ajh", Integer.parseInt(ajh)));
            criterions.add(Restrictions.eq("nd", nd));
            criterions.add(Restrictions.or(Restrictions.eq("state", 0), Restrictions.eq("state",1)));
            Page<Archive> page = entityService.search(modelName,criterions,null,0,-1);

            if (page.getItems().size()>0) {
                logger.info("获取档案信息：{}，{}",page.getItem(0).getMlh(), page.getItem(0).getAjh());

                java.util.Map<String,String> map = archiveEditData(page.getItem(0));
                archiverootItem.put(frontList, map);
                archiverootItem.put(isSuccessful, "1");
                archiverootItem.put(reData, "1");
                archiverootItem.put(errMsg, "1");
                archiverootItem.put("cxbh", newsNo);
            } else {
                archiverootItem.put(isSuccessful, "1");
                archiverootItem.put(reData, "0");
                archiverootItem.put(errMsg, "1");
                archiverootItem.put("cxbh", newsNo);
                archiverootItem.put(frontList, archiveChildren);
            }
        }catch (Exception e){
            archiverootItem.put(isSuccessful, "2");
            archiverootItem.put(reData, "0");
            archiverootItem.put(errMsg, e.getMessage());
            archiverootItem.put("cxbh", "");
            archiverootItem.put(frontList, archiveChildren);
            logger.error("获取档案列表失败：{}",e.getMessage());
        }
        rootItem.put("Data",archiverootItem);

        return rootItem;
    }

    public java.util.Map<String,String> archiveEditData(Archive archive){
        java.util.Map<String,String> map = new HashMap();

        String editTemplate = archiveService.getArchiveModel(archive.getModelName()).getTemplate("editFields");
        String[] editFields = editTemplate.split(",");
        for(String filed:editFields){
            try {
                map.put(filed, PropertyUtils.getProperty(archive, filed).toString());
            }catch (Exception e){
                logger.error("获取{}属性信息失败：{}",filed,e.getMessage());
            }
        }

        return map;
    }

    public String setLoanToRFID(String dh , String mothed){
        String responseData = null;     //门禁系统反馈返回的数据
        String RFIDUrl = EnvHolder.getAppEnv().get("electronicCabinet.url");
        if (org.apache.commons.lang3.StringUtils.isBlank(RFIDUrl)) {
            logger.error("electronicCabinet.url没有配置");
        }

        String soapActionString = "http://tempuri.org/" + mothed;
        try {
            URL url = new URL(RFIDUrl);
            URLConnection urlConnection = url.openConnection();
            HttpURLConnection httpConn = (HttpURLConnection) urlConnection;
            String soap = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" +
                    "<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n" +
                    "<soap:Body>\n" +
                    "<" + mothed + " xmlns=\"http://tempuri.org/\">\n" +
                    "<dh>" + dh + "</dh>\n" +
                    "</" + mothed + ">\n" +
                    "</soap:Body>\n" +
                    "</soap:Envelope>\n";
            byte[] buf = soap.getBytes();
            logger.info(soap);
            //设置一些头参数
            String length = String.valueOf(buf.length);
            logger.info("Content-Length:{}",length);
            httpConn.setRequestProperty("Content-Length", length);
            httpConn.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
            httpConn.setRequestProperty("soapActionString", soapActionString);
            httpConn.setRequestMethod("POST");
            //输入参数和输出结果
            httpConn.setDoOutput(true);
            httpConn.setDoInput(true);
            OutputStream out = httpConn.getOutputStream();
            out.write(buf);
            out.close();
            InputStream receiveString = httpConn.getInputStream();    //获取返回数据
            StringBuilder sb = new StringBuilder();     //将InputStream转换为String
            String line;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(receiveString));
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
            }
            String back = sb.toString();      //转换完成
            logger.info(back);
            String result = back.substring(back.indexOf("<bResult>") + 10, back.indexOf("</bResult>"));
            if (result.equals("true")) {
                responseData = back.substring(back.indexOf("<szRemark>") + 11, back.indexOf("</szRemark>"));
            } else {
                responseData = "操作失败";
            }
        } catch (IOException e) {
            logger.error(e.getMessage());
        }
        return responseData;
    }

    /**
     * 连云港接收接口返回数据
     */
    public String translate(String dh,String mothed){
        String remark = "";
        //地址
        String urlString = EnvHolder.getAppEnv().get("electronicCabinet.url");
        if (org.apache.commons.lang3.StringUtils.isBlank(urlString)) {
            logger.error("electronicCabinet.url没有配置");
        }
        //方法
        String soapActionString = "http://tempuri.org/" + mothed;
        try {
            URL url = new URL(urlString);
            URLConnection urlConnection = url.openConnection();
            HttpURLConnection httpConn = (HttpURLConnection) urlConnection;
            httpConn.setDoOutput(true);
            httpConn.setDoInput(true);

            //拼接请求体,此处也可以在外面写xml文件然后读取,但是为了方便一个文件搞定,而且参数也比较好传递我们直接String拼接(直接将网页上的复制进来即可)
            String soap = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" +
                    "<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n" +
                    "<soap:Body>\n" +
                    "<" + mothed + " xmlns=\"http://tempuri.org/\">\n" +
                    "<dh>" + dh + "</dh>\n" +
                    "</" + mothed + ">\n" +
                    "</soap:Body>\n" +
                    "</soap:Envelope>\n";
            byte[] buf = soap.getBytes();
            logger.info(soap);
            //设置一些头参数
            String length = String.valueOf(buf.length);
            logger.info("Content-Length:{}",length);
            httpConn.setRequestProperty("Content-Length", length);
            httpConn.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
            httpConn.setRequestProperty("soapActionString", soapActionString);
            httpConn.setRequestMethod("POST");
            //输入参数和输出结果
            httpConn.setDoOutput(true);
            httpConn.setDoInput(true);
            int responseCode = httpConn.getResponseCode();
            logger.info("连接状态{}",responseCode);
            if (responseCode == HttpURLConnection.HTTP_OK) {  //判断是否连接成功
                InputStream receiveString = httpConn.getInputStream();    //获取返回数据
                logger.info("{}",receiveString);
                StringBuilder sb = new StringBuilder();     //将InputStream转换为String
                String line;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(receiveString,"utf-8"));
                while ((line = bufferedReader.readLine()) != null) {
                    sb.append(line);
                }
                String back = sb.toString();
                logger.info(back);
                org.dom4j.Document document = DocumentHelper.parseText(back);
                String text2= document.getRootElement().element("Body").element(mothed + "Response").element(mothed + resultInfo).elementText("bResult");
                if (text2.equals("true")) {
                    remark = document.getRootElement().element("Body").element(mothed + "Response").element(mothed + resultInfo).elementText("szRemark");
                } else {
                    remark = "操作失败";
                }
                receiveString.close();
            }else {
                logger.error("HTTP connection response !=HTTP_OK");
            }
        }catch (Exception e) {
            logger.error(e.getMessage());
        }
        return remark;
    }

    /**
     * 马鞍山收发文数据
     */
    public String getTransmitXmlData(Map<String,Object> map) {
        StringBuilder xmlnodes = new StringBuilder();
        try {
            String fieldString = "</field>\n";
            xmlnodes.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            xmlnodes.append("<list>\n");
            xmlnodes.append("<archive type='Zhda'>");
            xmlnodes.append("<field name='tm'>" + map.get("TM") + fieldString);
            xmlnodes.append("<field name='id'>" + map.get("ID") + fieldString);
            xmlnodes.append("<field name='wh'>" + map.get("WH") + fieldString);
            xmlnodes.append("<field name='bgqx'>" + map.get("BGQX") + fieldString);
            xmlnodes.append("<field name='mj'>" + map.get("MJ") + fieldString);
            xmlnodes.append("<field name='zrz'>" + map.get("DWMC") + fieldString);
            xmlnodes.append("<field name='yfrq'>" + map.get("YFRQ") + fieldString);
            xmlnodes.append("<field name='jjcd'>" + map.get("JJCD") + fieldString);
            xmlnodes.append("<field name='wz'>" + map.get("WZ") + fieldString);
            xmlnodes.append("<field name='sqrq'>" + map.get("QCRQ") + fieldString);
            xmlnodes.append("<field name='zsjg'>" + map.get("ZSJG") + fieldString);
            xmlnodes.append("<field name='csjg'>" + map.get("CSJG") + fieldString);
            xmlnodes.append("<field name='fz'>" + map.get("FZ") + fieldString);
            xmlnodes.append("<field name='gjc'>" + map.get("GJC") + fieldString);
            xmlnodes.append("<field name='ngr'>" + map.get("NGR") + fieldString);
            xmlnodes.append("<field name='ngbm'>" + map.get("NGBM") + fieldString);
            xmlnodes.append("<field name='sfgk'>" + map.get("SFGK") + fieldString);
            xmlnodes.append("<field name='wjlb'>" + map.get("WJLB") + fieldString);
            xmlnodes.append("<field name='dwdm'>" + "3405" + fieldString);
            if(!Struts2Utils.isNull(map.get("QCRQ"))){
                xmlnodes.append("<field name='nd'>" + map.get("QCRQ").toString().substring(0,4) + fieldString);
            }

            String esql = "select * from dbo.Original where Owner_ID = '" + map.get("ID").toString() + "'";
            Page<Map<String, Object>> page = sqlServerService.getTransmitDate(esql);
            if (!page.isEmpty()) {
                String parentPath = createTempFile(0);
                for (int i = 0; i < page.getItems().size(); i++) {
                    Map<String, Object> mapOriginal = page.getItem(i);
                    if (!Struts2Utils.isNull(mapOriginal.get("FILENAME"))) {
                        String path = getOriginalFile(parentPath, mapOriginal, mapOriginal.get("FILENAME").toString());
                        xmlnodes.append("<original url='" + path + "'></original>\n");
                    }
                }
            }
            xmlnodes.append("</archive>\n");
            xmlnodes.append("</list>\n");
        }catch (Exception e){
            logger.error(e.getMessage());
        }
        return xmlnodes.toString();
    }

    /**
     * 马鞍山创建原文临时文件路径
     */
    public String createTempFile(long n) throws IOException {
        HttpServletRequest request = ServletActionContext.getRequest();
        String basePath = request.getSession().getServletContext().getRealPath("/");
        File parentFile = new File(basePath + File.separator + "tmp" + File.separator + "originalFile");
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }else {
            //文件夹大于300MB 时删除
            if(FileUtils.sizeOfDirectory(parentFile) > FileUtils.ONE_MB * n) {
                FileUtils.cleanDirectory(parentFile);
            }
        }
        return parentFile.getPath() + File.separator;
    }

    /**
     * 马鞍山创建原文临时文件
     */
    @Transactional
    public String getOriginalFile(String path,Map<String,Object> map,String name) {
        Object inputStream = map.get("FILECONTENT");
        String fileName = name.substring(0,name.indexOf("."));
        String suffix = name.substring(name.lastIndexOf("."));
        BufferedOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            if (!Struts2Utils.isNull(inputStream)) {
                byte[] bo = (byte[]) inputStream;
                File dir = new File(path + name);

                int i = 1;
                while (dir.exists()){
                    name = fileName + "(" + i + ")" + suffix;
                    dir = new File(path + name);
                    i++;
                }
                path = path + name;
                if(!dir.createNewFile()){
                    logger.error("getOriginalFile创建临时文件失败！[{}]" , dir.getPath());
                    path = null;
                }
                fos = new FileOutputStream(dir,false);
                bos = new BufferedOutputStream(fos);
                bos.write(bo);
            }else{
                path = null;
            }
        } catch (Exception e) {
            logger.error(e.getMessage());
        } finally {
            if (bos != null) {
                try {
                    bos.close();
                } catch (IOException e1) {
                    logger.error(e1.getMessage());
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                } catch (IOException e1) {
                    logger.error(e1.getMessage());
                }
            }
        }
        return path;
    }

    /**
     *  保存原文路径
     * @param el
     * @param ownerId
     * @param modelName
     * @return
     */
    public Original saveOriginalPath(Element el, String ownerId, String modelName) {
        String url = el.attributeValue("url");
        String id = el.attributeValue("id");
        String status = el.attributeValue("status");
        String relationId = null;
        String temp[] = url.split("\\\\"); //split里面必须是正则表达式，"\\"的作用是对字符串转义
        String filename = temp[temp.length-1];
        List<Original> list = originalService.getOriginalByName(filename,ownerId);
        if (list != null && !list.isEmpty()){
            relationId = list.get(0).getId();
        }
        GetMethod get = null;
        try {
            if (id == null || StringUtils.isBlank(id)) {
                ////获取原文的关联Id，如果已经存在则不需要再添加原文信息，直接用即可
                if (relationId != null || StringUtils.isNotBlank(relationId)) {
                    Original original = originalService.getOriginalByRelationId(relationId);
                    if (original != null) {
                        original.setOwnerId(ownerId);
                        original.setOwnerModelName(modelName);
                        originalService.saveOriginalRel(original, relationId);

                        el.addAttribute(resultInfo, "success");
                        Element idField = el.addElement("field");
                        idField.addAttribute("name", "id");
                        idField.setText(original.getId());
                        return original;
                    }
                }
            }

            File file = new File(url);
            String fileName = file.getName();
            Original original = new Original();
            original.setName(fileName);
            original.setOwnerId(ownerId);
            if (StringUtils.isNotBlank(id)) {
                original.setId(id);
            }

            if (StringUtils.isNotBlank(status)) {
                original.setStatus(status);
            }
            logger.info(modelName + fileName);
            originalService.saveOriginalFile(original, file, modelName, false);
            List<Original> originals = originalService.getOriginalByName(fileName,ownerId);
            if(!originals.isEmpty()) {
                original.setId(originals.get(0).getId());
            }
            original = originalService.saveOriginal(original);
            ////保存原文关系信息
            originalService.saveOriginalRel(original, StringUtils.isBlank(relationId) ? original.getId() : relationId);
            Element idField = el.addElement(originalText);
            idField.addAttribute("name", "id");
            idField.setText(original.getId());
        } catch (Exception e) {
            el.addAttribute(resultInfo, "fail");
            el.addAttribute("msg", e.getMessage());
            logger.error("Save original error", e);
        } finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
        return null;
    }
}
