package com.gtis.archive.service.impl;

import com.gtis.archive.Switch;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.entity.AjhRange;
import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.AjhRangeService;
import com.gtis.archive.service.ExtTreeService;
import com.gtis.archive.service.ResourceService;
import com.gtis.archive.service.SecurityService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-9-17
 */
@Service
public class ExtTreeServiceImpl implements ExtTreeService {
    protected final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private AjhRangeService ajhRangeService;
    private List children;
    private String contentText = "content";
    private String checked = "checked";
    private String checkBox = "checkbox";
    private String childrenText = "children";
    private String expanded = "expanded";
    private String iconCls = "iconCls";
    private String nodeLeft = "node left";
    @Override
    public List<Map<String, Object>> getTree3(String resourceId) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<Resource> ress = resourceService.getChildrenResource(resourceId);
        for (Resource res : ress) {
            Map<String, Object> map = new HashMap<String, Object>();
            children = getTree3(res.getId());
            List childrenAjh = getAjhTree(res.getId(), res.getName());
            if (!EnvHolder.isEnable(Switch.isNewPermission)) {
                if (securityService.isPermitted(res.getId(), "view") || (!children.isEmpty() || !childrenAjh.isEmpty())) {
                    map.put("id", res.getId());
                    map.put("name", res.getName());
                    map.put("text", res.getTitle() == null ? res.getName() : res.getTitle());
                    map.put(contentText, res.getContent());
                    if (checkBox.equals(EnvHolder.getAppEnv().get(Switch.CLASSIFYVIEWMODE))) {
                        map.put(checked, false);
                    }
                    if (!children.isEmpty()) {
                        map.put(childrenText, children);
                        map.put(expanded, true);
                        map.put(iconCls, "node");
                    } else if (!childrenAjh.isEmpty()) {
                        map.put(childrenText, childrenAjh);
                        map.put(expanded, true);
                        map.put(iconCls, "node");
                    } else {
                        map.put("leaf", true);
                        map.put(iconCls, nodeLeft);
                    }
                    list.add(map);
                }
            }else {
                if (securityService.isResPermittedNew(res.getId(), "view") || (!children.isEmpty() || !childrenAjh.isEmpty())) {
                    map.put("id", res.getId());
                    map.put("name", res.getName());
                    map.put("text", res.getTitle() == null ? res.getName() : res.getTitle());
                    map.put(contentText, res.getContent());
                    if (checkBox.equals(EnvHolder.getAppEnv().get(Switch.CLASSIFYVIEWMODE))) {
                        map.put(checked, false);
                    }
                    if (!children.isEmpty()) {
                        map.put(childrenText, children);
                        map.put(expanded, true);
                        map.put(iconCls, "node");
                    } else if (!childrenAjh.isEmpty()) {
                        map.put(childrenText, childrenAjh);
                        map.put(expanded, true);
                        map.put(iconCls, "node");
                    } else {
                        map.put("leaf", true);
                        map.put(iconCls, nodeLeft);
                    }
                    list.add(map);
                }
            }
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> getTree(String resourceId) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<Resource> resources = resourceService.getChildrenResource(resourceId);
        for (Resource resource : resources) {
            Map<String, Object> map = new HashMap<String, Object>();
            children = getTree(resource.getId());
            boolean b = securityService.isResPermitted(resource.getId());
            if (b || !children.isEmpty()) {
                map.put("id", resource.getId());
                map.put("name", resource.getName());
                map.put("text", resource.getTitle() == null ? resource.getName() : resource.getTitle());
                map.put(contentText, resource.getContent());
                if (checkBox.equals(EnvHolder.getAppEnv().get(Switch.CLASSIFYVIEWMODE))) {
                    map.put(checked, false);
                }
                if (!children.isEmpty()) {
                    map.put(childrenText, children);
                    map.put(expanded, true);
                    map.put(iconCls, "node");
                } else {
                    map.put("leaf", true);
                    map.put(iconCls, nodeLeft);
                }
                list.add(map);
            }
        }
        return list;
    }

    public List<Map<String, Object>> getTreeByCheck(String resourceId) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<Resource> resources = resourceService.getChildrenResource(resourceId);
        for (Resource resource : resources) {
            Map<String, Object> map = new HashMap<String, Object>();
            children = getTreeByCheck(resource.getId());
            if (!EnvHolder.isEnable(Switch.isNewPermission)) {
                if (securityService.isPermitted(resource.getId(), "view") || !children.isEmpty()) {
                    map.put("id", resource.getId());
                    map.put("name", resource.getName());
                    map.put("text", resource.getTitle() == null ? resource.getName() : resource.getTitle());
                    map.put(contentText, resource.getContent());
                    map.put(checked, false);
                    if (!children.isEmpty()) {
                        map.put(childrenText, children);
                        map.put(expanded, true);
                        map.put(iconCls, "node");
                        map.put(checked, false);
                    } else {
                        map.put("leaf", true);
                        map.put(iconCls, nodeLeft);
                    }
                    list.add(map);
                }
            }else {
                if (securityService.isResPermittedNew(resource.getId(), "view") || !children.isEmpty()) {
                    map.put("id", resource.getId());
                    map.put("name", resource.getName());
                    map.put("text", resource.getTitle() == null ? resource.getName() : resource.getTitle());
                    map.put(contentText, resource.getContent());
                    map.put(checked, false);
                    if (!children.isEmpty()) {
                        map.put(childrenText, children);
                        map.put(expanded, true);
                        map.put(iconCls, "node");
                        map.put(checked, false);
                    } else {
                        map.put("leaf", true);
                        map.put(iconCls, nodeLeft);
                    }
                    list.add(map);
                }
            }
        }
        return list;
    }

    public List<Map<String, Object>> getAjhTree(String resourceId, String resourceName) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<AjhRange> ress = ajhRangeService.getAjhRangeByModelName(resourceName);
        for (AjhRange res : ress) {
            Map<String, Object> map = new HashMap<String, Object>();
            if (!EnvHolder.isEnable(Switch.isNewPermission)) {
                if (securityService.isPermitted(resourceId, "view")) {
                    map.put("id", res.getId());
                    map.put("name", res.getMlh());
                    map.put("text", res.getMlh());
                    map.put(contentText, res.getMlh());
                    if (checkBox.equals(EnvHolder.getAppEnv().get(Switch.CLASSIFYVIEWMODE))) {
                        map.put(checked, false);
                    }
                }
            }else {
                if (securityService.isResPermittedNew(resourceId, "view")) {
                    map.put("id", res.getId());
                    map.put("name", res.getMlh());
                    map.put("text", res.getMlh());
                    map.put(contentText, res.getMlh());
                    if (checkBox.equals(EnvHolder.getAppEnv().get(Switch.CLASSIFYVIEWMODE))) {
                        map.put(checked, false);
                    }
                }
            }
            map.put("leaf", true);
            map.put(iconCls, nodeLeft);
            list.add(map);
        }
        return list;
    }

    public List<Map<String, Object>> getALLTree(String resourceId) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<Resource> ress = resourceService.getChildrenResource(resourceId);
        for (Resource res : ress) {
            Map<String, Object> map = new HashMap<String, Object>();
            children = getTree(res.getId());
            map.put("id", res.getId());
            map.put("name", res.getName());
            map.put("text", res.getTitle() == null ? res.getName() : res.getTitle());
            map.put(contentText, res.getContent());
            if (checkBox.equals(EnvHolder.getAppEnv().get(Switch.CLASSIFYVIEWMODE))) {
                map.put(checked, false);
            }
            if (!children.isEmpty()) {
                map.put(childrenText, children);
                map.put(expanded, true);
                map.put(iconCls, "node");
            } else {
                map.put("leaf", true);
                map.put(iconCls, nodeLeft);
            }
            list.add(map);
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> getTree(String resourceId, String... name) {
        return getTree(resourceService.getResource(resourceId, name).getId());
    }

    @Override
    public List<Map<String, Object>> getAjhTree(String resourceId, String... name) {
        return getTree3(resourceService.getResource(resourceId, name).getId());
    }

    @Override
    public List<Map<String, Object>> getAllTree(String resourceId, String... name) {
        return getALLTree(resourceService.getResource(resourceId, name).getId());
    }

    @Override
    public List<Map<String, Object>> getTree2(String resourceId) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<Resource> ress = resourceService.getChildrenResource(resourceId);
        for (Resource res : ress) {
            Map<String, Object> map = new HashMap<String, Object>();
            children = getTree2(res.getId());
            if (!EnvHolder.isEnable(Switch.isNewPermission)) {
                if (securityService.isPermitted(res.getId(), "view") || !children.isEmpty()) {
                    map = getResMap(res);
                    list.add(map);
                }
            }else {
                if (securityService.isResPermittedNew(res.getId(), "view") || !children.isEmpty()) {
                    map = getResMap(res);
                    list.add(map);
                }
            }
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> getTreeByCheck(String resourceId, String... name) {
        return getTreeByCheck(resourceService.getResource(resourceId, name).getId());
    }

    private Map<String, Object> getResMap(Resource res){
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("id", res.getId());
        map.put("name", res.getName());
        map.put("text", res.getTitle() == null ? res.getName() : res.getTitle());
        map.put(contentText, res.getContent());
        if (!children.isEmpty()) {
            map.put(childrenText, children);
            map.put(expanded, true);
            map.put(iconCls, "node");
        } else {
            map.put("leaf", true);
            map.put(iconCls, nodeLeft);
        }
        return map;
    }
}
