package com.gtis.archive.service.impl;

import com.gtis.archive.core.EntityService;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.DailysService;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by zhayw on 2015/5/27.
 */
public class DailysServiceImpl implements DailysService {
    private static final Logger logger = LoggerFactory.getLogger(ArchiveServiceImpl.class);

    private Configuration configuration = null;

    @Autowired
    private ArchiveService archiveService;

    @Autowired
    private EntityService entityService;

    public void init(){
        configuration = new Configuration();
        configuration.setDefaultEncoding("utf-8");

    }

    @Override
    public String renderExcel(String name, String modelName, String[] ids) throws IOException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ParseException {
        Template t = null;
        HttpServletRequest request = ServletActionContext.getRequest();
        Map data = new HashMap();
        List<Object> reuslt = new ArrayList<Object>();

        try {
            configuration.setDirectoryForTemplateLoading(new File(request.getSession().getServletContext().getRealPath("")+"/tpls"));
        } catch (IOException e) {
            logger.error(e.getMessage());
        }
        t = configuration.getTemplate(name+".ftl");
        t.setEncoding("utf-8");
        StringWriter writer = new StringWriter();



        for(String id : ids){
            reuslt.add(entityService.load(modelName,id.trim()));
        }

        if("Kfwsd".equals(modelName)){
            List<Map> tempList = new ArrayList<Map>();
            DateFormat df = new SimpleDateFormat("MM-dd HH:mm");
            for(Object obj : reuslt){
                Map map = new HashMap();
                String recordDate = "recordDate";
                map.put("month", df.parse(PropertyUtils.getProperty(obj,recordDate).toString()));
                map.put("day", df.parse(PropertyUtils.getProperty(obj,recordDate).toString()));
                map.put("hours", df.parse(PropertyUtils.getProperty(obj,recordDate).toString()));
                map.put("min", df.parse(PropertyUtils.getProperty(obj,recordDate).toString()));

                tempList.add(map);
            }

            data.put("entitys",tempList);
        }

        try {
            t.process(data, writer);
            return writer.toString();
        } catch (TemplateException e) {
            e.printStackTrace();
        } finally {
            writer.close();
        }
        return null;
    }
}
