package com.gtis.archive.service.impl;

import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.ArchiveMetaData;
import com.gtis.archive.service.ArchiveMetadataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.concurrent.BlockingQueue;

/**
 * 将队列中的档案实例生成元数据并保存
 *
 * @author linlong
 */
@Component
public class ArchiveMetadataQueueConsumer implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(ArchiveMetadataQueueConsumer.class);

    /*
     * 若使用@Autowired则需要使用@Qualifier配合
     * reference:
     * 1. https://kanpiaoxue.iteye.com/blog/2164479
     * 2. https://github.com/spring-projects/spring-framework/issues/12454
     * 3. https://jira.spring.io/browse/SPR-7798?redirect=false
     */
    /** 档案待更新元数据队列 */
    @Resource(name = "archiveMetadataQueue")
    private BlockingQueue archiveQueue;

    @Autowired
    private ArchiveMetadataService archiveMetadataService;

    @Autowired
    private TaskExecutor taskExecutor;

    @Override
    public void afterPropertiesSet() throws Exception {
        taskExecutor.execute(new Runnable() {
            @Override
            public void run() {
                for (;;) {
                    try {
                        Archive archive = (Archive) archiveQueue.take();
                        ArchiveMetaData metaData = archiveMetadataService.getArchiveMetadataByArchiveId(archive.getId());
                        metaData = archiveMetadataService.getArchiveMetaDataInfoFromArchive(archive, metaData);
                        logger.info("archiveId: {}", metaData.getArchiveId());
                        logger.info("id: {}",  metaData.getId());
                        archiveMetadataService.saveOrUpdate(metaData);
                        break;
                    } catch (InterruptedException e) {
                        logger.error(e.getMessage());
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
    }
}
