package com.gtis.archive.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import com.gtis.archive.Switch;
import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.entity.ArchiveJdHistory;
import com.gtis.archive.entity.Permission;
import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.ArchiveJdHistoryService;
import com.gtis.archive.service.PermissionService;
import com.gtis.archive.service.ResourceService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.support.hibernate.HibernateDao;
import com.gtis.web.SessionUtil;
public class ArchiveJdHistoryServiceImpl  extends HibernateDao implements ArchiveJdHistoryService {

    @Autowired
    private EntityService entityService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SysUserService userService;
    
    private boolean dwdmEnable = true;
    
    @Transactional
    @Override
    public ArchiveJdHistory saveArchiveJdHistory(ArchiveJdHistory archiveJdHistory) {
        return entityService.save(archiveJdHistory);
    }
    
	@Override
	public Page<ArchiveJdHistory> searchArchiveJdHistory(String modelName,List<? extends Criterion> criterions, List<Order> orders,
			int start, int limit) {
        List<Criterion> list = new ArrayList<Criterion>(criterions);

        if (dwdmEnable && !SessionUtil.getCurrentUser().isAdmin() && !hasPermissionToViewAllArchive()) {
            Set<String> dwdms = getAvailableDwdms(modelName); // 获取单位代码列表
            list.add(Restrictions.or(Restrictions.isNull("dwdm"), Restrictions.in("dwdm", dwdms)));
        }
        return entityService.search(modelName, list, orders == null ? Collections.singletonList(Order.desc("id")) : orders, start, limit);
    }
	
	@Override
	public ArchiveJdHistory getSimpleArchiveJdHistory(String id) {
        return (ArchiveJdHistory) getSession().createSQLQuery("select t.*,0 clazz_ from t_archivejdhistory t where t.id=? ").addEntity(ArchiveJdHistory.class).setParameter(0, id).uniqueResult();
    }
	
	@Override
	public ArchiveJdHistory getSimpleArchiveJdHistoryByArchiveId(String archiveId) {
		return (ArchiveJdHistory) getSession().createSQLQuery("select t.*,0 clazz_ from t_archivejdhistory t where t.archive_id=? and rownum=1 order by sqrq desc").addEntity(ArchiveJdHistory.class).setParameter(0, archiveId).uniqueResult();
	}
	
	/**
     * 检查是否有权限查看所有的档案
     *
     * @return
     */
    private boolean hasPermissionToViewAllArchive() {
        boolean flag = false;
        flag = permissionService.hasPermission("sys", "viewAllArchive");
        return flag;
    }
    
    /**
     * 获取当前用户可访问的单位代码
     * @return
     */
    public Set<String> getAvailableDwdms(String modelName) {
        List<PfRoleVo> roles = SessionUtil.getCurrentUser().getLstRole();
        Set<String> dwdms = new HashSet<String>();
        Resource resource = resourceService.getResourceByName(modelName);
        for (PfRoleVo role : roles) {
            List<Permission> permissions = permissionService.getDwdmPermissions(resource.getId(), role.getRoleId(),"dwdm");
            Iterator<Permission> itr = permissions.iterator();
            while (itr.hasNext()) {
                dwdms.add(itr.next().getDwdm());
            }
        }
        dwdms.add(getDwdm());
        return dwdms;
    }
    
    private String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            ////单位代码用部门代码进行替换
            if (EnvHolder.isEnable(Switch.ORAGAN_NO)) {
                String oraganNo = null;
                List<PfOrganVo> pfOrganVoList = userService.getOrganListByUser(SessionUtil.getCurrentUserId());
                if (pfOrganVoList != null && !pfOrganVoList.isEmpty()) {
                    PfOrganVo pfOrganVo = pfOrganVoList.get(0);
                    oraganNo = pfOrganVo.getOraganNo();
                }

                dwdm = oraganNo;
            } else {
                dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            }
        }

        return dwdm;
    }
    
	public void setDwdmEnable(boolean dwdmEnable) {
        this.dwdmEnable = dwdmEnable;
    }
	
}
