package com.gtis.archive.service.impl;

import com.gtis.archive.entity.Archive;
import com.gtis.search.EntityIndexProvider;
import com.gtis.search.Index;
import com.gtis.search.IndexManager;
import org.hibernate.event.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;

import javax.annotation.Resource;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-10-28
 */
@SuppressWarnings("unchecked")
public class ArchiveIndexListener implements PostInsertEventListener, PostDeleteEventListener, PostUpdateEventListener, BeanPostProcessor {
    private static final long serialVersionUID = 5859744034324984631L;

    private static Logger logger = LoggerFactory.getLogger(ArchiveIndexListener.class);
    @Autowired
    private EntityIndexProvider indexProvider;
    @Autowired
    private IndexManager indexManager;

    @Resource(name = "archiveMetadataQueue")
    private BlockingQueue archiveQueue;

    @Override
    public Object postProcessBeforeInitialization(Object bean, String s) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String s) throws BeansException {
        if (bean instanceof EntityIndexProvider) {
            indexProvider = (EntityIndexProvider) bean;
        } else if (bean instanceof IndexManager) {
            indexManager = (IndexManager) bean;
        }
        return bean;
    }

    @Override
    public void onPostDelete(PostDeleteEvent event) {
        Index index = indexProvider.toIndex(event.getEntity());
        if (index != null) {
            indexManager.remove(index.getId());
        }
    }

    @Override
    public void onPostInsert(PostInsertEvent event) {
        doUpdate(event.getEntity());
        updateArchiveMetadata(event.getEntity());
    }

    @Override
    public void onPostUpdate(PostUpdateEvent event) {
        doUpdate(event.getEntity());
        updateArchiveMetadata(event.getEntity());
    }

    private void doUpdate(Object entity) {
        Index index = indexProvider.toIndex(entity);
        if (index != null) {
            indexManager.update(index);
        }
    }

    private void updateArchiveMetadata(Object entity) {
        if (entity instanceof Archive) {
            try {
                if(!archiveQueue.offer(entity, 30, TimeUnit.SECONDS)){
                    logger.error("元数据插入失败！");
                }else{
                    logger.error("元数据插入成功！");
                }
            } catch (InterruptedException e) {
                logger.error(e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }
}
