package com.gtis.archive.service;

import java.util.List;
import java.util.Map;

/**
 * . VR service
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2015/6/29 13:44
 */
public interface VRService {
    /**
     * VR exception
     */
    class VRException extends RuntimeException {
        public VRException(String s) {
            super(s);
        }
    }

    enum Tag {
        id, rooms, cabinets
    }

    /**
     * get vr config
     *
     * @return
     */
    Map getConfig();


    /**
     * get vr rooms
     *
     * @return
     */
    List getRooms();

    /**
     * get rooms only
     *
     * @return
     */
    List getRoomsOnly();


    /**
     *  get room by id
     *
     * @param roomId
     * @return
     */
    Map getRoomById(String roomId);

    Map getRoomByIdFromDb(String roomId);

    List getCabinetByRoomId(String roomId);

    List cabinetsDetail(String roomId,String cabId,String sideId);

    List cellsDetail(String roomId,String cabId,String sideId,String cellId);

    List boxajhs(String roomId,String cabId,String sideId,String cellId,String boxId);

}
