package com.gtis.archive.service;

import com.gtis.plat.vo.UserInfo;

import java.util.HashMap;
import java.util.Set;

/**
 * 访问控制接口.
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">Administrator</a>
 * @version V1.0, 2010-12-8
 */
public interface SecurityService {
    /**
     * 是否能访问
     *
     * @param permissionString 权限字符串
     * @return 是否能访问
     */
    boolean isPermitted(String permissionString);

    /**
     * 是否能访问
     *
     * @param resourceId 资源id
     * @param operation  操作
     * @return 是否能访问
     */
    boolean isPermitted(String resourceId, String operation);

    /**
     * 对某资源是否拥有权限
     * @param resourceId
     * @return
     */
    boolean isResPermitted(String resourceId);

    Set<String> getReadableRoleIds(String resourceId);

    /**
     *  获取用户权限集合
     */
    HashMap<String, Boolean> getUserPermMap(UserInfo user, String resId);
    HashMap<String, Boolean> getUserPermMapTest(String user, String resId);
    /**
     * 判断当前登录用户对资源是否拥有权限
     * @param resourceId
     * @return
     */
    boolean isResPermittedNew(String resourceId,String operation);
}
