package com.gtis.archive.service;

import com.gtis.archive.entity.Resource;

import java.util.List;

/**
 * 资源管理接口.
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-8-13
 */
public interface ResourceService {
    /**
     * 获取资源列表
     *
     * @param id   资源id
     * @param name 资源名
     * @return 资源列表
     */
    List<Resource> getChildrenResource(String id, String... name);

    /**
     * 获取资源列表
     *
     * @param id   资源id
     * @param name 资源名
     * @return 资源列表
     */
    List<Resource> getChildrenResourceRecursively(String id, String... name);

    /**
     * 获取资源
     *
     * @param id   资源id
     * @param name 资源名
     * @return 资源列表
     */
    Resource getResource(String id, String... name);

    /**
     * 从指定节点开始查找指定名称的子节点
     *
     * @param id   资源id
     * @param targetName 要匹配的节点名称
     * @param name 资源名
     * @return 资源
     */
    Resource findChildResource(String id, String targetName, String... name);

    /**
     * 删除资源
     *
     * @param id 资源id
     */
    void removeResource(String id);

    /**
     * 保存资源
     *
     * @param resource 资源
     * @return 资源
     */
    Resource saveResource(Resource resource);

    /**
     * 更具名称获取资源
     * @param name 名称
     * @return
     */
    Resource getResourceByName(String name);
}
