package com.gtis.archive.service;

import com.gtis.archive.entity.RecordAjhRange;

import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: zhangbixi
 * Date: 13-4-17
 * Time: 下午2:41
 * To change this template use File | Settings | File Templates.
 */
public interface RecordAjhRangeService {


    /**
     * 根据模型名称得到可用的
     * @param mlh
     * @param modelName
     * @return
     */
    RecordAjhRange getAvailable(String mlh,String modelName,String dwdm);

    /**
     * 江阴档案删除后，案卷号重用
     * @param mlh
     * @param modelName
     * @param dwdm
     * @param bgqx
     * @return
     */
    RecordAjhRange getRecordAjhRange(String mlh,String modelName,String dwdm,String bgqx);


    /**
     * 删除
     * @param id
     */
    void remove(String id);


    /**
     * 新增档案若使用了案卷号，将该条记录删除
     * @param mlh
     * @param modelName
     * @param dwdm
     * @param bgqx
     * @param ajh
     */
    String removeHasUsed(String mlh,String modelName,String dwdm,String bgqx,int ajh);

    String removeHasUsed(String mlh, String modelName, String dwdm, int ajh);

    RecordAjhRange saveRecordAjh(RecordAjhRange recordAjhRange);

    /**
     * 获取存放回收的存放位置的信息
     * 默认的modelName是recordeCfwz
     * 默认的案卷号是1
     * @return
     */
    List<RecordAjhRange> getAvailableMlh();

}
