package com.gtis.archive.service;

import com.gtis.archive.entity.Position;

import java.util.List;
import java.util.Map;

/**
 * Created by Think on 2017/5/3.
 */
public interface PositionService {

    /**
     * 新增或修改position
     * @param position 位置
     * @param addRows 新增的行数
     * @param addCols 新增的列数
     * @param insert 是否是新增柜子
     * @return
     */
    Position savePosition(Position position, Integer addRows, Integer addCols, boolean insert);

    /**
     * 获取房间内的柜子数
     * @param roomId
     * @return
     */
    List<Position> getCabinetByRoom(String roomId);

    /**
     * 根据房间号和柜号获取行数
     * @param roomId
     * @param cabinetSno
     * @return
     */
    Integer getRowByCabinet(String roomId, String cabinetSno);

    /**
     * 根据房间号和柜号获取列数
     * @param roomId
     * @param cabinetSno
     * @return
     */
    Integer getColumnByCabinet(String roomId, String cabinetSno);

    /**
     * 根据房间号和柜号获取位置
     * @param roomId
     * @param cabinetSno
     * @return
     */
    Position getPositionByCabinet(String roomId, String cabinetSno);

    /**
     * 获取柜子中的所有格子是否有案卷
     * @param p 柜子
     * @return
     */
    Map getCellHasArchives(Position p);

    /**
     * 更新柜子中的格子的状态
     * @param p 柜子
     * @param isUp 是否是上架
     */
    void updateCabinetStatus(Position p, boolean isUp);
}
