package com.gtis.archive.service;

import com.gtis.archive.entity.Permission;
import com.gtis.plat.vo.PfUserVo;
import java.io.IOException;
import java.util.List;
import java.util.Set;

/**
 * 权限项管理接口.
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-12-8
 */
public interface PermissionService {

    /**
     * 分配权限
     *
     * @param permissions permissions
     */
    void grant(Permission[] permissions);

    /**
     * 取消权限
     *
     * @param permissions permissions
     */
    void revoke(Permission[] permissions);

    /**
     * 分配权限
     * @param permissions
     */
    void grant(List<Permission> permissions);

    /**
     * 取消权限
     * @param permissions
     */
    void revoke(List<Permission> permissions);

    /**
     * 检查是否拥有权限
     *
     * @param resourceId 资源id
     * @param operation  操作
     * @return 是否拥有权限
     */
    boolean hasPermission(String resourceId, String operation);

    /**
     * 获取权限列表
     *
     * @param resourceId 资源id
     * @param roleId     角色Id
     * @return 权限列表
     */
    List<Permission> getPermissions(String resourceId, String roleId, String operation);

    /**
     * 获取权限列表
     *
     * @param resourceId 资源id
     * @param roleId     角色Id
     * @return 权限列表
     */
    List<Permission> getPermissions(String resourceId, String roleId);

    /**
     * 对某资源是否拥有权限
     * @param resourceId
     * @return
     */
    boolean hasResPermission(String resourceId);


    Set<String> getReadableRoleIds(String resourceId);

    /**
     * 获取权限项的json
     * @param location
     * @return
     */
    String getPermissionJson(String location);

    /**
     * 获取所有的权限项
     * @param location
     * @return
     * @throws IOException
     */
    List<String> getLeavesId(String location) throws IOException;

    /**
     * 获取角色对业务可访问的单位代码
     * @param resourceId
     * @param roleId
     * @return
     */
    List<Permission> getDwdmPermissions(String resourceId, String roleId, String dwdm, String operation);

    /**
     * 获取单位代码的访问权限
     * @param resourceId
     * @param roleId
     * @return
     */
    List<Permission> getDwdmPermissions(String resourceId, String roleId, String operation);


    /**
     * 获取所有权限用户
     * @return
     */
    List<String> getUserId();

    /**
     * 获取有权限的用户名
     * @return
     */
    List<Permission> getUsers();

    /**
     * 获取有权限的用户名
     * @return
     */
    List<Permission> getUserPermissions(String resourceId, String userId);

    /**
     * 根据userId删除已有权限
     */
    void delete(String userId,String resId);

    /**
     * 保存权限
     */
    void grantNew(List<Permission> permissions);

    /**
     * 获取用户可访问的数据
     * @param resourceId
     * @param userId
     * @return
     */
    List<Permission> getDwdmPermissionsNew(String resourceId, String userId, String operation);

    /**
     * 判断用户是否拥某资源的功能权限
     *
     * @param userId
     * @param resourceId
     * @return
     */
    boolean hasUserResPermission(String userId, String resourceId, String operation);
}
