package com.gtis.archive.service;

import com.gtis.archive.entity.Original;
import com.gtis.common.Page;
import com.gtis.plat.vo.UserInfo;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-11-30
 */
public interface OriginalService {
    /**
     * 根据id获取原文
     *
     * @param id 原文id
     * @return 原文
     */
    Original getOriginal(String id);

    /**
     * 删除原文
     *
     * @param ids 原文id列表
     */
    void removeOriginal(String[] ids);

    /**
     * 删除原文
     *
     * @param id 原文id
     */
    void removeOriginal(String id);

    /**
     * 保存原文方法
     * @param original
     */
    Original saveOriginal(Original original);

    /**
     * 批量存储原文
     * @param originals
     */
    void batchSaveOriginal(List<Original> originals);

    /**
     * 根据所有者获取原文
     *
     * @param ownerId 所有者id
     * @return 原文列表
     */
    List<Original> getOriginals(String ownerId);

    /**
     * 根据名称获取原文
     *
     * @param name 名称
     * @return 原文列表
     */


    /**
     * 获取原文的所有者对象
     *
     * @param id 原文id
     * @return 所有者对象
     */
    Object getOriginalOwner(String id);

    /**
     * 获取原文文件
     *
     *
     * @param id 原文id
     * @param action
     * @return 预览文件
     */
    File getOriginalFile(String id, String action, UserInfo userInfo);

    /**
     * 获取原文的预览文件
     *
     * @param id 原文id
     * @return 预览文件
     */
    File getOriginalThumbFile(String id);

    /**
     * 获取原文的html文件
     * @param original 原文id
     * @return 原文的html文件
     */
    File getOriginalHtmlFile(Original original);

    /**
     * 获取原文的OCR识别的PDF文件
     * @param original 原文信息
     * @return OCR识别出来的PDF文件
     */
    File getOriginalOcrPdfFile(Original original);

    /**
     * 保存原文文件
     *
     * @param original  原文
     * @param file      文件
     * @param overWrite 是否覆盖
     */
    void saveOriginalFile(Original original, File file, boolean overWrite);

    /**
     * 保存原文
     * @param original
     * @param file
     * @param ownerModelName
     * @param overWrite
     */
    void saveOriginalFile(Original original, File file, String ownerModelName, boolean overWrite);

    /**
     * 保存原文(缩略图方式存储，需要添加目录的结构)
     * @param original
     * @param file
     * @param ownerModelName
     * @param overWrite
     * @param dirName
     */
    void saveOriginalFile(Original original, File file, String ownerModelName, boolean overWrite, String dirName);

    /**
     * 解析扫描件为pdf的原文
     * @param ownerId
     * @param file
     * @param ownerModelName
     * @param overWrite
     */
    List<Original> parseAndSaveOriginalFile(String ownerId,String fileName, File file, String ownerModelName, boolean overWrite);

    /**
     * 检索原文
     *
     * @param ownerId 所属
     * @param name     名称
     * @param start      位置
     * @param limit      分页大小
     * @return 原文分页对象
     */
    Page<Original> searchOriginal(String ownerId, String name, int start, int limit);

    /**
     * 是否存在原文
     * @param ownerId
     * @return
     */
    boolean hasOriginal(String ownerId);

    /**
     * 是否存在原文
     * @param ownerId
     * @return
     */
    boolean hasOriginalForComp(String ownerId);

    /**
     * 原文是否齐全
     * @param ownerId
     * @return
     */
    boolean originalIsAll(String ownerId);

    Object[] getIds(String ownerId);

    boolean getUploadState(File file) ;

    /**
     * 创建原文的子文件夹
     * @param dirName    对应的路径
     * @param folderName 创建的文件夹名称
     * @param ownerId
     * @param modelName
     */
    public void makeDir(String dirName, String folderName, String ownerId, String modelName);

    /**
     * 获取缩略图信息
     * @param ownerId
     * @param modelName
     * @param dirName
     * @return
     */
    public Set<Map> getAllAcronymInfo(String ownerId, String modelName, String dirName);

    /**
     * 要更改的名字
     * @param formName 原始名称
     * @param toName   替换名称
     * @param ownerId
     * @param modelName
     * @param path
     */
    public void renameDir(String formName, String toName, String ownerId, String modelName, String path);

    /**
     * 删除文件夹（包含删除里面的子文件夹和文件）
     * @param dirName
     * @param folderName
     * @param ownerId
     * @param modelName
     */
    public void removeDir(String dirName, String folderName, String ownerId, String modelName);

    /**
     * 重命名原文
     * @param dirName    文件目录
     * @param fromName   原始名称
     * @param toName     改变名称
     * @param ownerId
     * @param modelName
     */
    public void renameOriginal(String dirName, String fromName, String toName, String ownerId, String modelName, String originalId);

    /**
     * 获取文件的树结构组织方式
     * @param ownerId
     * @param modelName
     */
    public List getOriginalTree(String ownerId, String modelName);

    /**
     * 下载PDF
     * @param ids
     */
    public File downloadPDF(String[] ids);

    /**
     * 获取宽高比
     * @param id  original主键
     * @return
     */
    String getKGB(String id);

    /**
     * 获取原文的树状结构（显示具体原文）
     * @param ownerId 所属ID
     * @param modelName 模型名
     * @return
     */
    List getAllOriginalTree(String ownerId, String modelName);

    /**
     * 获取原文的树状结构(不显示具体原文)
     * @param ownerId 所属ID
     * @param modelName 模型名
     * @return
     */
    List getDocTree(String ownerId, String modelName);

    /**
     * 保存原文关系信息
     * @param original
     * @param relationId
     */
    void saveOriginalRel(Original original, String relationId);

    /**
     * 根据关系Id获取原文信息
     * @param relationId
     * @return
     */
    Original getOriginalByRelationId(String relationId);

    /**
     * 根据ownerId从原文关系表中获取originalId的列表
     * @param ownerId
     * @return
     */
    List<String> getAllOriginalIdsByRel(String ownerId);

    /**
     *  移除原文关联关系表
     * @param original 原文
     */
    void removeOriginalRel(Original original);

    /**
     * 保存原文的内容
     * @param original 原文
     * @param f 文件
     * @param is 输入流
     */
    void saveOriginalContent(Original original, File f, InputStream is);

    /**
     * 保存原文日志
     * @param action 操作（preview,预览;view,查看;download,下载;print,打印;upload,上传）
     * @param original 原文
     */
    void saveDownloadLog(Original original, String action, UserInfo userInfo);

    /**
     * 根据owerId获取原文列表
     * @param name 所有者id
     * @return 原文列表
     */
    List<Original> getOriginalByName(String name,String ownerId);
}
