package com.gtis.archive.service;

import java.io.File;

/**
 * Created by Think on 2017/8/1.
 */
public interface OcrService {
    /**
     * 获取html文件
     * @param location 文件地址
     * @return 获取得文件
     */
    File getHtmlFile(String location);

    /**
     * 解析pdf文件内容
     * @param pdfPath pdf路径
     * @return 解析后的内容
     */
    String readPdf(String pdfPath);

    /**
     * 读取txt文本内容
     * @param txtPath txt路径
     * @return 文本内容
     */
    String readTxt(String txtPath);

    /**
     * 读取word内容
     * @param wordPath word路径
     * @param type 文档类型
     * @return word内容
     */
    String readWord(String wordPath, String type);

    /**
     * 读取excel内容
     * @param excelPath excel路径
     * @param type 文件类型
     * @return excel内容
     */
    String readExcel(String excelPath, String type);
}
