package com.gtis.archive.service;

import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Original;
import org.dom4j.Element;

import java.io.IOException;
import java.util.Map;


/**
 * archive Gateway service.
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-9-30
 */
public interface GatewayService {

    /**
     * proccess archive in access
     *
     * @param content content
     * @return result
     * @throws Exception exception
     */
    String in(String content) ;

    /**
     * proccess archive out access
     *
     * @param key key
     * @return result
     */
    String out(String key);

    /**
     * update archive
     *
     * @param content the content of archive(before update,format the content)
     * @return true or false
     */
    String update(String content);

    /**
     * 档案数据接入
     * @param content
     * @return
     * @throws Exception
     */
    String preIn(String content);

    /**
     * 预处理接口
     * @param modelName
     * @param id
     * @param mlh
     * @return
     * @throws Exception
     */
    String  preDispose(String modelName,String id,String mlh);

    /**
     *  取消预处理
     * @param modelName
     * @param id
     * @return
     * @throws Exception
     */
    String cancelDispose(String modelName,String id);

    /**
     * 打印完交接单，数据将在档案列表中显示
     * @param modelName
     * @param id
     * @return
     * @throws Exception
     */
    String dispose(String modelName,String id);

    /**
     *
     * @param key id
     * @param modelName 模型名称
     * @return
     */
    String out(String key,String modelName);


    /**
     * 删除档案信息
     * @param key  id
     * @param modelName 模型名称
     * @return
     */
    Boolean remove(String key,String modelName);


    /**
     * 解析档案xml信息
     * @param el  xml
     * @param modelName 模型名称
     * @return
     *
     */
    Archive readArchive(Element el,String modelName);

    /**
     * 根据档号获取档案edit模板上的信息（连云港电子标签）
     * @param mlh 目录号
     * @param ajh 案卷号
     * @return
     */
    Map getArchiveForEdit(String modelName,String mlh,String ajh,String nd);

    java.util.Map<String,String> archiveEditData(Archive archive);

    String setLoanToRFID(String dh,String mothed);

    /**
     * 连云港接收返回数据
     */
    String translate(String dh,String mothed);

    /**
     * 马鞍山收发文数据
     */
    String getTransmitXmlData(Map<String,Object> map);

    /**
     * 马鞍山创建原文临时文件路径
     */
    String createTempFile(long n) throws IOException;
    String getOriginalFile(String path,Map<String,Object> map,String name);
    Original saveOriginalPath(Element el, String ownerId, String modelName);
}
