package com.gtis.archive.service;

import com.gtis.archive.entity.Archive;
import com.gtis.common.Page;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;

import java.util.List;

/**
 * Created by linlong on 2017/6/15.
 */
public interface FondsManagerService {

    /**
     * 保存全宗卷
     * @param fondsManager 要保存的全宗卷
     * @return 保存的全宗卷
     */
    Archive saveFondsManager(Archive fondsManager);


    /**
     * 更新全宗卷
     * @param fondsManager
     * @return
     */
    Archive updateFondsManager(Archive fondsManager);

    /**
     * 删除全宗卷
     * @param ids
     */
    void removeFondsManager(String[] ids, String modelName);

    /**
     * 根据业务名和id获取全宗卷
     * @param id 全宗卷id
     * @return 获取的全宗卷
     */
    Archive getFondsManager(String id);

    /**
     * 查找全宗卷
     * @param modelName 业务名
     * @param criterions 查找语句
     * @param orders 字段排序
     * @param start 起始
     * @param limit 页面大小
     * @return 全宗卷页面
     */
     Page<Archive> searchFondsManager(String modelName, List<? extends Criterion> criterions, List<Order> orders, int start, int limit);

    /**
     * 获取某个业务的最大值
     * @param modelName 业务名
     * @return 顺序号的最大值
     */
    Integer generateSxh(String modelName);

    /**
     * 通过id获取全宗卷对象
     * @param id
     * @return
     */
    Archive getFondsManagerById(String mdoelName, String id);

}
