package com.gtis.archive.service;

import java.awt.image.BufferedImage;
import java.io.File;

/**
 * 将文件转成图片
 * @author wangxinyi
 * @date 2018/10/08
 */
public interface FileToPicService {

    /**
     * 将excel转换为图片
     * @param excelPath excel的路径
     * @param path 文件路径
     * @param fileName 文件名
     * @param ownerId
     * @param ownerModelName
     */
    int excelToJpg(String excelPath, String path, String fileName, String ownerId, String ownerModelName);

    /**
     * 将excel转换为pdf
     * @param excelPath 原文件
     * @param pdfPath 目标文件
     */
    void excelToPdf(String excelPath, String pdfPath);

    /**
     * 将word转换为pdf
     * @param docPath word文件
     * @param pdfPath pdf文件
     */
    void wordToPdf(String docPath, String pdfPath);

    /**
     * 将word转换为图片
     * @param docPath word路径
     * @param path 文件转换后的路径
     * @param fileName 文件名
     * @param ownerId
     * @param ownerModelName
     */
    int wordToJpg(String docPath, String path, String fileName, String ownerId, String ownerModelName);

    /**
     * 将ceb文件转为图片
     * @param fileName 源文件
     * @param archiveId
     * @param modelName
     */
    void cebToJpg(String fileName, String fileUrl, String archiveId, String modelName);

    /**
     * 将pdf转换为jpg
     * @param pdfPath pdf路径
     * @param path 路径
     * @param fileName 文件名
     * @param ownerId
     * @param ownerModelName
     * @return pdf的页数
     */
    int pdfToJpg(String pdfPath, String path, String fileName, String ownerId, String ownerModelName);

    /**
     * 生成表格图片
     * @param cellValue 单元格的值
     * @param path 文件路径
     * @param fontSize 字体大小
     * @param imageWidth 图像宽度
     * @param rowHeight 行高度
     */
    void generateTableGraphics(String[][] cellValue, String path, int fontSize, int imageWidth, int rowHeight);

    /**
     * 生成电子签名
     * @param src 被签名文件
     * @param digitalFile 电子签名文件
     * @param alpha
     * @return
     */
    BufferedImage digitalSign(File src, File digitalFile, float alpha);

    /**
     * 合成签名图片
     * @param bi 签名图片
     * @param savePath 保存路径
     */
    void generateSignFile(BufferedImage bi, String savePath);
}
