package com.gtis.archive.service;

import com.gtis.archive.entity.ConfigProp;

import java.util.List;
import java.util.Map;

/**
 * 配置项service
 *
 * @author linlong
 */
public interface ConfigPropService {

    /**
     * 获取数据库中的所有配置项
     *
     * @return 配置项列表
     */
    List<ConfigProp> getAll();

    /**
     * 获取配置项总数
     *
     * @return 配置项总数
     */
    int count();

    /**
     * 批量新增
     *
     * @param list
     */
    void batchSave(List<ConfigProp> list);

    /**
     * 更新pair，同时更新缓存
     *
     * @param p 待更新pair
     */
    void updatePair(ConfigProp p);

    /**
     * 获取所有的配置项
     *
     * @return 配置项列表
     */
    List<ConfigProp> getConfigProps();

    /**
     * 更新配置
     *
     * @param enables 开关型配置，名称：通过逗号连接要获取开关列表用逗号分隔
     * @param inputs 输入型配置
     * @return 更新结果
     */
    void updateProps(String enables, Map<String, String> inputs) throws Exception;


    void init();
}
