package com.gtis.archive.service;

import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.ArchiveMetaData;

import java.io.File;
import java.io.IOException;
import java.util.List;

/**
 * 档案元数据接口
 *
 * @author linlong
 *
 * @date 2019.03.18
 */
public interface ArchiveMetadataService {


    /**
     * 将元数据对象转换为xml
     *
     * @param metaData
     * @return
     */
    String convertObjToXml(ArchiveMetaData metaData);

    /**
     * 将xml转换为元数据对象
     *
     * @param xmlStr xml内容
     * @return
     */
    ArchiveMetaData toBean(String xmlStr);


    /**
     * 从档案获取相关元数据
     *
     * @param archive 档案实例
     * @param metaData 元数据
     * @return 元数据实例
     */
    ArchiveMetaData getArchiveMetaDataInfoFromArchive(Archive archive, ArchiveMetaData metaData);

    /**
     * 从档案获取相关元数据
     *
     * @param archive 档案实例
     * @return 元数据实例
     */
    ArchiveMetaData getArchiveMetaDataInfoFromArchive(Archive archive);

    /**
     * 批量获取
     *
     * @param metadataIds 元数据的id
     * @param parentPath 父目录
     * @exception IOException 抛出出现的io异常
     * @return 要打包的文件列表
     */
    List<File> batch(List<String> metadataIds, String parentPath) throws IOException;

    /**
     * 生成xml文件
     *
     * @param parentPath 父目录
     * @param archiveMetaData 元数据对象
     * @return 生成文件的路径
     * @throws IOException 生成文件过程中出现的IO异常
     */
    File generateXmlFile(String parentPath, ArchiveMetaData archiveMetaData) throws IOException;

    /**
     * 保存档案元数据
     *
     * @param archiveMetaData 待保存的档案元数据
     * @return 档案元数据
     */
    ArchiveMetaData saveOrUpdate(ArchiveMetaData archiveMetaData);

    /**
     * 根据档案id查找元数据
     *
     * @param archiveId 档案id
     * @return 档案元数据
     */
    ArchiveMetaData getArchiveMetadataByArchiveId(String archiveId);


    /**
     * 获取实例的版本号列表
     *
     * @param modelName 模型名
     * @param archiveId 档案id
     * @return 版本号列表
     * @throws ClassNotFoundException 若不存在类则抛出异常
     */
    List<Number> getVersions(String modelName, String archiveId) throws ClassNotFoundException;

    /**
     * 获取以前版本的档案实例
     *
     * @param modelName 模型名
     * @param archiveId 档案id
     * @param version 版本
     * @return 先前版本实例
     * @throws ClassNotFoundException 若不存在类则抛出异常
     */
    Archive getPreVersionArchive(String modelName, String archiveId, Number version) throws ClassNotFoundException;
}
