package com.gtis.archive.service;

import java.util.List;

import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;

import com.gtis.archive.entity.ArchiveJdHistory;
import com.gtis.common.Page;

/**
 * 描述：档案鉴定历史服务
 * @author 卜祥东
 * 2017年10月12日 下午2:48:20
 */
public interface ArchiveJdHistoryService {
	
	/**
	 * 描述：id获取档案鉴定历史
	 * @author 卜祥东
	 * 2017年10月16日 下午3:23:30
	 * @param id
	 * @return
	 */
	public ArchiveJdHistory getSimpleArchiveJdHistory(String id);
	
	/**
	 * 描述：通过archiveId获取档案鉴定历史
	 * @author 卜祥东
	 * 2017年10月16日 下午3:23:30
	 * @param archiveId
	 * @return
	 */
	public ArchiveJdHistory getSimpleArchiveJdHistoryByArchiveId(String archiveId);
	
	/**
	 * 描述：保存
	 * @author 卜祥东
	 * 2017年10月13日 下午5:07:17
	 * @param archiveJdHistory
	 * @return
	 */
	public ArchiveJdHistory saveArchiveJdHistory(ArchiveJdHistory archiveJdHistory);

    /**
     * 档案鉴定历史
     *
     * @param modelName  案卷的模型名
     * @param criterions 检索条件
     * @param orders     排序
     * @param start      位置
     * @param limit      分页大小
     * @return 案卷列表page对象
     */
    Page<ArchiveJdHistory> searchArchiveJdHistory(String modelName, List<? extends Criterion> criterions, List<Order> orders, int start, int limit);

}
