package com.gtis.archive.entity;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * Created by Think on 2017/5/3.
 */
@Entity
@Table(name = "t_position")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Position {
    public static final String MODEL_NAME = Position.class.getSimpleName();

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    private String id;

    /**
     * 房间号
     */
    @Column(length = 100)
    private String roomId;

    /**
     * 柜号（架号）
     */
    @Column(length = 100)
    private  String cabinetSno;

    /**
     * 行号（排号）
     */
    @Column(length = 10)
    private Integer rowId;

    /**
     * 列号
     */
    @Column(length = 10)
    private Integer columnId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRoomId() {
        return roomId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public String getCabinetSno() {
        return cabinetSno;
    }

    public void setCabinetSno(String cabinetSno) {
        this.cabinetSno = cabinetSno;
    }

    public Integer getRowId() {
        return rowId;
    }

    public void setRowId(Integer rowId) {
        this.rowId = rowId;
    }

    public Integer getColumnId() {
        return columnId;
    }

    public void setColumnId(Integer columnId) {
        this.columnId = columnId;
    }
}
