package com.gtis.archive.entity;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

import java.util.Date;

/**
 * 日志记录类，记录档案的操作记录
 */
@Entity
@Table(name = "t_logmanager")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class LogManager {

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    private String id;

    /**
     * 操作记录的id
     */
    @Column(length = 100)
    private String ownerId;

    /**
     * 业务名称或者Original
     */
    @Column(length = 100)
    private String modelName;

    /**
     * 当前用户id
     */
    @Column(length = 100)
    private String userId;

    /**
     * 当前用户的用户名
     */
    @Column(length = 100)
    private String userName;

    /**
     * 操作时间
     */

    private Date oprationTime;

    /**
     * 操作(add、edit、remove、gd、cxgd、package、cx-package、bind、cx-bind、yj)
     * 新增、编辑、删除、归档、撤销归档、组盒、撤销组盒、上架、下架、档案移交
     */
    @Column(length = 100)
    private String action;

    /**
     * 题名
     */
    @Column(length = 1000)
    private String tm;

    /**
     * 单位代码
     */
    @Column(length = 100)
    private String dwdm;

    /**
     * 全宗号
     */
    @Column(length = 100)
    private String qzh;

    /**
     * 目录号
     */
    @Column(length = 100)
    private String mlh;

    /**
     * 案卷号
     */
    @Column
    private Integer ajh;

    /**
     * 分类类型
     */
    @Column(length = 100)
    private String catalogType;

    /**
     * 查询记录的modelName或者是原文
     */
    @Column(length = 100)
    private String ownerType;

    public String getOwnerType() {
        return ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getCatalogType() {
        return catalogType;
    }

    public void setCatalogType(String catalogType) {
        this.catalogType = catalogType;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getModelName() {
        return modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Date getOprationTime() {
        return oprationTime;
    }

    public void setOprationTime(Date oprationTime) {
        this.oprationTime = oprationTime;
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getTm() {
        return tm;
    }

    public void setTm(String tm) {
        this.tm = tm;
    }

    public String getDwdm() {
        return dwdm;
    }

    public void setDwdm(String dwdm) {
        this.dwdm = dwdm;
    }

    public String getQzh() {
        return qzh;
    }

    public void setQzh(String qzh) {
        this.qzh = qzh;
    }

    public String getMlh() {
        return mlh;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public Integer getAjh() {
        return ajh;
    }

    public void setAjh(Integer ajh) {
        this.ajh = ajh;
    }
}
