package com.gtis.archive.entity;

import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.Date;

/**
 * .借阅车
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 12-8-30 下午3:11
 */
@Entity
@Table(name = "t_loan_cart")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class LoanCart {
    public static final String MODEL_NAME = LoanCart.class.getSimpleName();
    public static final String ENTITY_NAME = "借阅车";
    public static final String FIELD_USERID = "用户";
    public static final String FIELD_ARCHIVETYPE = "档案类型";
    public static final String FIELD_ARCHIVEID = "档案主键";
    public static final String FIELD_INDATE = "借阅日期";
    public static final String FIELD_BUNIT = "借阅单位";
    public static final String FIELD_BZ = "备注";

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    private String id;

    /**
     * 模型名
     */
    @Column(length = 10)
    private String modelName = getClass().getSimpleName();

    /**
     * 用户
     */
    @Column(length = 32, nullable = false)
    private String userId;

    /**
     * 档案类型
     */
    @Column(length = 100, nullable = false)
    private String archiveType;

    /**
     * 档案主键
     */
    @Column(length = 32, nullable = false)
    private String archiveId;

    /**
     * 借阅日期
     */
    private Date inDate;

    /**
     * 借阅单位
     */
    @Column(length = 100)
    private String bUnit;

    /**
     * 备注
     */
    @Column(length = 100)
    private String bz;

    /**
     * 单位代码
     */
    @Column(length = 20, nullable = false)
    private String dwdm;

    /**
     * 案卷号
     */
    @Column(length = 10)
    private String ajh;

    /**
     * 目录号
     */
    @Column(length = 10)
    private String mlh;

    /**
     * 题名
     */
    @Column(length = 100)
    private String tm;

    @Column(length = 100)
    private String dh;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setModelName(String modelName) {
        if (StringUtils.isNotEmpty(modelName)) {
            this.modelName = modelName;
        }
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getArchiveType() {
        return archiveType;
    }

    public void setArchiveType(String archiveType) {
        this.archiveType = archiveType;
    }

    public String getArchiveId() {
        return archiveId;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public Date getInDate() {
        return inDate;
    }

    public void setInDate(Date inDate) {
        this.inDate = inDate;
    }

    public String getbUnit() {
        return bUnit;
    }

    public void setbUnit(String bUnit) {
        this.bUnit = bUnit;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public String getDwdm() {
        return dwdm;
    }

    public void setDwdm(String dwdm) {
        this.dwdm = dwdm;
    }

    public String getAjh() {
        return ajh;
    }

    public void setAjh(String ajh) {
        this.ajh = ajh;
    }

    public String getMlh() {
        return mlh;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public String getTm() {
        return tm;
    }

    public void setTm(String tm) {
        this.tm = tm;
    }

    public String getDh() {
        return dh;
    }

    public void setDh(String dh) {
        this.dh = dh;
    }
}
