package com.gtis.archive.entity;

import com.alibaba.fastjson.annotation.JSONField;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.Date;

/**
 * <p>
 * 借阅登记表
 * Generated 2010-11-09 by Model Code Generater 1.0
 * </p>
 *
 * @author <a href="mailto:wanggang@gtis.com.cn">WangGang</a>
 */
@Entity
@Table(name = "t_loan")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Loan implements Cloneable {
    public static final String MODEL_NAME = Loan.class.getSimpleName();
    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    private String id;

    /**
     * 借阅人
     */
    @Column(length = 100)
    private String jyr;

    /**
     * 借阅日期
     */
    @Column(nullable = false)
    private Date jyrq;

    /**
     * 批准领导
     */
    @Column(length = 100)
    private String pzld;

    /**
     * 档案室管理员
     */
    @Column(length = 100)
    private String gly;

    /**
     * 借阅期限(天)
     */
    @Column(nullable = false)
    private int jyqx;

    /**
     * 借阅备注
     */
    @Column(length = 1000)
    private String bz;

    /**
     * 部门
     */
    @Column(length = 100)
    private String bm;

    /**
     * 档案序号
     */
    @Column(length = 32, nullable = false)
    private String archiveId;

    @Transient
    private String loanCartId;

    @Column(length = 100)
    private int state;

    @Column(length = 100)
    private String dwdm;

    /**
     * 档案题名
     */
    @Column(length = 100)
    private String tm;

    /**
     *档案档号
     */
    @Column
    private String dh;

    /**
     * 用户
     */
    @Column(length = 32, nullable = false)
    private String userId;


    /**
     * 批次号
     */
    @Column(length = 100)
    private String pch;

    /**
     * 卷次/记录某次借阅一共借了多少
     */
    @Column(length = 32)
    private String jc;


    /**
     *    档案业务名称
     */
    @Column(length =32 )
    private String type;

    /**
     * 档案目录号
     */
    @Column(length = 32)
    private String mlh;

    /**
     * 档案案卷号
     */
    private String ajh;

    /**
     * 利用效果登记
     */
    @Column(length = 255)
    private String lyxgdj;

    /**
     * 借阅目的
     */
    @Column(length = 255)
    private String jymd;

    /**
     * 借阅单位
     */
    @Column(length = 255)
    private String jydw;

    /**
     * 归还日期
     */
    @Column
    private Date ghrq;

    /**
     * 借阅类型
     */
    @Column(length = 10)
    private String loanType;

    /**
     * 是否审核通过
     */
    @Column
    private Integer sfpz;//0.未审批 1：审批不通过 2：审批通过

    @Transient
    private boolean isBackNow;

    /**
     * 查阅原文状态（ 正在查阅、已归还、超期）
     */
    @Transient
    private String viewState;

    @Column(length = 100)
    private String detail;
    
    @Column(length = 100)
    private String satisfy;

    @Column(length = 255)
    private String lymd;

    /**
     * 单位（处室）负责人
     */
    @Column(length = 100)
    private String dwfzr;

    /**
     * 复印内容
     */
    @Column(length = 100)
    private String fynr;

    /**
     * 分管领导
     */
    @Column(length = 100)
    private String fgld;

    /**
     * 联系电话
     */
    @Column(length = 100)
    private String lxdh;

    /**
     * 还档日期
     */
    @Column
    private Date hdrq;

    /**
     * 身份证号码
     */
    @Column(length = 100)
    private String sfzhm;

    /**
     * 是否存在原文
     */
    @Transient
    private Boolean hasOriginal;

    /**
     * 是否填写效果登记
     */
    @Transient
    private Boolean isEditXg;
    
    public String getViewState() {
        return viewState;
    }

    public void setViewState(String viewState) {
        this.viewState = viewState;
    }

    public String getMlh() {
        return mlh;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public String getAjh() {
        return ajh;
    }

    public void setAjh(String ajh) {
        this.ajh = ajh;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getJyr() {
        return jyr;
    }

    public void setJyr(String jyr) {
        this.jyr = jyr;
    }

    @JSONField(format = "yyyy-MM-dd")
    public Date getJyrq() {
        return jyrq;
    }

    public void setJyrq(Date jyrq) {
        this.jyrq = jyrq;
    }

    public String getPzld() {
        return pzld;
    }

    public void setPzld(String pzld) {
        this.pzld = pzld;
    }

    public String getGly() {
        return gly;
    }

    public void setGly(String gly) {
        this.gly = gly;
    }

    public int getJyqx() {
        return jyqx;
    }

    public void setJyqx(int jyqx) {
        this.jyqx = jyqx;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public String getArchiveId() {
        return archiveId;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public int getState() {
        return state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getDwdm() {
        return dwdm;
    }

    public void setDwdm(String dwdm) {
        this.dwdm = dwdm;
    }

    public String getLoanCartId() {
        return loanCartId;
    }

    public void setLoanCartId(String loanCartId) {
        this.loanCartId = loanCartId;
    }

    public String getPch() {
        return pch;
    }

    public void setPch(String pch) {
        this.pch = pch;
    }

    public String getBm() {
        return bm;
    }

    public void setBm(String bm) {
        this.bm = bm;
    }

    public boolean isBackNow() {
        return isBackNow;
    }

    public void setBackNow(boolean backNow) {
        isBackNow = backNow;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getJc() {
        return jc;
    }

    public void setJc(String jc) {
        this.jc = jc;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTm() {
        return tm;
    }

    public void setTm(String tm) {
        this.tm = tm;
    }

    public String getDh() {
        return dh;
    }

    public void setDh(String dh) {
        this.dh = dh;
    }

    public String getLyxgdj() {
        return lyxgdj;
    }

    public void setLyxgdj(String lyxgdj) {
        this.lyxgdj = lyxgdj;
    }

    public String getJydw() {
        return jydw;
    }

    public void setJydw(String jydw) {
        this.jydw = jydw;
    }

    public String getJymd() {
        return jymd;
    }

    public void setJymd(String jymd) {
        this.jymd = jymd;
    }

    public Date getGhrq() {
        return ghrq;
    }

    public void setGhrq(Date ghrq) {
        this.ghrq = ghrq;
    }

    public Integer getSfpz() {
        return sfpz;
    }

    public void setSfpz(Integer sfpz) {
        this.sfpz = sfpz;
    }

    public String getLoanType() {
        return loanType;
    }

    public void setLoanType(String loanType) {
        this.loanType = loanType;
    }

    @Override
    public Loan clone() throws CloneNotSupportedException {
        return (Loan) super.clone();
    }

	public String getSatisfy() {
		return satisfy;
	}

	public void setSatisfy(String satisfy) {
		this.satisfy = satisfy;
	}

	public String getDetail() {
		return detail;
	}

	public void setDetail(String detail) {
		this.detail = detail;
	}

    public String getLymd() {
        return lymd;
    }

    public void setLymd(String lymd) {
        this.lymd = lymd;
    }

    public String getDwfzr() {
        return dwfzr;
    }

    public void setDwfzr(String dwfzr) {
        this.dwfzr = dwfzr;
    }

    public String getFynr() {
        return fynr;
    }

    public void setFynr(String fynr) {
        this.fynr = fynr;
    }

    public String getFgld() {
        return fgld;
    }

    public void setFgld(String fgld) {
        this.fgld = fgld;
    }

    public String getLxdh() {
        return lxdh;
    }

    public void setLxdh(String lxdh) {
        this.lxdh = lxdh;
    }

    public Date getHdrq() {
        return hdrq;
    }

    public void setHdrq(Date hdrq) {
        this.hdrq = hdrq;
    }

    public String getSfzhm() {
        return sfzhm;
    }

    public void setSfzhm(String sfzhm) {
        this.sfzhm = sfzhm;
    }

    public Boolean getHasOriginal() {
        return hasOriginal;
    }

    public void setHasOriginal(Boolean hasOriginal) {
        this.hasOriginal = hasOriginal;
    }

    public Boolean getEditXg() {
        return isEditXg;
    }

    public void setEditXg(Boolean editXg) {
        isEditXg = editXg;
    }
}
